/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.XATerminator;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.deployment.ObjectModelFactorySimpleSubDeployerSupport;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.JBossRAMetaData;
/*     */ import org.jboss.resource.metadata.RARDeploymentMetaData;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ 
/*     */ public class RARDeployer extends ObjectModelFactorySimpleSubDeployerSupport
/*     */   implements RARDeployerMBean
/*     */ {
/*     */   private static final String JBOSS_RA_XML = "META-INF/jboss-ra.xml";
/*     */   protected ObjectName workManagerName;
/*     */   protected WorkManager workManager;
/*     */   protected XATerminator xaTerminator;
/*     */   protected ObjectName xaTerminatorName;
/*     */ 
/*     */   public RARDeployer()
/*     */   {
/*  70 */     setEnhancedSuffixes(new String[] { "250:.rar" });
/*     */   }
/*     */ 
/*     */   protected void parseMetaData(DeploymentInfo di, URL url)
/*     */     throws DeploymentException
/*     */   {
/*  76 */     super.parseMetaData(di, url);
/*     */ 
/*  78 */     InputStream is = di.localCl.getResourceAsStream("META-INF/jboss-ra.xml");
/*  79 */     RARDeploymentMetaData rdmd = new RARDeploymentMetaData();
/*  80 */     rdmd.setConnectorMetaData((ConnectorMetaData)di.metaData);
/*  81 */     di.metaData = rdmd;
/*     */     try
/*     */     {
/*  85 */       if (is != null)
/*     */       {
/*  88 */         Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  89 */         ObjectModelFactory factory = getExtendedObjectModelFactory();
/*  90 */         JBossRAMetaData ramd = (JBossRAMetaData)unmarshaller.unmarshal(is, factory, (Object)null);
/*  91 */         rdmd.setRaXmlMetaData(ramd);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 100 */       DeploymentException.rethrowAsDeploymentException("Error parsing meta data " + url, t);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 106 */         if (is != null)
/*     */         {
/* 108 */           is.close();
/*     */         }
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getExtension()
/*     */   {
/* 120 */     return ".rar";
/*     */   }
/*     */ 
/*     */   public String getMetaDataURL()
/*     */   {
/* 125 */     return "META-INF/ra.xml";
/*     */   }
/*     */ 
/*     */   public String getObjectName(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 130 */     String name = di.shortName;
/* 131 */     di = di.parent;
/* 132 */     while (di != null)
/*     */     {
/* 134 */       name = di.shortName + "#" + name;
/* 135 */       di = di.parent;
/*     */     }
/* 137 */     return "jboss.jca:service=RARDeployment,name='" + name + "'";
/*     */   }
/*     */ 
/*     */   public String getDeploymentClass()
/*     */   {
/* 142 */     return RARDeployment.class.getName();
/*     */   }
/*     */ 
/*     */   public ObjectModelFactory getObjectModelFactory()
/*     */   {
/* 147 */     return new ResourceAdapterObjectModelFactory();
/*     */   }
/*     */ 
/*     */   public ObjectName getWorkManagerName()
/*     */   {
/* 152 */     return this.workManagerName;
/*     */   }
/*     */ 
/*     */   public void setWorkManagerName(ObjectName workManagerName)
/*     */   {
/* 157 */     this.workManagerName = workManagerName;
/*     */   }
/*     */ 
/*     */   public ObjectName getXATerminatorName()
/*     */   {
/* 162 */     return this.xaTerminatorName;
/*     */   }
/*     */ 
/*     */   public void setXATerminatorName(ObjectName xaTerminatorName)
/*     */   {
/* 167 */     this.xaTerminatorName = xaTerminatorName;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 172 */     this.workManager = ((WorkManager)this.server.getAttribute(this.workManagerName, "Instance"));
/* 173 */     this.xaTerminator = ((XATerminator)this.server.getAttribute(this.xaTerminatorName, "XATerminator"));
/* 174 */     super.startService();
/*     */   }
/*     */ 
/*     */   private ObjectModelFactory getExtendedObjectModelFactory()
/*     */   {
/* 179 */     return new JBossRAObjectModelFactory();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.RARDeployer
 * JD-Core Version:    0.6.0
 */