/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.metadata.AdminObjectMetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ 
/*     */ public class AdminObjectFactory
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(AdminObjectFactory.class);
/*     */ 
/*     */   public static Object createAdminObject(String jndiName, ObjectName rarName, AdminObjectMetaData aomd, Properties properties) throws Exception
/*     */   {
/*  53 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  56 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */ 
/*  58 */     if (trace) {
/*  59 */       log.trace("Creating AdminObject '" + jndiName + "' metadata=" + aomd + " rar=" + rarName + " properties=" + properties + " classloader=" + cl);
/*     */     }
/*     */ 
/*  62 */     String interfaceName = aomd.getAdminObjectInterfaceClass();
/*     */ 
/*  64 */     if (trace)
/*  65 */       log.trace("AdminObject '" + jndiName + "' loading interface=" + interfaceName);
/*  66 */     Class interfaceClass = cl.loadClass(interfaceName);
/*     */ 
/*  69 */     String implName = aomd.getAdminObjectImplementationClass();
/*  70 */     if (implName == null) {
/*  71 */       throw new DeploymentException("No implementation class for admin object '" + interfaceClass + "' ra=" + rarName);
/*     */     }
/*     */ 
/*  74 */     if (trace)
/*  75 */       log.trace("AdminObject '" + jndiName + "' loading implementation=" + implName);
/*  76 */     Class implClass = cl.loadClass(implName);
/*  77 */     if (!interfaceClass.isAssignableFrom(implClass)) {
/*  78 */       throw new DeploymentException(implClass.getName() + " is not a '" + interfaceClass + "' ra=" + rarName);
/*     */     }
/*  80 */     Object result = implClass.newInstance();
/*  81 */     if (trace) {
/*  82 */       log.trace("AdminObject '" + jndiName + "' created instance=" + result);
/*     */     }
/*     */ 
/*  85 */     Collection raProperties = aomd.getProperties();
/*     */     Iterator i;
/*  86 */     if ((raProperties != null) && (raProperties.size() != 0))
/*     */     {
/*  88 */       for (i = raProperties.iterator(); i.hasNext(); )
/*     */       {
/*  90 */         ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/*  91 */         String name = cpmd.getName();
/*  92 */         String value = cpmd.getValue();
/*  93 */         if ((value != null) && (value.length() > 0))
/*     */         {
/*  95 */           if (properties.containsKey(name))
/*     */           {
/*  97 */             if (trace) {
/*  98 */               log.trace("AdminObject '" + jndiName + "' property=" + name + " IGNORING value=" + value + " specified in MBean properties.");
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 103 */             String typeName = cpmd.getType();
/* 104 */             if (trace)
/* 105 */               log.trace("AdminObject '" + jndiName + "' property=" + name + " loading class=" + typeName);
/* 106 */             Class type = cl.loadClass(typeName);
/*     */ 
/* 109 */             PropertyEditor editor = PropertyEditorManager.findEditor(type);
/* 110 */             if (editor == null)
/* 111 */               throw new DeploymentException("No property editor found for property '" + name + " class='" + type + "' for admin object '" + interfaceClass + "' ra=" + rarName);
/* 112 */             editor.setAsText(value);
/* 113 */             Object object = editor.getValue();
/*     */             try
/*     */             {
/* 117 */               String setter = "set" + Character.toUpperCase(name.charAt(0));
/* 118 */               if (name.length() > 1)
/* 119 */                 setter = setter.concat(name.substring(1));
/* 120 */               Method method = implClass.getMethod(setter, new Class[] { type });
/* 121 */               if (trace)
/* 122 */                 log.trace("AdminObject '" + jndiName + "' property=" + name + " set=" + object);
/* 123 */               method.invoke(result, new Object[] { object });
/*     */             }
/*     */             catch (InvocationTargetException e)
/*     */             {
/* 127 */               DeploymentException.rethrowAsDeploymentException("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName, e.getTargetException());
/*     */             }
/*     */             catch (Throwable t)
/*     */             {
/* 131 */               DeploymentException.rethrowAsDeploymentException("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName, t);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     Iterator i;
/* 139 */     if (properties != null)
/*     */     {
/* 141 */       for (i = properties.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 143 */         Map.Entry property = (Map.Entry)i.next();
/* 144 */         String name = (String)property.getKey();
/* 145 */         String value = (String)property.getValue();
/* 146 */         if (trace) {
/* 147 */           log.trace("AdminObject '" + jndiName + "' property=" + name + " value=" + value);
/*     */         }
/*     */ 
/* 150 */         ConfigPropertyMetaData cpmd = aomd.getProperty(name);
/* 151 */         if (cpmd == null)
/* 152 */           throw new DeploymentException("No property '" + name + "' for admin object '" + interfaceClass + "' ra=" + rarName);
/* 153 */         if (trace) {
/* 154 */           log.trace("AdminObject '" + jndiName + "' property=" + name + " metadata=" + cpmd);
/*     */         }
/*     */ 
/* 157 */         String typeName = cpmd.getType();
/* 158 */         if (trace)
/* 159 */           log.trace("AdminObject '" + jndiName + "' property=" + name + " loading class=" + typeName);
/* 160 */         Class type = cl.loadClass(typeName);
/*     */ 
/* 163 */         PropertyEditor editor = PropertyEditorManager.findEditor(type);
/* 164 */         if (editor == null)
/* 165 */           throw new DeploymentException("No property editor found for property '" + name + " class='" + type + "' for admin object '" + interfaceClass + "' ra=" + rarName);
/* 166 */         editor.setAsText(value);
/* 167 */         Object object = editor.getValue();
/*     */         try
/*     */         {
/* 171 */           String setter = "set" + Character.toUpperCase(name.charAt(0));
/* 172 */           if (name.length() > 1)
/* 173 */             setter = setter.concat(name.substring(1));
/* 174 */           Method method = implClass.getMethod(setter, new Class[] { type });
/* 175 */           if (trace)
/* 176 */             log.trace("AdminObject '" + jndiName + "' property=" + name + " set=" + object);
/* 177 */           method.invoke(result, new Object[] { object });
/*     */         }
/*     */         catch (InvocationTargetException e)
/*     */         {
/* 181 */           DeploymentException.rethrowAsDeploymentException("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName, e.getTargetException());
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 185 */           DeploymentException.rethrowAsDeploymentException("Error for property '" + name + "' class=" + implClass + "' for admin object '" + interfaceClass + "' ra=" + rarName, t);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 190 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.AdminObjectFactory
 * JD-Core Version:    0.6.0
 */