/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import java.util.Properties;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.metadata.AdminObjectMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class AdminObject extends ServiceMBeanSupport
/*     */   implements AdminObjectMBean
/*     */ {
/*     */   protected ObjectName rarName;
/*     */   protected String type;
/*     */   protected Properties properties;
/*     */   protected String jndiName;
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/*  57 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJNDIName(String jndiName)
/*     */   {
/*  62 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */   {
/*  67 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties properties)
/*     */   {
/*  72 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public ObjectName getRARName()
/*     */   {
/*  77 */     return this.rarName;
/*     */   }
/*     */ 
/*     */   public void setRARName(ObjectName rarName)
/*     */   {
/*  82 */     this.rarName = rarName;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/*  87 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/*  92 */     this.type = type;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/*  97 */     AdminObjectMetaData aomd = retrieveAdminObjectMetaData();
/*  98 */     if (aomd == null) {
/*  99 */       throw new DeploymentException("No admin object metadata type=" + this.type + " ra=" + this.rarName);
/*     */     }
/* 101 */     Object adminObject = createAdminObject(aomd);
/*     */ 
/* 103 */     bind(adminObject);
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 108 */     unbind();
/*     */   }
/*     */ 
/*     */   protected AdminObjectMetaData retrieveAdminObjectMetaData()
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 121 */       ConnectorMetaData cmd = (ConnectorMetaData)this.server.getAttribute(this.rarName, "MetaData");
/* 122 */       return cmd.getAdminObject(this.type);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 126 */       DeploymentException.rethrowAsDeploymentException("Error retrieving admin object metadata type=" + this.type + " ra=" + this.rarName, t);
/* 127 */     }return null;
/*     */   }
/*     */ 
/*     */   protected Object createAdminObject(AdminObjectMetaData aomd)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 142 */       return AdminObjectFactory.createAdminObject(this.jndiName, this.rarName, aomd, this.properties);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 146 */       DeploymentException.rethrowAsDeploymentException("Error creating admin object metadata type=" + this.type + " ra=" + this.rarName, t);
/* 147 */     }return null;
/*     */   }
/*     */ 
/*     */   protected void bind(Object object)
/*     */     throws Exception
/*     */   {
/* 159 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 162 */       Util.bind(ctx, this.jndiName, object);
/* 163 */       this.log.info("Bound admin object '" + object.getClass().getName() + "' at '" + this.jndiName + "'");
/*     */     }
/*     */     finally
/*     */     {
/* 167 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void unbind()
/*     */     throws Exception
/*     */   {
/* 178 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 181 */       Util.unbind(ctx, this.jndiName);
/* 182 */       this.log.info("Unbound admin object at '" + this.jndiName + "'");
/*     */     }
/*     */     finally
/*     */     {
/* 186 */       ctx.close();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.AdminObject
 * JD-Core Version:    0.6.0
 */