/*     */ package org.jboss.resource.deployment;
/*     */ 
/*     */ import java.beans.IntrospectionException;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import javax.management.ObjectName;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ActivationConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.MessageListenerMetaData;
/*     */ import org.jboss.resource.metadata.RequiredConfigPropertyMetaData;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class ActivationSpecFactory
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(ActivationSpecFactory.class);
/*     */ 
/*     */   public static ActivationSpec createActivationSpec(ObjectName rarName, String messagingType, Collection activationConfig, MessageListenerMetaData mlmd)
/*     */     throws Exception
/*     */   {
/*  55 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  57 */     if (trace) {
/*  58 */       log.trace("Create ActivationSpec rar=" + rarName + " messagingType=" + messagingType + " activationConfig=" + activationConfig + " messageListner=" + mlmd);
/*     */     }
/*     */ 
/*  62 */     for (Iterator i = mlmd.getRequiredConfigProperties().iterator(); i.hasNext(); )
/*     */     {
/*  64 */       RequiredConfigPropertyMetaData rcpmd = (RequiredConfigPropertyMetaData)i.next();
/*     */ 
/*  66 */       String rcp = rcpmd.getName();
/*  67 */       String rcpName = rcp.substring(0, 1).toUpperCase();
/*  68 */       if (rcp.length() > 1)
/*  69 */         rcpName = rcpName.concat(rcp.substring(1));
/*  70 */       if (trace) {
/*  71 */         log.trace("Checking required config " + rcpName);
/*     */       }
/*  73 */       boolean found = false;
/*  74 */       for (Iterator j = activationConfig.iterator(); j.hasNext(); )
/*     */       {
/*  76 */         ActivationConfigPropertyMetaData acpmd = (ActivationConfigPropertyMetaData)j.next();
/*     */ 
/*  78 */         String acp = acpmd.getName();
/*  79 */         String acpName = acp.substring(0, 1).toUpperCase();
/*  80 */         if (acp.length() > 1) {
/*  81 */           acpName = acpName.concat(acp.substring(1));
/*     */         }
/*  83 */         if (trace) {
/*  84 */           log.trace("Checking required config " + rcpName + " against " + acpName + " result=" + rcpName.equals(acpName));
/*     */         }
/*  86 */         if (rcpName.equals(acpName))
/*     */         {
/*  88 */           if (trace)
/*  89 */             log.trace("Found required config " + rcp + " " + acpmd);
/*  90 */           found = true;
/*  91 */           break;
/*     */         }
/*     */       }
/*  94 */       if (!found) {
/*  95 */         throw new DeploymentException("Required config property " + rcpmd + " for messagingType '" + messagingType + "' not found in activation config " + activationConfig + " ra=" + rarName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 100 */     String className = mlmd.getActivationSpecType();
/* 101 */     if (className == null) {
/* 102 */       throw new DeploymentException("No activation spec type for messagingType '" + messagingType + "' ra=" + rarName);
/*     */     }
/*     */ 
/* 105 */     if (trace)
/* 106 */       log.trace("Loading ActivationSpec class=" + className);
/* 107 */     Class asClass = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 108 */     if (!ActivationSpec.class.isAssignableFrom(asClass))
/* 109 */       throw new DeploymentException(asClass.getName() + " is not an activation spec class '" + messagingType + "' ra=" + rarName);
/* 110 */     ActivationSpec result = (ActivationSpec)asClass.newInstance();
/* 111 */     if (trace) {
/* 112 */       log.trace("Instantiated ActivationSpec class=" + result);
/*     */     }
/*     */ 
/* 117 */     Properties beanProps = new Properties();
/* 118 */     for (Iterator i = activationConfig.iterator(); i.hasNext(); )
/*     */     {
/* 120 */       ActivationConfigPropertyMetaData acpmd = (ActivationConfigPropertyMetaData)i.next();
/* 121 */       String name = acpmd.getName();
/* 122 */       String value = acpmd.getValue();
/* 123 */       beanProps.setProperty(name, value);
/*     */     }
/* 125 */     if (trace)
/* 126 */       log.trace("Configuring ActivationSpec properties=" + beanProps);
/*     */     try
/*     */     {
/* 129 */       PropertyEditors.mapJavaBeanProperties(result, beanProps);
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/* 133 */       String msg = "Error for ActivationSpec class " + asClass.getName() + " as JavaBean";
/*     */ 
/* 135 */       DeploymentException.rethrowAsDeploymentException(msg, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 141 */       if (trace)
/* 142 */         log.trace("Trying to validate ActivationSpec " + result);
/* 143 */       result.validate();
/*     */     }
/*     */     catch (UnsupportedOperationException e)
/*     */     {
/* 147 */       log.debug("Validation is not supported for ActivationSpec: " + className);
/*     */     }
/*     */ 
/* 150 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployment.ActivationSpecFactory
 * JD-Core Version:    0.6.0
 */