/*     */ package org.jboss.resource.deployers.management;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.io.Serializable;
/*     */ import java.net.URI;
/*     */ import java.util.Map;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.Marshaller;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplate;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
/*     */ import org.jboss.deployers.spi.management.KnownComponentTypes.DataSourceTypes;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ComponentType;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.managed.api.factory.ManagedObjectFactory;
/*     */ import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
/*     */ import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.NoTxConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class DsDataSourceTemplate
/*     */   implements DeploymentTemplate
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(DsDataSourceTemplate.class);
/*     */   private DeploymentTemplateInfo info;
/*     */ 
/*     */   public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/*  65 */     String dsName = deploymentBaseName + "-ds.xml";
/*  66 */     URI dsXmlURI = new URI(root.toURI() + dsName);
/*  67 */     File dsXml = new File(dsXmlURI.getPath());
/*  68 */     writeTemplate(dsXml, values);
/*  69 */     return root.findChild(dsName);
/*     */   }
/*     */ 
/*     */   public DeploymentTemplateInfo getInfo()
/*     */   {
/*  74 */     return this.info;
/*     */   }
/*     */ 
/*     */   public void setInfo(DeploymentTemplateInfo info) {
/*  78 */     this.info = info;
/*     */   }
/*     */ 
/*     */   public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void writeTemplate(File dsXml, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/*  90 */     String cfType = ((DsDataSourceTemplateInfo)values).getConnectionFactoryType();
/*     */ 
/*  93 */     ManagedObjectFactory mof = ManagedObjectFactoryBuilder.create();
/*     */ 
/*  96 */     String rootElementName = "datasources";
/*     */     ManagedObject cfMO;
/*  97 */     if ("local-tx-datasource".equals(cfType))
/*     */     {
/*  99 */       ManagedConnectionFactoryDeploymentMetaData mcf = new LocalDataSourceDeploymentMetaData();
/* 100 */       mof.setBuilder(mcf.getClass(), new XADataSourceDeploymentMetaDataBuilder());
/* 101 */       cfMO = mof.initManagedObject(mcf, KnownComponentTypes.DataSourceTypes.LocalTx.getType().getType(), KnownComponentTypes.DataSourceTypes.LocalTx.getType().getSubtype());
/*     */     }
/*     */     else
/*     */     {
/*     */       ManagedObject cfMO;
/* 105 */       if ("xa-datasource".equals(cfType))
/*     */       {
/* 107 */         ManagedConnectionFactoryDeploymentMetaData mcf = new XADataSourceDeploymentMetaData();
/* 108 */         mof.setBuilder(mcf.getClass(), new XADataSourceDeploymentMetaDataBuilder());
/* 109 */         cfMO = mof.initManagedObject(mcf, KnownComponentTypes.DataSourceTypes.XA.getType().getType(), KnownComponentTypes.DataSourceTypes.XA.getType().getSubtype());
/*     */       }
/*     */       else
/*     */       {
/*     */         ManagedObject cfMO;
/* 113 */         if ("tx-connection-factory".equals(cfType))
/*     */         {
/* 115 */           rootElementName = "connection-factories";
/* 116 */           ManagedConnectionFactoryDeploymentMetaData mcf = new TxConnectionFactoryDeploymentMetaData();
/* 117 */           mof.setBuilder(mcf.getClass(), new XADataSourceDeploymentMetaDataBuilder());
/*     */ 
/* 119 */           cfMO = mof.initManagedObject(mcf, "ConnectionFactory", "XA");
/*     */         }
/*     */         else
/*     */         {
/*     */           ManagedObject cfMO;
/* 123 */           if ("no-tx-connection-factory".equals(cfType))
/*     */           {
/* 125 */             rootElementName = "connection-factories";
/* 126 */             ManagedConnectionFactoryDeploymentMetaData mcf = new NoTxConnectionFactoryDeploymentMetaData();
/* 127 */             mof.setBuilder(mcf.getClass(), new XADataSourceDeploymentMetaDataBuilder());
/*     */ 
/* 129 */             cfMO = mof.initManagedObject(mcf, "ConnectionFactory", "NoTx");
/*     */           }
/*     */           else
/*     */           {
/*     */             ManagedObject cfMO;
/* 133 */             if ("no-tx-datasource".equals(cfType))
/*     */             {
/* 135 */               ManagedConnectionFactoryDeploymentMetaData mcf = new NoTxDataSourceDeploymentMetaData();
/* 136 */               mof.setBuilder(mcf.getClass(), new XADataSourceDeploymentMetaDataBuilder());
/* 137 */               cfMO = mof.initManagedObject(mcf, KnownComponentTypes.DataSourceTypes.NoTx.getType().getType(), KnownComponentTypes.DataSourceTypes.NoTx.getType().getSubtype());
/*     */             }
/*     */             else
/*     */             {
/* 142 */               throw new IllegalStateException("Unexpected value connection factory type: " + cfType);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     ManagedObject cfMO;
/*     */     ManagedConnectionFactoryDeploymentMetaData mcf;
/* 144 */     ManagedConnectionFactoryDeploymentGroup group = new ManagedConnectionFactoryDeploymentGroup();
/* 145 */     group.addManagedConnectionFactoryDeployment(mcf);
/* 146 */     boolean logTrace = log.isTraceEnabled();
/* 147 */     for (ManagedProperty tempProp : values.getProperties().values())
/*     */     {
/* 149 */       ManagedProperty dsProp = cfMO.getProperty(tempProp.getName());
/* 150 */       if (dsProp != null)
/*     */       {
/* 152 */         if (logTrace)
/* 153 */           log.trace("setting " + tempProp.getName() + "=" + tempProp.getValue());
/* 154 */         dsProp.setValue((Serializable)tempProp.getValue());
/*     */       }
/* 156 */       else if (logTrace) {
/* 157 */         log.trace("property not found: " + tempProp.getName());
/*     */       }
/*     */     }
/* 160 */     Class[] classes = { ManagedConnectionFactoryDeploymentGroup.class };
/* 161 */     JAXBContext context = JAXBContext.newInstance(classes);
/* 162 */     Marshaller marshaller = context.createMarshaller();
/* 163 */     marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
/*     */ 
/* 165 */     JAXBElement root = new JAXBElement(new QName(rootElementName), ManagedConnectionFactoryDeploymentGroup.class, null, group);
/*     */ 
/* 172 */     FileWriter fw = null;
/*     */     try
/*     */     {
/* 175 */       fw = new FileWriter(dsXml);
/* 176 */       marshaller.marshal(root, fw);
/*     */     }
/*     */     finally
/*     */     {
/* 180 */       if (fw != null)
/* 181 */         fw.close();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.management.DsDataSourceTemplate
 * JD-Core Version:    0.6.0
 */