/*     */ package org.jboss.resource.deployers.builder;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryTransactionSupportMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ 
/*     */ public class ConnectionFactoryBindingBuilder extends AbstractBuilder
/*     */ {
/*     */   private static final String DATASOURCE = "org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceService";
/*     */   private static final String CONNECTION_FACTORY = "org.jboss.resource.connectionmanager.ConnectionFactoryBindingService";
/*     */   private static final String DATASOURCE_JMX = "jboss.jca:service=DataSourceBinding,name=";
/*     */   private static final String CONNNECTION_FACTORY_JMX = "jboss.jca:service=ConnectionFactoryBinding,name=";
/*     */ 
/*     */   public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  52 */     List attributes = new ArrayList();
/*  53 */     ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
/*     */ 
/*  55 */     attribute = buildSimpleAttribute("JndiName", md.getJndiName());
/*  56 */     attributes.add(attribute);
/*     */ 
/*  58 */     attribute = buildSimpleAttribute("UseJavaContext", String.valueOf(md.isUseJavaContext()));
/*  59 */     attributes.add(attribute);
/*     */ 
/*  61 */     if ((!md.isUseJavaContext()) && ((md instanceof DataSourceDeploymentMetaData)))
/*     */     {
/*  63 */       attribute = buildDependencyAttribute("JMXInvokerName", md.getJmxInvokerName());
/*  64 */       attributes.add(attribute);
/*     */     }
/*     */ 
/*  67 */     attribute = buildDependencyAttribute("ConnectionManager", buildCMName(md));
/*  68 */     attributes.add(attribute);
/*  69 */     return attributes;
/*     */   }
/*     */ 
/*     */   public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  76 */     ObjectName on = null;
/*     */ 
/*  78 */     if ((md instanceof DataSourceDeploymentMetaData))
/*     */     {
/*  80 */       on = ObjectNameFactory.create("jboss.jca:service=DataSourceBinding,name=" + md.getJndiName());
/*     */     }
/*     */     else
/*     */     {
/*  84 */       on = ObjectNameFactory.create("jboss.jca:service=ConnectionFactoryBinding,name=" + md.getJndiName());
/*     */     }
/*     */ 
/*  87 */     return on;
/*     */   }
/*     */ 
/*     */   public String getCode(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/*  94 */     return (md instanceof DataSourceDeploymentMetaData) ? "org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceService" : "org.jboss.resource.connectionmanager.ConnectionFactoryBindingService";
/*     */   }
/*     */ 
/*     */   private String buildCMName(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/* 101 */     String cmType = "jboss.jca:service=";
/* 102 */     String jndiName = md.getJndiName();
/*     */ 
/* 104 */     if (md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.NONE))
/*     */     {
/* 106 */       cmType = cmType + "NoTxCM,name=" + jndiName;
/*     */     }
/* 109 */     else if (md.getTransactionSupportMetaData().equals(ManagedConnectionFactoryTransactionSupportMetaData.LOCAL))
/*     */     {
/* 111 */       if ((md instanceof DataSourceDeploymentMetaData))
/*     */       {
/* 113 */         cmType = cmType + "LocalTxCM,name=" + jndiName;
/*     */       }
/*     */       else
/*     */       {
/* 117 */         cmType = cmType + "TxCM,name=" + jndiName;
/*     */       }
/*     */ 
/*     */     }
/* 123 */     else if ((md instanceof DataSourceDeploymentMetaData))
/*     */     {
/* 125 */       cmType = cmType + "XATxCM,name=" + jndiName;
/*     */     }
/*     */     else
/*     */     {
/* 130 */       cmType = cmType + "TxCM,name=" + jndiName;
/*     */     }
/*     */ 
/* 135 */     return cmType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.builder.ConnectionFactoryBindingBuilder
 * JD-Core Version:    0.6.0
 */