/*     */ package org.jboss.resource.deployers.builder;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyValueMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceTextValueMetaData;
/*     */ 
/*     */ public abstract class AbstractBuilder
/*     */ {
/*     */   public abstract ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData paramManagedConnectionFactoryDeploymentMetaData);
/*     */ 
/*     */   public abstract String getCode(ManagedConnectionFactoryDeploymentMetaData paramManagedConnectionFactoryDeploymentMetaData);
/*     */ 
/*     */   public ServiceMetaData buildService(ManagedConnectionFactoryDeploymentMetaData mcfmd)
/*     */   {
/*  51 */     ServiceMetaData md = new ServiceMetaData();
/*  52 */     ObjectName on = buildObjectName(mcfmd);
/*  53 */     md.setObjectName(on);
/*  54 */     String code = getCode(mcfmd);
/*  55 */     md.setCode(code);
/*  56 */     ServiceConstructorMetaData cmd = buildConstructor(mcfmd);
/*  57 */     md.setConstructor(cmd);
/*  58 */     return md;
/*     */   }
/*     */ 
/*     */   public ServiceMetaData build(ManagedConnectionFactoryDeploymentMetaData mcfmd)
/*     */   {
/*  65 */     ServiceMetaData md = buildService(mcfmd);
/*  66 */     List attributes = buildAttributes(mcfmd);
/*  67 */     md.setAttributes(attributes);
/*  68 */     List dependencies = buildDependencies(mcfmd);
/*  69 */     md.setDependencies(dependencies);
/*     */ 
/*  71 */     return md;
/*     */   }
/*     */ 
/*     */   public abstract List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData paramManagedConnectionFactoryDeploymentMetaData);
/*     */ 
/*     */   public ServiceConstructorMetaData buildConstructor(ManagedConnectionFactoryDeploymentMetaData mcfmd)
/*     */   {
/*  79 */     ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/*  80 */     constructor.setParameters(new Object[0]);
/*  81 */     constructor.setParams(new String[0]);
/*  82 */     return constructor;
/*     */   }
/*     */ 
/*     */   public ServiceAttributeMetaData buildSimpleAttribute(String name, String value)
/*     */   {
/*  89 */     ServiceAttributeMetaData att = new ServiceAttributeMetaData();
/*  90 */     att.setName(name);
/*  91 */     ServiceTextValueMetaData dep = new ServiceTextValueMetaData(value);
/*  92 */     att.setValue(dep);
/*  93 */     return att;
/*     */   }
/*     */ 
/*     */   public ServiceDependencyMetaData buildDependency(String dependencyName)
/*     */   {
/*  99 */     ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
/* 100 */     dependency.setIDependOn(dependencyName);
/* 101 */     return dependency;
/*     */   }
/*     */ 
/*     */   public List<ServiceDependencyMetaData> buildDependencies(ManagedConnectionFactoryDeploymentMetaData md)
/*     */   {
/* 107 */     return new ArrayList();
/*     */   }
/*     */ 
/*     */   public ServiceAttributeMetaData buildDependencyAttribute(String name, String dependency)
/*     */   {
/* 112 */     ServiceAttributeMetaData att = new ServiceAttributeMetaData();
/* 113 */     ServiceDependencyValueMetaData dep = new ServiceDependencyValueMetaData();
/* 114 */     dep.setDependency(dependency);
/*     */ 
/* 116 */     if (name != null) {
/* 117 */       att.setName(name);
/*     */     }
/* 119 */     att.setValue(dep);
/* 120 */     return att;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.builder.AbstractBuilder
 * JD-Core Version:    0.6.0
 */