/*     */ package org.jboss.resource.deployers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceInjectionValueMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ public class RARDeployer extends AbstractSimpleRealDeployer<ConnectorMetaData>
/*     */ {
/*     */   private String workManagerName;
/*     */   private String xaTerminatorName;
/*     */ 
/*     */   public RARDeployer()
/*     */   {
/*  57 */     super(ConnectorMetaData.class);
/*  58 */     setOutput(ServiceMetaData.class);
/*     */   }
/*     */ 
/*     */   public String getWorkManagerName()
/*     */   {
/*  68 */     return this.workManagerName;
/*     */   }
/*     */ 
/*     */   public void setWorkManagerName(String workManagerName)
/*     */   {
/*  78 */     this.workManagerName = workManagerName;
/*     */   }
/*     */ 
/*     */   public String getXATerminatorName()
/*     */   {
/*  88 */     return this.xaTerminatorName;
/*     */   }
/*     */ 
/*     */   public void setXATerminatorName(String xaTerminatorName)
/*     */   {
/*  98 */     this.xaTerminatorName = xaTerminatorName;
/*     */   }
/*     */ 
/*     */   protected String getObjectName(DeploymentUnit unit, ConnectorMetaData cmd)
/*     */   {
/* 104 */     String name = unit.getSimpleName();
/* 105 */     unit = unit.getParent();
/* 106 */     while (unit != null)
/*     */     {
/* 108 */       name = unit.getSimpleName() + "#" + name;
/* 109 */       unit = unit.getParent();
/*     */     }
/* 111 */     return "jboss.jca:service=RARDeployment,name='" + name + "'";
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit, ConnectorMetaData cmd) throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 118 */       ServiceMetaData rarDeployment = new ServiceMetaData();
/* 119 */       String name = getObjectName(unit, cmd);
/* 120 */       ObjectName objectName = new ObjectName(name);
/* 121 */       rarDeployment.setObjectName(objectName);
/* 122 */       rarDeployment.setCode(RARDeployment.class.getName());
/* 123 */       ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/* 124 */       constructor.setSignature(new String[] { ConnectorMetaData.class.getName() });
/* 125 */       constructor.setParameters(new Object[] { cmd });
/* 126 */       rarDeployment.setConstructor(constructor);
/*     */ 
/* 128 */       List attributes = new ArrayList();
/* 129 */       ServiceAttributeMetaData attribute = null;
/* 130 */       if (this.workManagerName != null)
/*     */       {
/* 132 */         attribute = new ServiceAttributeMetaData();
/* 133 */         attribute.setName("WorkManager");
/* 134 */         attribute.setValue(new ServiceInjectionValueMetaData(this.workManagerName));
/* 135 */         attributes.add(attribute);
/*     */       }
/* 137 */       if (this.xaTerminatorName != null)
/*     */       {
/* 139 */         attribute = new ServiceAttributeMetaData();
/* 140 */         attribute.setName("XATerminator");
/* 141 */         attribute.setValue(new ServiceInjectionValueMetaData(this.xaTerminatorName, "XATerminator"));
/* 142 */         attributes.add(attribute);
/*     */       }
/* 144 */       if (!attributes.isEmpty()) {
/* 145 */         rarDeployment.setAttributes(attributes);
/*     */       }
/*     */ 
/* 148 */       unit.addAttachment(ServiceMetaData.class, rarDeployment);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 152 */       throw DeploymentException.rethrowAsDeploymentException("Error creating rar deployment " + unit.getName(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit, ConnectorMetaData cmd)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.deployers.RARDeployer
 * JD-Core Version:    0.6.0
 */