/*     */ package org.jboss.resource.connectionmanager.xa;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class XAResourceWrapper
/*     */   implements XAResource, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 4551722165222496828L;
/*  45 */   private static final Logger log = Logger.getLogger(XAResourceWrapper.class);
/*     */   private XAResource xaResource;
/*     */   private boolean pad;
/*     */   private Boolean overrideRmValue;
/*     */ 
/*     */   public XAResourceWrapper(XAResource resource)
/*     */   {
/*  56 */     this(Boolean.FALSE, false, resource);
/*     */   }
/*     */ 
/*     */   public XAResourceWrapper(boolean pad, XAResource resource)
/*     */   {
/*  62 */     this(Boolean.FALSE, pad, resource);
/*     */   }
/*     */ 
/*     */   public XAResourceWrapper(Boolean override, boolean pad, XAResource resource)
/*     */   {
/*  67 */     this.overrideRmValue = override;
/*  68 */     this.pad = pad;
/*  69 */     this.xaResource = resource;
/*     */   }
/*     */ 
/*     */   public void commit(Xid xid, boolean onePhase)
/*     */     throws XAException
/*     */   {
/*  75 */     xid = convertXid(xid);
/*  76 */     this.xaResource.commit(xid, onePhase);
/*     */   }
/*     */ 
/*     */   public void end(Xid xid, int flags) throws XAException
/*     */   {
/*  81 */     xid = convertXid(xid);
/*  82 */     this.xaResource.end(xid, flags);
/*     */   }
/*     */ 
/*     */   public void forget(Xid xid)
/*     */     throws XAException
/*     */   {
/*  88 */     xid = convertXid(xid);
/*  89 */     this.xaResource.forget(xid);
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout() throws XAException
/*     */   {
/*  94 */     return this.xaResource.getTransactionTimeout();
/*     */   }
/*     */ 
/*     */   public boolean isSameRM(XAResource resource)
/*     */     throws XAException
/*     */   {
/* 100 */     if (this.overrideRmValue != null)
/*     */     {
/* 102 */       if (log.isTraceEnabled())
/*     */       {
/* 104 */         log.trace("Executing isSameRM with override value" + this.overrideRmValue + " for XAResourceWrapper" + this);
/*     */       }
/*     */ 
/* 108 */       return this.overrideRmValue.booleanValue();
/*     */     }
/*     */ 
/* 113 */     if ((resource instanceof XAResourceWrapper))
/*     */     {
/* 115 */       XAResourceWrapper other = (XAResourceWrapper)resource;
/* 116 */       return this.xaResource.isSameRM(other.getResource());
/*     */     }
/*     */ 
/* 120 */     return this.xaResource.isSameRM(resource);
/*     */   }
/*     */ 
/*     */   public int prepare(Xid xid)
/*     */     throws XAException
/*     */   {
/* 130 */     xid = convertXid(xid);
/* 131 */     return this.xaResource.prepare(xid);
/*     */   }
/*     */ 
/*     */   public Xid[] recover(int flag)
/*     */     throws XAException
/*     */   {
/* 137 */     return this.xaResource.recover(flag);
/*     */   }
/*     */ 
/*     */   public void rollback(Xid xid) throws XAException
/*     */   {
/* 142 */     xid = convertXid(xid);
/* 143 */     this.xaResource.rollback(xid);
/*     */   }
/*     */ 
/*     */   public boolean setTransactionTimeout(int flag) throws XAException
/*     */   {
/* 148 */     return this.xaResource.setTransactionTimeout(flag);
/*     */   }
/*     */ 
/*     */   public void start(Xid xid, int flags)
/*     */     throws XAException
/*     */   {
/* 154 */     xid = convertXid(xid);
/* 155 */     this.xaResource.start(xid, flags);
/*     */   }
/*     */ 
/*     */   private Xid convertXid(Xid xid)
/*     */   {
/* 161 */     if ((xid instanceof JcaXid)) {
/* 162 */       return xid;
/*     */     }
/*     */ 
/* 165 */     return new JcaXid(this.pad, xid);
/*     */   }
/*     */ 
/*     */   private XAResource getResource()
/*     */   {
/* 171 */     return this.xaResource;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 176 */     return super.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.xa.XAResourceWrapper
 * JD-Core Version:    0.6.0
 */