/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.util.LinkedList;
/*     */ 
/*     */ public class PoolFiller
/*     */   implements Runnable
/*     */ {
/*  36 */   private final LinkedList pools = new LinkedList();
/*     */   private final Thread fillerThread;
/*  40 */   private static final PoolFiller filler = new PoolFiller();
/*     */ 
/*     */   public static void fillPool(InternalManagedConnectionPool mcp)
/*     */   {
/*  44 */     filler.internalFillPool(mcp);
/*     */   }
/*     */ 
/*     */   public PoolFiller()
/*     */   {
/*  49 */     this.fillerThread = new Thread(this, "JCA PoolFiller");
/*  50 */     this.fillerThread.start();
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*  55 */     ClassLoader myClassLoader = getClass().getClassLoader();
/*  56 */     Thread.currentThread().setContextClassLoader(myClassLoader);
/*     */     while (true)
/*     */     {
/*     */       try
/*     */       {
/*  62 */         InternalManagedConnectionPool mcp = null;
/*     */ 
/*  67 */         synchronized (this.pools)
/*     */         {
/*  69 */           mcp = (InternalManagedConnectionPool)this.pools.removeFirst();
/*     */         }
/*  71 */         if (mcp == null) {
/*     */           continue;
/*     */         }
/*  74 */         mcp.fillToMin(); continue;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/*  83 */         synchronized (this.pools)
/*     */         {
/*  85 */           while (this.pools.isEmpty())
/*     */           {
/*  87 */             this.pools.wait();
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ie)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void internalFillPool(InternalManagedConnectionPool mcp)
/*     */   {
/* 100 */     synchronized (this.pools)
/*     */     {
/* 102 */       this.pools.addLast(mcp);
/* 103 */       this.pools.notify();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.PoolFiller
 * JD-Core Version:    0.6.0
 */