/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.PrintWriter;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import javax.resource.spi.ResourceAdapterAssociation;
/*     */ import javax.security.auth.Subject;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.metadata.AuthenticationMechanismMetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionGroupMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
/*     */ import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryPropertyMetaData;
/*     */ import org.jboss.system.ServiceDynamicMBeanSupport;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ManagedConnectionFactoryDeployment extends ServiceDynamicMBeanSupport
/*     */   implements ManagedConnectionFactory
/*     */ {
/*     */   private static final long serialVersionUID = -8448602289610025849L;
/*     */   public static final String MCF_ATTRIBUTE_CHANGED_NOTIFICATION = "jboss.mcfattributechangednotification";
/*  83 */   private Logger log = Logger.getLogger(getClass());
/*     */   private ObjectName oldRarDeployment;
/*     */   private String rarName;
/*     */   private String connectionDefinition;
/*     */   private String vendorName;
/*     */   private String specVersion;
/*     */   private String eisType;
/*     */   private String version;
/*     */   private String managedConnectionFactoryClass;
/*     */   private String connectionFactoryInterface;
/*     */   private String connectionFactoryImplClass;
/*     */   private String connectionInterface;
/*     */   private String connectionImplClass;
/*     */   private String transactionSupport;
/*     */   private Element managedConnectionFactoryProperties;
/*     */   private String authenticationMechanismType;
/*     */   private String credentialInterface;
/*     */   private boolean reauthenticationSupport;
/*     */   private Class mcfClass;
/*     */   private String jndiName;
/*     */   private ManagedConnectionFactory mcf;
/*     */   private ManagedConnectionFactoryDeploymentMetaData dmd;
/*     */   private ConnectorMetaData cmd;
/*     */ 
/*     */   public ManagedConnectionFactoryDeployment()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ManagedConnectionFactoryDeployment(ConnectorMetaData cmd, ManagedConnectionFactoryDeploymentMetaData dmd)
/*     */   {
/* 139 */     this.cmd = cmd;
/* 140 */     this.dmd = dmd;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 145 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 150 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getRARName()
/*     */   {
/* 155 */     return this.rarName;
/*     */   }
/*     */ 
/*     */   public void setRARName(String rarName)
/*     */   {
/* 160 */     this.rarName = rarName;
/*     */   }
/*     */ 
/*     */   public String getConnectionDefinition()
/*     */   {
/* 165 */     return this.connectionDefinition;
/*     */   }
/*     */ 
/*     */   public void setConnectionDefinition(String connectionDefinition)
/*     */   {
/* 170 */     this.connectionDefinition = connectionDefinition;
/*     */   }
/*     */ 
/*     */   public String getVendorName()
/*     */   {
/* 175 */     return this.vendorName;
/*     */   }
/*     */ 
/*     */   public void setVendorName(String vendorName)
/*     */   {
/* 180 */     this.vendorName = vendorName;
/*     */   }
/*     */ 
/*     */   public String getSpecVersion()
/*     */   {
/* 185 */     return this.specVersion;
/*     */   }
/*     */ 
/*     */   public void setSpecVersion(String specVersion)
/*     */   {
/* 190 */     this.specVersion = specVersion;
/*     */   }
/*     */ 
/*     */   public String getEisType()
/*     */   {
/* 195 */     return this.eisType;
/*     */   }
/*     */ 
/*     */   public void setEisType(String eisType)
/*     */   {
/* 200 */     this.eisType = eisType;
/*     */   }
/*     */ 
/*     */   public String getVersion()
/*     */   {
/* 205 */     return this.version;
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/* 210 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getManagedConnectionFactoryClass()
/*     */   {
/* 215 */     return this.managedConnectionFactoryClass;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass)
/*     */   {
/* 220 */     this.managedConnectionFactoryClass = managedConnectionFactoryClass;
/*     */   }
/*     */ 
/*     */   public String getConnectionFactoryInterface()
/*     */   {
/* 225 */     return this.connectionFactoryInterface;
/*     */   }
/*     */ 
/*     */   public void setConnectionFactoryInterface(String connectionFactoryInterface)
/*     */   {
/* 230 */     this.connectionFactoryInterface = connectionFactoryInterface;
/*     */   }
/*     */ 
/*     */   public String getConnectionFactoryImplClass()
/*     */   {
/* 235 */     return this.connectionFactoryImplClass;
/*     */   }
/*     */ 
/*     */   public void setConnectionFactoryImplClass(String connectionFactoryImplClass)
/*     */   {
/* 240 */     this.connectionFactoryImplClass = connectionFactoryImplClass;
/*     */   }
/*     */ 
/*     */   public String getConnectionInterface()
/*     */   {
/* 245 */     return this.connectionInterface;
/*     */   }
/*     */ 
/*     */   public void setConnectionInterface(String connectionInterface)
/*     */   {
/* 250 */     this.connectionInterface = connectionInterface;
/*     */   }
/*     */ 
/*     */   public String getConnectionImplClass()
/*     */   {
/* 255 */     return this.connectionImplClass;
/*     */   }
/*     */ 
/*     */   public void setConnectionImplClass(String connectionImplClass)
/*     */   {
/* 260 */     this.connectionImplClass = connectionImplClass;
/*     */   }
/*     */ 
/*     */   public String getTransactionSupport()
/*     */   {
/* 265 */     return this.transactionSupport;
/*     */   }
/*     */ 
/*     */   public void setTransactionSupport(String transactionSupport)
/*     */   {
/* 270 */     this.transactionSupport = transactionSupport;
/*     */   }
/*     */ 
/*     */   public Element getManagedConnectionFactoryProperties()
/*     */   {
/* 275 */     return this.managedConnectionFactoryProperties;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryProperties(Element managedConnectionFactoryProperties)
/*     */   {
/* 280 */     this.managedConnectionFactoryProperties = managedConnectionFactoryProperties;
/*     */   }
/*     */ 
/*     */   public String getAuthenticationMechanismType()
/*     */   {
/* 285 */     return this.authenticationMechanismType;
/*     */   }
/*     */ 
/*     */   public void setAuthenticationMechanismType(String authenticationMechanismType)
/*     */   {
/* 290 */     this.authenticationMechanismType = authenticationMechanismType;
/*     */   }
/*     */ 
/*     */   public String getCredentialInterface()
/*     */   {
/* 295 */     return this.credentialInterface;
/*     */   }
/*     */ 
/*     */   public void setCredentialInterface(String credentialInterface)
/*     */   {
/* 300 */     this.credentialInterface = credentialInterface;
/*     */   }
/*     */ 
/*     */   public boolean isReauthenticationSupport()
/*     */   {
/* 305 */     return this.reauthenticationSupport;
/*     */   }
/*     */ 
/*     */   public void setReauthenticationSupport(boolean reauthenticationSupport)
/*     */   {
/* 310 */     this.reauthenticationSupport = reauthenticationSupport;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionFactory getMcfInstance()
/*     */   {
/* 315 */     return this.mcf;
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 320 */     if (this.mcf != null) {
/* 321 */       throw new DeploymentException("Stop the RARDeployment before restarting it");
/*     */     }
/* 323 */     ResourceAdapter resourceAdapter = null;
/* 324 */     ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.dmd.getConnectionDefinition());
/*     */     try
/*     */     {
/* 328 */       resourceAdapter = (ResourceAdapter)getServer().getAttribute(this.oldRarDeployment, "ResourceAdapter");
/*     */ 
/* 330 */       if (cdmd == null) {
/* 331 */         throw new DeploymentException("ConnectionDefinition '" + this.connectionDefinition + "' not found in rar '" + this.rarName + "'");
/*     */       }
/*     */ 
/* 334 */       setManagedConnectionFactoryClass(cdmd.getManagedConnectionFactoryClass());
/* 335 */       setReauthenticationSupport(this.cmd.getReauthenticationSupport());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 339 */       throw new DeploymentException("couldn't get oldRarDeployment! " + this.oldRarDeployment, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 344 */       this.mcfClass = Thread.currentThread().getContextClassLoader().loadClass(cdmd.getManagedConnectionFactoryClass());
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/* 348 */       this.log.error("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass, cnfe);
/* 349 */       throw new DeploymentException("Could not find ManagedConnectionFactory class: " + this.managedConnectionFactoryClass);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 354 */       this.mcf = ((ManagedConnectionFactory)this.mcfClass.newInstance());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 358 */       this.log.error("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass, e);
/* 359 */       throw new DeploymentException("Could not instantiate ManagedConnectionFactory: " + this.managedConnectionFactoryClass);
/*     */     }
/*     */ 
/* 363 */     if (this.cmd != null)
/*     */     {
/* 366 */       setMcfProperties(this.cmd.getProperties(), false);
/*     */ 
/* 368 */       setMcfProperties(cdmd.getProperties(), true);
/*     */     }
/*     */ 
/* 371 */     setManagedConnectionFactoryProperties(this.dmd.getManagedConnectionFactoryProperties());
/*     */ 
/* 373 */     if ((resourceAdapter != null) && ((this.mcf instanceof ResourceAdapterAssociation)))
/*     */     {
/* 375 */       ResourceAdapterAssociation raa = (ResourceAdapterAssociation)this.mcf;
/* 376 */       raa.setResourceAdapter(resourceAdapter);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/* 382 */     this.mcf = null;
/* 383 */     this.mcfClass = null;
/* 384 */     this.cmd = null;
/* 385 */     this.dmd = null;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value)
/*     */   {
/* 390 */     setManagedConnectionFactoryAttribute(name, clazz, value, false);
/*     */   }
/*     */ 
/*     */   protected void setManagedConnectionFactoryAttribute(String name, Class clazz, Object value, boolean mustExist)
/*     */   {
/* 395 */     if ((name == null) || (name.length() == 0))
/* 396 */       throw new IllegalArgumentException("Null or empty attribute name " + name);
/* 397 */     String setterName = "set" + Character.toUpperCase(name.charAt(0));
/* 398 */     if (name.length() > 1)
/* 399 */       setterName = setterName.concat(name.substring(1));
/*     */     Method setter;
/*     */     try {
/* 403 */       setter = this.mcfClass.getMethod(setterName, new Class[] { clazz });
/*     */     }
/*     */     catch (NoSuchMethodException nsme)
/*     */     {
/* 407 */       String error = "The class '" + this.mcfClass.toString() + "' has no setter for config property '" + name + "'";
/* 408 */       if (mustExist) {
/* 409 */         throw new IllegalArgumentException(error);
/*     */       }
/*     */ 
/* 412 */       this.log.trace(error, nsme);
/* 413 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 418 */       setter.invoke(this.mcf, new Object[] { value });
/* 419 */       this.log.debug("set property " + name + " to value " + value);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 423 */       String error = "Unable to invoke setter method '" + setter + "' " + "on object '" + this.mcf + "'";
/* 424 */       if ((e instanceof InvocationTargetException)) {
/* 425 */         throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
/*     */       }
/* 427 */       throw new NestedRuntimeException(error, e);
/*     */     }
/* 429 */     sendNotification(new Notification("jboss.mcfattributechangednotification", getServiceName(), getNextNotificationSequenceNumber()));
/*     */   }
/*     */ 
/*     */   public Object getManagedConnectionFactoryAttribute(String name)
/*     */   {
/* 435 */     if ((name == null) || (name.length() == 0))
/* 436 */       throw new IllegalArgumentException("Null or empty attribute name " + name);
/* 437 */     String getterName = "get" + Character.toUpperCase(name.charAt(0));
/* 438 */     if (name.length() > 1)
/* 439 */       getterName = getterName.concat(name.substring(1));
/*     */     Method getter;
/*     */     try {
/* 443 */       getter = this.mcfClass.getMethod(getterName, new Class[0]);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 447 */       String msg = "The class '" + this.mcfClass + "' has no getter(" + getterName + ") for config property '" + name + "'";
/*     */ 
/* 449 */       this.log.debug(msg, e);
/* 450 */       throw new IllegalArgumentException(msg);
/*     */     }String error;
/*     */     try {
/* 454 */       Object value = getter.invoke(this.mcf, new Object[0]);
/* 455 */       this.log.debug("get property " + name + ": value " + value);
/* 456 */       return value;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 460 */       error = "Unable to invoke getter method '" + getter + "' " + "on object '" + this.mcf + "'";
/* 461 */       this.log.debug(error, e);
/* 462 */       if ((e instanceof InvocationTargetException))
/* 463 */         throw new NestedRuntimeException(error, ((InvocationTargetException)e).getCause());
/*     */     }
/* 465 */     throw new NestedRuntimeException(error, e);
/*     */   }
/*     */ 
/*     */   protected void setMcfProperties(Collection properties, boolean mustExist)
/*     */     throws DeploymentException
/*     */   {
/* 471 */     for (Iterator i = properties.iterator(); i.hasNext(); )
/*     */     {
/* 473 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/* 474 */       String name = cpmd.getName();
/* 475 */       String type = cpmd.getType();
/* 476 */       String value = cpmd.getValue();
/* 477 */       if ((name == null) || (name.length() == 0) || (value == null) || (value.length() == 0))
/*     */       {
/* 479 */         this.log.debug("Not setting config property '" + name + "'");
/* 480 */         continue;
/*     */       }
/*     */ 
/* 483 */       Class clazz = Classes.getPrimitiveTypeForName(type);
/* 484 */       if (clazz == null)
/*     */       {
/*     */         try
/*     */         {
/* 489 */           clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
/*     */         }
/*     */         catch (ClassNotFoundException cnfe)
/*     */         {
/* 493 */           this.log.warn("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property.");
/* 494 */         }continue;
/*     */       }
/*     */ 
/* 497 */       PropertyEditor pe = PropertyEditorManager.findEditor(clazz);
/* 498 */       if (pe == null)
/*     */       {
/* 500 */         this.log.warn("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property");
/*     */ 
/* 502 */         continue;
/*     */       }
/*     */ 
/* 505 */       value = StringPropertyReplacer.replaceProperties(value);
/* 506 */       this.log.debug("setting property: " + name + " to value " + value);
/*     */       try
/*     */       {
/* 509 */         pe.setAsText(value);
/*     */       }
/*     */       catch (IllegalArgumentException iae)
/*     */       {
/* 513 */         this.log.warn("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property");
/*     */       }
/* 515 */       continue;
/*     */ 
/* 517 */       Object v = pe.getValue();
/* 518 */       setManagedConnectionFactoryAttribute(name, clazz, v, mustExist);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setManagedConnectionFactoryProperties(List<ManagedConnectionFactoryPropertyMetaData> properties)
/*     */   {
/* 525 */     for (ManagedConnectionFactoryPropertyMetaData property : properties)
/*     */     {
/* 527 */       String name = property.getName();
/* 528 */       String type = property.getType();
/* 529 */       String value = property.getValue();
/*     */ 
/* 531 */       if ((name == null) || (name.length() == 0) || (value == null) || (value.length() == 0))
/*     */       {
/* 533 */         this.log.debug("Not setting config property '" + name + "'");
/* 534 */         continue;
/*     */       }
/*     */ 
/* 537 */       if ((type == null) || (type.length() == 0))
/*     */       {
/* 540 */         type = "java.lang.String";
/*     */       }
/* 542 */       Class clazz = Classes.getPrimitiveTypeForName(type);
/* 543 */       if (clazz == null)
/*     */       {
/*     */         try
/*     */         {
/* 548 */           clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
/*     */         }
/*     */         catch (ClassNotFoundException cnfe)
/*     */         {
/* 552 */           this.log.warn("Unable to find class '" + type + "' for " + "property '" + name + "' - skipping property.");
/*     */         }
/* 554 */         continue;
/*     */       }
/*     */ 
/* 557 */       PropertyEditor pe = PropertyEditorManager.findEditor(clazz);
/* 558 */       if (pe == null)
/*     */       {
/* 560 */         this.log.warn("Unable to find a PropertyEditor for class '" + clazz + "' of property '" + name + "' - " + "skipping property");
/*     */ 
/* 562 */         continue;
/*     */       }
/*     */ 
/* 565 */       value = StringPropertyReplacer.replaceProperties(value);
/* 566 */       this.log.debug("setting property: " + name + " to value " + value);
/*     */       try
/*     */       {
/* 569 */         pe.setAsText(value);
/*     */       }
/*     */       catch (IllegalArgumentException iae)
/*     */       {
/* 573 */         this.log.warn("Value '" + value + "' is not valid for property '" + name + "' of class '" + clazz + "' - skipping " + "property");
/*     */       }
/* 575 */       continue;
/*     */ 
/* 577 */       Object v = pe.getValue();
/* 578 */       setManagedConnectionFactoryAttribute(name, clazz, v);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory()
/*     */     throws ResourceException
/*     */   {
/* 587 */     return this.mcf.createConnectionFactory();
/*     */   }
/*     */ 
/*     */   public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException
/*     */   {
/* 592 */     return this.mcf.createConnectionFactory(cxManager);
/*     */   }
/*     */ 
/*     */   public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo)
/*     */     throws ResourceException
/*     */   {
/* 598 */     return this.mcf.createManagedConnection(subject, cxRequestInfo);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 603 */     return this.mcf.equals(other);
/*     */   }
/*     */ 
/*     */   public PrintWriter getLogWriter() throws ResourceException
/*     */   {
/* 608 */     return this.mcf.getLogWriter();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 613 */     StringBuffer buffer = new StringBuffer();
/* 614 */     buffer.append(getClass().getName());
/* 615 */     buffer.append('@');
/* 616 */     buffer.append(Integer.toHexString(System.identityHashCode(this)));
/* 617 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 622 */     return this.mcf.hashCode();
/*     */   }
/*     */ 
/*     */   public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo)
/*     */     throws ResourceException
/*     */   {
/* 628 */     return this.mcf.matchManagedConnections(connectionSet, subject, cxRequestInfo);
/*     */   }
/*     */ 
/*     */   public void setLogWriter(PrintWriter out) throws ResourceException
/*     */   {
/* 633 */     this.mcf.setLogWriter(out);
/*     */   }
/*     */ 
/*     */   protected MBeanAttributeInfo[] getInternalAttributeInfo()
/*     */   {
/* 639 */     List attributes = new ArrayList();
/* 640 */     attributes.add(new MBeanAttributeInfo("RARName", String.class.getName(), "The ResourceAdapter deployment name.", true, false, false));
/* 641 */     attributes.add(new MBeanAttributeInfo("OldRarDeployment", ObjectName.class.getName(), "The Connection Defintion class name.", true, true, false));
/* 642 */     attributes.add(new MBeanAttributeInfo("ConnectionDefinition", String.class.getName(), "The Connection Defintion class name.", true, false, false));
/* 643 */     attributes.add(new MBeanAttributeInfo("VendorName", String.class.getName(), "The Vendor Name.", true, false, false));
/* 644 */     attributes.add(new MBeanAttributeInfo("SpecVersion", String.class.getName(), "The Specification Version.", true, false, false));
/* 645 */     attributes.add(new MBeanAttributeInfo("EisType", String.class.getName(), "The Enterprise Information System type.", true, false, false));
/* 646 */     attributes.add(new MBeanAttributeInfo("Version", String.class.getName(), "The ResourceAdapter version.", true, false, false));
/* 647 */     attributes.add(new MBeanAttributeInfo("ManagedConnectionFactoryClass", String.class.getName(), "The ManagedConnectionFactory class", true, false, false));
/* 648 */     attributes.add(new MBeanAttributeInfo("ConnectionFactoryImpl", String.class.getName(), "The Connection Factory implementation", true, false, false));
/* 649 */     attributes.add(new MBeanAttributeInfo("ConnectionInterface", String.class.getName(), "The Connection Inteface", true, false, false));
/* 650 */     attributes.add(new MBeanAttributeInfo("ConnectionImplClass", String.class.getName(), "The Connection Implementation class", true, false, false));
/* 651 */     attributes.add(new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The Transaction Support", true, false, false));
/* 652 */     attributes.add(new MBeanAttributeInfo("AuthenticationMechanismType", String.class.getName(), "The Authentication Mechanism Type", true, false, false));
/* 653 */     attributes.add(new MBeanAttributeInfo("CredentialInterface", String.class.getName(), "The Credential Interface", true, false, false));
/* 654 */     attributes.add(new MBeanAttributeInfo("ReauthenticationSupport", Boolean.class.getName(), "The Reauthentication Support", true, false, true));
/* 655 */     attributes.add(new MBeanAttributeInfo("McfInstance", "javax.resource.spi.ManagedConnectionFactory", "The ManagedConnectionFactory instance", true, false, false));
/*     */ 
/* 657 */     ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.connectionDefinition);
/*     */ 
/* 666 */     MBeanAttributeInfo[] info = (MBeanAttributeInfo[])attributes.toArray(new MBeanAttributeInfo[attributes.size()]);
/* 667 */     return info;
/*     */   }
/*     */ 
/*     */   protected void setInternalAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 674 */     if ("OldRarDeployment".equals(attribute.getName()))
/*     */     {
/* 676 */       this.oldRarDeployment = ((ObjectName)attribute.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected MBeanOperationInfo[] getInternalOperationInfo()
/*     */   {
/* 684 */     MBeanOperationInfo[] operations = new MBeanOperationInfo[1];
/* 685 */     MBeanParameterInfo[] getMCFAttributeParamInfo = { new MBeanParameterInfo("ManagedConnectionFactoryAttributeName", String.class.getName(), "The ManagedConnectionFactoryAttribute name") };
/* 686 */     operations[0] = new MBeanOperationInfo("getManagedConnectionFactoryAttribute", "Inspect the value of a ManagedConnectionFactory attribute", getMCFAttributeParamInfo, Object.class.getName(), 0);
/* 687 */     return operations;
/*     */   }
/*     */ 
/*     */   protected Object internalInvoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 694 */     if (actionName.equals("getManagedConnectionFactoryAttribute"))
/*     */     {
/* 696 */       String param = (String)params[0];
/* 697 */       return getManagedConnectionFactoryAttribute(param);
/*     */     }
/*     */ 
/* 702 */     return super.internalInvoke(actionName, params, signature);
/*     */   }
/*     */ 
/*     */   protected Object getInternalAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 710 */     ConnectionDefinitionMetaData cdmd = this.cmd.getConnectionDefinition(this.dmd.getConnectionDefinition());
/*     */ 
/* 712 */     Object result = null;
/*     */ 
/* 714 */     if ("RARName".equals(attribute))
/*     */     {
/* 716 */       result = this.rarName;
/*     */     }
/* 718 */     else if ("OldRarDeployment".equals(attribute))
/*     */     {
/* 720 */       result = this.oldRarDeployment;
/*     */     }
/* 722 */     else if ("ConnectionDefinition".equals(attribute))
/*     */     {
/* 724 */       result = this.dmd.getConnectionDefinition();
/*     */     }
/* 726 */     else if ("VendorName".equals(attribute))
/*     */     {
/* 728 */       result = this.cmd.getVendorName();
/*     */     }
/* 730 */     else if ("SpecVersion".equals(attribute))
/*     */     {
/* 732 */       result = this.cmd.getVersion();
/*     */     }
/* 734 */     else if ("EisType".equals(attribute))
/*     */     {
/* 736 */       result = this.cmd.getEISType();
/*     */     }
/* 738 */     else if ("Version".equals(attribute))
/*     */     {
/* 740 */       result = this.cmd.getRAVersion();
/*     */     }
/* 742 */     else if ("ManagedConnectionFactoryClass".equals(attribute))
/*     */     {
/* 744 */       result = cdmd.getManagedConnectionFactoryClass();
/*     */     }
/* 746 */     else if ("ConnectionInterface".equals(attribute))
/*     */     {
/* 748 */       result = cdmd.getConnectionInterfaceClass();
/*     */     }
/* 750 */     else if ("ConnectionFactoryImpl".equals(attribute))
/*     */     {
/* 752 */       result = cdmd.getConnectionFactoryImplementationClass();
/*     */     }
/* 754 */     else if ("ConnectionImplClass".equals(attribute))
/*     */     {
/* 756 */       result = cdmd.getConnectionImplementationClass();
/*     */     }
/* 759 */     else if ("TransactionSupport".equals(attribute))
/*     */     {
/* 761 */       result = this.dmd.getTransactionSupportMetaData();
/*     */     }
/* 764 */     else if ("AuthenticationMechanismType".equals(attribute))
/*     */     {
/* 766 */       result = this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
/*     */     }
/* 769 */     else if ("CredentialInterface".equals(attribute))
/*     */     {
/* 771 */       result = this.cmd.getAuthenticationMechanism().getCredentialInterfaceClass();
/*     */     }
/* 774 */     else if ("ReauthenticationSupport".equals(attribute))
/*     */     {
/* 776 */       result = Boolean.valueOf(this.cmd.getReauthenticationSupport());
/*     */     }
/* 779 */     else if ("McfInstance".equals(attribute))
/*     */     {
/* 781 */       result = this.mcf;
/*     */     }
/*     */ 
/* 784 */     if (result == null)
/*     */     {
/* 786 */       result = super.getInternalAttribute(attribute);
/*     */     }
/*     */ 
/* 789 */     return result;
/*     */   }
/*     */ 
/*     */   protected String getInternalDescription()
/*     */   {
/* 794 */     String description = null;
/* 795 */     DescriptionGroupMetaData dgmd = this.cmd.getDescription();
/* 796 */     if (dgmd != null)
/* 797 */       description = dgmd.getDescription();
/* 798 */     if (description == null)
/* 799 */       description = "RAR Deployment ";
/* 800 */     return description;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.ManagedConnectionFactoryDeployment
 * JD-Core Version:    0.6.0
 */