/*      */ package org.jboss.resource.connectionmanager;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.util.Collection;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.Notification;
/*      */ import javax.management.NotificationFilter;
/*      */ import javax.management.NotificationListener;
/*      */ import javax.management.ObjectName;
/*      */ import javax.resource.ResourceException;
/*      */ import javax.resource.spi.ConnectionRequestInfo;
/*      */ import javax.resource.spi.ManagedConnectionFactory;
/*      */ import javax.security.auth.Subject;
/*      */ import javax.transaction.Transaction;
/*      */ import javax.transaction.TransactionManager;
/*      */ import org.jboss.deployers.spi.DeploymentException;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.managed.api.ManagedOperation.Impact;
/*      */ import org.jboss.managed.api.annotation.ManagementObject;
/*      */ import org.jboss.managed.api.annotation.ManagementObjectID;
/*      */ import org.jboss.managed.api.annotation.ManagementOperation;
/*      */ import org.jboss.managed.api.annotation.ManagementProperties;
/*      */ import org.jboss.managed.api.annotation.ManagementProperty;
/*      */ import org.jboss.mx.util.JMXExceptionDecoder;
/*      */ import org.jboss.resource.JBossResourceException;
/*      */ import org.jboss.resource.statistic.JBossStatistics;
/*      */ import org.jboss.resource.statistic.StatisticsReporter;
/*      */ import org.jboss.resource.statistic.formatter.StatisticsFormatter;
/*      */ import org.jboss.resource.statistic.pool.JBossDefaultSubPoolStatisticFormatter;
/*      */ import org.jboss.resource.statistic.pool.JBossManagedConnectionPoolStatistics;
/*      */ import org.jboss.resource.statistic.pool.JBossSubPoolStatistics;
/*      */ import org.jboss.resource.statistic.pool.ManagedConnectionPoolStatistics;
/*      */ import org.jboss.system.ServiceMBeanSupport;
/*      */ import org.jboss.tm.TransactionLocal;
/*      */ 
/*      */ @ManagementObject(isRuntime=true, properties=ManagementProperties.EXPLICIT)
/*      */ public class JBossManagedConnectionPool extends ServiceMBeanSupport
/*      */   implements JBossManagedConnectionPoolMBean, NotificationListener
/*      */ {
/*   84 */   static Logger log = Logger.getLogger(JBossManagedConnectionPool.class);
/*      */   private ObjectName managedConnectionFactoryName;
/*      */   private String criteria;
/*      */   private ManagedConnectionPool poolingStrategy;
/*   96 */   private final InternalManagedConnectionPool.PoolParams poolParams = new InternalManagedConnectionPool.PoolParams();
/*      */   private boolean noTxSeparatePools;
/*      */   private String statisticsFormatter;
/*      */   private String poolJndiName;
/*      */ 
/*      */   @ManagementOperation(description="Obtain a formatted statistics report", impact=ManagedOperation.Impact.ReadOnly, params={@org.jboss.managed.api.annotation.ManagementParameter(name="formatClassName", description="The StatisticsFormatter class name")})
/*      */   public Object listFormattedSubPoolStatistics(String formatClassName)
/*      */   {
/*  117 */     JBossStatistics stats = (JBossStatistics)listStatistics();
/*  118 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*      */ 
/*  120 */     StatisticsFormatter formatter = null;
/*      */     try
/*      */     {
/*  124 */       Class clazz = cl.loadClass(formatClassName);
/*  125 */       formatter = (StatisticsFormatter)clazz.newInstance();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  129 */       log.warn("warn: statistics formatter not found, setting to " + this.statisticsFormatter);
/*  130 */       formatter = new JBossDefaultSubPoolStatisticFormatter();
/*      */     }
/*      */ 
/*  134 */     return formatter.formatStatistics(stats);
/*      */   }
/*      */ 
/*      */   @ManagementOperation(description="Obtain a formatted statistics report", impact=ManagedOperation.Impact.ReadOnly)
/*      */   public Object listFormattedSubPoolStatistics()
/*      */   {
/*  142 */     Object formatted = listFormattedSubPoolStatistics(this.statisticsFormatter);
/*  143 */     return formatted;
/*      */   }
/*      */ 
/*      */   @ManagementOperation(description="Obtain a statistics report", impact=ManagedOperation.Impact.ReadOnly)
/*      */   public Object listStatistics()
/*      */   {
/*  150 */     ManagedConnectionPoolStatistics stats = null;
/*      */ 
/*  152 */     if ((this.poolingStrategy instanceof StatisticsReporter))
/*      */     {
/*  155 */       StatisticsReporter reporter = (StatisticsReporter)this.poolingStrategy;
/*  156 */       stats = (ManagedConnectionPoolStatistics)reporter.listStatistics();
/*  157 */       stats.setCriteria(getCriteria());
/*  158 */       stats.setName(getManagedConnectionFactoryName().toString());
/*      */     }
/*      */ 
/*  162 */     return stats;
/*      */   }
/*      */ 
/*      */   public ManagedConnectionPool getManagedConnectionPool()
/*      */   {
/*  167 */     return this.poolingStrategy;
/*      */   }
/*      */ 
/*      */   public ObjectName getManagedConnectionFactoryName()
/*      */   {
/*  172 */     return this.managedConnectionFactoryName;
/*      */   }
/*      */ 
/*      */   public void setManagedConnectionFactoryName(ObjectName newManagedConnectionFactoryName)
/*      */   {
/*  177 */     this.managedConnectionFactoryName = newManagedConnectionFactoryName;
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="number of available connection")
/*      */   public long getAvailableConnectionCount() {
/*  183 */     return this.poolingStrategy == null ? 0L : this.poolingStrategy.getAvailableConnectionCount();
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="number of maximum connections in use")
/*      */   public long getMaxConnectionsInUseCount() {
/*  189 */     return this.poolingStrategy.getMaxConnectionsInUseCount();
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="number of connections currently in use")
/*      */   public long getInUseConnectionCount() {
/*  195 */     return this.poolingStrategy.getInUseConnectionCount();
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*      */   public int getMinSize() {
/*  201 */     return this.poolParams.minSize;
/*      */   }
/*      */ 
/*      */   public void setMinSize(int newMinSize)
/*      */   {
/*  206 */     this.poolParams.minSize = newMinSize;
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*      */   public int getMaxSize() {
/*  212 */     return this.poolParams.maxSize;
/*      */   }
/*      */ 
/*      */   public void setMaxSize(int newMaxSize)
/*      */   {
/*  217 */     this.poolParams.maxSize = newMaxSize;
/*      */   }
/*      */ 
/*      */   public int getBlockingTimeoutMillis()
/*      */   {
/*  222 */     return this.poolParams.blockingTimeout;
/*      */   }
/*      */ 
/*      */   public void setBlockingTimeoutMillis(int newBlockingTimeout)
/*      */   {
/*  227 */     this.poolParams.blockingTimeout = newBlockingTimeout;
/*      */   }
/*      */ 
/*      */   public long getIdleTimeoutMinutes()
/*      */   {
/*  232 */     return this.poolParams.idleTimeout / 60000L;
/*      */   }
/*      */ 
/*      */   public void setIdleTimeoutMinutes(long newIdleTimeoutMinutes)
/*      */   {
/*  237 */     this.poolParams.idleTimeout = (newIdleTimeoutMinutes * 1000L * 60L);
/*      */   }
/*      */ 
/*      */   public long getIdleTimeout()
/*      */   {
/*  247 */     return this.poolParams.idleTimeout;
/*      */   }
/*      */ 
/*      */   public void setIdleTimeout(long newIdleTimeout)
/*      */   {
/*  257 */     this.poolParams.idleTimeout = newIdleTimeout;
/*      */   }
/*      */ 
/*      */   public String getCriteria()
/*      */   {
/*  262 */     return this.criteria;
/*      */   }
/*      */ 
/*      */   public void setCriteria(String newCriteria)
/*      */   {
/*  267 */     this.criteria = newCriteria;
/*      */   }
/*      */ 
/*      */   public boolean getNoTxSeparatePools()
/*      */   {
/*  272 */     return this.noTxSeparatePools;
/*      */   }
/*      */ 
/*      */   public void setNoTxSeparatePools(boolean value)
/*      */   {
/*  277 */     this.noTxSeparatePools = value;
/*      */   }
/*      */ 
/*      */   public boolean getPreFill()
/*      */   {
/*  282 */     return this.poolParams.prefill;
/*      */   }
/*      */ 
/*      */   public void setPreFill(boolean prefill)
/*      */   {
/*  288 */     this.poolParams.prefill = prefill;
/*      */   }
/*      */ 
/*      */   public void setStrictMin(boolean strictMin)
/*      */   {
/*  293 */     this.poolParams.stictMin = strictMin;
/*      */   }
/*      */ 
/*      */   public boolean getStrictMin()
/*      */   {
/*  300 */     return this.poolParams.stictMin;
/*      */   }
/*      */ 
/*      */   public boolean getUseFastFail()
/*      */   {
/*  306 */     return this.poolParams.useFastFail;
/*      */   }
/*      */ 
/*      */   public void setUseFastFail(boolean useFastFail)
/*      */   {
/*  311 */     this.poolParams.useFastFail = useFastFail;
/*      */   }
/*      */ 
/*      */   @ManagementOperation(description="Flush the connections in the pool", impact=ManagedOperation.Impact.WriteOnly)
/*      */   public void flush() {
/*  317 */     if (this.poolingStrategy == null) {
/*  318 */       throw new IllegalStateException("The connection pool is not started");
/*      */     }
/*  320 */     this.poolingStrategy.flush();
/*      */ 
/*  322 */     if ((this.poolingStrategy instanceof PreFillPoolSupport))
/*      */     {
/*  324 */       PreFillPoolSupport pfs = (PreFillPoolSupport)this.poolingStrategy;
/*      */ 
/*  326 */       if (pfs.shouldPreFill())
/*  327 */         pfs.prefill(this.noTxSeparatePools);
/*      */     }
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*      */   public int getConnectionCount()
/*      */   {
/*  335 */     return this.poolingStrategy == null ? 0 : this.poolingStrategy.getConnectionCount();
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*      */   public int getConnectionCreatedCount() {
/*  341 */     return this.poolingStrategy == null ? 0 : this.poolingStrategy.getConnectionCreatedCount();
/*      */   }
/*      */ 
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC})
/*      */   public int getConnectionDestroyedCount() {
/*  347 */     return this.poolingStrategy == null ? 0 : this.poolingStrategy.getConnectionDestroyedCount();
/*      */   }
/*      */ 
/*      */   public String getName()
/*      */   {
/*  352 */     return "JBossManagedConnectionPool";
/*      */   }
/*      */ 
/*      */   public String getStatisticsFormatter() {
/*  356 */     return this.statisticsFormatter;
/*      */   }
/*      */ 
/*      */   public void setStatisticsFormatter(String statisticsFormatter)
/*      */   {
/*  361 */     this.statisticsFormatter = statisticsFormatter;
/*      */   }
/*      */ 
/*      */   @ManagementObjectID(type="DataSource")
/*      */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME})
/*      */   public String getPoolJndiName()
/*      */   {
/*  373 */     return this.poolJndiName;
/*      */   }
/*      */ 
/*      */   public void setPoolJndiName(String poolName)
/*      */   {
/*  378 */     this.poolJndiName = poolName;
/*      */   }
/*      */ 
/*      */   public boolean getBackGroundValidation()
/*      */   {
/*  383 */     return this.poolParams.backgroundValidation;
/*      */   }
/*      */ 
/*      */   public void setBackGroundValidation(boolean backgroundValidation)
/*      */   {
/*  389 */     this.poolParams.backgroundValidation = backgroundValidation;
/*      */   }
/*      */ 
/*      */   public long getBackGroundValidationMinutes()
/*      */   {
/*  396 */     return this.poolParams.backgroundInterval / 60000L;
/*      */   }
/*      */ 
/*      */   public void setBackGroundValidationMinutes(long backgroundValidationInterval)
/*      */   {
/*  402 */     this.poolParams.backgroundInterval = (backgroundValidationInterval * 1000L * 60L);
/*      */   }
/*      */ 
/*      */   protected void startService()
/*      */     throws Exception
/*      */   {
/*  408 */     ManagedConnectionFactory mcf = null;
/*      */ 
/*  410 */     if (this.managedConnectionFactoryName == null)
/*      */     {
/*  412 */       throw new DeploymentException("ManagedConnectionFactory is not set.");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  420 */       mcf = (ManagedConnectionFactory)this.server.getAttribute(this.managedConnectionFactoryName, "McfInstance");
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  424 */       JMXExceptionDecoder.rethrow(e);
/*      */     }
/*      */ 
/*  427 */     getServer().addNotificationListener(this.managedConnectionFactoryName, this, new NotificationFilter()
/*      */     {
/*      */       private static final long serialVersionUID = -9211456539783257343L;
/*      */ 
/*      */       public boolean isNotificationEnabled(Notification n)
/*      */       {
/*  437 */         return ("jboss.mcfattributechangednotification".equals(n.getType())) && (JBossManagedConnectionPool.this.managedConnectionFactoryName.equals(n.getSource()));
/*      */       }
/*      */     }
/*      */     , null);
/*      */ 
/*  444 */     if ("ByContainerAndApplication".equals(this.criteria))
/*  445 */       this.poolingStrategy = new PoolBySubjectAndCri(mcf, this.poolParams, this.noTxSeparatePools, log);
/*  446 */     else if ("ByContainer".equals(this.criteria))
/*  447 */       this.poolingStrategy = new PoolBySubject(mcf, this.poolParams, this.noTxSeparatePools, log);
/*  448 */     else if ("ByApplication".equals(this.criteria))
/*  449 */       this.poolingStrategy = new PoolByCri(mcf, this.poolParams, this.noTxSeparatePools, log);
/*  450 */     else if ("ByNothing".equals(this.criteria))
/*  451 */       this.poolingStrategy = new OnePool(mcf, this.poolParams, this.noTxSeparatePools, log);
/*      */     else
/*  453 */       throw new DeploymentException("Unknown pooling criteria: " + this.criteria);
/*      */   }
/*      */ 
/*      */   protected void stopService()
/*      */     throws Exception
/*      */   {
/*  459 */     if (this.poolingStrategy != null)
/*      */     {
/*  461 */       this.poolingStrategy.shutdown();
/*      */     }
/*      */ 
/*  465 */     getServer().removeNotificationListener(this.managedConnectionFactoryName, this);
/*  466 */     this.poolingStrategy = null;
/*      */   }
/*      */ 
/*      */   public void handleNotification(Notification notification, Object handback)
/*      */   {
/*  471 */     log.trace("Flushing pool due to notification from ManagedConnectionFactory" + notification);
/*  472 */     flush();
/*      */   }
/*      */ 
/*      */   private static class SubjectActions
/*      */     implements PrivilegedAction
/*      */   {
/*      */     Subject subject;
/*      */     Subject other;
/*      */ 
/*      */     SubjectActions(Subject subject, Subject other)
/*      */     {
/* 1306 */       this.subject = subject;
/* 1307 */       this.other = other;
/*      */     }
/*      */ 
/*      */     public Object run() {
/* 1311 */       Object value = null;
/* 1312 */       if (this.other == null)
/* 1313 */         value = new Integer(this.subject.hashCode());
/*      */       else
/* 1315 */         value = new Boolean(this.subject.equals(this.other));
/* 1316 */       return value;
/*      */     }
/*      */ 
/*      */     static int hashCode(Subject subject) {
/* 1320 */       SubjectActions action = new SubjectActions(subject, null);
/* 1321 */       Integer hash = (Integer)AccessController.doPrivileged(action);
/* 1322 */       return hash.intValue();
/*      */     }
/*      */ 
/*      */     static boolean equals(Subject subject, Subject other) {
/* 1326 */       SubjectActions action = new SubjectActions(subject, other);
/* 1327 */       Boolean equals = (Boolean)AccessController.doPrivileged(action);
/* 1328 */       return equals.booleanValue();
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class OnePool extends JBossManagedConnectionPool.BasePool
/*      */   {
/*      */     public OnePool(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, Logger log)
/*      */     {
/* 1269 */       super(poolParams, noTxSeparatePools, log);
/*      */     }
/*      */ 
/*      */     protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx)
/*      */     {
/* 1274 */       if (separateNoTx) {
/* 1275 */         return Boolean.TRUE;
/*      */       }
/* 1277 */       return Boolean.FALSE;
/*      */     }
/*      */ 
/*      */     public void prefill(Subject sub)
/*      */     {
/* 1282 */       JBossManagedConnectionPool.log.debug("Attempting to prefill pool" + getClass());
/*      */       try
/*      */       {
/* 1287 */         getSubPool(getKey(null, null, false), null, null);
/*      */       }
/*      */       catch (ResourceException e)
/*      */       {
/* 1293 */         JBossManagedConnectionPool.log.error("Prefill failed for pool instance " + getClass(), e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class CriKey
/*      */   {
/* 1223 */     private static final Object NOCRI = new Object();
/*      */     private final Object cri;
/*      */     private boolean separateNoTx;
/* 1232 */     private int hashCode = 2147483647;
/*      */ 
/*      */     CriKey(ConnectionRequestInfo cri, boolean separateNoTx)
/*      */     {
/* 1236 */       this.cri = (cri == null ? NOCRI : cri);
/* 1237 */       this.separateNoTx = separateNoTx;
/*      */     }
/*      */ 
/*      */     public int hashCode()
/*      */     {
/* 1242 */       if (this.hashCode == 2147483647)
/* 1243 */         this.hashCode = this.cri.hashCode();
/* 1244 */       return this.hashCode;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object obj)
/*      */     {
/* 1249 */       if (this == obj)
/* 1250 */         return true;
/* 1251 */       if ((obj == null) || (!(obj instanceof CriKey)))
/* 1252 */         return false;
/* 1253 */       CriKey other = (CriKey)obj;
/* 1254 */       return (this.cri.equals(other.cri)) && (this.separateNoTx == other.separateNoTx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class PoolByCri extends JBossManagedConnectionPool.BasePool
/*      */   {
/*      */     public PoolByCri(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, Logger log)
/*      */     {
/* 1180 */       super(poolParams, noTxSeparatePools, log);
/*      */     }
/*      */ 
/*      */     protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx)
/*      */     {
/* 1185 */       return new JBossManagedConnectionPool.CriKey(cri, separateNoTx);
/*      */     }
/*      */ 
/*      */     public void prefill()
/*      */     {
/* 1190 */       prefill(null, null, false);
/*      */     }
/*      */ 
/*      */     public void prefill(boolean noTxSeperatePool)
/*      */     {
/* 1195 */       prefill(null, null, noTxSeperatePool);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri)
/*      */     {
/* 1200 */       prefill(subject, cri, false);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool)
/*      */     {
/* 1206 */       if (getPreFill())
/*      */       {
/* 1208 */         JBossManagedConnectionPool.log.warn("Prefill pool option was selected for pool with JNDI name " + getPoolName() + " that does not support this feature.");
/*      */ 
/* 1210 */         JBossManagedConnectionPool.log.warn("Please verify your *-ds.xml file that corresponds with this resource and either remove the <prefill>true|false</prefill element or explicitly set this value to false.");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class SubjectKey
/*      */   {
/* 1133 */     private static final Subject NOSUBJECT = new Subject();
/*      */     private final Subject subject;
/*      */     private boolean separateNoTx;
/* 1142 */     private int hashCode = 2147483647;
/*      */ 
/*      */     SubjectKey(Subject subject, boolean separateNoTx)
/*      */     {
/* 1146 */       this.subject = (subject == null ? NOSUBJECT : subject);
/* 1147 */       this.separateNoTx = separateNoTx;
/*      */     }
/*      */ 
/*      */     public int hashCode()
/*      */     {
/* 1152 */       if (this.hashCode == 2147483647)
/* 1153 */         this.hashCode = JBossManagedConnectionPool.SubjectActions.hashCode(this.subject);
/* 1154 */       return this.hashCode;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object obj)
/*      */     {
/* 1159 */       if (this == obj)
/* 1160 */         return true;
/* 1161 */       if ((obj == null) || (!(obj instanceof SubjectKey)))
/* 1162 */         return false;
/* 1163 */       SubjectKey other = (SubjectKey)obj;
/* 1164 */       return (JBossManagedConnectionPool.SubjectActions.equals(this.subject, other.subject)) && (this.separateNoTx == other.separateNoTx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class PoolBySubject extends JBossManagedConnectionPool.BasePool
/*      */   {
/*      */     public PoolBySubject(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, Logger log)
/*      */     {
/* 1090 */       super(poolParams, noTxSeparatePools, log);
/*      */     }
/*      */ 
/*      */     protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx)
/*      */     {
/* 1095 */       return new JBossManagedConnectionPool.SubjectKey(subject, separateNoTx);
/*      */     }
/*      */ 
/*      */     public void prefill()
/*      */     {
/* 1100 */       prefill(null, null, false);
/*      */     }
/*      */ 
/*      */     public void prefill(boolean noTxSeperatePool)
/*      */     {
/* 1105 */       prefill(null, null, noTxSeperatePool);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri)
/*      */     {
/* 1110 */       prefill(subject, cri, false);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool)
/*      */     {
/* 1116 */       if (getPreFill())
/*      */       {
/* 1118 */         JBossManagedConnectionPool.log.warn("Prefill pool option was selected for pool with JNDI name " + getPoolName() + " that does not support this feature.");
/*      */ 
/* 1120 */         JBossManagedConnectionPool.log.warn("Please verify your *-ds.xml file that corresponds with this resource and either remove the <prefill>true|false</prefill element or explicitly set this value to false.");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class SubjectCriKey
/*      */   {
/* 1034 */     private static final Subject NOSUBJECT = new Subject();
/*      */ 
/* 1037 */     private static final Object NOCRI = new Object();
/*      */     private final Subject subject;
/*      */     private final Object cri;
/* 1046 */     private int hashCode = 2147483647;
/*      */     private boolean separateNoTx;
/*      */ 
/*      */     SubjectCriKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx)
/*      */     {
/* 1053 */       this.subject = (subject == null ? NOSUBJECT : subject);
/* 1054 */       this.cri = (cri == null ? NOCRI : cri);
/* 1055 */       this.separateNoTx = separateNoTx;
/*      */     }
/*      */ 
/*      */     public int hashCode()
/*      */     {
/* 1060 */       if (this.hashCode == 2147483647)
/* 1061 */         this.hashCode = (JBossManagedConnectionPool.SubjectActions.hashCode(this.subject) ^ this.cri.hashCode());
/* 1062 */       return this.hashCode;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object obj)
/*      */     {
/* 1067 */       if (this == obj)
/* 1068 */         return true;
/* 1069 */       if ((obj == null) || (!(obj instanceof SubjectCriKey)))
/* 1070 */         return false;
/* 1071 */       SubjectCriKey other = (SubjectCriKey)obj;
/* 1072 */       return (JBossManagedConnectionPool.SubjectActions.equals(this.subject, other.subject)) && (this.cri.equals(other.cri)) && (this.separateNoTx == other.separateNoTx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class PoolBySubjectAndCri extends JBossManagedConnectionPool.BasePool
/*      */   {
/*      */     public PoolBySubjectAndCri(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, Logger log)
/*      */     {
/*  990 */       super(poolParams, noTxSeparatePools, log);
/*      */     }
/*      */ 
/*      */     protected Object getKey(Subject subject, ConnectionRequestInfo cri, boolean separateNoTx)
/*      */       throws ResourceException
/*      */     {
/*  996 */       return new JBossManagedConnectionPool.SubjectCriKey(subject, cri, separateNoTx);
/*      */     }
/*      */ 
/*      */     public void prefill()
/*      */     {
/* 1001 */       prefill(null, null, false);
/*      */     }
/*      */ 
/*      */     public void prefill(boolean noTxSeperatePool)
/*      */     {
/* 1006 */       prefill(null, null, noTxSeperatePool);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri)
/*      */     {
/* 1011 */       prefill(subject, cri, false);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool)
/*      */     {
/* 1017 */       if (getPreFill())
/*      */       {
/* 1019 */         JBossManagedConnectionPool.log.warn("Prefill pool option was selected for pool with JNDI name " + getPoolName() + " that does not support this feature.");
/*      */ 
/* 1021 */         JBossManagedConnectionPool.log.warn("Please verify your *-ds.xml file that corresponds with this resource and either remove the <prefill>true|false</prefill element or explicitly set this value to false.");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public static abstract class BasePool
/*      */     implements ManagedConnectionPool, StatisticsReporter, PreFillPoolSupport
/*      */   {
/*  537 */     private final Map subPools = new ConcurrentReaderHashMap();
/*      */     private final ManagedConnectionFactory mcf;
/*      */     private ConnectionListenerFactory clf;
/*      */     private final InternalManagedConnectionPool.PoolParams poolParams;
/*      */     private boolean noTxSeparatePools;
/*      */     private String poolName;
/*      */     private final Logger log;
/*  557 */     private boolean traceEnabled = false;
/*      */ 
/*      */     public BasePool(ManagedConnectionFactory mcf, InternalManagedConnectionPool.PoolParams poolParams, boolean noTxSeparatePools, Logger log)
/*      */     {
/*  569 */       this.mcf = mcf;
/*  570 */       this.poolParams = poolParams;
/*  571 */       this.noTxSeparatePools = noTxSeparatePools;
/*  572 */       this.log = log;
/*  573 */       this.traceEnabled = log.isTraceEnabled();
/*      */     }
/*      */ 
/*      */     protected abstract Object getKey(Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo, boolean paramBoolean)
/*      */       throws ResourceException;
/*      */ 
/*      */     public ManagedConnectionFactory getManagedConnectionFactory()
/*      */     {
/*  589 */       return this.mcf;
/*      */     }
/*      */ 
/*      */     public void setConnectionListenerFactory(ConnectionListenerFactory clf)
/*      */     {
/*  594 */       this.clf = clf;
/*      */     }
/*      */ 
/*      */     public ConnectionListener getConnection(Transaction trackByTransaction, Subject subject, ConnectionRequestInfo cri)
/*      */       throws ResourceException
/*      */     {
/*  601 */       boolean separateNoTx = false;
/*  602 */       if (this.noTxSeparatePools)
/*  603 */         separateNoTx = this.clf.isTransactional();
/*  604 */       Object key = getKey(subject, cri, separateNoTx);
/*  605 */       JBossManagedConnectionPool.SubPoolContext subPool = getSubPool(key, subject, cri);
/*      */ 
/*  607 */       InternalManagedConnectionPool mcp = subPool.getSubPool();
/*      */ 
/*  610 */       TransactionLocal trackByTx = subPool.getTrackByTx();
/*      */ 
/*  613 */       if ((trackByTransaction == null) || (trackByTx == null))
/*      */       {
/*  615 */         ConnectionListener cl = mcp.getConnection(subject, cri);
/*  616 */         if (this.traceEnabled)
/*  617 */           dump("Got connection from pool " + cl);
/*  618 */         return cl;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  624 */         trackByTx.lock(trackByTransaction);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/*  628 */         JBossResourceException.rethrowAsResourceException("Unable to get connection from the pool for tx=" + trackByTransaction, t);
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  633 */         ConnectionListener cl = (ConnectionListener)trackByTx.get(trackByTransaction);
/*  634 */         if (cl != null)
/*      */         {
/*  636 */           if (this.traceEnabled)
/*  637 */             dump("Previous connection tracked by transaction " + cl + " tx=" + trackByTransaction);
/*  638 */           ConnectionListener localConnectionListener1 = cl;
/*      */           return localConnectionListener1;
/*      */         } } finally { trackByTx.unlock(trackByTransaction);
/*      */       }
/*      */ 
/*  652 */       ConnectionListener cl = mcp.getConnection(subject, cri);
/*  653 */       if (this.traceEnabled) {
/*  654 */         dump("Got connection from pool tracked by transaction " + cl + " tx=" + trackByTransaction);
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  659 */         trackByTx.lock(trackByTransaction);
/*      */       }
/*      */       catch (Throwable t)
/*      */       {
/*  663 */         mcp.returnConnection(cl, false);
/*  664 */         if (this.traceEnabled)
/*  665 */           dump("Had to return connection tracked by transaction " + cl + " tx=" + trackByTransaction + " error=" + t.getMessage());
/*  666 */         JBossResourceException.rethrowAsResourceException("Unable to get connection from the pool for tx=" + trackByTransaction, t);
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  671 */         ConnectionListener other = (ConnectionListener)trackByTx.get(trackByTransaction);
/*  672 */         if (other != null)
/*      */         {
/*  674 */           mcp.returnConnection(cl, false);
/*  675 */           if (this.traceEnabled)
/*  676 */             dump("Another thread already got a connection tracked by transaction " + other + " tx=" + trackByTransaction);
/*  677 */           localConnectionListener2 = other;
/*      */           return localConnectionListener2;
/*      */         }
/*  681 */         cl.setTrackByTx(true);
/*  682 */         trackByTx.set(cl);
/*  683 */         if (this.traceEnabled)
/*  684 */           dump("Using connection from pool tracked by transaction " + cl + " tx=" + trackByTransaction);
/*  685 */         ConnectionListener localConnectionListener2 = cl;
/*      */         return localConnectionListener2; } finally { trackByTx.unlock(trackByTransaction); } throw localObject2;
/*      */     }
/*      */ 
/*      */     public void returnConnection(ConnectionListener cl, boolean kill)
/*      */       throws ResourceException
/*      */     {
/*  695 */       cl.setTrackByTx(false);
/*  696 */       InternalManagedConnectionPool mcp = (InternalManagedConnectionPool)cl.getContext();
/*  697 */       mcp.returnConnection(cl, kill);
/*  698 */       if (this.traceEnabled)
/*  699 */         dump("Returning connection to pool " + cl);
/*      */     }
/*      */ 
/*      */     public int getInUseConnectionCount()
/*      */     {
/*  709 */       int count = 0;
/*      */       Iterator i;
/*  710 */       synchronized (this.subPools)
/*      */       {
/*  712 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  714 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  715 */           count += subPool.getSubPool().getConnectionInUseCount();
/*      */         }
/*      */       }
/*  718 */       return count;
/*      */     }
/*      */ 
/*      */     public boolean getPreFill() {
/*  722 */       return this.poolParams.prefill;
/*      */     }
/*      */ 
/*      */     public boolean shouldPreFill()
/*      */     {
/*  728 */       return getPreFill();
/*      */     }
/*      */ 
/*      */     public void prefill()
/*      */     {
/*  734 */       prefill(null, null, false);
/*      */     }
/*      */ 
/*      */     public void prefill(boolean noTxSeperatePool)
/*      */     {
/*  741 */       prefill(null, null, noTxSeperatePool);
/*      */     }
/*      */ 
/*      */     public void prefill(Subject subject, ConnectionRequestInfo cri, boolean noTxSeperatePool)
/*      */     {
/*  747 */       if (getPreFill())
/*      */       {
/*  750 */         this.log.debug("Attempting to prefill pool for pool with jndi name" + this.poolName);
/*      */         try
/*      */         {
/*  755 */           getSubPool(getKey(subject, cri, this.noTxSeparatePools), subject, cri);
/*      */         }
/*      */         catch (Throwable t)
/*      */         {
/*  761 */           this.log.error("Unable to prefill pool with jndi name" + getPoolName(), t);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public int getConnectionCount()
/*      */     {
/*  771 */       int count = 0;
/*      */       Iterator i;
/*  772 */       synchronized (this.subPools)
/*      */       {
/*  774 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  776 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  777 */           count += subPool.getSubPool().getConnectionCount();
/*      */         }
/*      */       }
/*  780 */       return count;
/*      */     }
/*      */ 
/*      */     public String getPoolName()
/*      */     {
/*  785 */       return this.poolName;
/*      */     }
/*      */ 
/*      */     public int getConnectionCreatedCount() {
/*  789 */       int count = 0;
/*      */       Iterator i;
/*  790 */       synchronized (this.subPools)
/*      */       {
/*  792 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  794 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  795 */           count += subPool.getSubPool().getConnectionCreatedCount();
/*      */         }
/*      */       }
/*  798 */       return count;
/*      */     }
/*      */ 
/*      */     public int getConnectionDestroyedCount()
/*      */     {
/*  803 */       int count = 0;
/*      */       Iterator i;
/*  804 */       synchronized (this.subPools)
/*      */       {
/*  806 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  808 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  809 */           count += subPool.getSubPool().getConnectionDestroyedCount();
/*      */         }
/*      */       }
/*  812 */       return count;
/*      */     }
/*      */ 
/*      */     public long getAvailableConnectionCount()
/*      */     {
/*  817 */       long count = 0L;
/*      */       Iterator i;
/*  818 */       synchronized (this.subPools)
/*      */       {
/*  820 */         if (this.subPools.size() == 0)
/*  821 */           return this.poolParams.maxSize;
/*  822 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  824 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  825 */           count += subPool.getSubPool().getAvailableConnections();
/*      */         }
/*      */       }
/*  828 */       return count;
/*      */     }
/*      */ 
/*      */     public int getMaxConnectionsInUseCount()
/*      */     {
/*  833 */       int count = 0;
/*      */       Iterator i;
/*  834 */       synchronized (this.subPools)
/*      */       {
/*  836 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  838 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  839 */           count += subPool.getSubPool().getMaxConnectionsInUseCount();
/*      */         }
/*      */       }
/*  842 */       return count;
/*      */     }
/*      */ 
/*      */     public void shutdown()
/*      */     {
/*  847 */       synchronized (this.subPools)
/*      */       {
/*  849 */         for (Iterator i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  851 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  852 */           subPool.getSubPool().shutdown();
/*      */         }
/*  854 */         this.subPools.clear();
/*      */       }
/*      */     }
/*      */ 
/*      */     public void flush()
/*      */     {
/*  860 */       synchronized (this.subPools)
/*      */       {
/*  862 */         for (Iterator i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  864 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  865 */           subPool.getSubPool().shutdown();
/*      */         }
/*  867 */         this.subPools.clear();
/*      */       }
/*      */     }
/*      */ 
/*      */     protected void shutdownWithoutClear()
/*      */     {
/*      */       Iterator i;
/*  876 */       synchronized (this.subPools)
/*      */       {
/*  878 */         for (i = this.subPools.values().iterator(); i.hasNext(); )
/*      */         {
/*  880 */           JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)i.next();
/*  881 */           subPool.getSubPool().shutdown();
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     protected TransactionManager getTransactionManager()
/*      */     {
/*  893 */       if (this.clf != null) {
/*  894 */         return this.clf.getTransactionManagerInstance();
/*      */       }
/*  896 */       return null;
/*      */     }
/*      */ 
/*      */     protected JBossManagedConnectionPool.SubPoolContext getSubPool(Object key, Subject subject, ConnectionRequestInfo cri)
/*      */       throws ResourceException
/*      */     {
/*  911 */       JBossManagedConnectionPool.SubPoolContext subPool = (JBossManagedConnectionPool.SubPoolContext)this.subPools.get(key);
/*  912 */       if (subPool == null)
/*      */       {
/*  914 */         TransactionManager tm = getTransactionManager();
/*  915 */         subPool = new JBossManagedConnectionPool.SubPoolContext(tm, this.mcf, this.clf, subject, cri, this.poolParams, this.log);
/*  916 */         synchronized (this.subPools)
/*      */         {
/*  918 */           if (this.subPools.containsKey(key)) {
/*  919 */             subPool = (JBossManagedConnectionPool.SubPoolContext)this.subPools.get(key);
/*      */           }
/*      */           else {
/*  922 */             subPool.initialize();
/*  923 */             this.subPools.put(key, subPool);
/*      */           }
/*      */         }
/*      */       }
/*  927 */       return subPool;
/*      */     }
/*      */ 
/*      */     private void dump(String info)
/*      */     {
/*  937 */       if (this.traceEnabled)
/*      */       {
/*  939 */         StringBuffer toLog = new StringBuffer(100);
/*  940 */         toLog.append(info).append(" [InUse/Available/Max]: [");
/*  941 */         toLog.append(getInUseConnectionCount()).append("/");
/*  942 */         toLog.append(getAvailableConnectionCount()).append("/");
/*  943 */         toLog.append(this.poolParams.maxSize);
/*  944 */         toLog.append("]");
/*  945 */         this.log.trace(toLog);
/*      */       }
/*      */     }
/*      */ 
/*      */     public JBossStatistics listStatistics()
/*      */     {
/*  951 */       ManagedConnectionPoolStatistics subPoolStats = new JBossManagedConnectionPoolStatistics(this.subPools.size());
/*      */ 
/*  953 */       subPoolStats.setBlockingTimeout(this.poolParams.blockingTimeout);
/*  954 */       subPoolStats.setIdleTimeout(this.poolParams.idleTimeout);
/*  955 */       subPoolStats.setMax(this.poolParams.maxSize);
/*  956 */       subPoolStats.setMin(this.poolParams.minSize);
/*  957 */       subPoolStats.setPrefill(this.poolParams.prefill);
/*  958 */       subPoolStats.setNoTxnSeperatePool(this.noTxSeparatePools);
/*      */ 
/*  960 */       for (Iterator iter = this.subPools.values().iterator(); iter.hasNext(); )
/*      */       {
/*  962 */         JBossSubPoolStatistics stat = new JBossSubPoolStatistics();
/*  963 */         JBossManagedConnectionPool.SubPoolContext subContext = (JBossManagedConnectionPool.SubPoolContext)iter.next();
/*  964 */         Boolean trackByTxn = subContext.getTrackByTx() != null ? Boolean.TRUE : Boolean.FALSE;
/*  965 */         stat.setTrackByTxn(trackByTxn);
/*  966 */         InternalManagedConnectionPool internalPool = subContext.getSubPool();
/*  967 */         stat.setAvailableConnections(internalPool.getAvailableConnections());
/*  968 */         stat.setConnectionsDestroyed(internalPool.getConnectionDestroyedCount());
/*  969 */         stat.setConnectionsInUse(internalPool.getMaxConnectionsInUseCount());
/*  970 */         stat.setMaxConnectionsInUse(internalPool.getMaxConnectionsInUseCount());
/*  971 */         stat.setTotalBlockTime(internalPool.getTotalBlockTime());
/*  972 */         subPoolStats.addSubPool(stat);
/*      */       }
/*      */ 
/*  975 */       return subPoolStats;
/*      */     }
/*      */   }
/*      */ 
/*      */   public static class SubPoolContext
/*      */   {
/*      */     private InternalManagedConnectionPool subPool;
/*      */     private TransactionLocal trackByTx;
/*      */ 
/*      */     public SubPoolContext(TransactionManager tm, ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, InternalManagedConnectionPool.PoolParams poolParams, Logger log)
/*      */     {
/*  497 */       this.subPool = new InternalManagedConnectionPool(mcf, clf, subject, cri, poolParams, log);
/*  498 */       if (tm != null)
/*  499 */         this.trackByTx = new TransactionLocal(tm);
/*      */     }
/*      */ 
/*      */     public InternalManagedConnectionPool getSubPool()
/*      */     {
/*  509 */       return this.subPool;
/*      */     }
/*      */ 
/*      */     public TransactionLocal getTrackByTx()
/*      */     {
/*  519 */       return this.trackByTx;
/*      */     }
/*      */ 
/*      */     public void initialize()
/*      */     {
/*  527 */       this.subPool.initialize();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.JBossManagedConnectionPool
 * JD-Core Version:    0.6.0
 */