/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ConnectionValidator
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ConnectionValidator.class);
/*     */ 
/*  47 */   private Collection pools = new ArrayList();
/*     */ 
/*  50 */   private long interval = 9223372036854775807L;
/*     */ 
/*  53 */   private long next = 9223372036854775807L;
/*     */ 
/*  56 */   private static final ConnectionValidator validator = new ConnectionValidator();
/*     */ 
/*     */   private ConnectionValidator()
/*     */   {
/*  61 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  65 */         Runnable runnable = new ConnectionValidator.ConnectionValidatorRunnable(ConnectionValidator.this, null);
/*  66 */         Thread removerThread = new Thread(runnable, "ConnectionValidator");
/*  67 */         removerThread.setDaemon(true);
/*  68 */         removerThread.start();
/*  69 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static void registerPool(InternalManagedConnectionPool mcp, long interval)
/*     */   {
/*  77 */     validator.internalRegisterPool(mcp, interval);
/*     */   }
/*     */ 
/*     */   public static void unRegisterPool(InternalManagedConnectionPool mcp)
/*     */   {
/*  84 */     validator.internalUnregisterPool(mcp);
/*     */   }
/*     */ 
/*     */   private void internalRegisterPool(InternalManagedConnectionPool mcp, long interval)
/*     */   {
/*  91 */     synchronized (this.pools)
/*     */     {
/*  93 */       this.pools.add(mcp);
/*     */ 
/*  95 */       if ((interval > 1L) && (interval / 2L < this.interval))
/*     */       {
/*  97 */         this.interval = (interval / 2L);
/*  98 */         long maybeNext = System.currentTimeMillis() + this.interval;
/*  99 */         if ((this.next > maybeNext) && (maybeNext > 0L))
/*     */         {
/* 101 */           this.next = maybeNext;
/* 102 */           log.debug("internalRegisterPool: about to notify thread: old next: " + this.next + ", new next: " + maybeNext);
/* 103 */           this.pools.notify();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void internalUnregisterPool(InternalManagedConnectionPool mcp)
/*     */   {
/* 112 */     synchronized (this.pools)
/*     */     {
/* 114 */       this.pools.remove(mcp);
/* 115 */       if (this.pools.size() == 0)
/*     */       {
/* 117 */         log.debug("internalUnregisterPool: setting interval to Long.MAX_VALUE");
/* 118 */         this.interval = 9223372036854775807L;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupContextClassLoader()
/*     */   {
/* 128 */     ClassLoader cl = IdleRemover.class.getClassLoader();
/* 129 */     if (cl == null) {
/* 130 */       return;
/*     */     }
/* 132 */     SecurityManager sm = System.getSecurityManager();
/* 133 */     if (sm == null) {
/* 134 */       Thread.currentThread().setContextClassLoader(cl);
/*     */     }
/* 136 */     AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 140 */         Thread.currentThread().setContextClassLoader(this.val$cl);
/* 141 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static void waitForBackgroundThread() {
/* 148 */     synchronized (validator.pools)
/*     */     {
/* 150 */       return;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class ConnectionValidatorRunnable implements Runnable {
/*     */     private ConnectionValidatorRunnable() {
/*     */     }
/*     */ 
/*     */     public void run() {
/* 159 */       ConnectionValidator.this.setupContextClassLoader();
/*     */ 
/* 161 */       synchronized (ConnectionValidator.this.pools)
/*     */       {
/*     */         try
/*     */         {
/*     */           while (true)
/*     */           {
/* 170 */             ConnectionValidator.this.pools.wait(ConnectionValidator.this.interval);
/*     */ 
/* 172 */             ConnectionValidator.log.debug("run: ConnectionValidator notifying pools, interval: " + ConnectionValidator.this.interval);
/*     */ 
/* 174 */             for (Iterator iter = ConnectionValidator.this.pools.iterator(); iter.hasNext(); )
/*     */             {
/* 177 */               InternalManagedConnectionPool mcp = (InternalManagedConnectionPool)iter.next();
/* 178 */               mcp.validateConnections();
/*     */             }
/*     */ 
/* 181 */             ConnectionValidator.access$502(ConnectionValidator.this, System.currentTimeMillis() + ConnectionValidator.this.interval);
/*     */ 
/* 183 */             if (ConnectionValidator.this.next < 0L)
/*     */             {
/* 185 */               ConnectionValidator.access$502(ConnectionValidator.this, 9223372036854775807L);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/* 192 */           ConnectionValidator.log.info("run: ConnectionValidator has been interrupted, returning");
/* 193 */           return;
/*     */         }
/*     */         catch (RuntimeException e) {
/*     */           while (true)
/* 197 */             ConnectionValidator.log.warn("run: ConnectionValidator ignored unexpected runtime exception", e);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 201 */           ConnectionValidator.log.warn("run: ConnectionValidator ignored unexpected error", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.ConnectionValidator
 * JD-Core Version:    0.6.0
 */