/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.RemoveException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.resource.ResourceException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EnterpriseContext;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.EntityPersistenceManager;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.Interceptor;
/*     */ import org.jboss.ejb.plugins.AbstractInterceptor;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ResourceRefMetaData;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class CachedConnectionInterceptor extends AbstractInterceptor
/*     */   implements EntityPersistenceManager
/*     */ {
/*     */   private final CachedConnectionManager ccm;
/*  64 */   private final Logger log = Logger.getLogger(getClass());
/*     */   private Container container;
/*     */   private EntityPersistenceManager pm;
/*  71 */   private Set unsharableResources = new HashSet();
/*     */ 
/*     */   public CachedConnectionInterceptor() throws Exception
/*     */   {
/*     */     try
/*     */     {
/*  77 */       MBeanServer server = MBeanServerLocator.locateJBoss();
/*  78 */       this.ccm = ((CachedConnectionManager)server.getAttribute(CachedConnectionManagerMBean.OBJECT_NAME, "Instance"));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  82 */       JMXExceptionDecoder.rethrow(e);
/*  83 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  89 */     this.log.debug("start called in CachedConnectionInterceptor");
/*  90 */     if (this.container == null)
/*     */     {
/*  92 */       this.log.warn("container is null, can't steal persistence manager");
/*  93 */       return;
/*     */     }
/*  95 */     if ((this.container instanceof EntityContainer))
/*     */     {
/*  97 */       EntityContainer ec = (EntityContainer)this.container;
/*     */ 
/*  99 */       if (ec.getPersistenceManager() == null)
/*     */       {
/* 101 */         this.log.info("no persistence manager in container!");
/* 102 */         return;
/*     */       }
/* 104 */       if (ec.getPersistenceManager() == this)
/*     */       {
/* 106 */         this.log.info(" persistence manager in container already set!");
/* 107 */         return;
/*     */       }
/* 109 */       this.pm = ec.getPersistenceManager();
/* 110 */       ec.setPersistenceManager(this);
/*     */     }
/*     */ 
/* 114 */     BeanMetaData bmd = this.container.getBeanMetaData();
/* 115 */     ApplicationMetaData appMetaData = bmd.getApplicationMetaData();
/*     */ 
/* 119 */     for (Iterator iter = bmd.getResourceReferences(); iter.hasNext(); )
/*     */     {
/* 121 */       ResourceRefMetaData resRefMetaData = (ResourceRefMetaData)iter.next();
/* 122 */       String jndiName = resRefMetaData.getJndiName();
/* 123 */       if (jndiName == null)
/*     */       {
/* 125 */         jndiName = appMetaData.getResourceByName(resRefMetaData.getResourceName());
/*     */       }
/* 127 */       if ((jndiName == null) || (resRefMetaData.isShareable()))
/*     */         continue;
/* 129 */       int i = jndiName.indexOf(':');
/* 130 */       if (jndiName.charAt(i + 1) == '/')
/*     */       {
/* 132 */         i++;
/*     */       }
/* 134 */       this.unsharableResources.add(jndiName.substring(i + 1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 142 */     if ((this.container != null) && (this.pm != null) && (((EntityContainer)this.container).getPersistenceManager() == this))
/*     */     {
/* 144 */       ((EntityContainer)this.container).setPersistenceManager(this.pm);
/* 145 */       this.pm = null;
/*     */     }
/* 147 */     this.unsharableResources.clear();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation mi) throws Exception
/*     */   {
/* 152 */     Object key = ((EnterpriseContext)mi.getEnterpriseContext()).getInstance();
/*     */     try
/*     */     {
/* 155 */       this.ccm.pushMetaAwareObject(key, this.unsharableResources);
/*     */       try
/*     */       {
/* 158 */         Object localObject1 = getNext().invoke(mi);
/*     */         return localObject1; } finally { this.ccm.popMetaAwareObject(this.unsharableResources);
/*     */       }
/*     */     }
/*     */     catch (ResourceException e)
/*     */     {
/* 167 */       InvocationType type = mi.getType();
/* 168 */       boolean isLocal = (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME);
/* 169 */       if (isLocal)
/* 170 */         throw new EJBException("Resource problem during invoke", e);
/*     */     }
/* 172 */     throw new RemoteException("Resource problem during invoke", e);
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Invocation mi)
/*     */     throws Exception
/*     */   {
/* 178 */     EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
/* 179 */     if (ctx == null) {
/* 180 */       return getNext().invokeHome(mi);
/*     */     }
/*     */ 
/* 183 */     Object key = ctx.getInstance();
/*     */     try
/*     */     {
/* 186 */       this.ccm.pushMetaAwareObject(key, this.unsharableResources);
/*     */       try
/*     */       {
/* 189 */         Object localObject1 = getNext().invokeHome(mi);
/*     */         return localObject1; } finally { this.ccm.popMetaAwareObject(this.unsharableResources);
/*     */       }
/*     */     }
/*     */     catch (ResourceException e)
/*     */     {
/* 198 */       InvocationType type = mi.getType();
/* 199 */       boolean isLocal = (type == InvocationType.LOCAL) || (type == InvocationType.LOCALHOME);
/* 200 */       if (isLocal)
/* 201 */         throw new EJBException("Resource problem during invokeHome", e);
/*     */     }
/* 203 */     throw new RemoteException("Resource problem during invokeHome", e);
/*     */   }
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 210 */     this.container = container;
/*     */   }
/*     */ 
/*     */   public Container getContainer()
/*     */   {
/* 215 */     return this.container;
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance() throws Exception
/*     */   {
/* 220 */     return this.pm.createBeanClassInstance();
/*     */   }
/*     */ 
/*     */   public void createEntity(Method m, Object[] args, EntityEnterpriseContext instance) throws Exception
/*     */   {
/* 225 */     this.pm.createEntity(m, args, instance);
/*     */   }
/*     */ 
/*     */   public void postCreateEntity(Method m, Object[] args, EntityEnterpriseContext instance) throws Exception
/*     */   {
/* 230 */     this.pm.postCreateEntity(m, args, instance);
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/* 236 */     return this.pm.findEntity(finderMethod, args, instance, factory);
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*     */     throws Exception
/*     */   {
/* 242 */     return this.pm.findEntities(finderMethod, args, instance, factory);
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext instance) throws RemoteException
/*     */   {
/* 247 */     this.pm.activateEntity(instance);
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext instance) throws RemoteException
/*     */   {
/* 252 */     this.pm.loadEntity(instance);
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext instance) throws Exception
/*     */   {
/* 257 */     return this.pm.isStoreRequired(instance);
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext ctx) throws Exception
/*     */   {
/* 262 */     return this.pm.isModified(ctx);
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext ctx) throws RemoteException
/*     */   {
/* 267 */     Object key = ctx.getInstance();
/*     */     try
/*     */     {
/* 270 */       this.ccm.pushMetaAwareObject(key, this.unsharableResources);
/*     */       try
/*     */       {
/* 273 */         this.pm.storeEntity(ctx);
/*     */       }
/*     */       finally
/*     */       {
/* 277 */         this.ccm.popMetaAwareObject(this.unsharableResources);
/*     */       }
/*     */     }
/*     */     catch (ResourceException e)
/*     */     {
/* 282 */       throw new RemoteException("Could not store!: ", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void invokeEjbStore(EntityEnterpriseContext ctx) throws RemoteException
/*     */   {
/* 288 */     Object key = ctx.getInstance();
/*     */     try
/*     */     {
/* 291 */       this.ccm.pushMetaAwareObject(key, this.unsharableResources);
/*     */       try
/*     */       {
/* 294 */         this.pm.invokeEjbStore(ctx);
/*     */       }
/*     */       finally
/*     */       {
/* 298 */         this.ccm.popMetaAwareObject(this.unsharableResources);
/*     */       }
/*     */     }
/*     */     catch (ResourceException e)
/*     */     {
/* 303 */       throw new RemoteException("Could not store!: ", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext instance) throws RemoteException
/*     */   {
/* 309 */     this.pm.passivateEntity(instance);
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext instance) throws RemoteException, RemoveException
/*     */   {
/* 314 */     this.pm.removeEntity(instance);
/*     */   }
/*     */ 
/*     */   public EntityPersistenceManager getDelegatePersistenceManager()
/*     */   {
/* 323 */     return this.pm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.CachedConnectionInterceptor
 * JD-Core Version:    0.6.0
 */