/*     */ package org.jboss.resource.connectionmanager;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionEvent;
/*     */ import javax.resource.spi.ConnectionManager;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.resource.spi.ManagedConnectionFactory;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.logging.util.LoggerPluginWriter;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SubjectSecurityManager;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.TransactionTimeoutConfiguration;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public abstract class BaseConnectionManager2 extends ServiceMBeanSupport
/*     */   implements BaseConnectionManager2MBean, ConnectionCacheListener, ConnectionListenerFactory, TransactionTimeoutConfiguration
/*     */ {
/*     */   private static final String SECURITY_MGR_PATH = "java:/jaas/";
/*     */   public static final String STOPPING_NOTIFICATION = "jboss.jca.connectionmanagerstopping";
/*     */   protected ObjectName managedConnectionPoolName;
/*     */   protected ManagedConnectionPool poolingStrategy;
/*     */   protected String jndiName;
/*     */   protected String securityDomainJndiName;
/*     */   protected SubjectSecurityManager securityDomain;
/*     */   protected ObjectName jaasSecurityManagerService;
/*     */   protected ObjectName ccmName;
/*     */   protected CachedConnectionManager ccm;
/*     */   protected boolean trace;
/*     */ 
/*     */   /** @deprecated */
/*     */   protected static void rethrowAsResourceException(String message, Throwable t)
/*     */     throws ResourceException
/*     */   {
/* 127 */     JBossResourceException.rethrowAsResourceException(message, t);
/*     */   }
/*     */ 
/*     */   public BaseConnectionManager2()
/*     */   {
/* 136 */     this.trace = this.log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public BaseConnectionManager2(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy)
/*     */   {
/* 148 */     this.ccm = ccm;
/* 149 */     this.poolingStrategy = poolingStrategy;
/* 150 */     this.trace = this.log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public ManagedConnectionPool getPoolingStrategy()
/*     */   {
/* 158 */     return this.poolingStrategy;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 163 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 168 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public ObjectName getManagedConnectionPool()
/*     */   {
/* 173 */     return this.managedConnectionPoolName;
/*     */   }
/*     */ 
/*     */   public void setManagedConnectionPool(ObjectName newManagedConnectionPool)
/*     */   {
/* 178 */     this.managedConnectionPoolName = newManagedConnectionPool;
/*     */   }
/*     */ 
/*     */   public void setCachedConnectionManager(ObjectName ccmName)
/*     */   {
/* 183 */     this.ccmName = ccmName;
/*     */   }
/*     */ 
/*     */   public ObjectName getCachedConnectionManager()
/*     */   {
/* 188 */     return this.ccmName;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomainJndiName(String securityDomainJndiName)
/*     */   {
/* 193 */     if ((securityDomainJndiName != null) && (securityDomainJndiName.startsWith("java:/jaas/")))
/*     */     {
/* 195 */       securityDomainJndiName = securityDomainJndiName.substring("java:/jaas/".length());
/* 196 */       this.log.warn("WARNING: UPDATE YOUR SecurityDomainJndiName! REMOVE java:/jaas/");
/*     */     }
/* 198 */     this.securityDomainJndiName = securityDomainJndiName;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomainJndiName()
/*     */   {
/* 203 */     return this.securityDomainJndiName;
/*     */   }
/*     */ 
/*     */   public ObjectName getJaasSecurityManagerService()
/*     */   {
/* 208 */     return this.jaasSecurityManagerService;
/*     */   }
/*     */ 
/*     */   public void setJaasSecurityManagerService(ObjectName jaasSecurityManagerService)
/*     */   {
/* 213 */     this.jaasSecurityManagerService = jaasSecurityManagerService;
/*     */   }
/*     */ 
/*     */   public ManagedConnectionFactory getManagedConnectionFactory()
/*     */   {
/* 218 */     return this.poolingStrategy.getManagedConnectionFactory();
/*     */   }
/*     */ 
/*     */   public BaseConnectionManager2 getInstance()
/*     */   {
/* 223 */     return this;
/*     */   }
/*     */ 
/*     */   public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException
/*     */   {
/* 228 */     return -1L;
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout() throws SystemException
/*     */   {
/* 233 */     throw new NotImplementedException("NYI: getTransactionTimeout()");
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 242 */       this.ccm = ((CachedConnectionManager)this.server.getAttribute(this.ccmName, "Instance"));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 246 */       JMXExceptionDecoder.rethrow(e);
/*     */     }
/*     */ 
/* 249 */     if (this.ccm == null) {
/* 250 */       throw new DeploymentException("cached ConnectionManager not found: " + this.ccmName);
/*     */     }
/* 252 */     if ((this.securityDomainJndiName != null) && (this.jaasSecurityManagerService == null)) {
/* 253 */       throw new DeploymentException("You must supply both securityDomainJndiName and jaasSecurityManagerService to use container managed security");
/*     */     }
/* 255 */     if (this.securityDomainJndiName != null) {
/* 256 */       this.securityDomain = ((SubjectSecurityManager)new InitialContext().lookup("java:/jaas/" + this.securityDomainJndiName));
/*     */     }
/*     */ 
/* 259 */     if (this.managedConnectionPoolName == null)
/* 260 */       throw new DeploymentException("managedConnectionPool not set!");
/*     */     try
/*     */     {
/* 263 */       this.poolingStrategy = ((ManagedConnectionPool)this.server.getAttribute(this.managedConnectionPoolName, "ManagedConnectionPool"));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 268 */       JMXExceptionDecoder.rethrow(e);
/*     */     }
/*     */ 
/* 271 */     this.poolingStrategy.setConnectionListenerFactory(this);
/*     */ 
/* 274 */     String categoryName = this.poolingStrategy.getManagedConnectionFactory().getClass().getName() + "." + this.jndiName;
/* 275 */     Logger log = Logger.getLogger(categoryName);
/* 276 */     PrintWriter logWriter = new LoggerPluginWriter(log.getLoggerPlugin());
/*     */     try
/*     */     {
/* 279 */       this.poolingStrategy.getManagedConnectionFactory().setLogWriter(logWriter);
/*     */     }
/*     */     catch (ResourceException re)
/*     */     {
/* 283 */       log.warn("Unable to set log writer '" + logWriter + "' on " + "managed connection factory", re);
/* 284 */       log.warn("Linked exception:", re.getLinkedException());
/*     */     }
/* 286 */     if ((this.poolingStrategy instanceof PreFillPoolSupport))
/*     */     {
/* 289 */       PreFillPoolSupport prefill = (PreFillPoolSupport)this.poolingStrategy;
/*     */ 
/* 291 */       if (prefill.shouldPreFill())
/*     */       {
/* 293 */         prefill.prefill();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 304 */     sendNotification(new Notification("jboss.jca.connectionmanagerstopping", getServiceName(), getNextNotificationSequenceNumber()));
/* 305 */     if ((this.jaasSecurityManagerService != null) && (this.securityDomainJndiName != null)) {
/* 306 */       this.server.invoke(this.jaasSecurityManagerService, "flushAuthenticationCache", new Object[] { this.securityDomainJndiName }, new String[] { String.class.getName() });
/*     */     }
/* 308 */     this.poolingStrategy.setConnectionListenerFactory(null);
/*     */ 
/* 310 */     this.poolingStrategy = null;
/* 311 */     this.securityDomain = null;
/* 312 */     this.ccm = null;
/*     */   }
/*     */ 
/*     */   public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 326 */     return getManagedConnection(null, subject, cri);
/*     */   }
/*     */ 
/*     */   protected ConnectionListener getManagedConnection(Transaction transaction, Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 341 */     return this.poolingStrategy.getConnection(transaction, subject, cri);
/*     */   }
/*     */ 
/*     */   public void returnManagedConnection(ConnectionListener cl, boolean kill)
/*     */   {
/* 346 */     ManagedConnectionPool localStrategy = cl.getManagedConnectionPool();
/* 347 */     if (localStrategy != this.poolingStrategy) {
/* 348 */       kill = true;
/*     */     }
/*     */     try
/*     */     {
/* 352 */       if ((!kill) && (cl.getState() == 0))
/* 353 */         cl.tidyup();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 357 */       this.log.warn("Error during tidyup " + cl, t);
/* 358 */       kill = true;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 363 */       localStrategy.returnConnection(cl, kill);
/*     */     }
/*     */     catch (ResourceException re)
/*     */     {
/* 370 */       if (kill)
/* 371 */         this.log.debug("resourceException killing connection (error retrieving from pool?)", re);
/*     */       else
/* 373 */         this.log.warn("resourceException returning connection: " + cl.getManagedConnection(), re);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getConnectionCount()
/*     */   {
/* 379 */     return this.poolingStrategy.getConnectionCount();
/*     */   }
/*     */ 
/*     */   public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException
/*     */   {
/* 384 */     if (this.poolingStrategy == null) {
/* 385 */       throw new ResourceException("You are trying to use a connection factory that has been shut down: ManagedConnectionFactory is null.");
/*     */     }
/*     */ 
/* 389 */     if (!this.poolingStrategy.getManagedConnectionFactory().equals(mcf)) {
/* 390 */       throw new ResourceException("Wrong ManagedConnectionFactory sent to allocateConnection!");
/*     */     }
/*     */ 
/* 393 */     Subject subject = getSubject();
/* 394 */     ConnectionListener cl = getManagedConnection(subject, cri);
/*     */ 
/* 397 */     reconnectManagedConnection(cl);
/*     */ 
/* 400 */     Object connection = null;
/*     */     try
/*     */     {
/* 403 */       connection = cl.getManagedConnection().getConnection(subject, cri);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 407 */       managedConnectionDisconnected(cl);
/* 408 */       JBossResourceException.rethrowAsResourceException("Unchecked throwable in ManagedConnection.getConnection() cl=" + cl, t);
/*     */     }
/*     */ 
/* 413 */     registerAssociation(cl, connection);
/* 414 */     if (this.ccm != null)
/* 415 */       this.ccm.registerConnection(this, cl, connection, cri);
/* 416 */     return connection;
/*     */   }
/*     */ 
/*     */   public void transactionStarted(Collection conns)
/*     */     throws SystemException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void reconnect(Collection conns, Set unsharableResources)
/*     */     throws ResourceException
/*     */   {
/* 430 */     if (unsharableResources.contains(this.jndiName))
/*     */     {
/* 432 */       this.log.trace("reconnect for unshareable connection: nothing to do");
/* 433 */       return;
/*     */     }
/*     */ 
/* 436 */     Map criToCLMap = new HashMap();
/* 437 */     for (Iterator i = conns.iterator(); i.hasNext(); )
/*     */     {
/* 439 */       ConnectionRecord cr = (ConnectionRecord)i.next();
/* 440 */       if (cr.cl != null)
/*     */       {
/* 443 */         this.log.warn("reconnecting a connection handle that still has a managedConnection! " + cr.cl.getManagedConnection() + " " + cr.connection);
/*     */       }
/*     */ 
/* 446 */       ConnectionListener cl = (ConnectionListener)criToCLMap.get(cr.cri);
/* 447 */       if (cl == null)
/*     */       {
/* 449 */         cl = getManagedConnection(getSubject(), cr.cri);
/* 450 */         criToCLMap.put(cr.cri, cl);
/*     */ 
/* 452 */         reconnectManagedConnection(cl);
/*     */       }
/*     */ 
/* 455 */       cl.getManagedConnection().associateConnection(cr.connection);
/* 456 */       registerAssociation(cl, cr.connection);
/* 457 */       cr.setConnectionListener(cl);
/*     */     }
/* 459 */     criToCLMap.clear();
/*     */   }
/*     */ 
/*     */   public void disconnect(Collection crs, Set unsharableResources)
/*     */     throws ResourceException
/*     */   {
/* 466 */     if (unsharableResources.contains(this.jndiName))
/*     */     {
/* 468 */       this.log.trace("disconnect for unshareable connection: nothing to do");
/* 469 */       return;
/*     */     }
/*     */ 
/* 472 */     Set cls = new HashSet();
/* 473 */     for (Iterator i = crs.iterator(); i.hasNext(); )
/*     */     {
/* 475 */       ConnectionRecord cr = (ConnectionRecord)i.next();
/* 476 */       ConnectionListener cl = cr.cl;
/* 477 */       cr.setConnectionListener(null);
/* 478 */       unregisterAssociation(cl, cr.connection);
/* 479 */       if (!cls.contains(cl))
/*     */       {
/* 481 */         cls.add(cl);
/*     */       }
/*     */     }
/* 484 */     for (Iterator i = cls.iterator(); i.hasNext(); )
/* 485 */       disconnectManagedConnection((ConnectionListener)i.next());
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 493 */     return super.getNotificationInfo();
/*     */   }
/*     */ 
/*     */   protected void unregisterAssociation(ConnectionListener cl, Object c)
/*     */     throws ResourceException
/*     */   {
/* 503 */     cl.unregisterConnection(c);
/*     */   }
/*     */ 
/*     */   protected void reconnectManagedConnection(ConnectionListener cl)
/*     */     throws ResourceException
/*     */   {
/*     */     try
/*     */     {
/* 516 */       managedConnectionReconnected(cl);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 520 */       disconnectManagedConnection(cl);
/* 521 */       JBossResourceException.rethrowAsResourceException("Unchecked throwable in managedConnectionReconnected() cl=" + cl, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void disconnectManagedConnection(ConnectionListener cl)
/*     */   {
/*     */     try
/*     */     {
/* 535 */       managedConnectionDisconnected(cl);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 539 */       this.log.warn("Unchecked throwable in managedConnectionDisconnected() cl=" + cl, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final CachedConnectionManager getCcm()
/*     */   {
/* 545 */     return this.ccm;
/*     */   }
/*     */ 
/*     */   protected void managedConnectionReconnected(ConnectionListener cl)
/*     */     throws ResourceException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void managedConnectionDisconnected(ConnectionListener cl)
/*     */     throws ResourceException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void registerAssociation(ConnectionListener cl, Object c)
/*     */     throws ResourceException
/*     */   {
/* 570 */     cl.registerConnection(c);
/*     */   }
/*     */ 
/*     */   private Subject getSubject()
/*     */   {
/* 575 */     Subject subject = null;
/* 576 */     if (this.securityDomain != null)
/*     */     {
/* 583 */       Principal principal = GetPrincipalAction.getPrincipal();
/* 584 */       Object credential = GetCredentialAction.getCredential();
/* 585 */       subject = new Subject();
/* 586 */       if (!this.securityDomain.isValid(principal, credential, subject))
/* 587 */         throw new SecurityException("Invalid authentication attempt, principal=" + principal);
/*     */     }
/* 589 */     if (this.trace)
/* 590 */       this.log.trace("subject: " + subject);
/* 591 */     return subject;
/*     */   }
/*     */ 
/*     */   public boolean isTransactional()
/*     */   {
/* 598 */     return false;
/*     */   }
/*     */ 
/*     */   public TransactionManager getTransactionManagerInstance()
/*     */   {
/* 603 */     return null;
/*     */   }
/*     */ 
/*     */   private static class GetCredentialAction
/*     */     implements PrivilegedAction
/*     */   {
/* 904 */     static PrivilegedAction ACTION = new GetCredentialAction();
/*     */ 
/*     */     public Object run()
/*     */     {
/* 908 */       Object credential = SecurityAssociation.getCredential();
/* 909 */       return credential;
/*     */     }
/*     */ 
/*     */     static Object getCredential()
/*     */     {
/* 914 */       Object credential = AccessController.doPrivileged(ACTION);
/* 915 */       return credential;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class GetPrincipalAction
/*     */     implements PrivilegedAction
/*     */   {
/* 887 */     static PrivilegedAction ACTION = new GetPrincipalAction();
/*     */ 
/*     */     public Object run()
/*     */     {
/* 891 */       Principal principal = SecurityAssociation.getPrincipal();
/* 892 */       return principal;
/*     */     }
/*     */ 
/*     */     static Principal getPrincipal()
/*     */     {
/* 897 */       Principal principal = (Principal)AccessController.doPrivileged(ACTION);
/* 898 */       return principal;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class ConnectionManagerProxy
/*     */     implements ConnectionManager, Serializable, TransactionTimeoutConfiguration
/*     */   {
/*     */     static final long serialVersionUID = -528322728929261214L;
/*     */     private transient BaseConnectionManager2 realCm;
/*     */     private final ObjectName cmName;
/*     */ 
/*     */     ConnectionManagerProxy(BaseConnectionManager2 realCm, ObjectName cmName)
/*     */     {
/* 829 */       this.realCm = realCm;
/* 830 */       this.cmName = cmName;
/*     */     }
/*     */ 
/*     */     public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri)
/*     */       throws ResourceException
/*     */     {
/* 838 */       return getCM().allocateConnection(mcf, cri);
/*     */     }
/*     */ 
/*     */     public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException
/*     */     {
/*     */       try
/*     */       {
/* 845 */         return getCM().getTimeLeftBeforeTransactionTimeout(errorRollback);
/*     */       }
/*     */       catch (ResourceException e) {
/*     */       }
/* 849 */       throw new NestedRuntimeException("Unable to retrieve connection manager", e);
/*     */     }
/*     */ 
/*     */     public int getTransactionTimeout()
/*     */       throws SystemException
/*     */     {
/*     */       try
/*     */       {
/* 857 */         return getCM().getTransactionTimeout();
/*     */       }
/*     */       catch (ResourceException e) {
/*     */       }
/* 861 */       throw new NestedRuntimeException("Unable to retrieve connection manager", e);
/*     */     }
/*     */ 
/*     */     private BaseConnectionManager2 getCM()
/*     */       throws ResourceException
/*     */     {
/* 867 */       if (this.realCm == null)
/*     */       {
/*     */         try
/*     */         {
/* 871 */           MBeanServer server = MBeanServerLocator.locateJBoss();
/* 872 */           this.realCm = ((BaseConnectionManager2)server.getAttribute(this.cmName, "Instance"));
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 876 */           Throwable t2 = JMXExceptionDecoder.decode(t);
/* 877 */           JBossResourceException.rethrowAsResourceException("Problem locating real ConnectionManager: " + this.cmName, t2);
/*     */         }
/*     */       }
/*     */ 
/* 881 */       return this.realCm;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract class BaseConnectionEventListener
/*     */     implements ConnectionListener
/*     */   {
/*     */     private final ManagedConnection mc;
/*     */     private final ManagedConnectionPool mcp;
/*     */     private final Object context;
/* 616 */     private int state = 0;
/*     */ 
/* 618 */     private final List handles = new LinkedList();
/*     */     private long lastUse;
/* 622 */     private boolean trackByTx = false;
/*     */ 
/* 624 */     private boolean permit = false;
/*     */     protected Logger log;
/*     */     protected boolean trace;
/*     */     protected long lastValidated;
/*     */ 
/*     */     protected BaseConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log)
/*     */     {
/* 634 */       this.mc = mc;
/* 635 */       this.mcp = mcp;
/* 636 */       this.context = context;
/* 637 */       this.log = log;
/* 638 */       this.trace = log.isTraceEnabled();
/* 639 */       this.lastUse = System.currentTimeMillis();
/*     */     }
/*     */ 
/*     */     public ManagedConnection getManagedConnection()
/*     */     {
/* 644 */       return this.mc;
/*     */     }
/*     */ 
/*     */     public ManagedConnectionPool getManagedConnectionPool()
/*     */     {
/* 649 */       return this.mcp;
/*     */     }
/*     */ 
/*     */     public Object getContext()
/*     */     {
/* 654 */       return this.context;
/*     */     }
/*     */ 
/*     */     public int getState()
/*     */     {
/* 659 */       return this.state;
/*     */     }
/*     */ 
/*     */     public void setState(int newState)
/*     */     {
/* 664 */       this.state = newState;
/*     */     }
/*     */ 
/*     */     public boolean isTimedOut(long timeout)
/*     */     {
/* 669 */       return this.lastUse < timeout;
/*     */     }
/*     */ 
/*     */     public void used()
/*     */     {
/* 674 */       this.lastUse = System.currentTimeMillis();
/*     */     }
/*     */ 
/*     */     public boolean isTrackByTx()
/*     */     {
/* 679 */       return this.trackByTx;
/*     */     }
/*     */ 
/*     */     public void setTrackByTx(boolean trackByTx)
/*     */     {
/* 684 */       this.trackByTx = trackByTx;
/*     */     }
/*     */ 
/*     */     public void tidyup() throws ResourceException
/*     */     {
/*     */     }
/*     */ 
/*     */     public synchronized void registerConnection(Object handle)
/*     */     {
/* 693 */       this.handles.add(handle);
/*     */     }
/*     */ 
/*     */     public synchronized void unregisterConnection(Object handle)
/*     */     {
/* 698 */       if (!this.handles.remove(handle))
/*     */       {
/* 700 */         this.log.info("Unregistered handle that was not registered! " + handle + " for managedConnection: " + this.mc);
/*     */       }
/* 702 */       if (this.trace)
/* 703 */         this.log.trace("unregisterConnection: " + this.handles.size() + " handles left");
/*     */     }
/*     */ 
/*     */     public synchronized boolean isManagedConnectionFree()
/*     */     {
/* 708 */       return this.handles.isEmpty();
/*     */     }
/*     */ 
/*     */     protected synchronized void unregisterConnections()
/*     */     {
/*     */       try
/*     */       {
/* 715 */         for (i = this.handles.iterator(); i.hasNext(); )
/*     */         {
/* 717 */           BaseConnectionManager2.this.getCcm().unregisterConnection(BaseConnectionManager2.this, i.next());
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*     */         Iterator i;
/* 722 */         this.handles.clear();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void connectionErrorOccurred(ConnectionEvent ce)
/*     */     {
/* 728 */       if (this.state == 0)
/*     */       {
/* 730 */         if (ce != null)
/*     */         {
/* 732 */           Throwable t = ce.getException();
/* 733 */           if (t == null)
/* 734 */             t = new Exception("No exception was reported");
/* 735 */           this.log.warn("Connection error occured: " + this, t);
/*     */         }
/*     */         else
/*     */         {
/* 739 */           Throwable t = new Exception("No exception was reported");
/* 740 */           this.log.warn("Unknown Connection error occured: " + this, t);
/*     */         }
/*     */       }
/*     */       try
/*     */       {
/* 745 */         unregisterConnections();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*     */       }
/*     */ 
/* 751 */       if ((ce != null) && (ce.getSource() != getManagedConnection()))
/* 752 */         this.log.warn("Notified of error on a different managed connection?");
/* 753 */       BaseConnectionManager2.this.returnManagedConnection(this, true);
/*     */     }
/*     */ 
/*     */     public void enlist() throws SystemException
/*     */     {
/*     */     }
/*     */ 
/*     */     public void delist() throws ResourceException
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean hasPermit()
/*     */     {
/* 766 */       return this.permit;
/*     */     }
/*     */ 
/*     */     public void grantPermit(boolean value)
/*     */     {
/* 771 */       this.permit = value;
/*     */     }
/*     */ 
/*     */     public long getLastValidatedTime()
/*     */     {
/* 776 */       return this.lastValidated;
/*     */     }
/*     */ 
/*     */     public void setLastValidatedTime(long lastValidated)
/*     */     {
/* 781 */       this.lastValidated = lastValidated;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 786 */       StringBuffer buffer = new StringBuffer(100);
/* 787 */       buffer.append(getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
/* 788 */       buffer.append("[state=");
/* 789 */       if (this.state == 0)
/* 790 */         buffer.append("NORMAL");
/* 791 */       else if (this.state == 1)
/* 792 */         buffer.append("DESTROY");
/* 793 */       else if (this.state == 2)
/* 794 */         buffer.append("DESTROYED");
/*     */       else
/* 796 */         buffer.append("UNKNOWN?");
/* 797 */       buffer.append(" mc=").append(this.mc);
/* 798 */       buffer.append(" handles=").append(this.handles.size());
/* 799 */       buffer.append(" lastUse=").append(this.lastUse);
/* 800 */       buffer.append(" permit=").append(this.permit);
/* 801 */       buffer.append(" trackByTx=").append(this.trackByTx);
/* 802 */       buffer.append(" mcp=").append(this.mcp);
/* 803 */       buffer.append(" context=").append(this.context);
/* 804 */       toString(buffer);
/* 805 */       buffer.append(']');
/* 806 */       return buffer.toString();
/*     */     }
/*     */ 
/*     */     protected void toString(StringBuffer buffer)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.connectionmanager.BaseConnectionManager2
 * JD-Core Version:    0.6.0
 */