/*    */ package org.jboss.resource.binding.remote;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.OutputStream;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.serial.io.JBossObjectInputStream;
/*    */ import org.jboss.serial.io.JBossObjectOutputStream;
/*    */ 
/*    */ public class RemoteSerializerImpl
/*    */   implements RemoteSerializer, Serializable
/*    */ {
/* 43 */   private static final RemoteSerializer serializer = new RemoteSerializerImpl();
/*    */   private static final long serialVersionUID = 6386719587282465130L;
/*    */ 
/*    */   public byte[] serializeToByte(Object target)
/*    */     throws Exception
/*    */   {
/* 50 */     ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 51 */     OutputStream oos = new ObjectOutputStream(baos);
/* 52 */     JBossObjectOutputStream jbos = new JBossObjectOutputStream(oos);
/* 53 */     jbos.writeObject(target);
/* 54 */     jbos.close();
/*    */ 
/* 56 */     return baos.toByteArray();
/*    */   }
/*    */ 
/*    */   public Object serialize(Object target)
/*    */     throws Exception
/*    */   {
/* 62 */     return shouldSerialize(target) ? serialize(target) : target;
/*    */   }
/*    */ 
/*    */   public Object deserialize(Object target)
/*    */     throws Exception
/*    */   {
/* 68 */     SerializableWrapper wrapper = (SerializableWrapper)target;
/* 69 */     byte[] payload = wrapper.getPayload();
/* 70 */     ByteArrayInputStream bais = new ByteArrayInputStream(payload);
/* 71 */     ObjectInputStream ois = new ObjectInputStream(bais);
/* 72 */     JBossObjectInputStream jbis = new JBossObjectInputStream(ois);
/* 73 */     Object result = jbis.readObject();
/* 74 */     return result;
/*    */   }
/*    */ 
/*    */   public void serialize(Object[] targets)
/*    */     throws Exception
/*    */   {
/* 80 */     for (int i = 0; i < targets.length; i++)
/*    */     {
/* 82 */       Object target = targets[i];
/* 83 */       targets[i] = serialize(target);
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean shouldSerialize(Object target)
/*    */   {
/* 91 */     return !(target instanceof Serializable);
/*    */   }
/*    */ 
/*    */   static RemoteSerializer getInstance()
/*    */   {
/* 97 */     return serializer;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.binding.remote.RemoteSerializerImpl
 * JD-Core Version:    0.6.0
 */