/*    */ package org.jboss.resource.binding.remote;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.proxy.Interceptor;
/*    */ 
/*    */ public class RemoteSerializableInterceptor extends Interceptor
/*    */ {
/*    */   private static final long serialVersionUID = -6940983640563009944L;
/*    */ 
/*    */   public Object invoke(Invocation mi)
/*    */     throws Throwable
/*    */   {
/* 48 */     Object[] arguments = mi.getArguments();
/*    */ 
/* 50 */     for (int i = 0; i < arguments.length; i++)
/*    */     {
/* 53 */       Object argument = arguments[i];
/*    */ 
/* 55 */       if (!wrapArgument(argument))
/*    */         continue;
/* 57 */       arguments[i] = generateWrapper(argument);
/*    */     }
/*    */ 
/* 63 */     return getNext().invoke(mi);
/*    */   }
/*    */ 
/*    */   private boolean wrapArgument(Object obj)
/*    */   {
/* 68 */     return obj instanceof Serializable;
/*    */   }
/*    */ 
/*    */   private Object generateWrapper(Object argument)
/*    */     throws Exception
/*    */   {
/* 74 */     RemoteSerializer serializer = RemoteSerializerFactory.getSerializer();
/* 75 */     Object wrapper = serializer.serialize(argument);
/* 76 */     return wrapper;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.binding.remote.RemoteSerializableInterceptor
 * JD-Core Version:    0.6.0
 */