/*     */ package org.jboss.resource.adapter.jms.inflow;
/*     */ 
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.Topic;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.InvalidPropertyException;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class JmsActivationSpec
/*     */   implements ActivationSpec
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(JmsActivationSpec.class);
/*     */   private ResourceAdapter ra;
/*     */   private String destination;
/*  53 */   private boolean isTopic = false;
/*     */   private String messageSelector;
/*     */   private int acknowledgeMode;
/*     */   private boolean subscriptionDurability;
/*     */   private String clientId;
/*     */   private String subscriptionName;
/*  71 */   private long reconnectInterval = 10L;
/*     */ 
/*  74 */   private String providerAdapterJNDI = "java:/DefaultJMSProvider";
/*     */   private String user;
/*     */   private String pass;
/*  83 */   private int maxMessages = 1;
/*     */ 
/*  86 */   private int minSession = 1;
/*     */ 
/*  89 */   private int maxSession = 15;
/*     */ 
/*  92 */   private long keepAlive = 60000L;
/*     */ 
/*  95 */   private boolean sessionTransacted = true;
/*     */ 
/*  98 */   private String dLQHandler = "org.jboss.resource.adapter.jms.inflow.dlq.GenericDLQHandler";
/*     */ 
/* 101 */   private boolean useDLQ = true;
/*     */ 
/* 104 */   private String dLQJNDIName = "queue/DLQ";
/*     */   private String dLQUser;
/*     */   private String dLQPassword;
/*     */   private String dLQClientID;
/* 116 */   private int dLQMaxResent = 5;
/*     */ 
/* 119 */   private int reconnectAttempts = 5;
/*     */ 
/* 121 */   private boolean redeliverUnspecified = true;
/*     */   private int transactionTimeout;
/*     */   private Boolean isSameRMOverrideValue;
/* 127 */   private boolean forceClearOnShutdown = false;
/*     */ 
/* 129 */   private long forceClearOnShutdownInterval = 1000L;
/*     */ 
/* 131 */   private int forceClearAttempts = 0;
/*     */ 
/*     */   public void setForceClearOnShutdown(boolean forceClear)
/*     */   {
/* 135 */     this.forceClearOnShutdown = forceClear;
/*     */   }
/*     */ 
/*     */   public boolean isForceClearOnShutdown()
/*     */   {
/* 140 */     return this.forceClearOnShutdown;
/*     */   }
/*     */ 
/*     */   public long getForceClearOnShutdownInterval()
/*     */   {
/* 145 */     return this.forceClearOnShutdownInterval;
/*     */   }
/*     */ 
/*     */   public void setForceClearOnShutdownInterval(long forceClearOnShutdownInterval)
/*     */   {
/* 150 */     this.forceClearOnShutdownInterval = forceClearOnShutdownInterval;
/*     */   }
/*     */ 
/*     */   public int getForceClearAttempts()
/*     */   {
/* 155 */     return this.forceClearAttempts;
/*     */   }
/*     */ 
/*     */   public void setForceClearAttempts(int forceClearAttempts)
/*     */   {
/* 160 */     this.forceClearAttempts = forceClearAttempts;
/*     */   }
/*     */ 
/*     */   public String getAcknowledgeMode()
/*     */   {
/* 168 */     if (this.sessionTransacted)
/* 169 */       return "TRANSACTED";
/* 170 */     if (3 == this.acknowledgeMode) {
/* 171 */       return "DUPS_OK_ACKNOWLEDGE";
/*     */     }
/* 173 */     return "AUTO_ACKNOWLEDGE";
/*     */   }
/*     */ 
/*     */   public void setAcknowledgeMode(String acknowledgeMode)
/*     */   {
/* 181 */     if ("DUPS_OK_ACKNOWLEDGE".equals(acknowledgeMode))
/* 182 */       this.acknowledgeMode = 3;
/* 183 */     else if ("AUTO_ACKNOWLEDGE".equals(acknowledgeMode))
/* 184 */       this.acknowledgeMode = 1;
/* 185 */     else if ("SESSION_TRANSACTED".equals(acknowledgeMode))
/* 186 */       this.acknowledgeMode = 0;
/*     */     else
/* 188 */       throw new IllegalArgumentException("Unsupported acknowledgement mode " + acknowledgeMode);
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeModeInt()
/*     */   {
/* 196 */     if (this.sessionTransacted)
/* 197 */       return 0;
/* 198 */     return this.acknowledgeMode;
/*     */   }
/*     */ 
/*     */   public String getClientId()
/*     */   {
/* 206 */     return this.clientId;
/*     */   }
/*     */ 
/*     */   public void setClientId(String clientId)
/*     */   {
/* 214 */     this.clientId = clientId;
/*     */   }
/*     */ 
/*     */   public String getDestination()
/*     */   {
/* 222 */     return this.destination;
/*     */   }
/*     */ 
/*     */   public void setDestination(String destination)
/*     */   {
/* 230 */     this.destination = destination;
/*     */   }
/*     */ 
/*     */   public String getDestinationType()
/*     */   {
/* 238 */     if (this.isTopic) {
/* 239 */       return Topic.class.getName();
/*     */     }
/* 241 */     return Queue.class.getName();
/*     */   }
/*     */ 
/*     */   public void setDestinationType(String destinationType)
/*     */   {
/* 249 */     if (Topic.class.getName().equals(destinationType))
/* 250 */       this.isTopic = true;
/*     */     else
/* 252 */       this.isTopic = false;
/*     */   }
/*     */ 
/*     */   public boolean isTopic()
/*     */   {
/* 260 */     return this.isTopic;
/*     */   }
/*     */ 
/*     */   public String getMessageSelector()
/*     */   {
/* 268 */     return this.messageSelector;
/*     */   }
/*     */ 
/*     */   public void setMessageSelector(String messageSelector)
/*     */   {
/* 276 */     this.messageSelector = messageSelector;
/*     */   }
/*     */ 
/*     */   public String getSubscriptionDurability()
/*     */   {
/* 284 */     if (this.subscriptionDurability) {
/* 285 */       return "Durable";
/*     */     }
/* 287 */     return "NonDurable";
/*     */   }
/*     */ 
/*     */   public void setSubscriptionDurability(String subscriptionDurability)
/*     */   {
/* 295 */     this.subscriptionDurability = "Durable".equals(subscriptionDurability);
/*     */   }
/*     */ 
/*     */   public boolean isDurable()
/*     */   {
/* 303 */     return this.subscriptionDurability;
/*     */   }
/*     */ 
/*     */   public String getSubscriptionName()
/*     */   {
/* 311 */     return this.subscriptionName;
/*     */   }
/*     */ 
/*     */   public void setSubscriptionName(String subscriptionName)
/*     */   {
/* 319 */     this.subscriptionName = subscriptionName;
/*     */   }
/*     */ 
/*     */   public long getReconnectInterval()
/*     */   {
/* 327 */     return this.reconnectInterval;
/*     */   }
/*     */ 
/*     */   public void setReconnectInterval(long reconnectInterval)
/*     */   {
/* 335 */     this.reconnectInterval = reconnectInterval;
/*     */   }
/*     */ 
/*     */   public long getReconnectIntervalLong()
/*     */   {
/* 343 */     return this.reconnectInterval * 1000L;
/*     */   }
/*     */ 
/*     */   public String getProviderAdapterJNDI()
/*     */   {
/* 351 */     return this.providerAdapterJNDI;
/*     */   }
/*     */ 
/*     */   public void setProviderAdapterJNDI(String providerAdapterJNDI)
/*     */   {
/* 359 */     this.providerAdapterJNDI = providerAdapterJNDI;
/*     */   }
/*     */ 
/*     */   public String getUser()
/*     */   {
/* 367 */     return this.user;
/*     */   }
/*     */ 
/*     */   public void setUser(String user)
/*     */   {
/* 375 */     this.user = user;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 383 */     return this.pass;
/*     */   }
/*     */ 
/*     */   public void setPassword(String pass)
/*     */   {
/* 391 */     this.pass = pass;
/*     */   }
/*     */ 
/*     */   public int getMaxMessages()
/*     */   {
/* 399 */     return this.maxMessages;
/*     */   }
/*     */ 
/*     */   public void setMaxMessages(int maxMessages)
/*     */   {
/* 407 */     this.maxSession = maxMessages;
/*     */   }
/*     */ 
/*     */   public int getMaxMessagesInt()
/*     */   {
/* 415 */     return this.maxMessages;
/*     */   }
/*     */ 
/*     */   public int getMinSession()
/*     */   {
/* 423 */     return this.minSession;
/*     */   }
/*     */ 
/*     */   public void setMinSession(int minSession)
/*     */   {
/* 431 */     this.minSession = minSession;
/*     */   }
/*     */ 
/*     */   public int getMinSessionInt()
/*     */   {
/* 439 */     return this.minSession;
/*     */   }
/*     */ 
/*     */   public int getMaxSession()
/*     */   {
/* 447 */     return this.maxSession;
/*     */   }
/*     */ 
/*     */   public void setMaxSession(int maxSession)
/*     */   {
/* 455 */     this.maxSession = maxSession;
/*     */   }
/*     */ 
/*     */   public int getMaxSessionInt()
/*     */   {
/* 463 */     return this.maxSession;
/*     */   }
/*     */ 
/*     */   public long getKeepAlive()
/*     */   {
/* 471 */     return this.keepAlive;
/*     */   }
/*     */ 
/*     */   public void setKeepAlive(long keepAlive)
/*     */   {
/* 479 */     this.keepAlive = keepAlive;
/*     */   }
/*     */ 
/*     */   public long getKeepAliveLong()
/*     */   {
/* 487 */     return this.keepAlive;
/*     */   }
/*     */ 
/*     */   public boolean getSessionTransacted()
/*     */   {
/* 495 */     return this.sessionTransacted;
/*     */   }
/*     */ 
/*     */   public void setSessionTransacted(boolean sessionTransacted)
/*     */   {
/* 503 */     this.sessionTransacted = sessionTransacted;
/*     */   }
/*     */ 
/*     */   public boolean isSessionTransacted()
/*     */   {
/* 511 */     return this.sessionTransacted;
/*     */   }
/*     */ 
/*     */   public String getDLQHandler()
/*     */   {
/* 519 */     return this.dLQHandler;
/*     */   }
/*     */ 
/*     */   public void setDLQHandler(String handler)
/*     */   {
/* 527 */     this.dLQHandler = handler;
/*     */   }
/*     */ 
/*     */   public String getDLQJNDIName()
/*     */   {
/* 535 */     return this.dLQJNDIName;
/*     */   }
/*     */ 
/*     */   public void setDLQJNDIName(String name)
/*     */   {
/* 543 */     this.dLQJNDIName = name;
/*     */   }
/*     */ 
/*     */   public boolean getUseDLQ()
/*     */   {
/* 551 */     return this.useDLQ;
/*     */   }
/*     */ 
/*     */   public void setUseDLQ(boolean useDLQ)
/*     */   {
/* 559 */     this.useDLQ = useDLQ;
/*     */   }
/*     */ 
/*     */   public boolean isUseDLQ()
/*     */   {
/* 569 */     return this.useDLQ;
/*     */   }
/*     */ 
/*     */   public String getDLQClientID()
/*     */   {
/* 577 */     return this.dLQClientID;
/*     */   }
/*     */ 
/*     */   public void setDLQClientID(String clientID)
/*     */   {
/* 585 */     this.dLQClientID = clientID;
/*     */   }
/*     */ 
/*     */   public String getDLQPassword()
/*     */   {
/* 593 */     return this.dLQPassword;
/*     */   }
/*     */ 
/*     */   public void setDLQPassword(String password)
/*     */   {
/* 601 */     this.dLQPassword = password;
/*     */   }
/*     */ 
/*     */   public String getDLQUser()
/*     */   {
/* 609 */     return this.dLQUser;
/*     */   }
/*     */ 
/*     */   public void setDLQUser(String user)
/*     */   {
/* 617 */     this.dLQUser = user;
/*     */   }
/*     */ 
/*     */   public int getDLQMaxResent()
/*     */   {
/* 625 */     return this.dLQMaxResent;
/*     */   }
/*     */ 
/*     */   public void setDLQMaxResent(int maxResent)
/*     */   {
/* 632 */     this.dLQMaxResent = maxResent;
/*     */   }
/*     */ 
/*     */   public ResourceAdapter getResourceAdapter()
/*     */   {
/* 637 */     return this.ra;
/*     */   }
/*     */ 
/*     */   public void setResourceAdapter(ResourceAdapter ra) throws ResourceException
/*     */   {
/* 642 */     this.ra = ra;
/*     */   }
/*     */ 
/*     */   public void validate() throws InvalidPropertyException
/*     */   {
/* 647 */     if (log.isTraceEnabled())
/* 648 */       log.trace("validate " + this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 654 */     StringBuffer buffer = new StringBuffer();
/* 655 */     buffer.append(Strings.defaultToString(this)).append('(');
/* 656 */     buffer.append("ra=").append(this.ra);
/* 657 */     buffer.append(" destination=").append(this.destination);
/* 658 */     buffer.append(" isTopic=").append(this.isTopic);
/* 659 */     if (this.messageSelector != null)
/* 660 */       buffer.append(" selector=").append(this.messageSelector);
/* 661 */     buffer.append(" tx=").append(this.sessionTransacted);
/* 662 */     if (!this.sessionTransacted)
/* 663 */       buffer.append(" ack=").append(getAcknowledgeMode());
/* 664 */     buffer.append(" durable=").append(this.subscriptionDurability);
/* 665 */     if (this.clientId != null)
/* 666 */       buffer.append(" clientID=").append(this.clientId);
/* 667 */     if (this.subscriptionName != null)
/* 668 */       buffer.append(" subscription=").append(this.subscriptionName);
/* 669 */     buffer.append(" reconnect=").append(this.reconnectInterval);
/* 670 */     buffer.append(" provider=").append(this.providerAdapterJNDI);
/* 671 */     buffer.append(" user=").append(this.user);
/* 672 */     if (this.pass != null)
/* 673 */       buffer.append(" pass=").append("<not shown>");
/* 674 */     buffer.append(" maxMessages=").append(this.maxMessages);
/* 675 */     buffer.append(" minSession=").append(this.minSession);
/* 676 */     buffer.append(" maxSession=").append(this.maxSession);
/* 677 */     buffer.append(" keepAlive=").append(this.keepAlive);
/* 678 */     buffer.append(" useDLQ=").append(this.useDLQ);
/* 679 */     if (this.useDLQ)
/*     */     {
/* 681 */       buffer.append(" DLQHandler=").append(this.dLQHandler);
/* 682 */       buffer.append(" DLQJndiName=").append(this.dLQJNDIName);
/* 683 */       buffer.append(" DLQUser=").append(this.dLQUser);
/* 684 */       if (this.dLQPassword != null)
/* 685 */         buffer.append(" DLQPass=").append("<not shown>");
/* 686 */       if (this.dLQClientID != null)
/* 687 */         buffer.append(" DLQClientID=").append(this.dLQClientID);
/* 688 */       buffer.append(" DLQMaxResent=").append(this.dLQMaxResent);
/*     */     }
/* 690 */     buffer.append(')');
/* 691 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public int getReconnectAttempts()
/*     */   {
/* 696 */     return this.reconnectAttempts;
/*     */   }
/*     */ 
/*     */   public void setReconnectAttempts(int reconnectAttempts)
/*     */   {
/* 701 */     this.reconnectAttempts = reconnectAttempts;
/*     */   }
/*     */ 
/*     */   public boolean getRedeliverUnspecified()
/*     */   {
/* 706 */     return this.redeliverUnspecified;
/*     */   }
/*     */ 
/*     */   public void setRedeliverUnspecified(boolean redeliverUnspecified)
/*     */   {
/* 711 */     this.redeliverUnspecified = redeliverUnspecified;
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout()
/*     */   {
/* 716 */     return this.transactionTimeout;
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int transactionTimeout)
/*     */   {
/* 721 */     this.transactionTimeout = transactionTimeout;
/*     */   }
/*     */ 
/*     */   public Boolean getIsSameRMOverrideValue()
/*     */   {
/* 726 */     return this.isSameRMOverrideValue;
/*     */   }
/*     */ 
/*     */   public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue)
/*     */   {
/* 731 */     this.isSameRMOverrideValue = isSameRMOverrideValue;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.inflow.JmsActivationSpec
 * JD-Core Version:    0.6.0
 */