/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.BootstrapContext;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import javax.resource.spi.ResourceAdapterInternalException;
/*     */ import javax.resource.spi.XATerminator;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.adapter.jms.inflow.JmsActivation;
/*     */ import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
/*     */ 
/*     */ public class JmsResourceAdapter
/*     */   implements ResourceAdapter
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(JmsResourceAdapter.class);
/*     */   private BootstrapContext ctx;
/*  58 */   private ConcurrentReaderHashMap activations = new ConcurrentReaderHashMap();
/*     */ 
/*     */   public WorkManager getWorkManager()
/*     */   {
/*  67 */     return this.ctx.getWorkManager();
/*     */   }
/*     */ 
/*     */   public XATerminator getTerminator()
/*     */   {
/*  72 */     return this.ctx.getXATerminator();
/*     */   }
/*     */ 
/*     */   public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
/*  76 */     JmsActivation activation = new JmsActivation(this, endpointFactory, (JmsActivationSpec)spec);
/*  77 */     this.activations.put(spec, activation);
/*  78 */     activation.start();
/*     */   }
/*     */ 
/*     */   public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec)
/*     */   {
/*  83 */     JmsActivation activation = (JmsActivation)this.activations.remove(spec);
/*  84 */     if (activation != null)
/*  85 */       activation.stop();
/*     */   }
/*     */ 
/*     */   public XAResource[] getXAResources(ActivationSpec[] specs)
/*     */     throws ResourceException
/*     */   {
/*  91 */     return null;
/*     */   }
/*     */ 
/*     */   public void start(BootstrapContext ctx) throws ResourceAdapterInternalException
/*     */   {
/*  96 */     this.ctx = ctx;
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 101 */     for (Iterator i = this.activations.entrySet().iterator(); i.hasNext(); )
/*     */     {
/* 103 */       Map.Entry entry = (Map.Entry)i.next();
/*     */       try
/*     */       {
/* 106 */         JmsActivation activation = (JmsActivation)entry.getValue();
/* 107 */         if (activation != null)
/* 108 */           activation.stop();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/* 112 */         log.debug("Ignored", ignored);
/*     */       }
/* 114 */       i.remove();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsResourceAdapter
 * JD-Core Version:    0.6.0
 */