/*     */ package org.jboss.resource.adapter.jms;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.Topic;
/*     */ import javax.resource.ResourceException;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class JmsMCFProperties
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -7997396849692340121L;
/*  42 */   public static final String QUEUE_TYPE = Queue.class.getName();
/*  43 */   public static final String TOPIC_TYPE = Topic.class.getName();
/*     */   String userName;
/*     */   String password;
/*     */   String clientID;
/*  48 */   String providerJNDI = "java:DefaultJMSProvider";
/*  49 */   int type = 0;
/*     */ 
/*     */   public void setUserName(String userName)
/*     */   {
/*  61 */     this.userName = userName;
/*     */   }
/*     */ 
/*     */   public String getUserName()
/*     */   {
/*  69 */     return this.userName;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/*  77 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/*  85 */     return this.password;
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */   {
/*  93 */     return this.clientID;
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID)
/*     */   {
/* 101 */     this.clientID = clientID;
/*     */   }
/*     */ 
/*     */   public void setProviderJNDI(String providerJNDI)
/*     */   {
/* 111 */     this.providerJNDI = providerJNDI;
/*     */   }
/*     */ 
/*     */   public String getProviderJNDI()
/*     */   {
/* 119 */     return this.providerJNDI;
/*     */   }
/*     */ 
/*     */   public int getType()
/*     */   {
/* 127 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(int type)
/*     */   {
/* 135 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public void setSessionDefaultType(String type)
/*     */     throws ResourceException
/*     */   {
/* 146 */     if (type.equals(QUEUE_TYPE))
/* 147 */       this.type = 1;
/* 148 */     else if (type.equals(TOPIC_TYPE))
/* 149 */       this.type = 2;
/*     */     else
/* 151 */       this.type = 0;
/*     */   }
/*     */ 
/*     */   public String getSessionDefaultType()
/*     */   {
/* 156 */     if (this.type == 0)
/* 157 */       return "both";
/* 158 */     if (this.type == 1) {
/* 159 */       return TOPIC_TYPE;
/*     */     }
/* 161 */     return QUEUE_TYPE;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 169 */     if (obj == null) return false;
/*     */ 
/* 171 */     if ((obj instanceof JmsMCFProperties))
/*     */     {
/* 173 */       JmsMCFProperties you = (JmsMCFProperties)obj;
/* 174 */       return (Strings.compare(this.userName, you.getUserName())) && (Strings.compare(this.password, you.getPassword())) && (Strings.compare(this.providerJNDI, you.getProviderJNDI())) && (this.type == you.type);
/*     */     }
/*     */ 
/* 180 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 189 */     String result = "" + this.userName + this.password + this.providerJNDI + this.type;
/* 190 */     return result.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsMCFProperties
 * JD-Core Version:    0.6.0
 */