/*    */ package org.jboss.resource.adapter.jms;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import javax.jms.Session;
/*    */ import javax.resource.ResourceException;
/*    */ import javax.resource.spi.LocalTransaction;
/*    */ import org.jboss.resource.JBossResourceException;
/*    */ 
/*    */ public class JmsLocalTransaction
/*    */   implements LocalTransaction
/*    */ {
/*    */   protected JmsManagedConnection mc;
/*    */ 
/*    */   public JmsLocalTransaction(JmsManagedConnection mc)
/*    */   {
/* 43 */     this.mc = mc;
/*    */   }
/*    */ 
/*    */   public void begin() throws ResourceException
/*    */   {
/*    */   }
/*    */ 
/*    */   public void commit() throws ResourceException
/*    */   {
/*    */     try
/*    */     {
/* 54 */       if (this.mc.getSession().getTransacted())
/* 55 */         this.mc.getSession().commit();
/*    */     }
/*    */     catch (JMSException e)
/*    */     {
/* 59 */       throw new JBossResourceException("Could not commit LocalTransaction", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void rollback() throws ResourceException
/*    */   {
/*    */     try
/*    */     {
/* 67 */       if (this.mc.getSession().getTransacted())
/* 68 */         this.mc.getSession().rollback();
/*    */     }
/*    */     catch (JMSException ex)
/*    */     {
/* 72 */       throw new JBossResourceException("Could not rollback LocalTransaction", ex);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jms.JmsLocalTransaction
 * JD-Core Version:    0.6.0
 */