/*     */ package org.jboss.resource.adapter.jdbc.xa;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.ConnectionRequestInfo;
/*     */ import javax.resource.spi.ManagedConnection;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.sql.XAConnection;
/*     */ import javax.sql.XADataSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.JBossResourceException;
/*     */ import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
/*     */ import org.jboss.resource.adapter.jdbc.URLSelectorStrategy;
/*     */ 
/*     */ public class XAManagedConnectionFactory extends BaseWrapperManagedConnectionFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1647927657609573729L;
/*     */   private String xaDataSourceClass;
/*     */   private String xaDataSourceProperties;
/*  62 */   protected final Properties xaProps = new Properties();
/*     */   private Boolean isSameRMOverrideValue;
/*     */   private XADataSource xads;
/*     */   private String urlProperty;
/*     */   private URLSelectorStrategy xadsSelector;
/*     */ 
/*     */   public String getURLProperty()
/*     */   {
/*  74 */     return this.urlProperty;
/*     */   }
/*     */ 
/*     */   public void setURLProperty(String urlProperty) throws ResourceException
/*     */   {
/*  79 */     this.urlProperty = urlProperty;
/*  80 */     initSelector();
/*     */   }
/*     */ 
/*     */   public void setURLDelimiter(String urlDelimiter) throws ResourceException
/*     */   {
/*  85 */     this.urlDelimiter = urlDelimiter;
/*  86 */     initSelector();
/*     */   }
/*     */ 
/*     */   private void initSelector() throws JBossResourceException
/*     */   {
/*  91 */     if ((this.urlProperty != null) && (this.urlProperty.length() > 0))
/*     */     {
/*  93 */       String urlsStr = this.xaProps.getProperty(this.urlProperty);
/*  94 */       if ((urlsStr != null) && (urlsStr.trim().length() > 0) && (this.urlDelimiter != null) && (this.urlDelimiter.trim().length() > 0))
/*     */       {
/*  96 */         List xaDataList = new ArrayList();
/*     */ 
/* 101 */         Properties xaPropsCopy = new Properties();
/* 102 */         for (Iterator i = this.xaProps.keySet().iterator(); i.hasNext(); )
/*     */         {
/* 104 */           Object key = i.next();
/* 105 */           xaPropsCopy.put(key, this.xaProps.get(key));
/*     */         }
/*     */ 
/* 108 */         int urlStart = 0;
/* 109 */         int urlEnd = urlsStr.indexOf(this.urlDelimiter);
/* 110 */         while (urlEnd > 0)
/*     */         {
/* 112 */           String url = urlsStr.substring(urlStart, urlEnd);
/* 113 */           xaPropsCopy.setProperty(this.urlProperty, url);
/* 114 */           XADataSource xads = createXaDataSource(xaPropsCopy);
/* 115 */           xaDataList.add(new XAData(xads, url));
/* 116 */           urlEnd++; urlStart = urlEnd;
/* 117 */           urlEnd = urlsStr.indexOf(this.urlDelimiter, urlEnd);
/* 118 */           this.log.debug("added XA HA connection url: " + url);
/*     */         }
/*     */ 
/* 121 */         if (urlStart != urlsStr.length())
/*     */         {
/* 123 */           String url = urlsStr.substring(urlStart, urlsStr.length());
/* 124 */           xaPropsCopy.setProperty(this.urlProperty, url);
/* 125 */           XADataSource xads = createXaDataSource(xaPropsCopy);
/* 126 */           xaDataList.add(new XAData(xads, url));
/* 127 */           this.log.debug("added XA HA connection url: " + url);
/*     */         }
/* 129 */         if (getUrlSelectorStrategyClassName() == null)
/*     */         {
/* 131 */           this.xadsSelector = new XADataSelector(xaDataList);
/* 132 */           this.log.debug("Default URLSelectorStrategy is being used : " + this.xadsSelector);
/*     */         }
/*     */         else
/*     */         {
/* 136 */           this.xadsSelector = ((URLSelectorStrategy)loadClass(getUrlSelectorStrategyClassName(), xaDataList));
/* 137 */           this.log.debug("Customized URLSelectorStrategy is being used : " + this.xadsSelector);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private XADataSource createXaDataSource(Properties xaProps)
/*     */     throws JBossResourceException
/*     */   {
/* 146 */     if (getXADataSourceClass() == null)
/*     */     {
/* 148 */       throw new JBossResourceException("No XADataSourceClass supplied!");
/*     */     }
/*     */     XADataSource xads;
/*     */     try
/*     */     {
/* 154 */       clazz = Thread.currentThread().getContextClassLoader().loadClass(getXADataSourceClass());
/* 155 */       xads = (XADataSource)clazz.newInstance();
/* 156 */       NOCLASSES = new Class[0];
/* 157 */       for (i = xaProps.keySet().iterator(); i.hasNext(); )
/*     */       {
/* 159 */         String name = (String)i.next();
/* 160 */         String value = xaProps.getProperty(name);
/*     */ 
/* 166 */         Class type = null;
/*     */         try
/*     */         {
/* 169 */           Method getter = clazz.getMethod("get" + name, NOCLASSES);
/* 170 */           type = getter.getReturnType();
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 174 */           type = String.class;
/*     */         }
/*     */ 
/* 177 */         Method setter = clazz.getMethod("set" + name, new Class[] { type });
/* 178 */         PropertyEditor editor = PropertyEditorManager.findEditor(type);
/* 179 */         if (editor == null)
/*     */         {
/* 181 */           throw new JBossResourceException("No property editor found for type: " + type);
/*     */         }
/* 183 */         editor.setAsText(value);
/* 184 */         setter.invoke(xads, new Object[] { editor.getValue() });
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException cnfe)
/*     */     {
/*     */       Class clazz;
/*     */       Class[] NOCLASSES;
/*     */       Iterator i;
/* 190 */       throw new JBossResourceException("Class not found for XADataSource " + getXADataSourceClass(), cnfe);
/*     */     }
/*     */     catch (InstantiationException ie)
/*     */     {
/* 194 */       throw new JBossResourceException("Could not create an XADataSource: ", ie);
/*     */     }
/*     */     catch (IllegalAccessException iae)
/*     */     {
/* 198 */       throw new JBossResourceException("Could not set a property: ", iae);
/*     */     }
/*     */     catch (IllegalArgumentException iae)
/*     */     {
/* 203 */       throw new JBossResourceException("Could not set a property: ", iae);
/*     */     }
/*     */     catch (InvocationTargetException ite)
/*     */     {
/* 208 */       throw new JBossResourceException("Could not invoke setter on XADataSource: ", ite);
/*     */     }
/*     */     catch (NoSuchMethodException nsme)
/*     */     {
/* 212 */       throw new JBossResourceException("Could not find accessor on XADataSource: ", nsme);
/*     */     }
/*     */ 
/* 215 */     return xads;
/*     */   }
/*     */ 
/*     */   public String getXADataSourceClass()
/*     */   {
/* 329 */     return this.xaDataSourceClass;
/*     */   }
/*     */ 
/*     */   public void setXADataSourceClass(String xaDataSourceClass)
/*     */   {
/* 339 */     this.xaDataSourceClass = xaDataSourceClass;
/*     */   }
/*     */ 
/*     */   public String getXADataSourceProperties()
/*     */   {
/* 349 */     return this.xaDataSourceProperties;
/*     */   }
/*     */ 
/*     */   public void setXADataSourceProperties(String xaDataSourceProperties)
/*     */     throws ResourceException
/*     */   {
/* 359 */     this.xaDataSourceProperties = xaDataSourceProperties;
/* 360 */     this.xaProps.clear();
/* 361 */     if (xaDataSourceProperties != null)
/*     */     {
/* 364 */       xaDataSourceProperties = xaDataSourceProperties.replaceAll("\\\\", "\\\\\\\\");
/*     */ 
/* 366 */       InputStream is = new ByteArrayInputStream(xaDataSourceProperties.getBytes());
/*     */       try
/*     */       {
/* 369 */         this.xaProps.load(is);
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 373 */         throw new JBossResourceException("Could not load connection properties", ioe);
/*     */       }
/*     */     }
/* 376 */     initSelector();
/*     */   }
/*     */ 
/*     */   public Boolean getIsSameRMOverrideValue()
/*     */   {
/* 386 */     return this.isSameRMOverrideValue;
/*     */   }
/*     */ 
/*     */   public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue)
/*     */   {
/* 396 */     this.isSameRMOverrideValue = isSameRMOverrideValue;
/*     */   }
/*     */ 
/*     */   public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 402 */     if (this.xadsSelector == null)
/*     */     {
/* 404 */       return getXAManagedConnection(subject, cri);
/*     */     }
/*     */ 
/* 408 */     for (int i = 0; i < this.xadsSelector.getCustomSortedUrls().size(); i++)
/*     */     {
/* 410 */       XAData xaData = (XAData)this.xadsSelector.getUrlObject();
/*     */ 
/* 412 */       if (this.log.isTraceEnabled())
/*     */       {
/* 414 */         this.log.trace("Trying to create an XA connection to " + xaData.url);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 419 */         return getXAManagedConnection(subject, cri);
/*     */       }
/*     */       catch (ResourceException e)
/*     */       {
/* 423 */         this.log.warn("Failed to create an XA connection to " + xaData.url + ": " + e.getMessage());
/* 424 */         this.xadsSelector.failedUrlObject(xaData);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 429 */     throw new JBossResourceException("Could not create connection using any of the URLs: " + this.xadsSelector.getAllUrlObjects());
/*     */   }
/*     */ 
/*     */   public ManagedConnection getXAManagedConnection(Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 437 */     Properties props = getConnectionProperties(subject, cri);
/*     */     try
/*     */     {
/* 440 */       String user = props.getProperty("user");
/* 441 */       String password = props.getProperty("password");
/*     */ 
/* 443 */       XAConnection xaConnection = user != null ? getXADataSource().getXAConnection(user, password) : getXADataSource().getXAConnection();
/*     */ 
/* 447 */       return newXAManagedConnection(props, xaConnection);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 451 */     throw new JBossResourceException("Could not create connection", e);
/*     */   }
/*     */ 
/*     */   protected ManagedConnection newXAManagedConnection(Properties props, XAConnection xaConnection)
/*     */     throws SQLException
/*     */   {
/* 461 */     return new XAManagedConnection(this, xaConnection, props, this.transactionIsolation, this.preparedStatementCacheSize);
/*     */   }
/*     */ 
/*     */   public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri)
/*     */     throws ResourceException
/*     */   {
/* 467 */     Properties newProps = getConnectionProperties(subject, cri);
/* 468 */     for (Iterator i = mcs.iterator(); i.hasNext(); )
/*     */     {
/* 470 */       Object o = i.next();
/* 471 */       if ((o instanceof XAManagedConnection))
/*     */       {
/* 473 */         XAManagedConnection mc = (XAManagedConnection)o;
/*     */ 
/* 475 */         if (mc.getProperties().equals(newProps))
/*     */         {
/* 478 */           if (((getValidateOnMatch()) && (mc.checkValid())) || (!getValidateOnMatch()))
/*     */           {
/* 481 */             return mc;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 489 */     return null;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 494 */     int result = 17;
/* 495 */     result = result * 37 + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
/* 496 */     result = result * 37 + this.xaProps.hashCode();
/* 497 */     result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
/* 498 */     result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
/* 499 */     result = result * 37 + this.transactionIsolation;
/* 500 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 505 */     if (this == other)
/* 506 */       return true;
/* 507 */     if (getClass() != other.getClass())
/* 508 */       return false;
/* 509 */     XAManagedConnectionFactory otherMcf = (XAManagedConnectionFactory)other;
/* 510 */     return (this.xaDataSourceClass.equals(otherMcf.xaDataSourceClass)) && (this.xaProps.equals(otherMcf.xaProps)) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && (this.transactionIsolation == otherMcf.transactionIsolation);
/*     */   }
/*     */ 
/*     */   protected synchronized XADataSource getXADataSource()
/*     */     throws ResourceException
/*     */   {
/* 519 */     if (this.xadsSelector != null)
/*     */     {
/* 521 */       XAData xada = (XAData)this.xadsSelector.getUrlObject();
/* 522 */       return xada.xads;
/*     */     }
/* 524 */     if (this.xads == null)
/*     */     {
/* 526 */       if (this.xaDataSourceClass == null)
/* 527 */         throw new JBossResourceException("No XADataSourceClass supplied!");
/*     */       try
/*     */       {
/* 530 */         clazz = Thread.currentThread().getContextClassLoader().loadClass(this.xaDataSourceClass);
/* 531 */         this.xads = ((XADataSource)clazz.newInstance());
/* 532 */         NOCLASSES = new Class[0];
/* 533 */         for (i = this.xaProps.keySet().iterator(); i.hasNext(); )
/*     */         {
/* 535 */           String name = (String)i.next();
/* 536 */           String value = this.xaProps.getProperty(name);
/*     */ 
/* 542 */           Class type = null;
/*     */           try
/*     */           {
/* 545 */             Method getter = clazz.getMethod("get" + name, NOCLASSES);
/* 546 */             type = getter.getReturnType();
/*     */           }
/*     */           catch (NoSuchMethodException e)
/*     */           {
/* 550 */             type = String.class;
/*     */           }
/*     */ 
/* 553 */           Method setter = clazz.getMethod("set" + name, new Class[] { type });
/* 554 */           PropertyEditor editor = PropertyEditorManager.findEditor(type);
/* 555 */           if (editor == null)
/* 556 */             throw new JBossResourceException("No property editor found for type: " + type);
/* 557 */           editor.setAsText(value);
/* 558 */           setter.invoke(this.xads, new Object[] { editor.getValue() });
/*     */         }
/*     */       }
/*     */       catch (ClassNotFoundException cnfe)
/*     */       {
/*     */         Class clazz;
/*     */         Class[] NOCLASSES;
/*     */         Iterator i;
/* 563 */         throw new JBossResourceException("Class not found for XADataSource " + this.xaDataSourceClass, cnfe);
/*     */       }
/*     */       catch (InstantiationException ie)
/*     */       {
/* 567 */         throw new JBossResourceException("Could not create an XADataSource: ", ie);
/*     */       }
/*     */       catch (IllegalAccessException iae)
/*     */       {
/* 571 */         throw new JBossResourceException("Could not set a property: ", iae);
/*     */       }
/*     */       catch (IllegalArgumentException iae)
/*     */       {
/* 575 */         throw new JBossResourceException("Could not set a property: ", iae);
/*     */       }
/*     */       catch (InvocationTargetException ite)
/*     */       {
/* 579 */         throw new JBossResourceException("Could not invoke setter on XADataSource: ", ite);
/*     */       }
/*     */       catch (NoSuchMethodException nsme)
/*     */       {
/* 583 */         throw new JBossResourceException("Could not find accessor on XADataSource: ", nsme);
/*     */       }
/*     */     }
/* 586 */     return this.xads;
/*     */   }
/*     */ 
/*     */   protected Properties getXaProps()
/*     */   {
/* 591 */     return this.xaProps;
/*     */   }
/*     */ 
/*     */   private static class XAData
/*     */   {
/*     */     public final XADataSource xads;
/*     */     public final String url;
/*     */ 
/*     */     public XAData(XADataSource xads, String url)
/*     */     {
/* 282 */       this.xads = xads;
/* 283 */       this.url = url;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 288 */       if (this == o)
/*     */       {
/* 290 */         return true;
/*     */       }
/* 292 */       if (!(o instanceof XAData))
/*     */       {
/* 294 */         return false;
/*     */       }
/*     */ 
/* 297 */       XAData xaData = (XAData)o;
/*     */ 
/* 301 */       return this.url.equals(xaData.url);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 309 */       return this.url.hashCode();
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 314 */       return "[XA URL=" + this.url + "]";
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class XADataSelector
/*     */     implements URLSelectorStrategy
/*     */   {
/*     */     private final List xaDataList;
/*     */     private int xaDataIndex;
/*     */     private XAManagedConnectionFactory.XAData xaData;
/*     */ 
/*     */     public XADataSelector(List xaDataList)
/*     */     {
/* 227 */       if ((xaDataList == null) || (xaDataList.size() == 0))
/*     */       {
/* 229 */         throw new IllegalStateException("Expected non-empty list of XADataSource/URL pairs but got: " + xaDataList);
/*     */       }
/*     */ 
/* 232 */       this.xaDataList = xaDataList;
/*     */     }
/*     */ 
/*     */     public synchronized XAManagedConnectionFactory.XAData getXAData()
/*     */     {
/* 237 */       if (this.xaData == null)
/*     */       {
/* 239 */         if (this.xaDataIndex == this.xaDataList.size())
/*     */         {
/* 241 */           this.xaDataIndex = 0;
/*     */         }
/* 243 */         this.xaData = ((XAManagedConnectionFactory.XAData)this.xaDataList.get(this.xaDataIndex++));
/*     */       }
/* 245 */       return this.xaData;
/*     */     }
/*     */ 
/*     */     public synchronized void failedXAData(XAManagedConnectionFactory.XAData xads)
/*     */     {
/* 250 */       if (xads.equals(this.xaData))
/*     */       {
/* 252 */         this.xaData = null;
/*     */       }
/*     */     }
/*     */ 
/*     */     public List getCustomSortedUrls()
/*     */     {
/* 259 */       return this.xaDataList;
/*     */     }
/*     */ 
/*     */     public void failedUrlObject(Object urlObject) {
/* 263 */       failedXAData((XAManagedConnectionFactory.XAData)urlObject);
/*     */     }
/*     */ 
/*     */     public List getAllUrlObjects() {
/* 267 */       return this.xaDataList;
/*     */     }
/*     */ 
/*     */     public Object getUrlObject() {
/* 271 */       return getXAData();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.xa.XAManagedConnectionFactory
 * JD-Core Version:    0.6.0
 */