/*     */ package org.jboss.resource.adapter.jdbc.vendor;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Connection;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
/*     */ 
/*     */ public class MySQLValidConnectionChecker
/*     */   implements ValidConnectionChecker, Serializable
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(MySQLValidConnectionChecker.class);
/*     */   private static final long serialVersionUID = -2227528634302168878L;
/*     */   private Method ping;
/*  54 */   private boolean driverHasPingMethod = false;
/*     */ 
/*  57 */   private static Object[] params = new Object[0];
/*     */ 
/*     */   public MySQLValidConnectionChecker()
/*     */   {
/*     */     try
/*     */     {
/*  63 */       Class mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.Connection");
/*  64 */       this.ping = mysqlConnection.getMethod("ping", new Class[0]);
/*     */ 
/*  66 */       if (this.ping != null)
/*     */       {
/*  68 */         this.driverHasPingMethod = true;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  73 */       log.warn("Cannot resolve com.mysq.jdbc.Connection.ping method.  Will use 'SELECT 1' instead.", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SQLException isValidConnection(Connection c)
/*     */   {
/*  80 */     if (this.driverHasPingMethod)
/*     */     {
/*     */       try
/*     */       {
/*  84 */         this.ping.invoke(c, params);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  88 */         if ((e instanceof SQLException))
/*     */         {
/*  90 */           return (SQLException)e;
/*     */         }
/*     */ 
/*  94 */         log.warn("Unexpected error in ping", e);
/*  95 */         return new SQLException("ping failed: " + e.toString());
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 103 */       Statement stmt = null;
/* 104 */       ResultSet rs = null;
/*     */       try
/*     */       {
/* 107 */         stmt = c.createStatement();
/* 108 */         rs = stmt.executeQuery("SELECT 1");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 112 */         if ((e instanceof SQLException))
/*     */         {
/* 114 */           localSQLException1 = (SQLException)e;
/*     */           return localSQLException1;
/*     */         }
/* 118 */         log.warn("Unexpected error in ping (SELECT 1)", e);
/* 119 */         SQLException localSQLException1 = new SQLException("ping (SELECT 1) failed: " + e.toString());
/*     */         return localSQLException1;
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 127 */           if (rs != null) {
/* 128 */             rs.close();
/*     */           }
/* 130 */           if (stmt != null) {
/* 131 */             stmt.close();
/*     */           }
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 140 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.vendor.MySQLValidConnectionChecker
 * JD-Core Version:    0.6.0
 */