/*     */ package org.jboss.resource.adapter.jdbc.vendor;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Connection;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;
/*     */ 
/*     */ public class MySQLReplicationValidConnectionChecker
/*     */   implements ValidConnectionChecker, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2658231045989623858L;
/*  57 */   private boolean driverHasIsValidMethod = false;
/*     */ 
/*  62 */   private boolean driverHasPingMethod = false;
/*     */   protected static final String CONNECTION_CLASS = "com.mysql.jdbc.ReplicationConnection";
/*  72 */   private static final Logger log = Logger.getLogger(MySQLReplicationValidConnectionChecker.class);
/*     */ 
/*  75 */   private static Object[] timeoutParam = new Object[0];
/*     */ 
/*     */   public MySQLReplicationValidConnectionChecker()
/*     */   {
/*  82 */     Class mysqlConnection = null;
/*     */     try
/*     */     {
/*  87 */       mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass("com.mysql.jdbc.ReplicationConnection");
/*     */       try
/*     */       {
/*  92 */         mysqlConnection.getMethod("isValid", new Class[0]);
/*  93 */         this.driverHasIsValidMethod = true;
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/*  99 */         log.info("Cannot resolve com.mysq.jdbc.ReplicationConnection.isValid method. Fallback to ping.", e);
/*     */       }
/*     */       catch (SecurityException e)
/*     */       {
/* 103 */         log.info("Cannot resolve com.mysq.jdbc.ReplicationConnection.isValid method. Fallback to ping.", e);
/*     */       }
/*     */ 
/* 106 */       if (!this.driverHasIsValidMethod)
/*     */       {
/*     */         try
/*     */         {
/* 111 */           mysqlConnection.getMethod("ping", new Class[0]);
/* 112 */           this.driverHasPingMethod = true;
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 118 */           log.warn("Cannot resolve com.mysq.jdbc.ReplicationConnection.ping method. Will use 'SELECT 1' instead.", e);
/*     */         }
/*     */         catch (SecurityException e)
/*     */         {
/* 122 */           log.info("Cannot resolve com.mysq.jdbc.ReplicationConnection.ping method. Will use 'SELECT 1' instead.", e);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 128 */       log.error("Cannot find the driver class defined in CONNECTION_CLASS", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SQLException isValidConnection(Connection c)
/*     */   {
/* 139 */     if (this.driverHasIsValidMethod)
/*     */     {
/*     */       try {
/* 142 */         c.getClass().getMethod("isValid", new Class[0]).invoke(c, timeoutParam);
/*     */       } catch (Exception e) {
/* 144 */         if ((e instanceof SQLException)) {
/* 145 */           return (SQLException)e;
/*     */         }
/* 147 */         log.warn("Unexpected error in ping", e);
/* 148 */         return new SQLException("ping failed: " + e.toString());
/*     */       }
/*     */ 
/*     */     }
/* 154 */     else if (this.driverHasPingMethod)
/*     */     {
/*     */       try {
/* 157 */         c.getClass().getMethod("ping", new Class[0]).invoke(c, timeoutParam);
/*     */       } catch (Exception e) {
/* 159 */         if ((e instanceof SQLException)) {
/* 160 */           return (SQLException)e;
/*     */         }
/* 162 */         log.warn("Unexpected error in ping", e);
/* 163 */         return new SQLException("ping failed: " + e.toString());
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 172 */       Statement stmt = null;
/* 173 */       ResultSet rs = null;
/*     */       try
/*     */       {
/* 176 */         stmt = c.createStatement();
/* 177 */         rs = stmt.executeQuery("SELECT 1");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 181 */         if ((e instanceof SQLException)) {
/* 182 */           localSQLException1 = (SQLException)e;
/*     */           return localSQLException1;
/*     */         }
/* 186 */         log.warn("Unexpected error in ping (SELECT 1)", e);
/* 187 */         SQLException localSQLException1 = new SQLException("ping (SELECT 1) failed: " + e.toString());
/*     */         return localSQLException1;
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 195 */           if (rs != null) rs.close(); 
/*     */         } catch (SQLException e) {
/*     */         }
/*     */         finally {
/*     */           try {
/* 199 */             if (stmt != null) stmt.close(); 
/*     */           }
/*     */           catch (SQLException e) {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 205 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.vendor.MySQLReplicationValidConnectionChecker
 * JD-Core Version:    0.6.0
 */