/*     */ package org.jboss.resource.adapter.jdbc.jdk6;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.sql.NClob;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLXML;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
/*     */ import org.jboss.resource.adapter.jdbc.WrappedResultSet;
/*     */ 
/*     */ public class WrappedPreparedStatementJDK6 extends WrappedPreparedStatement
/*     */ {
/*     */   public WrappedPreparedStatementJDK6(WrappedConnectionJDK6 lc, PreparedStatement s)
/*     */   {
/*  46 */     super(lc, s);
/*     */   }
/*     */ 
/*     */   protected WrappedResultSet wrapResultSet(ResultSet resultSet)
/*     */   {
/*  51 */     return new WrappedResultSetJDK6(this, resultSet);
/*     */   }
/*     */ 
/*     */   public boolean isClosed() throws SQLException
/*     */   {
/*     */     try
/*     */     {
/*  58 */       PreparedStatement wrapped = getWrappedObject();
/*  59 */       if (wrapped == null)
/*  60 */         return true;
/*  61 */       return wrapped.isClosed();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  65 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public boolean isPoolable()
/*     */     throws SQLException
/*     */   {
/*  71 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/*  74 */       return statement.isPoolable();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  78 */     throw checkException(t);
/*     */   }
/*     */ 
/*     */   public void setPoolable(boolean poolable)
/*     */     throws SQLException
/*     */   {
/*  84 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/*  87 */       statement.setPoolable(poolable);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  91 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException
/*     */   {
/*  97 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 100 */       statement.setAsciiStream(parameterIndex, x, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 104 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException
/*     */   {
/* 110 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 113 */       statement.setAsciiStream(parameterIndex, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 117 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException
/*     */   {
/* 123 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 126 */       statement.setBinaryStream(parameterIndex, x, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 130 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException
/*     */   {
/* 136 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 139 */       statement.setBinaryStream(parameterIndex, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 143 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException
/*     */   {
/* 149 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 152 */       statement.setBlob(parameterIndex, inputStream, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 156 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException
/*     */   {
/* 162 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 165 */       statement.setBlob(parameterIndex, inputStream);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 169 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException
/*     */   {
/* 175 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 178 */       statement.setCharacterStream(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 182 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException
/*     */   {
/* 188 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 191 */       statement.setCharacterStream(parameterIndex, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 195 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(int parameterIndex, Reader reader, long length) throws SQLException
/*     */   {
/* 201 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 204 */       statement.setClob(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 208 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setClob(int parameterIndex, Reader reader) throws SQLException
/*     */   {
/* 214 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 217 */       statement.setClob(parameterIndex, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 221 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException
/*     */   {
/* 227 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 230 */       statement.setNCharacterStream(parameterIndex, value, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 234 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException
/*     */   {
/* 240 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 243 */       statement.setNCharacterStream(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 247 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(int parameterIndex, NClob value) throws SQLException
/*     */   {
/* 253 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 256 */       statement.setNClob(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 260 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException
/*     */   {
/* 266 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 269 */       statement.setNClob(parameterIndex, reader, length);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 273 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNClob(int parameterIndex, Reader reader) throws SQLException
/*     */   {
/* 279 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 282 */       statement.setNClob(parameterIndex, reader);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 286 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNString(int parameterIndex, String value) throws SQLException
/*     */   {
/* 292 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 295 */       statement.setNString(parameterIndex, value);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 299 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRowId(int parameterIndex, RowId x) throws SQLException
/*     */   {
/* 305 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 308 */       statement.setRowId(parameterIndex, x);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 312 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException
/*     */   {
/* 318 */     PreparedStatement statement = getUnderlyingStatement();
/*     */     try
/*     */     {
/* 321 */       statement.setSQLXML(parameterIndex, xmlObject);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 325 */       throw checkException(t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.jdk6.WrappedPreparedStatementJDK6
 * JD-Core Version:    0.6.0
 */