/*      */ package org.jboss.resource.adapter.jdbc;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.Ref;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLWarning;
/*      */ import java.sql.Statement;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Map;
/*      */ 
/*      */ public abstract class WrappedResultSet extends JBossWrapper
/*      */   implements ResultSet
/*      */ {
/*      */   private WrappedStatement statement;
/*      */   private ResultSet resultSet;
/*   58 */   private boolean closed = false;
/*      */ 
/*   61 */   private Object lock = new Object();
/*      */ 
/*      */   public WrappedResultSet(WrappedStatement statement, ResultSet resultSet)
/*      */   {
/*   71 */     if (statement == null)
/*   72 */       throw new IllegalArgumentException("Null statement!");
/*   73 */     if (resultSet == null)
/*   74 */       throw new IllegalArgumentException("Null result set!");
/*   75 */     this.statement = statement;
/*   76 */     this.resultSet = resultSet;
/*      */   }
/*      */ 
/*      */   public boolean equals(Object o)
/*      */   {
/*   81 */     if (o == null)
/*   82 */       return false;
/*   83 */     if (o == this)
/*   84 */       return true;
/*   85 */     if ((o instanceof WrappedResultSet))
/*   86 */       return this.resultSet.equals(((WrappedResultSet)o).resultSet);
/*   87 */     if ((o instanceof ResultSet))
/*   88 */       return this.resultSet.equals(o);
/*   89 */     return false;
/*      */   }
/*      */ 
/*      */   public int hashCode()
/*      */   {
/*   94 */     return this.resultSet.hashCode();
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*   99 */     return this.resultSet.toString();
/*      */   }
/*      */ 
/*      */   public ResultSet getUnderlyingResultSet() throws SQLException
/*      */   {
/*  104 */     checkState();
/*  105 */     return this.resultSet;
/*      */   }
/*      */ 
/*      */   public boolean absolute(int row) throws SQLException
/*      */   {
/*  110 */     checkState();
/*      */     try
/*      */     {
/*  113 */       return this.resultSet.absolute(row);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  117 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void afterLast()
/*      */     throws SQLException
/*      */   {
/*  123 */     checkState();
/*      */     try
/*      */     {
/*  126 */       this.resultSet.afterLast();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  130 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void beforeFirst() throws SQLException
/*      */   {
/*  136 */     checkState();
/*      */     try
/*      */     {
/*  139 */       this.resultSet.beforeFirst();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  143 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void cancelRowUpdates() throws SQLException
/*      */   {
/*  149 */     checkState();
/*      */     try
/*      */     {
/*  152 */       this.resultSet.cancelRowUpdates();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  156 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void clearWarnings() throws SQLException
/*      */   {
/*  162 */     checkState();
/*      */     try
/*      */     {
/*  165 */       this.resultSet.clearWarnings();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  169 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void close() throws SQLException
/*      */   {
/*  175 */     synchronized (this.lock)
/*      */     {
/*  177 */       if (this.closed)
/*  178 */         return;
/*  179 */       this.closed = true;
/*      */     }
/*  181 */     this.statement.unregisterResultSet(this);
/*  182 */     internalClose();
/*      */   }
/*      */ 
/*      */   public void deleteRow() throws SQLException
/*      */   {
/*  187 */     checkState();
/*      */     try
/*      */     {
/*  190 */       this.resultSet.deleteRow();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  194 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int findColumn(String columnName) throws SQLException
/*      */   {
/*  200 */     checkState();
/*      */     try
/*      */     {
/*  203 */       return this.resultSet.findColumn(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  207 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean first()
/*      */     throws SQLException
/*      */   {
/*  213 */     checkState();
/*      */     try
/*      */     {
/*  216 */       return this.resultSet.first();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  220 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Array getArray(int i)
/*      */     throws SQLException
/*      */   {
/*  226 */     checkState();
/*      */     try
/*      */     {
/*  229 */       return this.resultSet.getArray(i);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  233 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Array getArray(String colName)
/*      */     throws SQLException
/*      */   {
/*  239 */     checkState();
/*      */     try
/*      */     {
/*  242 */       return this.resultSet.getArray(colName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  246 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  252 */     checkState();
/*      */     try
/*      */     {
/*  255 */       return this.resultSet.getAsciiStream(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  259 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(String columnName)
/*      */     throws SQLException
/*      */   {
/*  265 */     checkState();
/*      */     try
/*      */     {
/*  268 */       return this.resultSet.getAsciiStream(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  272 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  278 */     checkState();
/*      */     try
/*      */     {
/*  281 */       return this.resultSet.getBigDecimal(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  285 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException
/*      */   {
/*  292 */     checkState();
/*      */     try
/*      */     {
/*  295 */       return this.resultSet.getBigDecimal(columnIndex, scale);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  299 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public BigDecimal getBigDecimal(String columnName)
/*      */     throws SQLException
/*      */   {
/*  305 */     checkState();
/*      */     try
/*      */     {
/*  308 */       return this.resultSet.getBigDecimal(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  312 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException
/*      */   {
/*  319 */     checkState();
/*      */     try
/*      */     {
/*  322 */       return this.resultSet.getBigDecimal(columnName, scale);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  326 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  332 */     checkState();
/*      */     try
/*      */     {
/*  335 */       return this.resultSet.getBinaryStream(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  339 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(String columnName)
/*      */     throws SQLException
/*      */   {
/*  345 */     checkState();
/*      */     try
/*      */     {
/*  348 */       return this.resultSet.getBinaryStream(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  352 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(int i)
/*      */     throws SQLException
/*      */   {
/*  358 */     checkState();
/*      */     try
/*      */     {
/*  361 */       return this.resultSet.getBlob(i);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  365 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Blob getBlob(String colName)
/*      */     throws SQLException
/*      */   {
/*  371 */     checkState();
/*      */     try
/*      */     {
/*  374 */       return this.resultSet.getBlob(colName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  378 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  384 */     checkState();
/*      */     try
/*      */     {
/*  387 */       return this.resultSet.getBoolean(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  391 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String columnName)
/*      */     throws SQLException
/*      */   {
/*  397 */     checkState();
/*      */     try
/*      */     {
/*  400 */       return this.resultSet.getBoolean(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  404 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte getByte(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  410 */     checkState();
/*      */     try
/*      */     {
/*  413 */       return this.resultSet.getByte(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  417 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte getByte(String columnName)
/*      */     throws SQLException
/*      */   {
/*  423 */     checkState();
/*      */     try
/*      */     {
/*  426 */       return this.resultSet.getByte(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  430 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  436 */     checkState();
/*      */     try
/*      */     {
/*  439 */       return this.resultSet.getBytes(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  443 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(String columnName)
/*      */     throws SQLException
/*      */   {
/*  449 */     checkState();
/*      */     try
/*      */     {
/*  452 */       return this.resultSet.getBytes(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  456 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  462 */     checkState();
/*      */     try
/*      */     {
/*  465 */       return this.resultSet.getCharacterStream(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  469 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(String columnName)
/*      */     throws SQLException
/*      */   {
/*  475 */     checkState();
/*      */     try
/*      */     {
/*  478 */       return this.resultSet.getCharacterStream(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  482 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Clob getClob(int i)
/*      */     throws SQLException
/*      */   {
/*  488 */     checkState();
/*      */     try
/*      */     {
/*  491 */       return this.resultSet.getClob(i);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  495 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Clob getClob(String colName)
/*      */     throws SQLException
/*      */   {
/*  501 */     checkState();
/*      */     try
/*      */     {
/*  504 */       return this.resultSet.getClob(colName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  508 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getConcurrency()
/*      */     throws SQLException
/*      */   {
/*  514 */     checkState();
/*      */     try
/*      */     {
/*  517 */       return this.resultSet.getConcurrency();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  521 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public String getCursorName()
/*      */     throws SQLException
/*      */   {
/*  527 */     checkState();
/*      */     try
/*      */     {
/*  530 */       return this.resultSet.getCursorName();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  534 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  540 */     checkState();
/*      */     try
/*      */     {
/*  543 */       return this.resultSet.getDate(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  547 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(int columnIndex, Calendar cal)
/*      */     throws SQLException
/*      */   {
/*  553 */     checkState();
/*      */     try
/*      */     {
/*  556 */       return this.resultSet.getDate(columnIndex, cal);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  560 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(String columnName)
/*      */     throws SQLException
/*      */   {
/*  566 */     checkState();
/*      */     try
/*      */     {
/*  569 */       return this.resultSet.getDate(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  573 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Date getDate(String columnName, Calendar cal)
/*      */     throws SQLException
/*      */   {
/*  579 */     checkState();
/*      */     try
/*      */     {
/*  582 */       return this.resultSet.getDate(columnName, cal);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  586 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public double getDouble(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  592 */     checkState();
/*      */     try
/*      */     {
/*  595 */       return this.resultSet.getDouble(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  599 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public double getDouble(String columnName)
/*      */     throws SQLException
/*      */   {
/*  605 */     checkState();
/*      */     try
/*      */     {
/*  608 */       return this.resultSet.getDouble(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  612 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getFetchDirection()
/*      */     throws SQLException
/*      */   {
/*  618 */     checkState();
/*      */     try
/*      */     {
/*  621 */       return this.resultSet.getFetchDirection();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  625 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getFetchSize()
/*      */     throws SQLException
/*      */   {
/*  631 */     checkState();
/*      */     try
/*      */     {
/*  634 */       return this.resultSet.getFetchSize();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  638 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public float getFloat(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  644 */     checkState();
/*      */     try
/*      */     {
/*  647 */       return this.resultSet.getFloat(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  651 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public float getFloat(String columnName)
/*      */     throws SQLException
/*      */   {
/*  657 */     checkState();
/*      */     try
/*      */     {
/*  660 */       return this.resultSet.getFloat(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  664 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getInt(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  670 */     checkState();
/*      */     try
/*      */     {
/*  673 */       return this.resultSet.getInt(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  677 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getInt(String columnName)
/*      */     throws SQLException
/*      */   {
/*  683 */     checkState();
/*      */     try
/*      */     {
/*  686 */       return this.resultSet.getInt(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  690 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public long getLong(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  696 */     checkState();
/*      */     try
/*      */     {
/*  699 */       return this.resultSet.getLong(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  703 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public long getLong(String columnName)
/*      */     throws SQLException
/*      */   {
/*  709 */     checkState();
/*      */     try
/*      */     {
/*  712 */       return this.resultSet.getLong(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  716 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/*  722 */     checkState();
/*      */     try
/*      */     {
/*  725 */       return this.resultSet.getMetaData();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  729 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  735 */     checkState();
/*      */     try
/*      */     {
/*  738 */       return this.resultSet.getObject(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  742 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(int i, Map map)
/*      */     throws SQLException
/*      */   {
/*  749 */     checkState();
/*      */     try
/*      */     {
/*  752 */       return this.resultSet.getObject(i, map);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  756 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(String columnName)
/*      */     throws SQLException
/*      */   {
/*  762 */     checkState();
/*      */     try
/*      */     {
/*  765 */       return this.resultSet.getObject(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  769 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Object getObject(String colName, Map map)
/*      */     throws SQLException
/*      */   {
/*  776 */     checkState();
/*      */     try
/*      */     {
/*  779 */       return this.resultSet.getObject(colName, map);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  783 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Ref getRef(int i)
/*      */     throws SQLException
/*      */   {
/*  789 */     checkState();
/*      */     try
/*      */     {
/*  792 */       return this.resultSet.getRef(i);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  796 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Ref getRef(String colName)
/*      */     throws SQLException
/*      */   {
/*  802 */     checkState();
/*      */     try
/*      */     {
/*  805 */       return this.resultSet.getRef(colName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  809 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getRow()
/*      */     throws SQLException
/*      */   {
/*  815 */     checkState();
/*      */     try
/*      */     {
/*  818 */       return this.resultSet.getRow();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  822 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public short getShort(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  828 */     checkState();
/*      */     try
/*      */     {
/*  831 */       return this.resultSet.getShort(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  835 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public short getShort(String columnName)
/*      */     throws SQLException
/*      */   {
/*  841 */     checkState();
/*      */     try
/*      */     {
/*  844 */       return this.resultSet.getShort(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  848 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Statement getStatement()
/*      */     throws SQLException
/*      */   {
/*  854 */     checkState();
/*  855 */     return this.statement;
/*      */   }
/*      */ 
/*      */   public String getString(int columnIndex) throws SQLException
/*      */   {
/*  860 */     checkState();
/*      */     try
/*      */     {
/*  863 */       return this.resultSet.getString(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  867 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public String getString(String columnName)
/*      */     throws SQLException
/*      */   {
/*  873 */     checkState();
/*      */     try
/*      */     {
/*  876 */       return this.resultSet.getString(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  880 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  886 */     checkState();
/*      */     try
/*      */     {
/*  889 */       return this.resultSet.getTime(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  893 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(int columnIndex, Calendar cal)
/*      */     throws SQLException
/*      */   {
/*  899 */     checkState();
/*      */     try
/*      */     {
/*  902 */       return this.resultSet.getTime(columnIndex, cal);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  906 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(String columnName)
/*      */     throws SQLException
/*      */   {
/*  912 */     checkState();
/*      */     try
/*      */     {
/*  915 */       return this.resultSet.getTime(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  919 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Time getTime(String columnName, Calendar cal)
/*      */     throws SQLException
/*      */   {
/*  925 */     checkState();
/*      */     try
/*      */     {
/*  928 */       return this.resultSet.getTime(columnName, cal);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  932 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int columnIndex)
/*      */     throws SQLException
/*      */   {
/*  938 */     checkState();
/*      */     try
/*      */     {
/*  941 */       return this.resultSet.getTimestamp(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  945 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(int columnIndex, Calendar cal)
/*      */     throws SQLException
/*      */   {
/*  951 */     checkState();
/*      */     try
/*      */     {
/*  954 */       return this.resultSet.getTimestamp(columnIndex, cal);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  958 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String columnName)
/*      */     throws SQLException
/*      */   {
/*  964 */     checkState();
/*      */     try
/*      */     {
/*  967 */       return this.resultSet.getTimestamp(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  971 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public Timestamp getTimestamp(String columnName, Calendar cal)
/*      */     throws SQLException
/*      */   {
/*  977 */     checkState();
/*      */     try
/*      */     {
/*  980 */       return this.resultSet.getTimestamp(columnName, cal);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  984 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public int getType()
/*      */     throws SQLException
/*      */   {
/*  990 */     checkState();
/*      */     try
/*      */     {
/*  993 */       return this.resultSet.getType();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  997 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public InputStream getUnicodeStream(int columnIndex) throws SQLException
/*      */   {
/* 1004 */     checkState();
/*      */     try
/*      */     {
/* 1007 */       return this.resultSet.getUnicodeStream(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1011 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public InputStream getUnicodeStream(String columnName) throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1020 */       return this.resultSet.getUnicodeStream(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1024 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public URL getURL(int columnIndex)
/*      */     throws SQLException
/*      */   {
/* 1030 */     checkState();
/*      */     try
/*      */     {
/* 1033 */       return this.resultSet.getURL(columnIndex);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1037 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public URL getURL(String columnName)
/*      */     throws SQLException
/*      */   {
/* 1043 */     checkState();
/*      */     try
/*      */     {
/* 1046 */       return this.resultSet.getURL(columnName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1050 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public SQLWarning getWarnings()
/*      */     throws SQLException
/*      */   {
/* 1056 */     checkState();
/*      */     try
/*      */     {
/* 1059 */       return this.resultSet.getWarnings();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1063 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void insertRow()
/*      */     throws SQLException
/*      */   {
/* 1069 */     checkState();
/*      */     try
/*      */     {
/* 1072 */       this.resultSet.insertRow();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1076 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isAfterLast() throws SQLException
/*      */   {
/* 1082 */     checkState();
/*      */     try
/*      */     {
/* 1085 */       return this.resultSet.isAfterLast();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1089 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean isBeforeFirst()
/*      */     throws SQLException
/*      */   {
/* 1095 */     checkState();
/*      */     try
/*      */     {
/* 1098 */       return this.resultSet.isBeforeFirst();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1102 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean isFirst()
/*      */     throws SQLException
/*      */   {
/* 1108 */     checkState();
/*      */     try
/*      */     {
/* 1111 */       return this.resultSet.isFirst();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1115 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean isLast()
/*      */     throws SQLException
/*      */   {
/* 1121 */     checkState();
/*      */     try
/*      */     {
/* 1124 */       return this.resultSet.isLast();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1128 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean last()
/*      */     throws SQLException
/*      */   {
/* 1134 */     checkState();
/*      */     try
/*      */     {
/* 1137 */       return this.resultSet.last();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1141 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void moveToCurrentRow()
/*      */     throws SQLException
/*      */   {
/* 1147 */     checkState();
/*      */     try
/*      */     {
/* 1150 */       this.resultSet.moveToCurrentRow();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1154 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void moveToInsertRow() throws SQLException
/*      */   {
/* 1160 */     checkState();
/*      */     try
/*      */     {
/* 1163 */       this.resultSet.moveToInsertRow();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1167 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean next() throws SQLException
/*      */   {
/* 1173 */     checkState();
/*      */     try
/*      */     {
/* 1176 */       return this.resultSet.next();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1180 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean previous()
/*      */     throws SQLException
/*      */   {
/* 1186 */     checkState();
/*      */     try
/*      */     {
/* 1189 */       return this.resultSet.previous();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1193 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void refreshRow()
/*      */     throws SQLException
/*      */   {
/* 1199 */     checkState();
/*      */     try
/*      */     {
/* 1202 */       this.resultSet.refreshRow();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1206 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean relative(int rows) throws SQLException
/*      */   {
/* 1212 */     checkState();
/*      */     try
/*      */     {
/* 1215 */       return this.resultSet.relative(rows);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1219 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean rowDeleted()
/*      */     throws SQLException
/*      */   {
/* 1225 */     checkState();
/*      */     try
/*      */     {
/* 1228 */       return this.resultSet.rowDeleted();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1232 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean rowInserted()
/*      */     throws SQLException
/*      */   {
/* 1238 */     checkState();
/*      */     try
/*      */     {
/* 1241 */       return this.resultSet.rowInserted();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1245 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public boolean rowUpdated()
/*      */     throws SQLException
/*      */   {
/* 1251 */     checkState();
/*      */     try
/*      */     {
/* 1254 */       return this.resultSet.rowUpdated();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1258 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   public void setFetchDirection(int direction)
/*      */     throws SQLException
/*      */   {
/* 1264 */     checkState();
/*      */     try
/*      */     {
/* 1267 */       this.resultSet.setFetchDirection(direction);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1271 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFetchSize(int rows) throws SQLException
/*      */   {
/* 1277 */     checkState();
/*      */     try
/*      */     {
/* 1280 */       this.resultSet.setFetchSize(rows);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1284 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateArray(int columnIndex, Array x) throws SQLException
/*      */   {
/* 1290 */     checkState();
/*      */     try
/*      */     {
/* 1293 */       this.resultSet.updateArray(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1297 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateArray(String columnName, Array x) throws SQLException
/*      */   {
/* 1303 */     checkState();
/*      */     try
/*      */     {
/* 1306 */       this.resultSet.updateArray(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1310 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException
/*      */   {
/* 1316 */     checkState();
/*      */     try
/*      */     {
/* 1319 */       this.resultSet.updateAsciiStream(columnIndex, x, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1323 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException
/*      */   {
/* 1329 */     checkState();
/*      */     try
/*      */     {
/* 1332 */       this.resultSet.updateAsciiStream(columnName, x, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1336 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException
/*      */   {
/* 1342 */     checkState();
/*      */     try
/*      */     {
/* 1345 */       this.resultSet.updateBigDecimal(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1349 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException
/*      */   {
/* 1355 */     checkState();
/*      */     try
/*      */     {
/* 1358 */       this.resultSet.updateBigDecimal(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1362 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException
/*      */   {
/* 1368 */     checkState();
/*      */     try
/*      */     {
/* 1371 */       this.resultSet.updateBinaryStream(columnIndex, x, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1375 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException
/*      */   {
/* 1381 */     checkState();
/*      */     try
/*      */     {
/* 1384 */       this.resultSet.updateBinaryStream(columnName, x, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1388 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBlob(int columnIndex, Blob x) throws SQLException
/*      */   {
/* 1394 */     checkState();
/*      */     try
/*      */     {
/* 1397 */       this.resultSet.updateBlob(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1401 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBlob(String columnName, Blob x) throws SQLException
/*      */   {
/* 1407 */     checkState();
/*      */     try
/*      */     {
/* 1410 */       this.resultSet.updateBlob(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1414 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBoolean(int columnIndex, boolean x) throws SQLException
/*      */   {
/* 1420 */     checkState();
/*      */     try
/*      */     {
/* 1423 */       this.resultSet.updateBoolean(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1427 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBoolean(String columnName, boolean x) throws SQLException
/*      */   {
/* 1433 */     checkState();
/*      */     try
/*      */     {
/* 1436 */       this.resultSet.updateBoolean(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1440 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateByte(int columnIndex, byte x) throws SQLException
/*      */   {
/* 1446 */     checkState();
/*      */     try
/*      */     {
/* 1449 */       this.resultSet.updateByte(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1453 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateByte(String columnName, byte x) throws SQLException
/*      */   {
/* 1459 */     checkState();
/*      */     try
/*      */     {
/* 1462 */       this.resultSet.updateByte(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1466 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBytes(int columnIndex, byte[] x) throws SQLException
/*      */   {
/* 1472 */     checkState();
/*      */     try
/*      */     {
/* 1475 */       this.resultSet.updateBytes(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1479 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateBytes(String columnName, byte[] x) throws SQLException
/*      */   {
/* 1485 */     checkState();
/*      */     try
/*      */     {
/* 1488 */       this.resultSet.updateBytes(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1492 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException
/*      */   {
/* 1498 */     checkState();
/*      */     try
/*      */     {
/* 1501 */       this.resultSet.updateCharacterStream(columnIndex, x, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1505 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException
/*      */   {
/* 1511 */     checkState();
/*      */     try
/*      */     {
/* 1514 */       this.resultSet.updateCharacterStream(columnName, reader, length);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1518 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateClob(int columnIndex, Clob x) throws SQLException
/*      */   {
/* 1524 */     checkState();
/*      */     try
/*      */     {
/* 1527 */       this.resultSet.updateClob(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1531 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateClob(String columnName, Clob x) throws SQLException
/*      */   {
/* 1537 */     checkState();
/*      */     try
/*      */     {
/* 1540 */       this.resultSet.updateClob(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1544 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateDate(int columnIndex, Date x) throws SQLException
/*      */   {
/* 1550 */     checkState();
/*      */     try
/*      */     {
/* 1553 */       this.resultSet.updateDate(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1557 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateDate(String columnName, Date x) throws SQLException
/*      */   {
/* 1563 */     checkState();
/*      */     try
/*      */     {
/* 1566 */       this.resultSet.updateDate(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1570 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateDouble(int columnIndex, double x) throws SQLException
/*      */   {
/* 1576 */     checkState();
/*      */     try
/*      */     {
/* 1579 */       this.resultSet.updateDouble(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1583 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateDouble(String columnName, double x) throws SQLException
/*      */   {
/* 1589 */     checkState();
/*      */     try
/*      */     {
/* 1592 */       this.resultSet.updateDouble(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1596 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateFloat(int columnIndex, float x) throws SQLException
/*      */   {
/* 1602 */     checkState();
/*      */     try
/*      */     {
/* 1605 */       this.resultSet.updateFloat(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1609 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateFloat(String columnName, float x) throws SQLException
/*      */   {
/* 1615 */     checkState();
/*      */     try
/*      */     {
/* 1618 */       this.resultSet.updateFloat(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1622 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateInt(int columnIndex, int x) throws SQLException
/*      */   {
/* 1628 */     checkState();
/*      */     try
/*      */     {
/* 1631 */       this.resultSet.updateInt(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1635 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateInt(String columnName, int x) throws SQLException
/*      */   {
/* 1641 */     checkState();
/*      */     try
/*      */     {
/* 1644 */       this.resultSet.updateInt(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1648 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateLong(int columnIndex, long x) throws SQLException
/*      */   {
/* 1654 */     checkState();
/*      */     try
/*      */     {
/* 1657 */       this.resultSet.updateLong(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1661 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateLong(String columnName, long x) throws SQLException
/*      */   {
/* 1667 */     checkState();
/*      */     try
/*      */     {
/* 1670 */       this.resultSet.updateLong(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1674 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateNull(int columnIndex) throws SQLException
/*      */   {
/* 1680 */     checkState();
/*      */     try
/*      */     {
/* 1683 */       this.resultSet.updateNull(columnIndex);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1687 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateNull(String columnName) throws SQLException
/*      */   {
/* 1693 */     checkState();
/*      */     try
/*      */     {
/* 1696 */       this.resultSet.updateNull(columnName);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1700 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateObject(int columnIndex, Object x) throws SQLException
/*      */   {
/* 1706 */     checkState();
/*      */     try
/*      */     {
/* 1709 */       this.resultSet.updateObject(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1713 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateObject(int columnIndex, Object x, int scale) throws SQLException
/*      */   {
/* 1719 */     checkState();
/*      */     try
/*      */     {
/* 1722 */       this.resultSet.updateObject(columnIndex, x, scale);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1726 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateObject(String columnName, Object x) throws SQLException
/*      */   {
/* 1732 */     checkState();
/*      */     try
/*      */     {
/* 1735 */       this.resultSet.updateObject(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1739 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateObject(String columnName, Object x, int scale) throws SQLException
/*      */   {
/* 1745 */     checkState();
/*      */     try
/*      */     {
/* 1748 */       this.resultSet.updateObject(columnName, x, scale);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1752 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateRef(int columnIndex, Ref x) throws SQLException
/*      */   {
/* 1758 */     checkState();
/*      */     try
/*      */     {
/* 1761 */       this.resultSet.updateRef(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1765 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateRef(String columnName, Ref x) throws SQLException
/*      */   {
/* 1771 */     checkState();
/*      */     try
/*      */     {
/* 1774 */       this.resultSet.updateRef(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1778 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateRow() throws SQLException
/*      */   {
/* 1784 */     checkState();
/*      */     try
/*      */     {
/* 1787 */       this.resultSet.updateRow();
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1791 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateShort(int columnIndex, short x) throws SQLException
/*      */   {
/* 1797 */     checkState();
/*      */     try
/*      */     {
/* 1800 */       this.resultSet.updateShort(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1804 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateShort(String columnName, short x) throws SQLException
/*      */   {
/* 1810 */     checkState();
/*      */     try
/*      */     {
/* 1813 */       this.resultSet.updateShort(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1817 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateString(int columnIndex, String x) throws SQLException
/*      */   {
/* 1823 */     checkState();
/*      */     try
/*      */     {
/* 1826 */       this.resultSet.updateString(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1830 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateString(String columnName, String x) throws SQLException
/*      */   {
/* 1836 */     checkState();
/*      */     try
/*      */     {
/* 1839 */       this.resultSet.updateString(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1843 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateTime(int columnIndex, Time x) throws SQLException
/*      */   {
/* 1849 */     checkState();
/*      */     try
/*      */     {
/* 1852 */       this.resultSet.updateTime(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1856 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateTime(String columnName, Time x) throws SQLException
/*      */   {
/* 1862 */     checkState();
/*      */     try
/*      */     {
/* 1865 */       this.resultSet.updateTime(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1869 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException
/*      */   {
/* 1875 */     checkState();
/*      */     try
/*      */     {
/* 1878 */       this.resultSet.updateTimestamp(columnIndex, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1882 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void updateTimestamp(String columnName, Timestamp x) throws SQLException
/*      */   {
/* 1888 */     checkState();
/*      */     try
/*      */     {
/* 1891 */       this.resultSet.updateTimestamp(columnName, x);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1895 */       throw checkException(t);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean wasNull() throws SQLException
/*      */   {
/* 1901 */     checkState();
/*      */     try
/*      */     {
/* 1904 */       return this.resultSet.wasNull();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/* 1908 */     throw checkException(t);
/*      */   }
/*      */ 
/*      */   protected ResultSet getWrappedObject()
/*      */     throws SQLException
/*      */   {
/* 1914 */     return this.resultSet;
/*      */   }
/*      */ 
/*      */   protected SQLException checkException(Throwable t) throws SQLException
/*      */   {
/* 1919 */     throw this.statement.checkException(t);
/*      */   }
/*      */ 
/*      */   void internalClose() throws SQLException
/*      */   {
/* 1924 */     synchronized (this.lock)
/*      */     {
/* 1926 */       this.closed = true;
/*      */     }
/* 1928 */     this.resultSet.close();
/*      */   }
/*      */ 
/*      */   void checkState() throws SQLException
/*      */   {
/* 1933 */     synchronized (this.lock)
/*      */     {
/* 1935 */       if (this.closed)
/* 1936 */         throw new SQLException("The result set is closed.");
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.WrappedResultSet
 * JD-Core Version:    0.6.0
 */