/*     */ package org.jboss.resource.adapter.jdbc;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.LRUCachePolicy;
/*     */ import org.jboss.util.LRUCachePolicy.LRUCacheEntry;
/*     */ 
/*     */ public class PreparedStatementCache extends LRUCachePolicy
/*     */ {
/*  40 */   private final Logger log = Logger.getLogger(getClass());
/*     */ 
/*     */   public PreparedStatementCache(int max)
/*     */   {
/* 134 */     super(2, max);
/* 135 */     create();
/*     */   }
/*     */ 
/*     */   protected void ageOut(LRUCachePolicy.LRUCacheEntry entry)
/*     */   {
/*     */     try
/*     */     {
/* 142 */       CachedPreparedStatement ws = (CachedPreparedStatement)entry.m_object;
/* 143 */       ws.agedOut();
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 147 */       this.log.debug("Failed closing cached statement", e);
/*     */     }
/*     */     finally
/*     */     {
/* 151 */       super.ageOut(entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Key
/*     */   {
/*     */     public static final int PREPARED_STATEMENT = 1;
/*     */     public static final int CALLABLE_STATEMENT = 2;
/*     */     private final String sql;
/*     */     private final int type;
/*     */     private final int resultSetType;
/*     */     private final int resultSetConcurrency;
/*     */ 
/*     */     public Key(String sql, int type, int resultSetType, int resultSetConcurrency)
/*     */     {
/*  53 */       this.sql = sql;
/*  54 */       this.type = type;
/*  55 */       this.resultSetType = resultSetType;
/*  56 */       this.resultSetConcurrency = resultSetConcurrency;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/*  61 */       if (this == o) return true;
/*  62 */       if ((o == null) || (!(o instanceof Key))) return false;
/*     */ 
/*  64 */       Key key = (Key)o;
/*     */ 
/*  66 */       if (this.resultSetConcurrency != key.resultSetConcurrency) return false;
/*  67 */       if (this.resultSetType != key.resultSetType) return false;
/*  68 */       if (this.type != key.type) return false;
/*  69 */       return this.sql != null ? this.sql.equals(key.sql) : key.sql == null;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/*  76 */       int result = this.sql != null ? this.sql.hashCode() : 0;
/*  77 */       result = 29 * result + this.type;
/*  78 */       result = 29 * result + this.resultSetType;
/*  79 */       result = 29 * result + this.resultSetConcurrency;
/*  80 */       return result;
/*     */     }
/*     */ 
/*     */     public String toString() {
/*  84 */       StringBuffer tmp = new StringBuffer(super.toString());
/*  85 */       tmp.append('[');
/*  86 */       tmp.append("sql=");
/*  87 */       tmp.append(this.sql);
/*  88 */       tmp.append(" type=");
/*  89 */       tmp.append(this.type == 1 ? "PS" : "CS");
/*  90 */       tmp.append(" resultSetType=");
/*  91 */       switch (this.resultSetType)
/*     */       {
/*     */       case 1003:
/*  95 */         tmp.append("TYPE_FORWARD_ONLY");
/*  96 */         break;
/*     */       case 1004:
/* 100 */         tmp.append("TYPE_SCROLL_INSENSITIVE");
/* 101 */         break;
/*     */       case 1005:
/* 105 */         tmp.append("TYPE_SCROLL_SENSITIVE");
/* 106 */         break;
/*     */       default:
/* 109 */         tmp.append(this.resultSetType);
/*     */       }
/* 111 */       tmp.append(" resultSetConcurrency=");
/* 112 */       switch (this.resultSetConcurrency)
/*     */       {
/*     */       case 1007:
/* 116 */         tmp.append("CONCUR_READ_ONLY");
/* 117 */         break;
/*     */       case 1008:
/* 121 */         tmp.append("CONCUR_UPDATABLE");
/* 122 */         break;
/*     */       default:
/* 125 */         tmp.append(this.resultSetConcurrency);
/*     */       }
/* 127 */       tmp.append(']');
/* 128 */       return tmp.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.PreparedStatementCache
 * JD-Core Version:    0.6.0
 */