/*    */ package org.jboss.resource.adapter.jdbc;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.sql.SQLException;
/*    */ 
/*    */ public class JBossWrapper
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -4018404397552543628L;
/*    */ 
/*    */   public boolean isWrapperFor(Class<?> iface)
/*    */     throws SQLException
/*    */   {
/* 40 */     if (iface == null)
/* 41 */       throw new IllegalArgumentException("Null interface");
/* 42 */     Object wrapped = getWrappedObject();
/* 43 */     if (wrapped == null)
/* 44 */       return false;
/* 45 */     return iface.isAssignableFrom(wrapped.getClass());
/*    */   }
/*    */ 
/*    */   public <T> T unwrap(Class<T> iface) throws SQLException
/*    */   {
/* 50 */     if (iface == null)
/* 51 */       throw new IllegalArgumentException("Null interface");
/* 52 */     Object wrapped = getWrappedObject();
/* 53 */     if ((wrapped != null) && (iface.isAssignableFrom(wrapped.getClass())))
/* 54 */       return iface.cast(wrapped);
/* 55 */     throw new SQLException("Not a wrapper for: " + iface.getName());
/*    */   }
/*    */ 
/*    */   protected Object getWrappedObject() throws SQLException
/*    */   {
/* 60 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.resource.adapter.jdbc.JBossWrapper
 * JD-Core Version:    0.6.0
 */