/*    */ package org.jboss.remoting.util.socket;
/*    */ 
/*    */ import javax.net.ssl.HandshakeCompletedEvent;
/*    */ import javax.net.ssl.HandshakeCompletedListener;
/*    */ import javax.net.ssl.SSLException;
/*    */ 
/*    */ public class HandshakeRepeater
/*    */   implements HandshakeCompletedListener
/*    */ {
/* 33 */   private HandshakeCompletedListener targetListener = null;
/* 34 */   private boolean handshakeCompleted = false;
/*    */ 
/*    */   public HandshakeRepeater(HandshakeCompletedListener listener)
/*    */   {
/* 38 */     this.targetListener = listener;
/*    */   }
/*    */ 
/*    */   public void waitForHandshake() throws SSLException
/*    */   {
/* 43 */     for (int x = 0; x < 120; x++)
/*    */     {
/* 45 */       if (this.handshakeCompleted)
/*    */       {
/*    */         break;
/*    */       }
/*    */ 
/*    */       try
/*    */       {
/* 53 */         Thread.sleep(500L);
/*    */       }
/*    */       catch (InterruptedException e)
/*    */       {
/*    */       }
/*    */     }
/*    */ 
/* 60 */     if (!this.handshakeCompleted)
/*    */     {
/* 62 */       throw new SSLException("Handshaked failed to complete in 60 seconds");
/*    */     }
/*    */   }
/*    */ 
/*    */   public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent)
/*    */   {
/* 68 */     if (this.targetListener != null)
/*    */     {
/* 70 */       this.targetListener.handshakeCompleted(handshakeCompletedEvent);
/*    */     }
/* 72 */     this.handshakeCompleted = true;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.util.socket.HandshakeRepeater
 * JD-Core Version:    0.6.0
 */