/*     */ package org.jboss.remoting.transport.sslrmi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.Socket;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.HandshakeCompletedListener;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.AbstractInvoker;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
/*     */ import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory.ComparableHolder;
/*     */ import org.jboss.remoting.util.socket.HandshakeRepeater;
/*     */ 
/*     */ public class SerializableSSLClientSocketFactory extends RemotingRMIClientSocketFactory
/*     */ {
/*     */   private static final long serialVersionUID = 3242156275483606618L;
/*  53 */   private static Logger log = Logger.getLogger(SerializableSSLClientSocketFactory.class);
/*     */ 
/*     */   public SerializableSSLClientSocketFactory(InvokerLocator invokerLocator, int timeout, Map configuration)
/*     */   {
/*  60 */     super(invokerLocator, invokerLocator.getHost(), timeout, configuration);
/*  61 */     this.invokerLocator = invokerLocator;
/*  62 */     this.configuration = new HashMap(configuration);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException
/*     */   {
/*  68 */     Socket s = super.createSocket(host, port);
/*     */ 
/*  71 */     Object obj = this.configuration.get("handshakeCompletedListener");
/*  72 */     if ((obj != null) && ((obj instanceof HandshakeCompletedListener)))
/*     */     {
/*  74 */       SSLSocket sslSocket = (SSLSocket)s;
/*  75 */       HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
/*  76 */       establishHandshake(sslSocket, listener);
/*     */     }
/*     */ 
/*  79 */     return s;
/*     */   }
/*     */ 
/*     */   public SocketFactory retrieveSocketFactory(RemotingRMIClientSocketFactory.ComparableHolder holder)
/*     */     throws IOException
/*     */   {
/*  85 */     SocketFactory sf = (SocketFactory)socketFactories.get(this);
/*  86 */     if (sf == null)
/*     */     {
/*     */       try
/*     */       {
/*  93 */         Map tempConfig = new HashMap(this.configuration);
/*  94 */         Map localConfig = (Map)configMaps.get(holder);
/*  95 */         if (localConfig != null) {
/*  96 */           tempConfig.putAll(localConfig);
/*     */         }
/*  98 */         if (tempConfig.containsKey("customSocketFactory"))
/*     */         {
/* 100 */           sf = (SocketFactory)tempConfig.get("customSocketFactory");
/*     */         }
/*     */         else
/*     */         {
/* 104 */           SSLSocketBuilder socketBuilder = new SSLSocketBuilder(tempConfig);
/* 105 */           socketBuilder.setUseSSLSocketFactory(false);
/* 106 */           sf = socketBuilder.createSSLSocketFactory();
/* 107 */           sf = AbstractInvoker.wrapSocketFactory(sf, tempConfig);
/*     */         }
/*     */ 
/* 110 */         socketFactories.put(this, sf);
/*     */ 
/* 116 */         if (localConfig != null)
/*     */         {
/* 118 */           Object obj = localConfig.get("handshakeCompletedListener");
/* 119 */           if (obj != null)
/* 120 */             this.configuration.put("handshakeCompletedListener", obj);
/*     */         }
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 125 */         log.error(e);
/* 126 */         throw new RuntimeException("Unable to create customized SSL socket factory", e);
/*     */       }
/*     */     }
/*     */ 
/* 130 */     return sf;
/*     */   }
/*     */ 
/*     */   private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener)
/*     */     throws IOException
/*     */   {
/* 137 */     HandshakeRepeater repeater = new HandshakeRepeater(listener);
/* 138 */     sslSocket.addHandshakeCompletedListener(repeater);
/* 139 */     sslSocket.getSession();
/* 140 */     repeater.waitForHandshake();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslrmi.SerializableSSLClientSocketFactory
 * JD-Core Version:    0.6.0
 */