/*     */ package org.jboss.remoting.transport.sslrmi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.transport.rmi.RMIServerInvoker;
/*     */ 
/*     */ public class SSLRMIServerInvoker extends RMIServerInvoker
/*     */ {
/*     */   public SSLRMIServerInvoker(InvokerLocator locator)
/*     */   {
/*  49 */     super(locator);
/*     */   }
/*     */ 
/*     */   public SSLRMIServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  55 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected RMIClientSocketFactory getRMIClientSocketFactory(String ignored)
/*     */   {
/*  61 */     HashMap remoteConfig = new HashMap(this.configuration);
/*  62 */     remoteConfig.remove("org.jboss.remoting.keyAlias");
/*  63 */     remoteConfig.remove("org.jboss.remoting.keyPassword");
/*  64 */     remoteConfig.remove("org.jboss.remoting.keyStoreAlgorithm");
/*  65 */     remoteConfig.remove("org.jboss.remoting.keyStore");
/*  66 */     remoteConfig.remove("org.jboss.remoting.keyStorePassword");
/*  67 */     remoteConfig.remove("org.jboss.remoting.keyStoreType");
/*  68 */     remoteConfig.remove("org.jboss.remoting.trustStoreAlgorithm");
/*  69 */     remoteConfig.remove("org.jboss.remoting.trustStore");
/*  70 */     remoteConfig.remove("org.jboss.remoting.trustStorePassword");
/*  71 */     remoteConfig.remove("org.jboss.remoting.trustStoreType");
/*     */ 
/*  74 */     remoteConfig.remove("customServerSocketFactory");
/*     */ 
/*  77 */     remoteConfig.remove("socketCreationClientListener");
/*  78 */     remoteConfig.remove("socketCreationServerListener");
/*     */ 
/*  82 */     String serverSocketUseClientModeString = (String)this.configuration.get("org.jboss.remoting.serversocket.useClientMode");
/*     */ 
/*  84 */     if (serverSocketUseClientModeString != null)
/*     */     {
/*  86 */       boolean serverSocketUseClientMode = Boolean.valueOf(serverSocketUseClientModeString).booleanValue();
/*  87 */       if (serverSocketUseClientMode)
/*     */       {
/*  89 */         String socketUseClientModeString = (String)this.configuration.get("org.jboss.remoting.socket.useClientMode");
/*     */ 
/*  91 */         if (socketUseClientModeString == null)
/*     */         {
/*  93 */           remoteConfig.put("org.jboss.remoting.socket.useClientMode", "false");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  98 */     return new SerializableSSLClientSocketFactory(this.locator, getTimeout(), remoteConfig);
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*     */     throws IOException
/*     */   {
/* 104 */     SSLSocketBuilder builder = new SSLSocketBuilder(this.configuration);
/* 105 */     builder.setUseSSLServerSocketFactory(false);
/* 106 */     return builder.createSSLServerSocketFactory();
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/* 112 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslrmi.SSLRMIServerInvoker
 * JD-Core Version:    0.6.0
 */