/*     */ package org.jboss.remoting.transport.sslmultiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
/*     */ import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualSocket;
/*     */ 
/*     */ public class SSLMultiplexClientInvoker extends MultiplexClientInvoker
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(SSLMultiplexClientInvoker.class);
/*  56 */   private static final boolean isTraceEnabled = log.isTraceEnabled();
/*     */ 
/*     */   public SSLMultiplexClientInvoker(InvokerLocator locator)
/*     */     throws IOException
/*     */   {
/*  61 */     super(locator);
/*     */   }
/*     */ 
/*     */   public SSLMultiplexClientInvoker(InvokerLocator locator, Map configuration)
/*     */     throws IOException
/*     */   {
/*  72 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/*  81 */     SocketFactory sf = super.createSocketFactory(configuration);
/*     */ 
/*  83 */     if (isCompleteSocketFactory(sf))
/*     */     {
/*  85 */       this.socketFactory = sf;
/*  86 */       return sf;
/*     */     }
/*     */ 
/*  89 */     SocketFactory wrapper = sf;
/*     */     try
/*     */     {
/*  93 */       SSLSocketBuilder server = new SSLSocketBuilder(configuration);
/*  94 */       server.setUseSSLSocketFactory(false);
/*  95 */       sf = server.createSSLSocketFactory();
/*  96 */       this.configuration.put("multiplex.SocketFactory", sf);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 100 */       log.error("Error creating SSL Socket Factory for client invoker.", e);
/*     */     }
/*     */ 
/* 103 */     if (wrapper != null)
/*     */     {
/* 105 */       ((SocketFactoryWrapper)wrapper).setSocketFactory(sf);
/* 106 */       this.socketFactory = wrapper;
/* 107 */       return wrapper;
/*     */     }
/*     */ 
/* 110 */     this.socketFactory = sf;
/* 111 */     return sf;
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(String address, int port, int timeout)
/*     */     throws IOException
/*     */   {
/* 117 */     SocketFactory sf = getSocketFactory();
/* 118 */     if (sf == null) {
/* 119 */       createSocketFactory(this.configuration);
/*     */     }
/* 121 */     VirtualSocket socket = new VirtualSocket(this.configuration);
/* 122 */     socket.connect(getConnectSocketAddress(), getBindSocketAddress(), this.timeout);
/* 123 */     return socket;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.sslmultiplex.SSLMultiplexClientInvoker
 * JD-Core Version:    0.6.0
 */