/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.TimerTask;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.ssl.SSLException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.ServerInvoker.InvalidStateException;
/*     */ import org.jboss.remoting.util.TimerUtil;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class SocketServerInvoker extends ServerInvoker
/*     */   implements Runnable, SocketServerInvokerMBean
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(SocketServerInvoker.class);
/*     */ 
/*  59 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*  61 */   static int clientCount = 0;
/*     */ 
/*  63 */   private Properties props = new Properties();
/*     */ 
/*  65 */   private static int BACKLOG_DEFAULT = 200;
/*  66 */   protected static int MAX_POOL_SIZE_DEFAULT = 300;
/*     */   public static final String CHECK_CONNECTION_KEY = "socket.check_connection";
/*     */   public static final String SERVER_SOCKET_CLASS_FLAG = "serverSocketClass";
/*  79 */   protected String serverSocketClass = ServerSocketWrapper.class.getName();
/*     */ 
/*  81 */   protected ServerSocket serverSocket = null;
/*  82 */   protected boolean running = false;
/*  83 */   protected int backlog = BACKLOG_DEFAULT;
/*     */   protected Thread[] acceptThreads;
/*  85 */   protected int numAcceptThreads = 1;
/*  86 */   protected int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
/*     */   protected LRUPool clientpool;
/*     */   protected LinkedList threadpool;
/*  90 */   protected boolean newServerSocketFactory = false;
/*  91 */   protected Object serverSocketFactoryLock = new Object();
/*     */ 
/*  93 */   protected boolean reuseAddress = true;
/*     */ 
/*  96 */   protected int idleTimeout = -1;
/*  97 */   protected IdleTimerTask idleTimerTask = null;
/*     */ 
/*     */   public SocketServerInvoker(InvokerLocator locator)
/*     */   {
/* 101 */     super(locator);
/*     */   }
/*     */ 
/*     */   public SocketServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 106 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   public void setNewServerSocketFactory(ServerSocketFactory serverSocketFactory)
/*     */   {
/* 117 */     log.trace("entering setNewServerSocketFactory()");
/* 118 */     synchronized (this.serverSocketFactoryLock)
/*     */     {
/* 120 */       this.newServerSocketFactory = true;
/* 121 */       setServerSocketFactory(serverSocketFactory);
/* 122 */       this.serverSocketFactoryLock.notify();
/* 123 */       log.info("ServerSocketFactory has been updated");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void refreshServerSocket()
/*     */     throws IOException
/*     */   {
/* 134 */     log.trace("entering refreshServerSocket()");
/* 135 */     synchronized (this.serverSocketFactoryLock)
/*     */     {
/* 139 */       this.newServerSocketFactory = false;
/* 140 */       ServerSocket oldServerSocket = this.serverSocket;
/* 141 */       this.serverSocket = null;
/* 142 */       oldServerSocket.close();
/* 143 */       InetAddress bindAddress = InetAddress.getByName(getServerBindAddress());
/* 144 */       ServerSocket newServerSocket = createServerSocket(getServerBindPort(), this.backlog, bindAddress);
/* 145 */       newServerSocket.setReuseAddress(this.reuseAddress);
/* 146 */       this.serverSocket = newServerSocket;
/* 147 */       log.info("ServerSocket has been updated");
/*     */     }
/* 149 */     log.trace("leavinging refreshServerSocket()");
/*     */   }
/*     */ 
/*     */   protected void setup() throws Exception
/*     */   {
/* 154 */     this.props.putAll(getConfiguration());
/* 155 */     PropertyEditors.mapJavaBeanProperties(this, this.props, false);
/*     */ 
/* 157 */     super.setup();
/*     */ 
/* 159 */     String ssclass = this.props.getProperty("serverSocketClass");
/* 160 */     if (ssclass != null)
/*     */     {
/* 162 */       this.serverSocketClass = ssclass;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void finalize() throws Throwable
/*     */   {
/* 168 */     stop();
/* 169 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public synchronized void start()
/*     */     throws IOException
/*     */   {
/* 180 */     if (!this.running)
/*     */     {
/* 182 */       log.debug(this + " starting");
/*     */ 
/* 184 */       InetAddress bindAddress = InetAddress.getByName(getServerBindAddress());
/*     */ 
/* 186 */       if (this.maxPoolSize <= 0)
/*     */       {
/* 189 */         this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
/*     */       }
/*     */       try
/*     */       {
/* 193 */         this.serverSocket = createServerSocket(getServerBindPort(), this.backlog, bindAddress);
/* 194 */         this.serverSocket.setReuseAddress(this.reuseAddress);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 198 */         log.error("Error starting ServerSocket.  Bind port: " + getServerBindPort() + ", bind address: " + bindAddress);
/*     */ 
/* 200 */         throw e;
/*     */       }
/*     */ 
/* 203 */       this.clientpool = new LRUPool(2, this.maxPoolSize);
/* 204 */       this.clientpool.create();
/* 205 */       this.threadpool = new LinkedList();
/*     */ 
/* 207 */       this.acceptThreads = new Thread[this.numAcceptThreads];
/*     */ 
/* 209 */       for (int i = 0; i < this.numAcceptThreads; i++)
/*     */       {
/* 211 */         if (trace) log.trace(this + " creating another AcceptThread");
/*     */ 
/* 213 */         String name = getThreadName(i);
/* 214 */         this.acceptThreads[i] = new Thread(this, name);
/*     */ 
/* 216 */         if (!trace) continue; log.trace(this + " created and registered " + this.acceptThreads[i]);
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 222 */       super.start();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 226 */       log.error("Error starting SocketServerInvoker.", e);
/* 227 */       cleanup();
/*     */     }
/* 229 */     if (!this.running)
/*     */     {
/* 231 */       this.running = true;
/*     */ 
/* 233 */       for (int i = 0; i < this.numAcceptThreads; i++)
/*     */       {
/* 235 */         this.acceptThreads[i].start();
/*     */       }
/*     */     }
/*     */ 
/* 239 */     if (this.idleTimeout > 0)
/*     */     {
/* 241 */       if (this.idleTimerTask != null)
/*     */       {
/* 243 */         this.idleTimerTask.cancel();
/*     */       }
/* 245 */       this.idleTimerTask = new IdleTimerTask();
/* 246 */       TimerUtil.schedule(this.idleTimerTask, this.idleTimeout * 1000);
/*     */     }
/* 250 */     else if (this.idleTimerTask != null)
/*     */     {
/* 252 */       this.idleTimerTask.cancel();
/*     */     }
/*     */ 
/* 256 */     log.debug(this + " started");
/*     */   }
/*     */ 
/*     */   protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress)
/*     */     throws IOException
/*     */   {
/* 264 */     return getServerSocketFactory().createServerSocket(serverBindPort, backlog, bindAddress);
/*     */   }
/*     */ 
/*     */   protected String getThreadName(int i)
/*     */   {
/* 269 */     return "AcceptorThread#" + i + ":" + getServerBindPort();
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 274 */     if (this.clientpool != null)
/*     */     {
/* 276 */       this.clientpool.destroy();
/*     */     }
/* 278 */     super.destroy();
/*     */   }
/*     */ 
/*     */   public synchronized void stop()
/*     */   {
/* 289 */     if (this.running)
/*     */     {
/* 291 */       cleanup();
/*     */     }
/* 293 */     super.stop();
/*     */   }
/*     */ 
/*     */   protected void cleanup()
/*     */   {
/* 298 */     this.running = false;
/*     */ 
/* 300 */     this.maxPoolSize = 0;
/* 301 */     if (this.acceptThreads != null)
/*     */     {
/* 303 */       for (int i = 0; i < this.acceptThreads.length; i++)
/*     */       {
/*     */         try
/*     */         {
/* 307 */           this.acceptThreads[i].interrupt();
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 317 */     if (this.clientpool != null)
/*     */     {
/* 319 */       synchronized (this.clientpool)
/*     */       {
/* 321 */         Set svrThreads = this.clientpool.getContents();
/* 322 */         Iterator itr = svrThreads.iterator();
/*     */ 
/* 324 */         while (itr.hasNext())
/*     */         {
/* 326 */           Object o = itr.next();
/* 327 */           ServerThread st = (ServerThread)o;
/* 328 */           st.shutdown();
/*     */         }
/*     */ 
/* 331 */         this.clientpool.flush();
/* 332 */         this.clientpool.stop();
/*     */ 
/* 334 */         if (this.threadpool != null)
/*     */         {
/* 336 */           synchronized (this.threadpool)
/*     */           {
/* 338 */             int threadsToShutdown = this.threadpool.size();
/* 339 */             for (int i = 0; i < threadsToShutdown; i++)
/*     */             {
/* 341 */               ServerThread thread = (ServerThread)this.threadpool.removeFirst();
/* 342 */               thread.shutdown();
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 351 */       this.serverSocket.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean getReuseAddress()
/*     */   {
/* 364 */     return this.reuseAddress;
/*     */   }
/*     */ 
/*     */   public void setReuseAddress(boolean reuse)
/*     */   {
/* 375 */     this.reuseAddress = reuse;
/*     */   }
/*     */ 
/*     */   public int getCurrentThreadPoolSize()
/*     */   {
/* 384 */     return this.threadpool.size();
/*     */   }
/*     */ 
/*     */   public int getCurrentClientPoolSize()
/*     */   {
/* 393 */     return this.clientpool.size();
/*     */   }
/*     */ 
/*     */   public int getNumAcceptThreads()
/*     */   {
/* 404 */     return this.numAcceptThreads;
/*     */   }
/*     */ 
/*     */   public void setNumAcceptThreads(int size)
/*     */   {
/* 415 */     this.numAcceptThreads = size;
/*     */   }
/*     */ 
/*     */   public int getMaxPoolSize()
/*     */   {
/* 427 */     return this.maxPoolSize;
/*     */   }
/*     */ 
/*     */   public void setMaxPoolSize(int maxPoolSize)
/*     */   {
/* 438 */     this.maxPoolSize = maxPoolSize;
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 446 */     return this.backlog;
/*     */   }
/*     */ 
/*     */   public void setBacklog(int backlog)
/*     */   {
/* 454 */     if (backlog < 0)
/*     */     {
/* 456 */       this.backlog = BACKLOG_DEFAULT;
/*     */     }
/*     */     else
/*     */     {
/* 460 */       this.backlog = backlog;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getIdleTimeout()
/*     */   {
/* 466 */     return this.idleTimeout;
/*     */   }
/*     */ 
/*     */   public void setIdleTimeout(int idleTimeout)
/*     */   {
/* 479 */     this.idleTimeout = idleTimeout;
/*     */ 
/* 481 */     if (isStarted())
/*     */     {
/* 483 */       if (idleTimeout > 0)
/*     */       {
/* 485 */         if (this.idleTimerTask != null)
/*     */         {
/* 487 */           this.idleTimerTask.cancel();
/*     */         }
/* 489 */         this.idleTimerTask = new IdleTimerTask();
/* 490 */         TimerUtil.schedule(this.idleTimerTask, idleTimeout * 1000);
/*     */       }
/* 494 */       else if (this.idleTimerTask != null)
/*     */       {
/* 496 */         this.idleTimerTask.cancel();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 504 */     if (trace) log.trace(this + " started execution of method run()");
/*     */ 
/* 506 */     ServerSocketRefresh thread = new ServerSocketRefresh();
/* 507 */     thread.setDaemon(true);
/* 508 */     thread.start();
/*     */     try
/*     */     {
/* 512 */       while (this.running)
/*     */       {
/*     */         try
/*     */         {
/* 516 */           thread.release();
/*     */ 
/* 518 */           if (trace) log.trace(this + " is going to wait on serverSocket.accept()");
/*     */ 
/* 520 */           Socket socket = this.serverSocket.accept();
/*     */ 
/* 522 */           if (trace) log.trace(this + " accepted " + socket);
/*     */ 
/* 530 */           processInvocation(socket);
/*     */         }
/*     */         catch (SSLException e)
/*     */         {
/* 534 */           log.error("SSLServerSocket error", e);
/*     */ 
/* 557 */           thread.shutdown(); return;
/*     */         }
/*     */         catch (ServerInvoker.InvalidStateException e)
/*     */         {
/* 539 */           log.error("Cannot proceed without functioning server socket.  Shutting down");
/* 540 */           stop();
/*     */         }
/*     */         catch (Throwable ex)
/*     */         {
/* 544 */           if (this.running)
/*     */           {
/* 546 */             log.error(this + " failed to handle socket", ex);
/*     */           }
/*     */           else
/*     */           {
/* 550 */             log.debug(this + " caught exception in run()", ex);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 557 */       thread.shutdown();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processInvocation(Socket socket)
/*     */     throws Exception
/*     */   {
/* 570 */     ServerThread worker = null;
/* 571 */     boolean newThread = false;
/*     */ 
/* 573 */     while (worker == null)
/*     */     {
/* 575 */       if (trace) log.trace(this + " trying to get a worker thread from threadpool for processing");
/*     */ 
/* 577 */       synchronized (this.threadpool)
/*     */       {
/* 579 */         if (this.threadpool.size() > 0)
/*     */         {
/* 581 */           worker = (ServerThread)this.threadpool.removeFirst();
/*     */ 
/* 583 */           if (trace) log.trace(this + (worker == null ? " found NO threads in threadpool" : new StringBuffer().append(" got ").append(worker).append(" from threadpool").toString()));
/*     */         }
/* 585 */         else if (trace) { log.trace(this + " has an empty threadpool");
/*     */         }
/*     */       }
/* 588 */       if (worker != null)
/*     */         continue;
/* 590 */       synchronized (this.clientpool)
/*     */       {
/* 592 */         if (this.clientpool.size() < this.maxPoolSize)
/*     */         {
/* 594 */           if (trace) log.trace(this + " creating new worker thread");
/*     */ 
/* 596 */           worker = new ServerThread(socket, this, this.clientpool, this.threadpool, getTimeout(), this.serverSocketClass);
/*     */ 
/* 599 */           if (trace) log.trace(this + " created " + worker);
/*     */ 
/* 601 */           newThread = true;
/*     */         }
/*     */ 
/* 604 */         if (worker == null)
/*     */         {
/* 606 */           if (trace) log.trace(this + " trying to evict a thread from clientpool");
/*     */ 
/* 608 */           this.clientpool.evict();
/*     */ 
/* 610 */           if (trace) log.trace(this + " waiting for a thread from clientpool");
/*     */ 
/* 612 */           this.clientpool.wait();
/*     */ 
/* 614 */           if (trace) log.trace(this + " notified of clientpool thread availability");
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 620 */     synchronized (this.clientpool)
/*     */     {
/* 622 */       this.clientpool.insert(worker, worker);
/*     */     }
/*     */ 
/* 625 */     if (newThread)
/*     */     {
/* 627 */       if (trace) log.trace(this + " starting " + worker);
/* 628 */       worker.start();
/*     */     }
/*     */     else
/*     */     {
/* 632 */       if (trace) log.trace(this + " reusing " + worker);
/* 633 */       worker.wakeup(socket, getTimeout(), this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isTransportBiDirectional()
/*     */   {
/* 644 */     return true;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 649 */     return "SocketServerInvoker[" + (this.serverSocket == null ? "UNINITIALIZED" : new StringBuffer().append(this.serverSocket.getInetAddress().getHostAddress()).append(":").append(this.serverSocket.getLocalPort()).toString()) + "]";
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/* 663 */     return "serializable";
/*     */   }
/*     */ 
/*     */   public class IdleTimerTask extends TimerTask
/*     */   {
/*     */     public IdleTimerTask()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 750 */       Object[] svrThreadArray = null;
/*     */ 
/* 752 */       synchronized (SocketServerInvoker.this.clientpool)
/*     */       {
/* 754 */         Set svrThreads = SocketServerInvoker.this.clientpool.getContents();
/* 755 */         svrThreadArray = svrThreads.toArray();
/*     */       }
/* 757 */       if (SocketServerInvoker.trace)
/*     */       {
/* 759 */         if (svrThreadArray != null)
/*     */         {
/* 761 */           SocketServerInvoker.log.trace("Idle timer task fired.  Number of ServerThreads = " + svrThreadArray.length);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 766 */       if (svrThreadArray != null)
/*     */       {
/* 768 */         long currentTime = System.currentTimeMillis();
/*     */ 
/* 770 */         for (int x = 0; x < svrThreadArray.length; x++)
/*     */         {
/* 772 */           ServerThread svrThread = (ServerThread)svrThreadArray[x];
/*     */ 
/* 775 */           long idleTime = currentTime - svrThread.getLastRequestTimestamp();
/*     */ 
/* 777 */           if (SocketServerInvoker.trace)
/*     */           {
/* 779 */             SocketServerInvoker.log.trace("Idle time for ServerThread (" + svrThread + ") is " + idleTime);
/*     */           }
/*     */ 
/* 782 */           long idleTimeout = SocketServerInvoker.this.getIdleTimeout() * 1000;
/* 783 */           if (idleTime <= idleTimeout)
/*     */             continue;
/* 785 */           if (SocketServerInvoker.trace)
/*     */           {
/* 787 */             SocketServerInvoker.log.trace("Idle timeout reached for ServerThread (" + svrThread + ") and will be evicted.");
/*     */           }
/* 789 */           SocketServerInvoker.this.clientpool.remove(svrThread);
/* 790 */           svrThread.shutdown();
/* 791 */           svrThread.unblock();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 797 */       svrThreadArray = null;
/* 798 */       synchronized (SocketServerInvoker.this.threadpool)
/*     */       {
/* 800 */         if (SocketServerInvoker.this.threadpool.size() > 0)
/*     */         {
/* 803 */           svrThreadArray = SocketServerInvoker.this.threadpool.toArray();
/*     */         }
/*     */       }
/*     */ 
/* 807 */       if (SocketServerInvoker.trace)
/*     */       {
/* 809 */         if (svrThreadArray != null)
/*     */         {
/* 811 */           SocketServerInvoker.log.trace("Number of ServerThread in thead pool = " + svrThreadArray.length);
/*     */         }
/*     */       }
/*     */ 
/* 815 */       if (svrThreadArray != null)
/*     */       {
/* 817 */         long currentTime = System.currentTimeMillis();
/*     */ 
/* 819 */         for (int x = 0; x < svrThreadArray.length; x++)
/*     */         {
/* 821 */           ServerThread svrThread = (ServerThread)svrThreadArray[x];
/* 822 */           long idleTime = currentTime - svrThread.getLastRequestTimestamp();
/*     */ 
/* 824 */           if (SocketServerInvoker.trace)
/*     */           {
/* 826 */             SocketServerInvoker.log.trace("Idle time for ServerThread (" + svrThread + ") is " + idleTime);
/*     */           }
/*     */ 
/* 829 */           long idleTimeout = SocketServerInvoker.this.getIdleTimeout() * 1000;
/* 830 */           if (idleTime <= idleTimeout)
/*     */             continue;
/* 832 */           if (SocketServerInvoker.trace)
/*     */           {
/* 834 */             SocketServerInvoker.log.trace("Idle timeout reached for ServerThread (" + svrThread + ") and will be removed from thread pool.");
/*     */           }
/* 836 */           SocketServerInvoker.this.threadpool.remove(svrThread);
/* 837 */           svrThread.shutdown();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public class ServerSocketRefresh extends Thread
/*     */   {
/* 674 */     private boolean running = true;
/*     */ 
/*     */     public ServerSocketRefresh()
/*     */     {
/* 678 */       super();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 683 */       while (this.running)
/*     */       {
/* 685 */         synchronized (SocketServerInvoker.this.serverSocketFactoryLock)
/*     */         {
/* 687 */           if (SocketServerInvoker.this.newServerSocketFactory)
/*     */           {
/* 689 */             SocketServerInvoker.log.debug("got notice about new ServerSocketFactory");
/*     */             try
/*     */             {
/* 692 */               SocketServerInvoker.log.debug("refreshing server socket");
/* 693 */               SocketServerInvoker.this.refreshServerSocket();
/*     */             }
/*     */             catch (IOException e) {
/* 696 */               SocketServerInvoker.log.debug("could not refresh server socket");
/* 697 */               SocketServerInvoker.log.debug("message is: " + e.getMessage());
/*     */             }
/* 699 */             SocketServerInvoker.log.debug("server socket refreshed");
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 704 */             SocketServerInvoker.this.serverSocketFactoryLock.wait();
/* 705 */             SocketServerInvoker.log.trace("ServerSocketRefresh thread woke up");
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void release()
/*     */       throws ServerInvoker.InvalidStateException
/*     */     {
/* 719 */       synchronized (SocketServerInvoker.this.serverSocketFactoryLock)
/*     */       {
/* 721 */         if (SocketServerInvoker.this.serverSocket == null)
/*     */         {
/* 723 */           throw new ServerInvoker.InvalidStateException("error refreshing ServerSocket");
/*     */         }
/* 725 */         SocketServerInvoker.log.trace("passed through ServerSocketRefresh.release()");
/*     */       }
/*     */     }
/*     */ 
/*     */     public void shutdown()
/*     */     {
/* 731 */       this.running = false;
/*     */ 
/* 733 */       synchronized (SocketServerInvoker.this.serverSocketFactoryLock)
/*     */       {
/* 735 */         SocketServerInvoker.this.serverSocketFactoryLock.notify();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.SocketServerInvoker
 * JD-Core Version:    0.6.0
 */