/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.rmi.MarshalException;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ 
/*     */ public class SocketClientInvoker extends MicroSocketClientInvoker
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(SocketClientInvoker.class);
/*  49 */   private static final boolean isTraceEnabled = log.isTraceEnabled();
/*     */   public static final String SO_TIMEOUT_FLAG = "timeout";
/*     */   public static final int SO_TIMEOUT_DEFAULT = 1800000;
/*  58 */   protected int timeout = 1800000;
/*     */ 
/*  60 */   private Constructor clientSocketConstructor = null;
/*     */ 
/*     */   public SocketClientInvoker(InvokerLocator locator)
/*     */   {
/*  67 */     this(locator, null);
/*     */   }
/*     */ 
/*     */   public SocketClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  72 */     super(locator, configuration);
/*  73 */     configureParameters();
/*     */   }
/*     */ 
/*     */   protected ServerAddress createServerAddress()
/*     */   {
/*  78 */     return new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, this.timeout, this.maxPoolSize);
/*     */   }
/*     */ 
/*     */   protected void configureParameters()
/*     */   {
/*  84 */     super.configureParameters();
/*  85 */     Map params = this.configuration;
/*  86 */     if (params != null)
/*     */     {
/*  89 */       Object val = params.get("timeout");
/*  90 */       if (val != null)
/*     */       {
/*     */         try
/*     */         {
/*  94 */           this.timeout = Integer.valueOf((String)val).intValue();
/*  95 */           log.debug(this + " setting timeout to " + this.timeout);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*  99 */           log.warn(this + " could not convert " + "timeout" + " value of " + val + " to a int value.");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object handleException(Exception ex, SocketWrapper socketWrapper)
/*     */     throws ClassNotFoundException, MarshalException
/*     */   {
/* 109 */     log.error("Got marshalling exception, exiting", ex);
/* 110 */     if ((ex instanceof ClassNotFoundException))
/*     */     {
/* 113 */       log.error("Error loading classes from remote call result.", ex);
/* 114 */       throw ((ClassNotFoundException)ex);
/*     */     }
/* 116 */     if ((ex instanceof SocketTimeoutException))
/*     */     {
/* 118 */       throw new MarshalException("Socket timed out.  Waited " + socketWrapper.getTimeout() + " milliseconds for response while calling on " + getLocator(), ex);
/*     */     }
/*     */ 
/* 122 */     throw new MarshalException("Failed to communicate.  Problem during marshalling/unmarshalling", ex);
/*     */   }
/*     */ 
/*     */   protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata)
/*     */     throws Exception
/*     */   {
/* 131 */     if (this.clientSocketConstructor == null)
/*     */     {
/* 133 */       if (this.clientSocketClass == null)
/*     */       {
/* 135 */         this.clientSocketClass = ClassLoaderUtility.loadClass(getClass(), this.clientSocketClassName);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 140 */         this.clientSocketConstructor = this.clientSocketClass.getConstructor(new Class[] { Socket.class, Map.class, Integer.class });
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 144 */         this.clientSocketConstructor = this.clientSocketClass.getConstructor(new Class[] { Socket.class });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 149 */     SocketWrapper clientSocketWrapper = null;
/* 150 */     if (this.clientSocketConstructor.getParameterTypes().length == 3)
/*     */     {
/* 152 */       clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(new Object[] { socket, metadata, new Integer(timeout) });
/*     */     }
/*     */     else
/*     */     {
/* 156 */       clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(new Object[] { socket });
/* 157 */       clientSocketWrapper.setTimeout(timeout);
/*     */     }
/*     */ 
/* 160 */     return clientSocketWrapper;
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(String address, int port, int timeout)
/*     */     throws IOException
/*     */   {
/* 166 */     Socket s = null;
/* 167 */     SocketFactory socketFactory = getSocketFactory();
/* 168 */     if (socketFactory != null)
/*     */     {
/* 170 */       s = socketFactory.createSocket();
/*     */     }
/*     */     else
/*     */     {
/* 174 */       s = new Socket();
/*     */     }
/*     */ 
/* 177 */     s.setReuseAddress(getReuseAddress());
/* 178 */     InetSocketAddress inetAddr = new InetSocketAddress(address, port);
/*     */ 
/* 180 */     if (timeout < 0)
/*     */     {
/* 182 */       timeout = getTimeout();
/* 183 */       if (timeout < 0) {
/* 184 */         timeout = 0;
/*     */       }
/*     */     }
/* 187 */     s.connect(inetAddr, timeout);
/*     */ 
/* 189 */     return s;
/*     */   }
/*     */ 
/*     */   protected SocketWrapper getPooledConnection()
/*     */   {
/* 194 */     SocketWrapper socketWrapper = null;
/* 195 */     while (this.pool.size() > 0)
/*     */     {
/* 197 */       socketWrapper = (SocketWrapper)this.pool.removeFirst();
/*     */       try
/*     */       {
/* 200 */         if (socketWrapper != null)
/*     */         {
/* 202 */           if ((socketWrapper instanceof OpenConnectionChecker))
/*     */           {
/* 204 */             ((OpenConnectionChecker)socketWrapper).checkOpenConnection();
/*     */           }
/* 206 */           if (this.shouldCheckConnection)
/*     */           {
/* 208 */             socketWrapper.checkConnection();
/* 209 */             return socketWrapper;
/*     */           }
/*     */ 
/* 213 */           if (socketWrapper.getSocket().isConnected())
/*     */           {
/* 215 */             return socketWrapper;
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 221 */             socketWrapper.close();
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/*     */           }
/* 226 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 233 */         if (isTraceEnabled)
/*     */         {
/* 235 */           log.trace("Couldn't reuse connection from pool");
/*     */         }
/*     */         try
/*     */         {
/* 239 */           socketWrapper.close();
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/* 246 */     return null;
/*     */   }
/*     */ 
/*     */   public int getTimeout()
/*     */   {
/* 257 */     return this.timeout;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 262 */     return "SocketClientInvoker[" + Integer.toHexString(System.identityHashCode(this)) + ", " + this.locator.getProtocol() + "://" + this.locator.getHost() + ":" + this.locator.getPort() + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.SocketClientInvoker
 * JD-Core Version:    0.6.0
 */