/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServerSocketWrapper extends ClientSocketWrapper
/*     */ {
/*  37 */   private static final Logger log = Logger.getLogger(ServerSocketWrapper.class);
/*     */ 
/*     */   public ServerSocketWrapper(Socket socket) throws Exception
/*     */   {
/*  41 */     super(socket);
/*     */   }
/*     */ 
/*     */   public ServerSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception
/*     */   {
/*  46 */     super(socket, metadata, timeout);
/*     */   }
/*     */ 
/*     */   public void close() throws IOException
/*     */   {
/*  51 */     if (getSocket() != null)
/*     */     {
/*     */       try
/*     */       {
/*  55 */         getOutputStream().write(254);
/*  56 */         getOutputStream().write(254);
/*  57 */         getOutputStream().flush();
/*  58 */         log.debug("wrote CLOSING");
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/*  62 */         log.debug("unable to writing CLOSING byte", e);
/*     */       }
/*     */     }
/*  65 */     super.close();
/*     */   }
/*     */ 
/*     */   public void checkConnection()
/*     */     throws IOException
/*     */   {
/*  72 */     int ACK = 0;
/*     */     try
/*     */     {
/*  77 */       ACK = getInputStream().read();
/*     */     }
/*     */     catch (EOFException eof)
/*     */     {
/*  81 */       if (log.isTraceEnabled())
/*     */       {
/*  83 */         log.trace("socket timeout is set to : " + getTimeout());
/*  84 */         log.trace("EOFException waiting on ACK in readByte().");
/*     */       }
/*     */ 
/*  87 */       throw eof;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  91 */       log.trace("IOException when reading in ACK", e);
/*  92 */       throw e;
/*     */     }
/*     */ 
/*  95 */     if (log.isTraceEnabled())
/*     */     {
/*  97 */       log.trace("***acknowledge read byte" + Thread.currentThread());
/*     */     }
/*     */ 
/* 101 */     OutputStream out = getOutputStream();
/*     */ 
/* 107 */     out.write(ACK);
/* 108 */     out.flush();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 113 */     Socket socket = getSocket();
/* 114 */     return "ServerSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.ServerSocketWrapper
 * JD-Core Version:    0.6.0
 */