/*     */ package org.jboss.remoting.transport.socket;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.Semaphore;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketException;
/*     */ import java.rmi.MarshalException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.CannotConnectException;
/*     */ import org.jboss.remoting.ConnectionFailedException;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.RemoteClientInvoker;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class MicroSocketClientInvoker extends RemoteClientInvoker
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(MicroSocketClientInvoker.class);
/*     */   public static final String TCP_NODELAY_FLAG = "enableTcpNoDelay";
/*     */   public static final String MAX_POOL_SIZE_FLAG = "clientMaxPoolSize";
/*     */   public static final String CLIENT_SOCKET_CLASS_FLAG = "clientSocketClass";
/*     */   public static final boolean TCP_NODELAY_DEFAULT = false;
/*     */   public static final int MAX_RETRIES = 30;
/*     */   public static final int MAX_CALL_RETRIES = 3;
/*     */   public static final int MAX_POOL_SIZE = 50;
/* 100 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/* 105 */   static int counter = 0;
/*     */ 
/* 107 */   protected static final Map connectionPools = new HashMap();
/*     */ 
/* 109 */   protected static final Map semaphores = new HashMap();
/*     */ 
/* 112 */   public static long getSocketTime = 0L;
/* 113 */   public static long readTime = 0L;
/* 114 */   public static long writeTime = 0L;
/* 115 */   public static long serializeTime = 0L;
/* 116 */   public static long deserializeTime = 0L;
/*     */   private Constructor clientSocketConstructor;
/*     */   private boolean reuseAddress;
/*     */   protected InetAddress addr;
/*     */   protected int port;
/*     */   private volatile boolean bailOut;
/*     */   protected boolean shouldCheckConnection;
/*     */   protected boolean enableTcpNoDelay;
/*     */   protected String clientSocketClassName;
/*     */   protected Class clientSocketClass;
/*     */   protected int numberOfRetries;
/*     */   protected int numberOfCallRetries;
/*     */   protected int maxPoolSize;
/*     */   protected LinkedList pool;
/*     */   protected Semaphore semaphore;
/*     */   protected ServerAddress address;
/*     */   public Object usedPoolLock;
/*     */ 
/*     */   public static void clearPool(LinkedList thepool)
/*     */   {
/*     */     try
/*     */     {
/* 125 */       if (thepool == null)
/*     */       {
/* 127 */         return;
/*     */       }
/* 129 */       synchronized (thepool)
/*     */       {
/* 131 */         int size = thepool.size();
/* 132 */         for (int i = 0; i < size; i++)
/*     */         {
/* 134 */           SocketWrapper socketWrapper = (SocketWrapper)thepool.removeFirst();
/*     */           try
/*     */           {
/* 137 */             socketWrapper.close();
/* 138 */             socketWrapper = null;
/*     */           }
/*     */           catch (Exception ignored)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 148 */       log.debug("Failure", ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void clearPools()
/*     */   {
/* 157 */     synchronized (connectionPools)
/*     */     {
/* 159 */       for (Iterator i = connectionPools.keySet().iterator(); i.hasNext(); )
/*     */       {
/* 161 */         ServerAddress sa = (ServerAddress)i.next();
/*     */ 
/* 163 */         if (trace) log.trace("clearing pool for " + sa);
/* 164 */         clearPool((LinkedList)connectionPools.get(sa));
/* 165 */         i.remove();
/*     */       }
/* 167 */       semaphores.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public MicroSocketClientInvoker(InvokerLocator locator)
/*     */   {
/* 223 */     this(locator, null);
/*     */   }
/*     */ 
/*     */   public MicroSocketClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 228 */     super(locator, configuration);
/*     */ 
/* 230 */     this.clientSocketConstructor = null;
/* 231 */     this.reuseAddress = true;
/* 232 */     this.shouldCheckConnection = false;
/* 233 */     this.enableTcpNoDelay = false;
/* 234 */     this.clientSocketClassName = ClientSocketWrapper.class.getName();
/* 235 */     this.clientSocketClass = null;
/* 236 */     this.numberOfRetries = 30;
/* 237 */     this.numberOfCallRetries = 3;
/* 238 */     this.pool = null;
/* 239 */     this.maxPoolSize = 50;
/*     */     try
/*     */     {
/* 245 */       setup();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 249 */       log.error("Error setting up " + this, ex);
/* 250 */       throw new RuntimeException(ex.getMessage());
/*     */     }
/*     */ 
/* 253 */     log.debug(this + " constructed");
/*     */   }
/*     */ 
/*     */   public boolean checkingConnection()
/*     */   {
/* 264 */     return this.shouldCheckConnection;
/*     */   }
/*     */ 
/*     */   public boolean getReuseAddress()
/*     */   {
/* 273 */     return this.reuseAddress;
/*     */   }
/*     */ 
/*     */   public void setReuseAddress(boolean reuse)
/*     */   {
/* 281 */     this.reuseAddress = reuse;
/*     */   }
/*     */ 
/*     */   public synchronized void disconnect()
/*     */   {
/* 286 */     log.debug(this + " disconnecting ...");
/* 287 */     this.bailOut = true;
/* 288 */     super.disconnect();
/*     */   }
/*     */ 
/*     */   public void flushConnectionPool()
/*     */   {
/* 293 */     synchronized (this.pool)
/*     */     {
/* 295 */       while ((this.pool != null) && (this.pool.size() > 0))
/*     */       {
/* 297 */         SocketWrapper socketWrapper = (SocketWrapper)this.pool.removeFirst();
/*     */         try
/*     */         {
/* 300 */           socketWrapper.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 304 */           log.debug("Failed to close socket wrapper", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setNumberOfCallRetries(int numberOfCallRetries)
/*     */   {
/* 315 */     if (numberOfCallRetries < 1)
/*     */     {
/* 317 */       this.numberOfCallRetries = 3;
/*     */     }
/*     */     else
/*     */     {
/* 321 */       this.numberOfCallRetries = numberOfCallRetries;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getNumberOfCallRetries()
/*     */   {
/* 327 */     return this.numberOfCallRetries;
/*     */   }
/*     */ 
/*     */   public void setNumberOfRetries(int numberOfRetries)
/*     */   {
/* 337 */     if (numberOfRetries < 1)
/*     */     {
/* 339 */       this.numberOfRetries = 30;
/*     */     }
/*     */     else
/*     */     {
/* 343 */       this.numberOfRetries = numberOfRetries;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getNumberOfRetries()
/*     */   {
/* 349 */     return this.numberOfRetries;
/*     */   }
/*     */ 
/*     */   public String getServerHostName()
/*     */     throws Exception
/*     */   {
/* 357 */     return this.address.address;
/*     */   }
/*     */ 
/*     */   public int getNumberOfUsedConnections()
/*     */   {
/* 362 */     if (this.semaphore == null) {
/* 363 */       return 0;
/*     */     }
/* 365 */     return this.maxPoolSize - (int)this.semaphore.permits();
/*     */   }
/*     */ 
/*     */   public int getNumberOfAvailableConnections()
/*     */   {
/* 370 */     if (this.semaphore == null) {
/* 371 */       return 0;
/*     */     }
/* 373 */     return (int)this.semaphore.permits();
/*     */   }
/*     */ 
/*     */   protected void setup()
/*     */     throws Exception
/*     */   {
/* 382 */     this.addr = InetAddress.getByName(this.locator.getHost());
/* 383 */     this.port = this.locator.getPort();
/*     */ 
/* 385 */     Properties props = new Properties();
/* 386 */     props.putAll(this.configuration);
/* 387 */     PropertyEditors.mapJavaBeanProperties(this, props, false);
/*     */ 
/* 389 */     configureParameters();
/*     */ 
/* 391 */     this.address = createServerAddress();
/*     */   }
/*     */ 
/*     */   protected void configureParameters()
/*     */   {
/* 396 */     Map params = this.configuration;
/*     */ 
/* 398 */     if (params == null)
/*     */     {
/* 400 */       return;
/*     */     }
/*     */ 
/* 404 */     Object val = params.get("enableTcpNoDelay");
/* 405 */     if (val != null)
/*     */     {
/*     */       try
/*     */       {
/* 409 */         this.enableTcpNoDelay = Boolean.valueOf((String)val).booleanValue();
/* 410 */         log.debug(this + " setting enableTcpNoDelay to " + this.enableTcpNoDelay);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 414 */         log.warn(this + " could not convert " + "enableTcpNoDelay" + " value of " + val + " to a boolean value.");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 420 */     val = params.get("clientMaxPoolSize");
/* 421 */     if (val != null)
/*     */     {
/*     */       try
/*     */       {
/* 425 */         this.maxPoolSize = Integer.valueOf((String)val).intValue();
/* 426 */         log.debug(this + " setting maxPoolSize to " + this.maxPoolSize);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 430 */         log.warn(this + " could not convert " + "clientMaxPoolSize" + " value of " + val + " to a int value");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 436 */     val = params.get("clientSocketClass");
/* 437 */     if (val != null)
/*     */     {
/* 439 */       String value = (String)val;
/* 440 */       if (value.length() > 0)
/*     */       {
/* 442 */         this.clientSocketClassName = value;
/* 443 */         log.debug(this + " setting client socket wrapper class name to " + this.clientSocketClassName);
/*     */       }
/*     */     }
/*     */ 
/* 447 */     val = params.get("socket.check_connection");
/* 448 */     if ((val != null) && (((String)val).length() > 0))
/*     */     {
/* 450 */       String value = (String)val;
/* 451 */       this.shouldCheckConnection = Boolean.valueOf(value).booleanValue();
/* 452 */       log.debug(this + " setting shouldCheckConnection to " + this.shouldCheckConnection);
/*     */     }
/* 454 */     else if (Version.getDefaultVersion() == 1)
/*     */     {
/* 456 */       this.shouldCheckConnection = true;
/* 457 */       log.debug(this + " setting shouldCheckConnection to " + this.shouldCheckConnection);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ServerAddress createServerAddress()
/*     */   {
/* 463 */     return new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, -1, this.maxPoolSize);
/*     */   }
/*     */ 
/*     */   protected void finalize() throws Throwable
/*     */   {
/* 468 */     disconnect();
/* 469 */     super.finalize();
/*     */   }
/*     */ 
/*     */   protected synchronized void handleConnect() throws ConnectionFailedException
/*     */   {
/* 474 */     initPool();
/*     */   }
/*     */ 
/*     */   protected synchronized void handleDisconnect()
/*     */   {
/* 479 */     clearPools();
/* 480 */     clearPool(this.pool);
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/* 489 */     return "serializable";
/*     */   }
/*     */ 
/*     */   protected Object transport(String sessionID, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller)
/*     */     throws IOException, ConnectionFailedException, ClassNotFoundException
/*     */   {
/* 496 */     long start = System.currentTimeMillis();
/* 497 */     SocketWrapper socketWrapper = null;
/* 498 */     Object response = null;
/* 499 */     boolean oneway = false;
/*     */ 
/* 502 */     int tempTimeout = -1;
/* 503 */     int savedTimeout = -1;
/*     */ 
/* 505 */     if (metadata != null)
/*     */     {
/* 508 */       Object val = metadata.get("oneway");
/* 509 */       if ((val != null) && ((val instanceof String)) && (Boolean.valueOf((String)val).booleanValue()))
/*     */       {
/* 511 */         oneway = true;
/*     */       }
/*     */ 
/* 515 */       String tempTimeoutString = (String)metadata.get("timeout");
/*     */ 
/* 517 */       if (tempTimeoutString != null)
/*     */       {
/*     */         try
/*     */         {
/* 521 */           tempTimeout = Integer.valueOf(tempTimeoutString).intValue();
/* 522 */           log.debug(this + " setting timeout to " + tempTimeout + " for this invocation");
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 526 */           log.warn(this + " could not convert " + "timeout" + " value of " + tempTimeoutString + " to an integer value.");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 533 */     int retryCount = 0;
/* 534 */     SocketException sockEx = null;
/*     */ 
/* 536 */     for (; retryCount < this.numberOfCallRetries; retryCount++)
/*     */     {
/* 539 */       int timeLeft = -1;
/* 540 */       if (0 < tempTimeout)
/*     */       {
/* 544 */         timeLeft = (int)(tempTimeout - (System.currentTimeMillis() - start));
/* 545 */         if (timeLeft <= 0) {
/*     */           break;
/*     */         }
/*     */       }
/*     */       try
/*     */       {
/* 551 */         socketWrapper = getConnection(marshaller, unmarshaller, timeLeft);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 557 */         this.semaphore.release();
/* 558 */         if (trace) log.trace(this + " released semaphore: " + this.semaphore.permits());
/* 559 */         throw new CannotConnectException("Can not get connection to server. Problem establishing socket connection for " + this.locator, e);
/*     */       }
/*     */ 
/* 564 */       if (tempTimeout >= 0)
/*     */       {
/* 566 */         savedTimeout = socketWrapper.getTimeout();
/* 567 */         socketWrapper.setTimeout((int)(tempTimeout - (System.currentTimeMillis() - start)));
/*     */       }
/*     */ 
/* 570 */       long end = System.currentTimeMillis() - start;
/* 571 */       getSocketTime += end;
/*     */       try
/*     */       {
/* 575 */         int version = Version.getDefaultVersion();
/* 576 */         boolean performVersioning = Version.performVersioning();
/*     */ 
/* 578 */         OutputStream outputStream = socketWrapper.getOutputStream();
/*     */ 
/* 580 */         if (performVersioning)
/*     */         {
/* 582 */           writeVersion(outputStream, version);
/*     */         }
/*     */ 
/* 586 */         versionedWrite(outputStream, marshaller, invocation, version);
/*     */ 
/* 588 */         end = System.currentTimeMillis() - start;
/* 589 */         writeTime += end;
/* 590 */         start = System.currentTimeMillis();
/*     */ 
/* 592 */         if (oneway)
/*     */         {
/* 594 */           if (trace) log.trace(this + " sent oneway invocation, so not waiting for response, returning null");
/*     */         }
/*     */         else
/*     */         {
/* 598 */           InputStream inputStream = socketWrapper.getInputStream();
/* 599 */           if (performVersioning)
/*     */           {
/* 601 */             version = readVersion(inputStream);
/* 602 */             if (version == -1)
/*     */             {
/* 604 */               throw new SocketException("end of file");
/*     */             }
/* 606 */             if (version == 254)
/*     */             {
/* 608 */               log.debug("Received version 254: treating as end of file");
/* 609 */               throw new SocketException("end of file");
/*     */             }
/*     */           }
/*     */ 
/* 613 */           response = versionedRead(inputStream, unmarshaller, version);
/*     */         }
/*     */ 
/* 616 */         end = System.currentTimeMillis() - start;
/* 617 */         readTime += end;
/*     */ 
/* 623 */         if (tempTimeout >= 0)
/*     */         {
/* 625 */           socketWrapper.setTimeout(savedTimeout);
/*     */         }
/*     */       }
/*     */       catch (SocketException sex)
/*     */       {
/* 630 */         log.debug(this + " got SocketException " + sex);
/*     */         try
/*     */         {
/* 634 */           this.semaphore.release();
/* 635 */           if (trace) log.trace(this + " released semaphore: " + this.semaphore.permits());
/* 636 */           socketWrapper.close();
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 640 */           if (trace) log.trace(this + " couldn't successfully close its socketWrapper", ex);
/*     */ 
/*     */         }
/*     */ 
/* 649 */         if (retryCount == this.numberOfCallRetries - 2)
/*     */         {
/* 651 */           flushConnectionPool();
/*     */         }
/* 653 */         sockEx = sex;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 658 */         log.debug(this + " got exception " + ex);
/*     */         try
/*     */         {
/* 662 */           this.semaphore.release();
/* 663 */           if (trace) log.trace(this + " released semaphore: " + this.semaphore.permits());
/* 664 */           socketWrapper.close();
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/*     */         }
/* 669 */         return handleException(ex, socketWrapper);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 677 */     if (retryCount >= this.numberOfCallRetries)
/*     */     {
/* 679 */       handleException(sockEx, socketWrapper);
/*     */     }
/*     */ 
/* 683 */     synchronized (this.pool)
/*     */     {
/* 685 */       if (this.pool.size() < this.maxPoolSize)
/*     */       {
/* 687 */         this.pool.add(socketWrapper);
/* 688 */         if (trace) log.trace(this + " returned " + socketWrapper + " to pool");
/*     */       }
/*     */       else
/*     */       {
/* 692 */         if (trace) log.trace(this + "'s pool is full, will close the connection");
/*     */         try
/*     */         {
/* 695 */           socketWrapper.close();
/*     */         }
/*     */         catch (Exception ignored)
/*     */         {
/*     */         }
/*     */       }
/* 701 */       this.semaphore.release();
/* 702 */       if (trace) log.trace(this + " released semaphore: " + this.semaphore.permits());
/*     */     }
/*     */ 
/* 705 */     if ((trace) && (!oneway)) log.trace(this + " received response " + response);
/* 706 */     return response;
/*     */   }
/*     */ 
/*     */   protected Object handleException(Exception ex, SocketWrapper socketWrapper)
/*     */     throws ClassNotFoundException, MarshalException
/*     */   {
/* 712 */     log.error(this + " got marshalling exception, exiting ...", ex);
/*     */ 
/* 714 */     if ((ex instanceof ClassNotFoundException))
/*     */     {
/* 717 */       log.error("Error loading classes from remote call result.", ex);
/* 718 */       throw ((ClassNotFoundException)ex);
/*     */     }
/*     */ 
/* 721 */     throw new MarshalException("Failed to communicate. Problem during marshalling/unmarshalling.", ex);
/*     */   }
/*     */ 
/*     */   protected void initPool()
/*     */   {
/* 727 */     synchronized (connectionPools)
/*     */     {
/* 729 */       this.pool = ((LinkedList)connectionPools.get(this.address));
/* 730 */       this.semaphore = ((Semaphore)semaphores.get(this.address));
/* 731 */       if (this.pool == null)
/*     */       {
/* 733 */         this.pool = new LinkedList();
/* 734 */         connectionPools.put(this.address, this.pool);
/* 735 */         log.debug("Creating semaphore with size " + this.maxPoolSize);
/* 736 */         this.semaphore = new Semaphore(this.maxPoolSize);
/* 737 */         semaphores.put(this.address, this.semaphore);
/*     */ 
/* 739 */         if (trace)
/*     */         {
/* 741 */           synchronized (this.pool)
/*     */           {
/* 743 */             log.trace(this + " added new pool (" + this.pool + ") as " + this.address);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 749 */       else if (trace)
/*     */       {
/* 751 */         synchronized (this.pool)
/*     */         {
/* 753 */           log.trace(this + " using pool (" + this.pool + ") already defined for " + this.address);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected SocketWrapper getConnection(Marshaller marshaller, UnMarshaller unmarshaller, int timeAllowed)
/*     */     throws Exception
/*     */   {
/* 765 */     long start = System.currentTimeMillis();
/* 766 */     long timeToWait = timeAllowed > 0 ? timeAllowed : 30000L;
/* 767 */     boolean timedout = !this.semaphore.attempt(timeToWait);
/* 768 */     if (trace) log.trace(this + " obtained semaphore: " + this.semaphore.permits());
/*     */ 
/* 770 */     if (timedout)
/*     */     {
/* 772 */       throw new IllegalStateException("Timeout waiting for a free socket");
/*     */     }
/*     */ 
/* 775 */     SocketWrapper pooled = null;
/*     */ 
/* 777 */     synchronized (this.pool)
/*     */     {
/* 780 */       if (this.pool.size() > 0)
/*     */       {
/* 782 */         pooled = getPooledConnection();
/* 783 */         if (trace) log.trace(this + " reusing pooled connection: " + pooled);
/*     */       }
/*     */     }
/*     */ 
/* 787 */     if (pooled == null)
/*     */     {
/* 790 */       Socket socket = null;
/*     */ 
/* 792 */       if (trace) log.trace(this + " creating socket ");
/*     */ 
/* 795 */       int timeRemaining = -1;
/* 796 */       if (0 <= timeAllowed)
/*     */       {
/* 798 */         timeRemaining = (int)(timeAllowed - (System.currentTimeMillis() - start));
/*     */       }
/*     */ 
/* 801 */       socket = createSocket(this.address.address, this.address.port, timeRemaining);
/* 802 */       if (trace) log.trace(this + " created socket: " + socket);
/*     */ 
/* 804 */       socket.setTcpNoDelay(this.address.enableTcpNoDelay);
/*     */ 
/* 806 */       Map metadata = getLocator().getParameters();
/* 807 */       if (metadata == null)
/*     */       {
/* 809 */         metadata = new HashMap(2);
/*     */       }
/*     */       else
/*     */       {
/* 813 */         metadata = new HashMap(metadata);
/*     */       }
/* 815 */       metadata.put("marshaller", marshaller);
/* 816 */       metadata.put("unmarshaller", unmarshaller);
/*     */ 
/* 818 */       if (timeAllowed > 0)
/*     */       {
/* 820 */         timeRemaining = (int)(timeAllowed - (System.currentTimeMillis() - start));
/*     */ 
/* 822 */         if (timeRemaining <= 0) {
/* 823 */           throw new IllegalStateException("Timeout creating a new socket");
/*     */         }
/* 825 */         metadata.put("temptimeout", new Integer(timeRemaining));
/*     */       }
/*     */ 
/* 828 */       pooled = createClientSocket(socket, this.address.timeout, metadata);
/*     */     }
/*     */ 
/* 831 */     return pooled;
/*     */   }
/*     */ 
/*     */   protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata)
/*     */     throws Exception
/*     */   {
/* 837 */     if (this.clientSocketConstructor == null)
/*     */     {
/* 839 */       if (this.clientSocketClass == null)
/*     */       {
/* 841 */         this.clientSocketClass = ClassLoaderUtility.loadClass(this.clientSocketClassName, getClass());
/*     */       }
/*     */ 
/* 844 */       Class[] args = { Socket.class, Map.class, Integer.class };
/* 845 */       this.clientSocketConstructor = this.clientSocketClass.getConstructor(args);
/*     */     }
/*     */ 
/* 848 */     SocketWrapper clientSocketWrapper = null;
/* 849 */     clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(new Object[] { socket, metadata, new Integer(timeout) });
/*     */ 
/* 852 */     return clientSocketWrapper;
/*     */   }
/*     */ 
/*     */   protected Socket createSocket(String address, int port, int timeout) throws IOException
/*     */   {
/* 857 */     Socket s = new Socket();
/* 858 */     s.setReuseAddress(getReuseAddress());
/* 859 */     InetSocketAddress inetAddr = new InetSocketAddress(address, port);
/* 860 */     s.connect(inetAddr);
/* 861 */     return s;
/*     */   }
/*     */ 
/*     */   protected SocketWrapper getPooledConnection()
/*     */   {
/* 866 */     SocketWrapper socketWrapper = null;
/* 867 */     while (this.pool.size() > 0)
/*     */     {
/* 869 */       socketWrapper = (SocketWrapper)this.pool.removeFirst();
/*     */       try
/*     */       {
/* 872 */         if (socketWrapper != null)
/*     */         {
/* 874 */           if ((socketWrapper instanceof OpenConnectionChecker))
/*     */           {
/* 876 */             ((OpenConnectionChecker)socketWrapper).checkOpenConnection();
/*     */           }
/* 878 */           if (this.shouldCheckConnection)
/*     */           {
/* 880 */             socketWrapper.checkConnection();
/* 881 */             return socketWrapper;
/*     */           }
/*     */ 
/* 885 */           return socketWrapper;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 891 */         if (trace) log.trace(this + " couldn't reuse connection from pool");
/*     */         try
/*     */         {
/* 894 */           socketWrapper.close();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 898 */           log.debug("Failed to close socket wrapper", e);
/*     */         }
/*     */       }
/*     */     }
/* 902 */     return null;
/*     */   }
/*     */ 
/*     */   private Object versionedRead(InputStream inputStream, UnMarshaller unmarshaller, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 911 */     switch (version)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 22:
/* 917 */       if (trace) log.trace(this + " reading response from unmarshaller");
/* 918 */       if ((unmarshaller instanceof VersionedUnMarshaller)) {
/* 919 */         return ((VersionedUnMarshaller)unmarshaller).read(inputStream, null, version);
/*     */       }
/* 921 */       return unmarshaller.read(inputStream, null);
/*     */     }
/*     */ 
/* 925 */     throw new IOException("Can not read data for version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
/*     */   }
/*     */ 
/*     */   private void versionedWrite(OutputStream outputStream, Marshaller marshaller, Object invocation, int version)
/*     */     throws IOException
/*     */   {
/* 935 */     switch (version)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*     */     case 22:
/* 941 */       if (trace) log.trace(this + " writing invocation to marshaller");
/* 942 */       if ((marshaller instanceof VersionedMarshaller))
/* 943 */         ((VersionedMarshaller)marshaller).write(invocation, outputStream, version);
/*     */       else
/* 945 */         marshaller.write(invocation, outputStream);
/* 946 */       if (trace) log.trace(this + " done writing invocation to marshaller");
/*     */ 
/* 948 */       return;
/*     */     }
/*     */ 
/* 952 */     throw new IOException("Can not write data for version " + version + ".  " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
/*     */   }
/*     */ 
/*     */   private int readVersion(InputStream inputStream)
/*     */     throws IOException
/*     */   {
/* 961 */     if (trace) log.trace(this + " reading version from input stream");
/* 962 */     int version = inputStream.read();
/* 963 */     if (trace) log.trace(this + " read version " + version + " from input stream");
/* 964 */     return version;
/*     */   }
/*     */ 
/*     */   private void writeVersion(OutputStream outputStream, int version)
/*     */     throws IOException
/*     */   {
/* 970 */     if (trace) log.trace(this + " writing version " + version + " on output stream");
/* 971 */     outputStream.write(version);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.socket.MicroSocketClientInvoker
 * JD-Core Version:    0.6.0
 */