/*     */ package org.jboss.remoting.transport.servlet;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.ServletInputStream;
/*     */ import javax.servlet.ServletOutputStream;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvocationResponse;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.transport.web.WebServerInvoker;
/*     */ import org.jboss.remoting.transport.web.WebUtil;
/*     */ 
/*     */ public class ServletServerInvoker extends WebServerInvoker
/*     */   implements ServletServerInvokerMBean
/*     */ {
/*  63 */   private static final Logger log = Logger.getLogger(ServletServerInvoker.class);
/*     */ 
/*     */   public ServletServerInvoker(InvokerLocator locator)
/*     */   {
/*  67 */     super(locator);
/*     */   }
/*     */ 
/*     */   public ServletServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  72 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/*  77 */     return "http";
/*     */   }
/*     */ 
/*     */   public String getMBeanObjectName()
/*     */   {
/*  82 */     return "jboss.remoting:service=invoker,transport=servlet";
/*     */   }
/*     */ 
/*     */   public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
/*     */   {
/*  87 */     Map metadata = new HashMap();
/*     */ 
/*  89 */     Enumeration enumer = request.getHeaderNames();
/*  90 */     while (enumer.hasMoreElements())
/*     */     {
/*  92 */       Object obj = enumer.nextElement();
/*  93 */       String headerKey = (String)obj;
/*  94 */       String headerValue = request.getHeader(headerKey);
/*  95 */       metadata.put(headerKey, headerValue);
/*     */     }
/*     */ 
/*  98 */     Map urlParams = request.getParameterMap();
/*  99 */     metadata.putAll(urlParams);
/*     */ 
/* 101 */     String requestContentType = request.getContentType();
/*     */     try
/*     */     {
/* 106 */       Object invocationResponse = null;
/*     */ 
/* 108 */       ServletInputStream inputStream = request.getInputStream();
/* 109 */       UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller("http", getSerializationType());
/* 110 */       Object obj = null;
/* 111 */       if ((unmarshaller instanceof VersionedUnMarshaller))
/* 112 */         obj = ((VersionedUnMarshaller)unmarshaller).read(inputStream, metadata, Version.getDefaultVersion());
/*     */       else
/* 114 */         obj = unmarshaller.read(inputStream, metadata);
/* 115 */       inputStream.close();
/*     */ 
/* 117 */       InvocationRequest invocationRequest = null;
/*     */ 
/* 119 */       if ((obj instanceof InvocationRequest))
/*     */       {
/* 121 */         invocationRequest = (InvocationRequest)obj;
/*     */       }
/* 125 */       else if (WebUtil.isBinary(requestContentType))
/*     */       {
/* 127 */         invocationRequest = getInvocationRequest(metadata, obj);
/*     */       }
/*     */       else
/*     */       {
/* 131 */         invocationRequest = createNewInvocationRequest(metadata, obj);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 138 */         invocationResponse = invoke(invocationRequest);
/*     */       }
/*     */       catch (Throwable ex)
/*     */       {
/* 142 */         log.debug("Error thrown calling invoke on server invoker.", ex);
/* 143 */         invocationResponse = null;
/* 144 */         response.sendError(500, "Error processing invocation request.  " + ex.getMessage());
/*     */       }
/*     */ 
/* 147 */       if (invocationResponse != null)
/*     */       {
/* 149 */         response.setContentType(requestContentType);
/* 150 */         int iContentLength = getContentLength(invocationResponse);
/* 151 */         response.setContentLength(iContentLength);
/* 152 */         ServletOutputStream outputStream = response.getOutputStream();
/* 153 */         Marshaller marshaller = MarshalFactory.getMarshaller("http", getSerializationType());
/* 154 */         if ((marshaller instanceof VersionedMarshaller))
/* 155 */           ((VersionedMarshaller)marshaller).write(invocationResponse, outputStream, Version.getDefaultVersion());
/*     */         else
/* 157 */           marshaller.write(invocationResponse, outputStream);
/* 158 */         outputStream.close();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 164 */       log.error("Error processing invocation request due to class not being found.", e);
/* 165 */       response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte[] processRequest(HttpServletRequest request, byte[] requestByte, HttpServletResponse response)
/*     */     throws ServletException, IOException
/*     */   {
/* 175 */     byte[] retval = new byte[0];
/*     */ 
/* 177 */     Map metadata = new HashMap();
/*     */ 
/* 179 */     Enumeration enumer = request.getHeaderNames();
/* 180 */     while (enumer.hasMoreElements())
/*     */     {
/* 182 */       Object obj = enumer.nextElement();
/* 183 */       String headerKey = (String)obj;
/* 184 */       String headerValue = request.getHeader(headerKey);
/* 185 */       metadata.put(headerKey, headerValue);
/*     */     }
/*     */ 
/* 188 */     Map urlParams = request.getParameterMap();
/* 189 */     metadata.putAll(urlParams);
/*     */ 
/* 191 */     metadata.put("MethodType", request.getMethod());
/* 192 */     metadata.put("Path", request.getPathTranslated());
/*     */ 
/* 194 */     String requestContentType = request.getContentType();
/*     */     try
/*     */     {
/* 199 */       Object invocationResponse = null;
/*     */ 
/* 201 */       ServletInputStream inputStream = request.getInputStream();
/* 202 */       UnMarshaller unmarshaller = getUnMarshaller();
/* 203 */       Object obj = null;
/* 204 */       if ((unmarshaller instanceof VersionedUnMarshaller))
/* 205 */         obj = ((VersionedUnMarshaller)unmarshaller).read(new ByteArrayInputStream(requestByte), metadata, Version.getDefaultVersion());
/*     */       else
/* 207 */         obj = unmarshaller.read(new ByteArrayInputStream(requestByte), metadata);
/* 208 */       inputStream.close();
/*     */ 
/* 210 */       boolean isError = false;
/* 211 */       InvocationRequest invocationRequest = null;
/*     */ 
/* 213 */       if ((obj instanceof InvocationRequest))
/*     */       {
/* 215 */         invocationRequest = (InvocationRequest)obj;
/*     */       }
/* 219 */       else if (WebUtil.isBinary(requestContentType))
/*     */       {
/* 221 */         invocationRequest = getInvocationRequest(metadata, obj);
/*     */       }
/*     */       else
/*     */       {
/* 225 */         invocationRequest = createNewInvocationRequest(metadata, obj);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 232 */         invocationResponse = invoke(invocationRequest);
/*     */       }
/*     */       catch (Throwable ex)
/*     */       {
/* 236 */         log.debug("Error thrown calling invoke on server invoker.", ex);
/* 237 */         invocationResponse = ex;
/*     */ 
/* 239 */         if (checkForExceptionReturn(metadata))
/*     */         {
/* 241 */           String sessionId = invocationRequest.getSessionId();
/* 242 */           ServletThrowable st = new ServletThrowable(ex);
/* 243 */           invocationResponse = new InvocationResponse(sessionId, st, true, null);
/*     */         }
/*     */         else
/*     */         {
/* 247 */           isError = true;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 252 */       int status = 204;
/* 253 */       if (invocationResponse != null)
/*     */       {
/* 255 */         if (isError)
/*     */         {
/* 257 */           response.sendError(500, "Error occurred processing invocation request. ");
/*     */         }
/*     */         else
/*     */         {
/* 261 */           status = 200;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 266 */       Map responseMap = invocationRequest.getReturnPayload();
/* 267 */       if (responseMap != null)
/*     */       {
/* 269 */         Integer handlerStatus = (Integer)responseMap.remove("ResponseCode");
/* 270 */         if (handlerStatus != null)
/*     */         {
/* 272 */           status = handlerStatus.intValue();
/*     */         }
/*     */ 
/* 276 */         Set entries = responseMap.entrySet();
/* 277 */         Iterator itr = entries.iterator();
/* 278 */         while (itr.hasNext())
/*     */         {
/* 280 */           Map.Entry entry = (Map.Entry)itr.next();
/* 281 */           response.addHeader(entry.getKey().toString(), entry.getValue().toString());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 288 */       response.setStatus(status);
/*     */ 
/* 290 */       if (invocationResponse != null)
/*     */       {
/* 292 */         String responseContentType = invocationResponse == null ? requestContentType : WebUtil.getContentType(invocationResponse);
/* 293 */         response.setContentType(responseContentType);
/*     */ 
/* 296 */         ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
/* 297 */         Marshaller marshaller = getMarshaller();
/* 298 */         if ((marshaller instanceof VersionedMarshaller))
/* 299 */           ((VersionedMarshaller)marshaller).write(invocationResponse, outputStream, Version.getDefaultVersion());
/*     */         else
/* 301 */           marshaller.write(invocationResponse, outputStream);
/* 302 */         retval = outputStream.toByteArray();
/* 303 */         response.setContentLength(retval.length);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 309 */       log.error("Error processing invocation request due to class not being found.", e);
/* 310 */       response.sendError(500, "Error processing invocation request due to class not being found.  " + e.getMessage());
/*     */     }
/*     */ 
/* 313 */     return retval;
/*     */   }
/*     */ 
/*     */   private boolean checkForExceptionReturn(Map headers)
/*     */   {
/* 318 */     boolean flag = false;
/*     */ 
/* 320 */     if (headers != null)
/*     */     {
/* 322 */       Object val = headers.get("return-exception");
/* 323 */       if (val != null)
/*     */       {
/* 325 */         if ((val instanceof String))
/*     */         {
/* 327 */           flag = Boolean.valueOf((String)val).booleanValue();
/*     */         }
/* 329 */         else if ((val instanceof String[]))
/*     */         {
/* 331 */           String param = ((String[])val)[0];
/* 332 */           flag = Boolean.valueOf(param).booleanValue();
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 337 */     return flag;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.servlet.ServletServerInvoker
 * JD-Core Version:    0.6.0
 */