/*     */ package org.jboss.remoting.transport.rmi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class RemotingRMIServerSocketFactory
/*     */   implements RMIServerSocketFactory, Serializable
/*     */ {
/*  63 */   protected static final Logger log = Logger.getLogger(RemotingRMIServerSocketFactory.class);
/*     */   private ServerSocketFactory serverSocketFactory;
/*     */   private int backlog;
/*     */   private InetAddress bindAddress;
/*     */   private int timeout;
/*     */   private static final long serialVersionUID = -5851426317709480542L;
/*     */ 
/*     */   public RemotingRMIServerSocketFactory(String bindHost)
/*     */     throws UnknownHostException
/*     */   {
/*  89 */     this(null, -1, bindHost);
/*     */   }
/*     */ 
/*     */   public RemotingRMIServerSocketFactory(int backlog, String bindHost)
/*     */     throws UnknownHostException
/*     */   {
/* 100 */     this(null, backlog, bindHost);
/*     */   }
/*     */ 
/*     */   public RemotingRMIServerSocketFactory(ServerSocketFactory serverSocketFactory, int backlog, String bindHost)
/*     */     throws UnknownHostException
/*     */   {
/* 113 */     this(serverSocketFactory, backlog, bindHost, 60000);
/*     */   }
/*     */ 
/*     */   public RemotingRMIServerSocketFactory(ServerSocketFactory serverSocketFactory, int backlog, String bindHost, int timeout)
/*     */     throws UnknownHostException
/*     */   {
/* 119 */     log.info("bind host: " + bindHost);
/* 120 */     this.serverSocketFactory = serverSocketFactory;
/* 121 */     this.backlog = backlog;
/* 122 */     this.bindAddress = InetAddress.getByName(bindHost);
/* 123 */     this.timeout = timeout;
/*     */   }
/*     */ 
/*     */   public RemotingRMIServerSocketFactory(String bindHost, int timeout) throws UnknownHostException
/*     */   {
/* 128 */     this(null, -1, bindHost, timeout);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/* 150 */     ServerSocket svrSocket = null;
/*     */ 
/* 152 */     if (this.serverSocketFactory != null)
/*     */     {
/* 154 */       svrSocket = this.serverSocketFactory.createServerSocket(port, this.backlog, this.bindAddress);
/*     */     }
/*     */     else
/*     */     {
/* 174 */       svrSocket = new ServerSocket(port, this.backlog, this.bindAddress);
/*     */     }
/*     */ 
/* 177 */     svrSocket.setSoTimeout(this.timeout);
/* 178 */     return svrSocket;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 191 */     if (!(o instanceof RemotingRMIServerSocketFactory))
/*     */     {
/* 193 */       return false;
/*     */     }
/*     */ 
/* 196 */     RemotingRMIServerSocketFactory ssf = (RemotingRMIServerSocketFactory)o;
/*     */ 
/* 199 */     if (this.serverSocketFactory != null)
/*     */     {
/* 206 */       return (ssf.serverSocketFactory != null) && (this.serverSocketFactory.equals(ssf.serverSocketFactory)) && (this.backlog == ssf.backlog) && (this.bindAddress.equals(ssf.bindAddress));
/*     */     }
/*     */ 
/* 232 */     return (ssf.serverSocketFactory == null) && (this.backlog == ssf.backlog) && (this.bindAddress.equals(ssf.bindAddress));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 246 */     if (this.serverSocketFactory != null)
/*     */     {
/* 248 */       return this.serverSocketFactory.hashCode() * this.backlog * this.bindAddress.hashCode();
/*     */     }
/*     */ 
/* 261 */     return this.backlog * this.bindAddress.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.rmi.RemotingRMIServerSocketFactory
 * JD-Core Version:    0.6.0
 */