/*     */ package org.jboss.remoting.transport.rmi;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.AbstractInvoker;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.Version;
/*     */ 
/*     */ public class RemotingRMIClientSocketFactory
/*     */   implements RMIClientSocketFactory, Serializable
/*     */ {
/*     */   static final long serialVersionUID;
/*  79 */   protected static Logger log = Logger.getLogger(RemotingRMIClientSocketFactory.class);
/*  80 */   protected static HashMap configMaps = new HashMap();
/*  81 */   protected static Map socketFactories = new HashMap();
/*     */   protected Map configuration;
/*     */   protected InvokerLocator invokerLocator;
/*     */   protected transient SocketFactory socketFactory;
/*  87 */   private int timeout = 60000;
/*     */   protected String hostName;
/*     */ 
/*     */   public static void addLocalConfiguration(InvokerLocator invokerLocator, Map localConfig)
/*     */   {
/* 119 */     log.debug("adding local configuration for: " + invokerLocator);
/* 120 */     configMaps.put(new ComparableHolder(invokerLocator), localConfig);
/*     */   }
/*     */ 
/*     */   public RemotingRMIClientSocketFactory(InvokerLocator locator, String hostName, int timeout, Map config)
/*     */   {
/* 135 */     this.invokerLocator = locator;
/* 136 */     this.hostName = hostName;
/* 137 */     this.timeout = timeout;
/* 138 */     this.configuration = new HashMap(config);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException
/*     */   {
/* 170 */     if (this.invokerLocator != null)
/*     */     {
/* 172 */       ComparableHolder holder = new ComparableHolder(this.invokerLocator);
/* 173 */       if (!configMaps.containsKey(holder))
/*     */       {
/* 175 */         log.warn("unrecognized invoker locator: " + this.invokerLocator);
/* 176 */         log.warn("unable to retrieve socket factory: returning plain socket");
/* 177 */         return new Socket(host, port);
/*     */       }
/* 179 */       this.socketFactory = retrieveSocketFactory(holder);
/*     */     }
/*     */ 
/* 182 */     String effectiveHost = this.hostName != null ? this.hostName : host;
/* 183 */     Socket socket = null;
/*     */ 
/* 185 */     if (this.socketFactory != null)
/*     */     {
/* 187 */       socket = this.socketFactory.createSocket(effectiveHost, port);
/*     */     }
/*     */     else
/*     */     {
/* 210 */       socket = new Socket(effectiveHost, port);
/*     */     }
/*     */ 
/* 213 */     socket.setSoTimeout(this.timeout);
/* 214 */     this.socketFactory = null;
/* 215 */     return socket;
/*     */   }
/*     */ 
/*     */   public SocketFactory retrieveSocketFactory(ComparableHolder holder)
/*     */     throws IOException
/*     */   {
/* 222 */     SocketFactory sf = (SocketFactory)socketFactories.get(this);
/* 223 */     if (sf == null)
/*     */     {
/* 228 */       Map tempConfig = new HashMap(this.configuration);
/* 229 */       Map localConfig = (Map)configMaps.get(holder);
/* 230 */       if (localConfig != null) {
/* 231 */         tempConfig.putAll(localConfig);
/*     */       }
/* 233 */       if (tempConfig.containsKey("customSocketFactory"))
/*     */       {
/* 235 */         sf = (SocketFactory)tempConfig.get("customSocketFactory");
/*     */       }
/*     */ 
/* 238 */       if (sf == null)
/*     */       {
/* 240 */         sf = SocketFactory.getDefault();
/* 241 */         sf = AbstractInvoker.wrapSocketFactory(sf, tempConfig);
/*     */       }
/*     */ 
/* 244 */       socketFactories.put(this, sf);
/*     */     }
/*     */ 
/* 247 */     return sf;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 106 */     if (Version.getDefaultVersion() == 1)
/*     */     {
/* 108 */       serialVersionUID = -7491556589517716155L;
/*     */     }
/*     */     else
/*     */     {
/* 112 */       serialVersionUID = -3039839695840773968L;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class ComparableHolder
/*     */   {
/*     */     private String protocol;
/*     */     private InetAddress host;
/*     */     private int port;
/*     */     private int hashCode;
/*     */ 
/*     */     public ComparableHolder(InvokerLocator invokerLocator)
/*     */     {
/* 260 */       this.protocol = invokerLocator.getProtocol().toLowerCase();
/*     */       try
/*     */       {
/* 264 */         this.host = InetAddress.getByName(invokerLocator.getHost());
/*     */       }
/*     */       catch (UnknownHostException e)
/*     */       {
/* 268 */         RemotingRMIClientSocketFactory.log.error("unable to resolve host: " + invokerLocator.getHost());
/*     */       }
/*     */ 
/* 271 */       this.port = invokerLocator.getPort();
/* 272 */       this.hashCode = (this.protocol.hashCode() * this.host.hashCode() * this.port);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj)
/*     */     {
/* 277 */       if ((obj == null) || (!(obj instanceof ComparableHolder))) {
/* 278 */         return false;
/*     */       }
/* 280 */       ComparableHolder holder = (ComparableHolder)obj;
/*     */ 
/* 282 */       return (this.protocol.equals(holder.protocol.toLowerCase())) && (this.host.equals(holder.host)) && (this.port == holder.port);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 289 */       return this.hashCode;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory
 * JD-Core Version:    0.6.0
 */