/*     */ package org.jboss.remoting.transport.multiplex.utility;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.net.SocketTimeoutException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GrowablePipedInputStream extends InputStream
/*     */ {
/*  61 */   protected static final Logger log = Logger.getLogger(GrowablePipedInputStream.class);
/*     */   private GrowablePipedOutputStream source;
/*  63 */   private ShrinkableByteArrayOutputStream baos = new ShrinkableByteArrayOutputStream();
/*     */   private VirtualSelector virtualSelector;
/*     */   private boolean connected;
/*     */   private int timeout;
/*     */ 
/*     */   public GrowablePipedInputStream()
/*     */   {
/*     */   }
/*     */ 
/*     */   public GrowablePipedInputStream(VirtualSelector virtualSelector)
/*     */   {
/*  82 */     this.virtualSelector = virtualSelector;
/*     */   }
/*     */ 
/*     */   public GrowablePipedInputStream(GrowablePipedOutputStream source)
/*     */     throws IOException
/*     */   {
/*  94 */     this.source = source;
/*  95 */     source.connect(this);
/*  96 */     this.connected = true;
/*     */   }
/*     */ 
/*     */   public GrowablePipedInputStream(GrowablePipedOutputStream source, VirtualSelector virtualSelector)
/*     */     throws IOException
/*     */   {
/* 109 */     this.source = source;
/* 110 */     this.virtualSelector = virtualSelector;
/* 111 */     source.connect(this);
/* 112 */     this.connected = true;
/*     */   }
/*     */ 
/*     */   public synchronized int available()
/*     */   {
/* 118 */     return this.baos.available();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 124 */     super.close();
/* 125 */     if (this.virtualSelector != null)
/* 126 */       this.virtualSelector.unregister(this);
/*     */   }
/*     */ 
/*     */   public int getTimeout()
/*     */   {
/* 132 */     return this.timeout;
/*     */   }
/*     */ 
/*     */   public synchronized int read()
/*     */     throws IOException
/*     */   {
/* 138 */     if (!this.connected) {
/* 139 */       throw new IOException("Pipe not connected");
/*     */     }
/* 141 */     if (this.baos.available() == 0)
/*     */     {
/* 143 */       long start = System.currentTimeMillis();
/*     */       try
/*     */       {
/*     */         while (true)
/*     */         {
/* 149 */           log.trace(this + ": entering wait()");
/* 150 */           wait(this.timeout);
/* 151 */           log.trace("leaving wait()");
/*     */ 
/* 153 */           if (this.baos.available() > 0) {
/*     */             break;
/*     */           }
/* 156 */           if ((0 < this.timeout) && (this.timeout <= System.currentTimeMillis() - start))
/* 157 */             throw new SocketTimeoutException("Read timed out");
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ignored) {
/* 161 */         log.debug("interrupted");
/* 162 */         throw new InterruptedIOException();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 167 */     byte[] bytes = this.baos.toByteArray(1);
/* 168 */     int answer = 0xFF & bytes[this.baos.start()];
/*     */ 
/* 170 */     if (this.baos.available() > 0) {
/* 171 */       notify();
/*     */     }
/* 173 */     return answer;
/*     */   }
/*     */ 
/*     */   public synchronized int read(byte[] bytes)
/*     */     throws IOException
/*     */   {
/* 179 */     return read(bytes, 0, bytes.length);
/*     */   }
/*     */ 
/*     */   public synchronized int read(byte[] bytes, int offset, int length)
/*     */     throws IOException
/*     */   {
/* 185 */     if (!this.connected) {
/* 186 */       throw new IOException("Pipe not connected");
/*     */     }
/* 188 */     if (this.baos.available() == 0)
/*     */     {
/* 190 */       long start = System.currentTimeMillis();
/*     */       try
/*     */       {
/*     */         while (true)
/*     */         {
/* 196 */           log.trace(this + ": entering wait()");
/* 197 */           wait(this.timeout);
/* 198 */           log.trace("leaving wait()");
/*     */ 
/* 200 */           if (this.baos.available() > 0) {
/*     */             break;
/*     */           }
/* 203 */           if ((0 < this.timeout) && (this.timeout <= System.currentTimeMillis() - start))
/* 204 */             throw new SocketTimeoutException("Read timed out");
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ignored) {
/* 208 */         log.debug("interrupted");
/* 209 */         throw new InterruptedIOException();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 214 */     byte[] localBytes = this.baos.toByteArray(length);
/* 215 */     int from = this.baos.start();
/* 216 */     int n = this.baos.bytesReturned();
/* 217 */     System.arraycopy(localBytes, from, bytes, offset, n);
/*     */ 
/* 219 */     if (this.baos.available() > 0) {
/* 220 */       notify();
/*     */     }
/* 222 */     return n;
/*     */   }
/*     */ 
/*     */   public void register(VirtualSelector virtualSelector, Object attachment)
/*     */   {
/* 228 */     this.virtualSelector = virtualSelector;
/* 229 */     virtualSelector.register(this, attachment);
/*     */   }
/*     */ 
/*     */   public void setTimeout(int timeout)
/*     */   {
/* 235 */     this.timeout = timeout;
/*     */   }
/*     */ 
/*     */   protected void connect(GrowablePipedOutputStream source)
/*     */     throws IOException
/*     */   {
/* 241 */     if (source == null) {
/* 242 */       throw new NullPointerException();
/*     */     }
/* 244 */     if (source.isConnected()) {
/* 245 */       throw new IOException("Already connected");
/*     */     }
/* 247 */     this.source = source;
/* 248 */     this.connected = true;
/*     */   }
/*     */ 
/*     */   protected boolean isConnected()
/*     */   {
/* 254 */     return this.connected;
/*     */   }
/*     */ 
/*     */   protected void receive(int i)
/*     */     throws IOException
/*     */   {
/* 260 */     log.trace("entering receive()");
/* 261 */     synchronized (this)
/*     */     {
/* 263 */       this.baos.write(i);
/* 264 */       notify();
/*     */     }
/*     */ 
/* 267 */     if (this.virtualSelector != null)
/* 268 */       this.virtualSelector.addToReadyInputStreams(this);
/*     */   }
/*     */ 
/*     */   protected void receive(byte[] bytes)
/*     */     throws IOException
/*     */   {
/* 274 */     log.trace("entering receive()");
/* 275 */     synchronized (this)
/*     */     {
/* 277 */       this.baos.write(bytes);
/* 278 */       notify();
/*     */     }
/*     */ 
/* 281 */     if (this.virtualSelector != null)
/* 282 */       this.virtualSelector.addToReadyInputStreams(this);
/*     */   }
/*     */ 
/*     */   protected void receive(byte[] bytes, int offset, int length)
/*     */     throws IOException
/*     */   {
/* 288 */     log.trace(this + ": entering receive()");
/* 289 */     synchronized (this)
/*     */     {
/* 291 */       this.baos.write(bytes, offset, length);
/* 292 */       log.trace(this + ": notifying");
/* 293 */       notify();
/*     */     }
/*     */ 
/* 296 */     if (this.virtualSelector != null)
/* 297 */       this.virtualSelector.addToReadyInputStreams(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.utility.GrowablePipedInputStream
 * JD-Core Version:    0.6.0
 */