/*     */ package org.jboss.remoting.transport.multiplex;
/*     */ 
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.net.SocketException;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.multiplex.utility.GrowablePipedInputStream;
/*     */ import org.jboss.remoting.transport.multiplex.utility.GrowablePipedOutputStream;
/*     */ import org.jboss.remoting.transport.multiplex.utility.VirtualSelector;
/*     */ 
/*     */ public class MultiplexingInputStream extends GrowablePipedInputStream
/*     */ {
/*  50 */   protected static final Logger log = Logger.getLogger(MultiplexingInputStream.class);
/*     */   private VirtualSocket socket;
/*  52 */   private boolean eof = false;
/*  53 */   private boolean closed = false;
/*  54 */   private boolean remoteShutDownPending = false;
/*  55 */   private Set readingThreads = new HashSet();
/*     */   private IOException readException;
/*  57 */   private long skipCount = 0L;
/*     */   private boolean tracing;
/*     */ 
/*     */   public MultiplexingInputStream(GrowablePipedOutputStream sourceStream, MultiplexingManager manager)
/*     */     throws IOException
/*     */   {
/*  68 */     this(sourceStream, manager, null, null);
/*     */   }
/*     */ 
/*     */   public MultiplexingInputStream(GrowablePipedOutputStream sourceStream, MultiplexingManager manager, VirtualSocket socket)
/*     */     throws IOException
/*     */   {
/*  83 */     this(sourceStream, manager, socket, null);
/*     */   }
/*     */ 
/*     */   public MultiplexingInputStream(GrowablePipedOutputStream sourceStream, MultiplexingManager manager, VirtualSocket socket, VirtualSelector virtualSelector)
/*     */     throws IOException
/*     */   {
/* 100 */     super(sourceStream, virtualSelector);
/* 101 */     this.socket = socket;
/* 102 */     this.tracing = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 127 */     if (this.closed) {
/* 128 */       return;
/*     */     }
/* 130 */     log.debug("MultiplexingInputStream closing");
/* 131 */     this.closed = true;
/* 132 */     super.close();
/*     */ 
/* 134 */     if (this.socket != null) {
/* 135 */       this.socket.close();
/*     */     }
/*     */ 
/* 138 */     interruptReadingThreads();
/*     */   }
/*     */ 
/*     */   public synchronized int read()
/*     */     throws IOException
/*     */   {
/* 147 */     if (this.eof) {
/* 148 */       return -1;
/*     */     }
/* 150 */     if (this.closed) {
/* 151 */       throw new SocketException("Socket closed");
/*     */     }
/* 153 */     if (this.readException != null) {
/* 154 */       throw this.readException;
/*     */     }
/* 156 */     if (this.skipCount > 0L) {
/* 157 */       skip(this.skipCount);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 163 */       this.readingThreads.add(Thread.currentThread());
/* 164 */       int b = super.read();
/* 165 */       this.readingThreads.remove(Thread.currentThread());
/*     */ 
/* 167 */       if (this.tracing) {
/* 168 */         log.trace("read(): super.read() returned: " + b);
/*     */       }
/* 170 */       if ((this.remoteShutDownPending) && (available() == 0)) {
/* 171 */         setEOF();
/*     */       }
/* 173 */       return b & 0xFF;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 177 */       this.readingThreads.remove(Thread.currentThread());
/*     */ 
/* 179 */       if (this.closed) {
/* 180 */         throw new SocketException("Socket closed");
/*     */       }
/* 182 */       if (this.eof) {
/* 183 */         return -1;
/*     */       }
/* 185 */       if (this.readException != null)
/* 186 */         throw this.readException;
/*     */     }
/* 188 */     throw e;
/*     */   }
/*     */ 
/*     */   public int read(byte[] bytes)
/*     */     throws IOException
/*     */   {
/* 198 */     return read(bytes, 0, bytes.length);
/*     */   }
/*     */ 
/*     */   public synchronized int read(byte[] bytes, int off, int len)
/*     */     throws IOException
/*     */   {
/* 207 */     log.trace("entering read()");
/*     */ 
/* 209 */     if (this.eof) {
/* 210 */       return -1;
/*     */     }
/* 212 */     if (this.closed) {
/* 213 */       throw new SocketException("Socket closed");
/*     */     }
/* 215 */     if (this.readException != null) {
/* 216 */       throw this.readException;
/*     */     }
/* 218 */     if (this.skipCount > 0L) {
/* 219 */       skip(this.skipCount);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 225 */       this.readingThreads.add(Thread.currentThread());
/* 226 */       int n = super.read(bytes, off, len);
/* 227 */       this.readingThreads.remove(Thread.currentThread());
/*     */ 
/* 229 */       if (this.tracing) {
/* 230 */         log.trace("super.read() returned " + n + " bytes: " + "[" + (0xFF & bytes[off]) + ".." + (0xFF & bytes[(off + n - 1)]) + "]");
/*     */       }
/*     */ 
/* 233 */       if ((this.remoteShutDownPending) && (available() == 0)) {
/* 234 */         setEOF();
/*     */       }
/* 236 */       return n;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 240 */       this.readingThreads.remove(Thread.currentThread());
/*     */ 
/* 242 */       if (this.eof) {
/* 243 */         return -1;
/*     */       }
/* 245 */       if (this.closed)
/* 246 */         throw new SocketException("Socket closed");
/*     */     }
/* 248 */     throw e;
/*     */   }
/*     */ 
/*     */   public synchronized long skip(long n)
/*     */     throws IOException
/*     */   {
/* 258 */     if (this.eof) {
/* 259 */       return 0L;
/*     */     }
/* 261 */     if (this.closed) {
/* 262 */       throw new SocketException("Socket closed");
/*     */     }
/* 264 */     if (this.readException != null) {
/* 265 */       throw this.readException;
/*     */     }
/* 267 */     if (n <= 0L) {
/* 268 */       return 0L;
/*     */     }
/* 270 */     int skipped = 0;
/*     */     try
/*     */     {
/* 274 */       this.readingThreads.add(Thread.currentThread());
/*     */ 
/* 276 */       while ((skipped < n) && ((skipped == 0) || (available() > 0)))
/*     */       {
/* 278 */         if (read() == -1) {
/*     */           break;
/*     */         }
/* 281 */         skipped++;
/*     */       }
/*     */ 
/* 284 */       this.readingThreads.remove(Thread.currentThread());
/*     */ 
/* 286 */       if ((this.remoteShutDownPending) && (available() == 0)) {
/* 287 */         setEOF();
/*     */       }
/* 289 */       return skipped;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 293 */       this.readingThreads.remove(Thread.currentThread());
/*     */ 
/* 295 */       if (this.eof) {
/* 296 */         return -1L;
/*     */       }
/* 298 */       if (this.closed)
/* 299 */         throw new SocketException("Socket closed");
/*     */     }
/* 301 */     throw e;
/*     */   }
/*     */ 
/*     */   protected VirtualSocket getSocket()
/*     */   {
/* 315 */     return this.socket;
/*     */   }
/*     */ 
/*     */   protected synchronized void handleRemoteShutdown()
/*     */     throws IOException
/*     */   {
/* 406 */     log.debug("entering handleRemoteShutdown()");
/*     */ 
/* 408 */     if (this.eof) {
/* 409 */       return;
/*     */     }
/* 411 */     this.remoteShutDownPending = true;
/*     */ 
/* 413 */     if (available() == 0)
/*     */     {
/* 415 */       setEOF();
/* 416 */       interruptReadingThreads();
/*     */     }
/*     */ 
/* 419 */     log.debug("leaving handleRemoteShutdown()");
/*     */   }
/*     */ 
/*     */   protected synchronized void interruptReadingThreads()
/*     */   {
/* 430 */     Iterator it = this.readingThreads.iterator();
/*     */ 
/* 432 */     while (it.hasNext())
/*     */     {
/* 434 */       Thread t = (Thread)it.next();
/* 435 */       it.remove();
/* 436 */       t.interrupt();
/*     */     }
/*     */   }
/*     */ 
/*     */   public final int readInt()
/*     */     throws IOException
/*     */   {
/* 447 */     int b1 = read();
/* 448 */     int b2 = read();
/* 449 */     int b3 = read();
/* 450 */     int b4 = read();
/*     */ 
/* 452 */     if ((b1 | b2 | b3 | b4) < 0) {
/* 453 */       throw new EOFException();
/*     */     }
/* 455 */     return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
/*     */   }
/*     */ 
/*     */   protected void setEOF()
/*     */   {
/* 463 */     this.eof = true;
/*     */   }
/*     */ 
/*     */   protected void setReadException(IOException e)
/*     */   {
/* 469 */     this.readException = e;
/* 470 */     interruptReadingThreads();
/*     */   }
/*     */ 
/*     */   protected synchronized void setSkip(long n)
/*     */   {
/* 478 */     this.skipCount += n;
/*     */   }
/*     */ 
/*     */   protected void setSocket(VirtualSocket socket)
/*     */   {
/* 491 */     this.socket = socket;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.multiplex.MultiplexingInputStream
 * JD-Core Version:    0.6.0
 */