/*     */ package org.jboss.remoting.transport.local;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.AbstractInvoker;
/*     */ import org.jboss.remoting.ConnectionFailedException;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.InvokerRegistry;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.ServerInvoker.InvalidStateException;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.serialization.IMarshalledValue;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ import org.jboss.remoting.transport.BidirectionalClientInvoker;
/*     */ 
/*     */ public class LocalClientInvoker extends AbstractInvoker
/*     */   implements BidirectionalClientInvoker
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(LocalClientInvoker.class);
/*     */   private ServerInvoker serverInvoker;
/*  56 */   private boolean isConnected = false;
/*  57 */   private boolean byValue = false;
/*     */ 
/*     */   public LocalClientInvoker(InvokerLocator locator)
/*     */   {
/*  61 */     super(locator);
/*     */   }
/*     */ 
/*     */   public LocalClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  66 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   public LocalClientInvoker(InvokerLocator locator, Map configuration, boolean byValue)
/*     */   {
/*  71 */     super(locator, configuration);
/*  72 */     this.byValue = byValue;
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocation)
/*     */     throws Throwable
/*     */   {
/*  84 */     if (log.isTraceEnabled())
/*     */     {
/*  86 */       log.trace("Using local client invoker for invocation.");
/*     */     }
/*     */ 
/*  89 */     InvocationRequest localInvocation = invocation;
/*     */ 
/*  91 */     if (this.byValue)
/*     */     {
/*  93 */       localInvocation = marshallInvocation(localInvocation);
/*     */     }
/*     */ 
/*  96 */     Object ret = null;
/*  97 */     if (this.serverInvoker != null)
/*     */     {
/*     */       try
/*     */       {
/* 101 */         ret = this.serverInvoker.invoke(localInvocation);
/*     */       }
/*     */       catch (ServerInvoker.InvalidStateException invalidStateEx)
/*     */       {
/* 105 */         if (log.isTraceEnabled())
/*     */         {
/* 107 */           log.trace("Error calling on " + this.serverInvoker + " because is in invalid state.  Will retry with new server invoker.");
/*     */         }
/*     */ 
/* 110 */         ServerInvoker newServerInvoker = null;
/*     */ 
/* 113 */         ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
/* 114 */         if (invokers != null)
/*     */         {
/* 116 */           for (int x = 0; x < invokers.length; x++)
/*     */           {
/* 118 */             ServerInvoker svrinvoker = invokers[x];
/* 119 */             InvokerLocator svrlocator = svrinvoker.getLocator();
/* 120 */             if (!getLocator().equals(svrlocator))
/*     */               continue;
/* 122 */             newServerInvoker = svrinvoker;
/* 123 */             break;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 128 */         if (newServerInvoker != null)
/*     */         {
/* 130 */           this.serverInvoker = newServerInvoker;
/* 131 */           ret = this.serverInvoker.invoke(localInvocation);
/*     */         }
/*     */         else
/*     */         {
/* 135 */           throw invalidStateEx;
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 141 */       throw new ConnectionFailedException("Error invoking on server because no local server to call upon.");
/*     */     }
/*     */ 
/* 145 */     return ret;
/*     */   }
/*     */ 
/*     */   protected InvocationRequest marshallInvocation(InvocationRequest localInvocation) throws IOException, ClassNotFoundException
/*     */   {
/* 150 */     Object param = localInvocation.getParameter();
/* 151 */     Object newParam = SerializationStreamFactory.getManagerInstance(getSerializationType()).createMarshalledValueForClone(param).get();
/* 152 */     localInvocation.setParameter(newParam);
/* 153 */     return localInvocation;
/*     */   }
/*     */ 
/*     */   public boolean isConnected()
/*     */   {
/* 166 */     return this.isConnected;
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws ConnectionFailedException
/*     */   {
/* 176 */     this.isConnected = true;
/*     */   }
/*     */ 
/*     */   public void disconnect()
/*     */   {
/* 186 */     this.isConnected = false;
/*     */   }
/*     */ 
/*     */   public void setMarshaller(Marshaller marshaller)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Marshaller getMarshaller()
/*     */   {
/* 196 */     return null;
/*     */   }
/*     */ 
/*     */   public void setUnMarshaller(UnMarshaller unmarshaller)
/*     */   {
/*     */   }
/*     */ 
/*     */   public UnMarshaller getUnMarshaller()
/*     */   {
/* 206 */     return null;
/*     */   }
/*     */ 
/*     */   public void establishLease(String sessionID, Map configuration, long leasePeriod)
/*     */     throws Throwable
/*     */   {
/*     */   }
/*     */ 
/*     */   public void terminateLease(String sessionId, int disconnectTimeout)
/*     */   {
/*     */   }
/*     */ 
/*     */   public long getLeasePeriod(String sessionID)
/*     */   {
/* 221 */     return -1L;
/*     */   }
/*     */ 
/*     */   public void setServerInvoker(ServerInvoker svrInvoker)
/*     */   {
/* 232 */     this.serverInvoker = svrInvoker;
/*     */   }
/*     */ 
/*     */   public InvokerLocator getCallbackLocator(Map metadata)
/*     */   {
/* 237 */     String transport = (String)metadata.get("callbackServerProtocol");
/* 238 */     String host = (String)metadata.get("callbackServerHost");
/* 239 */     String sPort = (String)metadata.get("callbackServerPort");
/* 240 */     int port = -1;
/* 241 */     if (sPort != null)
/*     */     {
/*     */       try
/*     */       {
/* 245 */         port = Integer.parseInt(sPort);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 249 */         throw new RuntimeException("Can not set internal callback server port as configuration value (" + sPort + " is not a number.");
/*     */       }
/*     */     }
/*     */ 
/* 253 */     return new InvokerLocator(transport, host, port, "callback", metadata);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.local.LocalClientInvoker
 * JD-Core Version:    0.6.0
 */