/*     */ package org.jboss.remoting.transport.http;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.FilterInputStream;
/*     */ import java.io.FilterOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketException;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerInvocationHandler;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import org.apache.commons.httpclient.Header;
/*     */ import org.apache.commons.httpclient.HeaderElement;
/*     */ import org.apache.commons.httpclient.HttpException;
/*     */ import org.apache.commons.httpclient.HttpParser;
/*     */ import org.apache.commons.httpclient.NameValuePair;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.transport.web.WebServerInvoker;
/*     */ import org.jboss.remoting.transport.web.WebUtil;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.BlockingMode;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ import org.jboss.util.threadpool.ThreadPoolMBean;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class HTTPServerInvoker extends WebServerInvoker
/*     */   implements Runnable
/*     */ {
/*  78 */   private static final Logger log = Logger.getLogger(HTTPServerInvoker.class);
/*     */   public static final String MAX_NUM_HTTP_THREADS_KEY = "maxNumThreadsHTTP";
/*     */   public static final String HTTP_THREAD_POOL_CLASS_KEY = "HTTPThreadPool";
/*     */   public static final String HTTP_KEEP_ALIVE_TIMEOUT_KEY = "keepAliveTimeout";
/*  84 */   private String httpThreadPoolClass = null;
/*     */ 
/*  86 */   private static int BACKLOG_DEFAULT = 1000;
/*  87 */   private static int MAX_POOL_SIZE_DEFAULT = 100;
/*     */ 
/*  89 */   private ServerSocket serverSocket = null;
/*     */ 
/*  91 */   private boolean running = false;
/*     */   private ThreadPool httpThreadPool;
/*  94 */   private int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
/*     */ 
/*  96 */   protected int backlog = BACKLOG_DEFAULT;
/*     */ 
/*  98 */   protected int keepAliveTimeout = 15000;
/*     */ 
/* 100 */   private boolean newServerSocketFactory = false;
/*     */ 
/* 103 */   public static String HTML = "text/html";
/* 104 */   public static String PLAIN = "text/plain";
/* 105 */   public static String SOAP = "application/soap+xml";
/*     */ 
/*     */   public HTTPServerInvoker(InvokerLocator locator)
/*     */   {
/* 109 */     super(locator);
/*     */   }
/*     */ 
/*     */   public HTTPServerInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 114 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   public int getKeepAliveTimeout()
/*     */   {
/* 119 */     return this.keepAliveTimeout;
/*     */   }
/*     */ 
/*     */   public void setKeepAliveTimeout(int keepAliveTimeout)
/*     */   {
/* 124 */     this.keepAliveTimeout = keepAliveTimeout;
/*     */   }
/*     */ 
/*     */   public void setNewServerSocketFactory(ServerSocketFactory serverSocketFactory) {
/* 128 */     this.newServerSocketFactory = true;
/* 129 */     setServerSocketFactory(serverSocketFactory);
/*     */   }
/*     */ 
/*     */   private void refreshServerSocket() throws IOException {
/* 133 */     this.newServerSocketFactory = false;
/* 134 */     this.serverSocket.close();
/* 135 */     this.serverSocket = null;
/* 136 */     InetAddress bindAddress = InetAddress.getByName(getServerBindAddress());
/* 137 */     this.serverSocket = createServerSocket(getServerBindPort(), this.backlog, bindAddress);
/*     */   }
/*     */ 
/*     */   protected void setup() throws Exception
/*     */   {
/* 142 */     super.setup();
/*     */ 
/* 144 */     Map config = getConfiguration();
/* 145 */     String maxNumOfThreads = (String)config.get("maxNumThreadsHTTP");
/* 146 */     if ((maxNumOfThreads != null) && (maxNumOfThreads.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 150 */         this.maxPoolSize = Integer.parseInt(maxNumOfThreads);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 154 */         log.error("Can not convert max number of threads value (" + maxNumOfThreads + ") into a number.");
/*     */       }
/*     */     }
/* 157 */     this.httpThreadPoolClass = ((String)config.get("HTTPThreadPool"));
/*     */ 
/* 159 */     String keepAliveTimeoutValue = (String)config.get("keepAliveTimeout");
/* 160 */     if ((keepAliveTimeoutValue != null) && (keepAliveTimeoutValue.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 164 */         this.keepAliveTimeout = Integer.parseInt(keepAliveTimeoutValue);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 168 */         log.error("Can not convert keep alive timeout value (" + keepAliveTimeoutValue + ") into a number.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMaxNumberOfHTTPThreads(int numOfThreads)
/*     */   {
/* 176 */     this.maxPoolSize = numOfThreads;
/*     */   }
/*     */ 
/*     */   public int getMaxNumberOfHTTPThreads()
/*     */   {
/* 181 */     return this.maxPoolSize;
/*     */   }
/*     */ 
/*     */   public ThreadPool getHTTPThreadPool()
/*     */   {
/* 186 */     if (this.httpThreadPool == null)
/*     */     {
/* 189 */       if ((this.httpThreadPoolClass == null) || (this.httpThreadPoolClass.length() == 0))
/*     */       {
/* 191 */         BasicThreadPool basicthreadpool = new BasicThreadPool("JBossRemoting - HTTP Server Invoker");
/* 192 */         basicthreadpool.setBlockingMode(BlockingMode.RUN);
/* 193 */         basicthreadpool.setMaximumPoolSize(this.maxPoolSize);
/* 194 */         this.httpThreadPool = basicthreadpool;
/*     */       }
/*     */       else
/*     */       {
/* 199 */         boolean isObjName = false;
/*     */         try
/*     */         {
/* 202 */           ObjectName objName = new ObjectName(this.httpThreadPoolClass);
/* 203 */           this.httpThreadPool = createThreadPoolProxy(objName);
/* 204 */           isObjName = true;
/*     */         }
/*     */         catch (MalformedObjectNameException e)
/*     */         {
/* 208 */           log.debug("Thread pool class supplied is not an object name.");
/*     */         }
/*     */ 
/* 211 */         if (!isObjName)
/*     */         {
/*     */           try
/*     */           {
/* 215 */             this.httpThreadPool = ((ThreadPool)Class.forName(this.httpThreadPoolClass, false, getClassLoader()).newInstance());
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 219 */             throw new RuntimeException("Error loading instance of ThreadPool based on class name: " + this.httpThreadPoolClass);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 224 */     return this.httpThreadPool;
/*     */   }
/*     */ 
/*     */   private ThreadPool createThreadPoolProxy(ObjectName objName)
/*     */   {
/* 230 */     MBeanServer server = getMBeanServer();
/*     */     ThreadPool pool;
/* 231 */     if (server != null)
/*     */     {
/* 233 */       ThreadPoolMBean poolMBean = (ThreadPoolMBean)MBeanServerInvocationHandler.newProxyInstance(server, objName, ThreadPoolMBean.class, false);
/*     */ 
/* 238 */       pool = poolMBean.getInstance();
/*     */     }
/*     */     else
/*     */     {
/* 242 */       throw new RuntimeException("Can not register MBean ThreadPool as the ServerInvoker has not been registered with a MBeanServer.");
/*     */     }
/*     */     ThreadPool pool;
/* 244 */     return pool;
/*     */   }
/*     */ 
/*     */   public void setHTTPThreadPool(ThreadPool pool)
/*     */   {
/* 250 */     this.httpThreadPool = pool;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws IOException
/*     */   {
/* 256 */     if (!this.running)
/*     */     {
/*     */       try
/*     */       {
/* 260 */         ThreadPool httpThreadPool = getHTTPThreadPool();
/* 261 */         InetAddress bindAddress = InetAddress.getByName(getServerBindAddress());
/* 262 */         this.serverSocket = createServerSocket(getServerBindPort(), this.backlog, bindAddress);
/*     */ 
/* 265 */         for (int t = 0; t < this.maxPoolSize; t++)
/*     */         {
/* 267 */           httpThreadPool.run(this);
/*     */         }
/*     */ 
/* 270 */         this.running = true;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 275 */         log.error("Error starting ServerSocket.  Bind port: " + getServerBindPort() + ", bind address: " + getServerBindAddress());
/* 276 */         throw e;
/*     */       }
/*     */     }
/* 279 */     super.start();
/*     */   }
/*     */ 
/*     */   protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException
/*     */   {
/* 284 */     return new ServerSocket(serverBindPort, backlog, bindAddress);
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/* 291 */       if (this.newServerSocketFactory) {
/* 292 */         log.debug("got notice about new ServerSocketFactory");
/*     */         try {
/* 294 */           log.debug("refreshing server socket");
/* 295 */           refreshServerSocket();
/*     */         } catch (IOException e) {
/* 297 */           log.debug("could not refresh server socket");
/* 298 */           log.debug("message is: " + e.getMessage());
/*     */         }
/* 300 */         log.debug("server socket refreshed");
/*     */       }
/*     */ 
/* 303 */       Socket socket = this.serverSocket.accept();
/* 304 */       BufferedInputStream dataInput = null;
/* 305 */       BufferedOutputStream dataOutput = null;
/*     */ 
/* 307 */       if (socket != null)
/*     */       {
/* 310 */         this.httpThreadPool.run(this);
/*     */         try
/*     */         {
/* 315 */           boolean keepAlive = true;
/*     */ 
/* 318 */           socket.setKeepAlive(true);
/* 319 */           socket.setSoTimeout(this.keepAliveTimeout);
/*     */ 
/* 321 */           DataInputStream realdataInput = new DataInputStream(socket.getInputStream());
/* 322 */           DataOutputStream realdataOutput = new DataOutputStream(socket.getOutputStream());
/*     */ 
/* 324 */           while (keepAlive)
/*     */           {
/* 326 */             dataOutput = new BufferedOutputStream(realdataOutput, 512);
/* 327 */             dataInput = new BufferedInputStream(realdataInput, 512);
/* 328 */             keepAlive = processRequest(dataInput, dataOutput);
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Throwable thr)
/*     */         {
/* 334 */           if (this.running)
/*     */           {
/* 336 */             log.error("Error processing incoming request.", thr);
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 341 */           if (dataInput != null)
/*     */           {
/*     */             try
/*     */             {
/* 345 */               dataInput.close();
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 349 */               log.warn("Error closing resource.", e);
/*     */             }
/*     */           }
/* 352 */           if (dataOutput != null)
/*     */           {
/*     */             try
/*     */             {
/* 356 */               dataOutput.close();
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 360 */               log.warn("Error closing resource.", e);
/*     */             }
/*     */           }
/*     */           try
/*     */           {
/* 365 */             socket.close();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 369 */             log.warn("Error closing resource.", e);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable thr)
/*     */     {
/* 376 */       if (this.running)
/*     */       {
/* 378 */         log.error("Error processing incoming request.", thr);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 385 */     if (this.running)
/*     */     {
/* 387 */       this.running = false;
/*     */ 
/* 389 */       this.maxPoolSize = 0;
/*     */       try
/*     */       {
/* 393 */         this.httpThreadPool.stop(false);
/* 394 */         this.httpThreadPool.waitForTasks(2000L);
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 398 */         log.error(e.getMessage(), e);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 403 */         if ((this.serverSocket != null) && (!this.serverSocket.isClosed()))
/*     */         {
/* 405 */           this.serverSocket.close();
/*     */         }
/* 407 */         this.serverSocket = null;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/* 413 */     super.stop();
/*     */ 
/* 415 */     log.debug("HTTPServerInvoker stopped.");
/*     */   }
/*     */ 
/*     */   private boolean processRequest(FilterInputStream dataInput, FilterOutputStream dataOutput)
/*     */   {
/* 420 */     boolean keepAlive = true;
/*     */     try
/*     */     {
/* 423 */       Object response = null;
/* 424 */       boolean isError = false;
/* 425 */       String requestContentType = null;
/* 426 */       String methodType = null;
/* 427 */       String path = null;
/* 428 */       String httpVersion = null;
/*     */ 
/* 430 */       InvocationRequest request = null;
/*     */       try
/*     */       {
/* 442 */         ByteArrayOutputStream buffer = new ByteArrayOutputStream();
/*     */         int ch;
/* 444 */         while ((ch = dataInput.read()) >= 0)
/*     */         {
/* 446 */           buffer.write(ch);
/* 447 */           if (ch != 10)
/*     */           {
/*     */             continue;
/*     */           }
/*     */         }
/*     */ 
/* 453 */         byte[] firstLineRaw = buffer.toByteArray();
/* 454 */         buffer.close();
/*     */ 
/* 456 */         if (firstLineRaw[(firstLineRaw.length - 2)] == 13)
/*     */         {
/* 459 */           String firstLine = new String(firstLineRaw).trim();
/* 460 */           int startIndex = 0;
/* 461 */           int endIndex = firstLine.indexOf(' ');
/* 462 */           methodType = firstLine.substring(startIndex, endIndex);
/* 463 */           startIndex = endIndex + 1;
/* 464 */           endIndex = firstLine.indexOf(' ', startIndex);
/* 465 */           path = firstLine.substring(startIndex, endIndex);
/* 466 */           startIndex = endIndex + 1;
/* 467 */           httpVersion = firstLine.substring(startIndex);
/*     */         }
/*     */         else
/*     */         {
/* 471 */           log.error("Error processing first line.  Should have ended in \r\n, but did not");
/* 472 */           throw new RuntimeException("Error processing HTTP request type.  First line of request is invalid.");
/*     */         }
/*     */ 
/* 475 */         Map metadata = new HashMap();
/* 476 */         Header[] headers = HttpParser.parseHeaders(dataInput);
/* 477 */         for (int x = 0; x < headers.length; x++)
/*     */         {
/* 479 */           String headerName = headers[x].getName();
/* 480 */           String headerValue = headers[x].getValue();
/* 481 */           metadata.put(headerName, headerValue);
/*     */ 
/* 483 */           if (!"Content-Type".equalsIgnoreCase(headerName))
/*     */             continue;
/* 485 */           requestContentType = headers[x].getValue();
/*     */         }
/*     */ 
/* 489 */         metadata.put("MethodType", methodType);
/* 490 */         metadata.put("Path", path);
/* 491 */         metadata.put("HttpVersion", httpVersion);
/*     */ 
/* 494 */         keepAlive = checkForConnecctionClose(headers);
/*     */ 
/* 497 */         if (methodType.equals("OPTIONS"))
/*     */         {
/* 499 */           request = createNewInvocationRequest(metadata, null);
/* 500 */           response = invoke(request);
/*     */ 
/* 502 */           Map responseMap = request.getReturnPayload();
/*     */ 
/* 504 */           dataOutput.write("HTTP/1.1 ".getBytes());
/* 505 */           String status = "200 OK";
/* 506 */           dataOutput.write(status.getBytes());
/* 507 */           String server = "\r\nServer: JBoss Remoting HTTP Server/2.2.2.SP3 (Bluto)";
/* 508 */           dataOutput.write(server.getBytes());
/* 509 */           String date = "\r\nDate: " + new Date();
/* 510 */           dataOutput.write(date.getBytes());
/* 511 */           String contentLength = "\r\nContent-Length: 0";
/* 512 */           dataOutput.write(contentLength.getBytes());
/*     */ 
/* 514 */           if (responseMap != null)
/*     */           {
/* 516 */             Set entries = responseMap.entrySet();
/* 517 */             Iterator itr = entries.iterator();
/* 518 */             while (itr.hasNext())
/*     */             {
/* 520 */               Map.Entry entry = (Map.Entry)itr.next();
/* 521 */               String entryString = "\r\n" + entry.getKey() + ": " + entry.getValue();
/* 522 */               dataOutput.write(entryString.getBytes());
/*     */             }
/*     */           }
/*     */ 
/* 526 */           String close = "\r\nConnection: close";
/* 527 */           dataOutput.write(close.getBytes());
/*     */ 
/* 530 */           dataOutput.write("\r\n\r\n".getBytes());
/*     */ 
/* 532 */           dataOutput.flush();
/*     */ 
/* 535 */           return keepAlive;
/*     */         }
/*     */ 
/* 538 */         if ((methodType.equals("GET")) || (methodType.equals("HEAD")))
/*     */         {
/* 540 */           request = createNewInvocationRequest(metadata, null);
/*     */         }
/*     */         else
/*     */         {
/* 544 */           UnMarshaller unmarshaller = getUnMarshaller();
/* 545 */           Object obj = unmarshaller.read(dataInput, metadata);
/*     */ 
/* 548 */           if ((obj instanceof InvocationRequest))
/*     */           {
/* 550 */             request = (InvocationRequest)obj;
/*     */           }
/* 554 */           else if (WebUtil.isBinary(requestContentType))
/*     */           {
/* 556 */             request = getInvocationRequest(metadata, obj);
/*     */           }
/*     */           else
/*     */           {
/* 560 */             request = createNewInvocationRequest(metadata, obj);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 568 */           response = invoke(request);
/*     */         }
/*     */         catch (Throwable ex)
/*     */         {
/* 572 */           log.debug("Error thrown calling invoke on server invoker.", ex);
/* 573 */           response = ex;
/* 574 */           isError = true;
/*     */         }
/*     */       }
/*     */       catch (Throwable thr)
/*     */       {
/* 579 */         log.debug("Error thrown processing request.  Probably error with processing headers.", thr);
/* 580 */         if ((thr instanceof SocketException))
/*     */         {
/* 582 */           log.error("Error processing on socket.", thr);
/* 583 */           keepAlive = false;
/* 584 */           return keepAlive;
/*     */         }
/* 586 */         if ((thr instanceof Exception))
/*     */         {
/* 588 */           response = (Exception)thr;
/*     */         }
/*     */         else
/*     */         {
/* 592 */           response = new Exception(thr);
/*     */         }
/* 594 */         isError = true;
/*     */       }
/*     */ 
/* 597 */       if (dataOutput != null)
/*     */       {
/* 600 */         Map responseMap = null;
/*     */ 
/* 602 */         if (request != null)
/*     */         {
/* 604 */           responseMap = request.getReturnPayload();
/*     */         }
/*     */ 
/* 607 */         if (response == null)
/*     */         {
/* 609 */           dataOutput.write("HTTP/1.1 ".getBytes());
/* 610 */           String status = "204 No Content";
/* 611 */           if (responseMap != null)
/*     */           {
/* 613 */             String handlerStatus = (String)responseMap.get("ResponseCode");
/* 614 */             if (handlerStatus != null)
/*     */             {
/* 616 */               status = handlerStatus;
/*     */             }
/*     */           }
/* 619 */           dataOutput.write(status.getBytes());
/* 620 */           String contentType = "\r\nContent-Type: text/html";
/* 621 */           dataOutput.write(contentType.getBytes());
/* 622 */           String contentLength = "\r\nContent-Length: 0";
/* 623 */           dataOutput.write(contentLength.getBytes());
/* 624 */           if (responseMap != null)
/*     */           {
/* 626 */             Set entries = responseMap.entrySet();
/* 627 */             Iterator itr = entries.iterator();
/* 628 */             while (itr.hasNext())
/*     */             {
/* 630 */               Map.Entry entry = (Map.Entry)itr.next();
/* 631 */               String entryString = "\r\n" + entry.getKey() + ": " + entry.getValue();
/* 632 */               dataOutput.write(entryString.getBytes());
/*     */             }
/*     */           }
/*     */ 
/* 636 */           dataOutput.write("\r\n\r\n".getBytes());
/*     */ 
/* 638 */           dataOutput.flush();
/*     */         }
/*     */         else
/*     */         {
/* 642 */           dataOutput.write("HTTP/1.1 ".getBytes());
/* 643 */           String status = null;
/* 644 */           if (isError)
/*     */           {
/* 646 */             status = "500 JBoss Remoting: Error occurred within target application.";
/*     */           }
/*     */           else
/*     */           {
/* 650 */             status = "200 OK";
/* 651 */             if (responseMap != null)
/*     */             {
/* 653 */               String handlerStatus = (String)responseMap.get("ResponseCode");
/* 654 */               if (handlerStatus != null)
/*     */               {
/* 656 */                 status = handlerStatus;
/*     */               }
/*     */             }
/*     */           }
/*     */ 
/* 661 */           dataOutput.write(status.getBytes());
/*     */ 
/* 664 */           String contentType = "\r\nContent-Type: " + requestContentType;
/* 665 */           dataOutput.write(contentType.getBytes());
/* 666 */           int iContentLength = getContentLength(response);
/* 667 */           String contentLength = "\r\nContent-Length: " + iContentLength;
/* 668 */           dataOutput.write(contentLength.getBytes());
/*     */ 
/* 670 */           if (responseMap != null)
/*     */           {
/* 672 */             Set entries = responseMap.entrySet();
/* 673 */             Iterator itr = entries.iterator();
/* 674 */             while (itr.hasNext())
/*     */             {
/* 676 */               Map.Entry entry = (Map.Entry)itr.next();
/* 677 */               String entryString = "\r\n" + entry.getKey() + ": " + entry.getValue();
/* 678 */               dataOutput.write(entryString.getBytes());
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 683 */           dataOutput.write("\r\n\r\n".getBytes());
/*     */ 
/* 685 */           if ((methodType != null) && (!methodType.equals("HEAD")))
/*     */           {
/* 688 */             Marshaller marshaller = getMarshaller();
/* 689 */             marshaller.write(response, dataOutput);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 695 */       else if (isError)
/*     */       {
/* 697 */         log.warn("Can not send error response due to output stream being null (due to previous error).");
/*     */       }
/*     */       else
/*     */       {
/* 701 */         log.error("Can not send response due to output stream being null (even though there was not a previous error encountered).");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 707 */       log.error("Error processing client request.", e);
/* 708 */       keepAlive = false;
/*     */     }
/*     */ 
/* 711 */     return keepAlive;
/*     */   }
/*     */ 
/*     */   private boolean checkForConnecctionClose(Header[] headers)
/*     */   {
/* 716 */     boolean keepAlive = true;
/*     */ 
/* 718 */     if (headers != null)
/*     */     {
/* 720 */       for (int x = 0; x < headers.length; x++)
/*     */       {
/* 722 */         String name = headers[x].getName();
/* 723 */         if (!"Connection".equals(name))
/*     */           continue;
/* 725 */         String value = headers[x].getValue();
/* 726 */         if (value != null)
/*     */         {
/* 728 */           if (!"close".equalsIgnoreCase(value))
/*     */             continue;
/* 730 */           keepAlive = false;
/* 731 */           break;
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 738 */           HeaderElement[] hdrElements = headers[x].getValues();
/* 739 */           if (hdrElements != null)
/*     */           {
/* 741 */             for (int i = 0; i < hdrElements.length; i++)
/*     */             {
/* 743 */               NameValuePair pair = hdrElements[i].getParameterByName("Connection");
/* 744 */               if (!"close".equalsIgnoreCase(pair.getValue()))
/*     */                 continue;
/* 746 */               keepAlive = false;
/* 747 */               break;
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (HttpException e)
/*     */         {
/* 754 */           log.error(e.getMessage(), e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 761 */     return keepAlive;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.http.HTTPServerInvoker
 * JD-Core Version:    0.6.0
 */