/*     */ package org.jboss.remoting.transport.http;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.HttpURLConnection;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.SocketAddress;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.CannotConnectException;
/*     */ import org.jboss.remoting.ConnectionFailedException;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvocationResponse;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.RemoteClientInvoker;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.marshal.compress.CompressingUnMarshaller;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ import org.jboss.remoting.transport.servlet.ServletThrowable;
/*     */ import org.jboss.remoting.transport.web.WebUtil;
/*     */ import org.jboss.util.Base64;
/*     */ import org.jboss.util.threadpool.BasicThreadPool;
/*     */ import org.jboss.util.threadpool.BlockingMode;
/*     */ import org.jboss.util.threadpool.RunnableTaskWrapper;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ 
/*     */ public class HTTPClientInvoker extends RemoteClientInvoker
/*     */ {
/*     */   public static final String MAX_NUM_TIMEOUT_THREADS = "maxNumTimeoutThreads";
/*     */   public static final String MAX_TIMEOUT_QUEUE_SIZE = "maxTimeoutQueueSize";
/*     */   public static final int MAX_NUM_TIMEOUT_THREADS_DEFAULT = 10;
/*  94 */   protected static final Logger log = Logger.getLogger(HTTPClientInvoker.class);
/*     */ 
/*  96 */   private Object timeoutThreadPoolLock = new Object();
/*     */   private ThreadPool timeoutThreadPool;
/*     */ 
/*     */   public HTTPClientInvoker(InvokerLocator locator)
/*     */   {
/* 101 */     super(locator);
/*     */   }
/*     */ 
/*     */   public HTTPClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 106 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller)
/*     */     throws IOException, ConnectionFailedException
/*     */   {
/* 123 */     String validatedUrl = validateURL(getLocator().getLocatorURI());
/*     */ 
/* 125 */     if (metadata == null)
/*     */     {
/* 127 */       metadata = new HashMap();
/*     */     }
/*     */ 
/* 130 */     HttpURLConnection conn = createURLConnection(validatedUrl, metadata);
/*     */ 
/* 132 */     int simulatedTimeout = getSimulatedTimeout(this.configuration, metadata, conn);
/*     */ 
/* 134 */     if (simulatedTimeout <= 0)
/*     */     {
/* 136 */       return useHttpURLConnection(conn, invocation, metadata, marshaller, unmarshaller);
/*     */     }
/*     */ 
/* 140 */     if (log.isTraceEnabled()) log.trace("using simulated timeout: " + simulatedTimeout);
/*     */ 
/* 142 */     1Holder resultHolder = new Object()
/*     */     {
/*     */       public Object value;
/*     */     };
/* 143 */     Map finalMetadata = metadata;
/*     */ 
/* 145 */     Runnable r = new Runnable(resultHolder, conn, invocation, finalMetadata, marshaller, unmarshaller) { private final HTTPClientInvoker.1Holder val$resultHolder;
/*     */       private final HttpURLConnection val$conn;
/*     */       private final Object val$invocation;
/*     */       private final Map val$finalMetadata;
/*     */       private final Marshaller val$marshaller;
/*     */       private final UnMarshaller val$unmarshaller;
/*     */ 
/*     */       public void run() { try { this.val$resultHolder.value = HTTPClientInvoker.this.useHttpURLConnection(this.val$conn, this.val$invocation, this.val$finalMetadata, this.val$marshaller, this.val$unmarshaller);
/* 152 */           if (HTTPClientInvoker.log.isTraceEnabled()) HTTPClientInvoker.log.trace("result: " + this.val$resultHolder.value);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 156 */           this.val$resultHolder.value = e;
/* 157 */           if (HTTPClientInvoker.log.isTraceEnabled()) HTTPClientInvoker.log.trace("exception: " + e);
/*     */         }
/*     */       }
/*     */     };
/* 164 */     Thread.interrupted();
/*     */ 
/* 166 */     ThreadPool pool = getTimeoutThreadPool();
/* 167 */     WaitingTaskWrapper wrapper = new WaitingTaskWrapper(r, simulatedTimeout);
/* 168 */     if (log.isTraceEnabled()) log.trace("starting task in thread pool");
/* 169 */     pool.runTaskWrapper(wrapper);
/* 170 */     if (log.isTraceEnabled()) log.trace("task finished in thread pool");
/*     */ 
/* 172 */     Object result = resultHolder.value;
/* 173 */     if (result == null)
/*     */     {
/* 175 */       if (log.isDebugEnabled()) log.debug("invocation timed out");
/* 176 */       Exception cause = new SocketTimeoutException("timed out");
/* 177 */       throw new CannotConnectException("Can not connect http client invoker.", cause);
/*     */     }
/* 179 */     if ((result instanceof IOException))
/*     */     {
/* 181 */       throw ((IOException)result);
/*     */     }
/* 183 */     if ((result instanceof RuntimeException))
/*     */     {
/* 185 */       throw ((RuntimeException)result);
/*     */     }
/*     */ 
/* 189 */     if (log.isTraceEnabled()) log.trace("returning result: " + result);
/* 190 */     return result;
/*     */   }
/*     */ 
/*     */   private Object useHttpURLConnection(HttpURLConnection conn, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller)
/*     */     throws WebServerError
/*     */   {
/* 198 */     Object result = null;
/* 199 */     int responseCode = -1;
/*     */     try
/*     */     {
/* 203 */       setChunked(this.configuration, conn);
/*     */ 
/* 206 */       String basicAuth = getBasicAuth(metadata);
/* 207 */       if (basicAuth != null)
/*     */       {
/* 209 */         conn.setRequestProperty("Authorization", basicAuth);
/*     */       }
/*     */ 
/* 213 */       result = checkForLeasePing(conn, invocation, metadata);
/* 214 */       if (result != null)
/*     */       {
/* 216 */         return result;
/*     */       }
/*     */ 
/* 221 */       boolean sendingData = true;
/* 222 */       String type = "POST";
/* 223 */       if (metadata != null)
/*     */       {
/* 225 */         type = (String)metadata.get("TYPE");
/* 226 */         if (type != null)
/*     */         {
/* 228 */           if ((!type.equals("POST")) && (!type.equals("PUT")))
/*     */           {
/* 230 */             sendingData = false;
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 235 */           type = "POST";
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 240 */         metadata = new HashMap();
/* 241 */         Map header = new HashMap();
/* 242 */         header.put("Content-Type", WebUtil.getContentType(invocation));
/* 243 */         metadata.put("HEADER", header);
/*     */       }
/*     */ 
/* 246 */       Map header = (Map)metadata.get("HEADER");
/* 247 */       if (header != null)
/*     */       {
/* 249 */         Set keys = header.keySet();
/* 250 */         Iterator itr = keys.iterator();
/* 251 */         while (itr.hasNext())
/*     */         {
/* 253 */           String key = (String)itr.next();
/* 254 */           String value = (String)header.get(key);
/* 255 */           log.debug("Setting request header with " + key + " : " + value);
/* 256 */           conn.setRequestProperty(key, value);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 261 */         conn.setRequestProperty("Content-Type", WebUtil.getContentType(invocation));
/*     */       }
/*     */ 
/* 265 */       conn.setRequestProperty("JBoss-Remoting-Version", new Integer(Version.getDefaultVersion()).toString());
/*     */ 
/* 267 */       conn.setRequestProperty("User-Agent", "JBossRemoting - 2.2.2.SP3 (Bluto)");
/*     */ 
/* 269 */       if (sendingData)
/*     */       {
/* 272 */         conn.setDoOutput(true);
/* 273 */         conn.setDoInput(true);
/* 274 */         conn.setRequestMethod(type);
/*     */ 
/* 276 */         OutputStream stream = conn.getOutputStream();
/* 277 */         if ((marshaller instanceof VersionedMarshaller))
/* 278 */           ((VersionedMarshaller)marshaller).write(invocation, stream, Version.getDefaultVersion());
/*     */         else
/* 280 */           marshaller.write(invocation, stream);
/* 281 */         responseCode = conn.getResponseCode();
/* 282 */         InputStream is = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
/* 283 */         Map headers = conn.getHeaderFields();
/* 284 */         if (metadata == null)
/*     */         {
/* 286 */           metadata = new HashMap();
/*     */         }
/*     */         Iterator i;
/* 291 */         if (headers != null)
/*     */         {
/* 293 */           for (i = headers.entrySet().iterator(); i.hasNext(); )
/*     */           {
/* 295 */             Map.Entry e = (Map.Entry)i.next();
/* 296 */             if (e.getKey() != null)
/*     */             {
/* 298 */               metadata.put(e.getKey(), e.getValue());
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 303 */         metadata.put("ResponseCodeMessage", conn.getResponseMessage());
/* 304 */         metadata.put("ResponseCode", new Integer(responseCode));
/*     */ 
/* 306 */         result = readResponse(metadata, headers, unmarshaller, is);
/*     */       }
/*     */       else
/*     */       {
/* 310 */         conn.setDoOutput(false);
/* 311 */         conn.setDoInput(true);
/* 312 */         conn.setRequestMethod(type);
/*     */ 
/* 314 */         conn.connect();
/*     */ 
/* 316 */         InputStream is = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
/* 317 */         Map headers = conn.getHeaderFields();
/*     */ 
/* 319 */         result = readResponse(null, headers, unmarshaller, is);
/*     */ 
/* 321 */         if (metadata == null)
/*     */         {
/* 323 */           metadata = new HashMap();
/*     */         }
/* 325 */         metadata.putAll(headers);
/* 326 */         metadata.put("ResponseCodeMessage", conn.getResponseMessage());
/* 327 */         responseCode = conn.getResponseCode();
/* 328 */         metadata.put("ResponseCode", new Integer(responseCode));
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 333 */       log.debug("Error invoking http client invoker.", e);
/* 334 */       throw new CannotConnectException("Can not connect http client invoker.", e);
/*     */     }
/*     */ 
/* 338 */     if ((responseCode >= 400) || (("servlet".equals(getLocator().getProtocol())) && ((result instanceof InvocationResponse)) && ((((InvocationResponse)result).getResult() instanceof ServletThrowable))))
/*     */     {
/* 343 */       if (metadata != null)
/*     */       {
/* 345 */         Object configObj = metadata.get("NoThrowOnError");
/* 346 */         if ((configObj != null) && ((configObj instanceof String)))
/*     */         {
/* 348 */           boolean doNotThrow = Boolean.valueOf((String)configObj).booleanValue();
/* 349 */           if (doNotThrow)
/*     */           {
/* 351 */             if ((result instanceof String))
/*     */             {
/* 354 */               WebServerError ex = new WebServerError((String)result);
/* 355 */               return ex;
/*     */             }
/* 357 */             if ((result instanceof InvocationResponse))
/*     */             {
/* 359 */               InvocationResponse response = (InvocationResponse)result;
/* 360 */               Object innerResult = response.getResult();
/* 361 */               if ((innerResult instanceof ServletThrowable))
/*     */               {
/* 363 */                 return ((ServletThrowable)innerResult).getCause();
/*     */               }
/*     */ 
/* 367 */               return innerResult;
/*     */             }
/*     */ 
/* 372 */             return result;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 383 */       if ((result instanceof InvocationResponse))
/*     */       {
/* 385 */         if ((((InvocationResponse)result).getResult() instanceof ServletThrowable))
/*     */         {
/* 387 */           InvocationResponse response = (InvocationResponse)result;
/* 388 */           ServletThrowable st = (ServletThrowable)response.getResult();
/* 389 */           Throwable t = st.getCause();
/* 390 */           InvocationResponse ir = new InvocationResponse(response.getSessionId(), t, response.isException(), response.getPayload());
/*     */ 
/* 394 */           return ir;
/*     */         }
/*     */ 
/* 398 */         return result;
/*     */       }
/*     */ 
/* 403 */       if ((result instanceof String))
/*     */       {
/* 405 */         WebServerError ex = new WebServerError((String)result);
/* 406 */         throw ex;
/*     */       }
/*     */ 
/* 410 */       WebServerError ex = new WebServerError("Error received when calling on web server.  Error returned was " + responseCode);
/* 411 */       throw ex;
/*     */     }
/*     */ 
/* 416 */     return result;
/*     */   }
/*     */ 
/*     */   private Object checkForLeasePing(HttpURLConnection conn, Object invocation, Map metadata) throws IOException
/*     */   {
/* 421 */     InvocationResponse response = null;
/* 422 */     boolean shouldLease = false;
/* 423 */     long leasePeriod = -1L;
/*     */ 
/* 425 */     if ((invocation != null) && ((invocation instanceof InvocationRequest)))
/*     */     {
/* 427 */       InvocationRequest request = (InvocationRequest)invocation;
/*     */ 
/* 429 */       Object payload = request.getParameter();
/*     */ 
/* 431 */       if ((payload != null) && ((payload instanceof String)) && ("$PING$".equalsIgnoreCase((String)payload)) && (request.getReturnPayload() != null))
/*     */       {
/*     */         try
/*     */         {
/* 436 */           conn.setDoOutput(false);
/* 437 */           conn.setDoInput(true);
/* 438 */           conn.setRequestMethod("HEAD");
/*     */ 
/* 440 */           conn.setRequestProperty("JBoss-Remoting-Version", new Integer(Version.getDefaultVersion()).toString());
/*     */ 
/* 442 */           conn.setRequestProperty("User-Agent", "JBossRemoting - 2.2.2.SP3 (Bluto)");
/* 443 */           conn.setRequestProperty("JBoss-Remoting-Lease-Query", "true");
/* 444 */           conn.setRequestProperty("sessionId", request.getSessionId());
/* 445 */           conn.connect();
/*     */ 
/* 448 */           Map headers = conn.getHeaderFields();
/*     */ 
/* 450 */           if (headers != null)
/*     */           {
/* 452 */             Object leasingEnabled = headers.get("LEASING_ENABLED");
/* 453 */             if ((leasingEnabled != null) && ((leasingEnabled instanceof List)))
/*     */             {
/* 455 */               shouldLease = new Boolean((String)((List)leasingEnabled).get(0)).booleanValue();
/*     */             }
/* 457 */             Object leasingPeriod = headers.get("LEASE_PERIOD");
/* 458 */             if ((leasingPeriod != null) && ((leasingPeriod instanceof List)))
/*     */             {
/* 460 */               leasePeriod = new Long((String)((List)leasingPeriod).get(0)).longValue();
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 466 */           log.error("Error checking server for lease information.", e);
/*     */         }
/*     */ 
/* 469 */         Map p = new HashMap();
/* 470 */         p.put("clientLeasePeriod", new Long(leasePeriod));
/* 471 */         InvocationResponse innterResponse = new InvocationResponse(null, new Boolean(shouldLease), false, p);
/* 472 */         response = new InvocationResponse(null, innterResponse, false, null);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 477 */     return response;
/*     */   }
/*     */ 
/*     */   private Object readResponse(Map metadata, Map headers, UnMarshaller unmarshaller, InputStream is)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 484 */     String encoding = null;
/* 485 */     Object ceObj = headers.get("Content-Encoding");
/* 486 */     if (ceObj != null)
/*     */     {
/* 488 */       if ((ceObj instanceof List))
/*     */       {
/* 490 */         encoding = (String)((List)ceObj).get(0);
/*     */       }
/*     */     }
/* 493 */     if ((encoding != null) && (encoding.indexOf("gzip") >= 0))
/*     */     {
/* 495 */       unmarshaller = new CompressingUnMarshaller(MarshalFactory.getUnMarshaller("serializable"));
/*     */     }
/*     */ 
/* 498 */     Map map = metadata == null ? headers : metadata;
/*     */     Object result;
/*     */     Object result;
/* 499 */     if ((unmarshaller instanceof VersionedUnMarshaller))
/* 500 */       result = ((VersionedUnMarshaller)unmarshaller).read(is, map, Version.getDefaultVersion());
/*     */     else {
/* 502 */       result = unmarshaller.read(is, map);
/*     */     }
/* 504 */     return result;
/*     */   }
/*     */ 
/*     */   private void setChunked(Map metadata, HttpURLConnection conn)
/*     */   {
/* 509 */     String chunkedValue = (String)metadata.get("chunkedLength");
/* 510 */     if ((chunkedValue != null) && (chunkedValue.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 514 */         int chunkedLength = Integer.parseInt(chunkedValue);
/*     */         try
/*     */         {
/* 522 */           Method setChunkedLengthMethod = conn.getClass().getMethod("setChunkedStreamingMode", new Class[] { Integer.TYPE });
/* 523 */           setChunkedLengthMethod.invoke(conn, new Object[] { new Integer(chunkedLength) });
/*     */         }
/*     */         catch (NoSuchMethodException e)
/*     */         {
/* 527 */           log.warn("Could not set chunked length (" + chunkedLength + ") on http client transport as method not available with JDK 1.4 (only JDK 1.5 or higher)");
/*     */         }
/*     */         catch (IllegalAccessException e)
/*     */         {
/* 531 */           log.error("Error setting http client connection chunked length.");
/* 532 */           log.debug(e);
/*     */         }
/*     */         catch (InvocationTargetException e)
/*     */         {
/* 536 */           log.error("Error setting http client connection chunked length.");
/* 537 */           log.debug(e);
/*     */         }
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 542 */         log.error("Could not set chunked length for http client connection because value (" + chunkedValue + ") is not a number.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private int getSimulatedTimeout(Map configuration, Map metadata, HttpURLConnection conn)
/*     */   {
/* 552 */     int timeout = -1;
/* 553 */     String connectionTimeout = (String)configuration.get("timeout");
/* 554 */     String invocationTimeout = (String)metadata.get("timeout");
/*     */ 
/* 556 */     if ((invocationTimeout != null) && (invocationTimeout.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 560 */         timeout = Integer.parseInt(invocationTimeout);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 564 */         log.error("Could not set timeout for current invocation because value (" + invocationTimeout + ") is not a number.");
/*     */       }
/*     */     }
/*     */ 
/* 568 */     if ((timeout < 0) && (connectionTimeout != null) && (connectionTimeout.length() > 0))
/*     */     {
/*     */       try
/*     */       {
/* 572 */         timeout = Integer.parseInt(connectionTimeout);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 576 */         log.error("Could not set timeout for http client connection because value (" + connectionTimeout + ") is not a number.");
/*     */       }
/*     */     }
/*     */ 
/* 580 */     if (timeout < 0) {
/* 581 */       timeout = 0;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 590 */       Method setTimeoutMethod = conn.getClass().getMethod("setConnectTimeout", new Class[] { Integer.TYPE });
/* 591 */       setTimeoutMethod.invoke(conn, new Object[] { new Integer(timeout) });
/* 592 */       setTimeoutMethod = conn.getClass().getMethod("setReadTimeout", new Class[] { Integer.TYPE });
/* 593 */       setTimeoutMethod.invoke(conn, new Object[] { new Integer(timeout) });
/* 594 */       return -1;
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 598 */       log.debug("Using older JDK (prior to 1.5): will simulate timeout");
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 602 */       log.error("Error setting http client connection timeout.");
/* 603 */       log.debug(e);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 607 */       log.error("Error setting http client connection timeout.");
/* 608 */       log.debug(e);
/*     */     }
/*     */ 
/* 611 */     return timeout;
/*     */   }
/*     */ 
/*     */   protected String validateURL(String url)
/*     */   {
/* 616 */     String validatedUrl = url;
/*     */ 
/* 618 */     if (validatedUrl.startsWith("servlet"))
/*     */     {
/* 621 */       validatedUrl = "http" + validatedUrl.substring("servlet".length());
/*     */     }
/* 623 */     return validatedUrl;
/*     */   }
/*     */ 
/*     */   protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException
/*     */   {
/* 628 */     URL externalURL = null;
/* 629 */     HttpURLConnection httpURLConn = null;
/*     */ 
/* 632 */     String proxyHost = null;
/* 633 */     String proxyportString = null;
/* 634 */     int proxyPort = 80;
/*     */ 
/* 636 */     if (metadata != null)
/*     */     {
/* 639 */       proxyHost = (String)metadata.get("http.proxyHost");
/* 640 */       proxyportString = (String)metadata.get("http.proxyPort");
/* 641 */       if ((proxyportString != null) && (proxyportString.length() > 0))
/*     */       {
/*     */         try
/*     */         {
/* 645 */           proxyPort = Integer.parseInt(proxyportString);
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 649 */           log.warn("Error converting proxy port specified (" + proxyportString + ") to a number.");
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 655 */     if (proxyHost != null)
/*     */     {
/* 657 */       externalURL = new URL(url);
/*     */       try
/*     */       {
/* 665 */         Class proxyClass = ClassLoaderUtility.loadClass("java.net.Proxy", HTTPClientInvoker.class);
/* 666 */         InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
/* 667 */         Class[] decalredClasses = proxyClass.getDeclaredClasses();
/* 668 */         Class proxyTypeClass = null;
/* 669 */         for (int x = 0; x < decalredClasses.length; x++)
/*     */         {
/* 671 */           Class declaredClass = decalredClasses[x];
/* 672 */           String className = declaredClass.getName();
/* 673 */           if (!className.endsWith("Type"))
/*     */             continue;
/* 675 */           proxyTypeClass = declaredClass;
/* 676 */           break;
/*     */         }
/*     */ 
/* 679 */         Object proxyType = null;
/* 680 */         Field[] fields = proxyTypeClass.getDeclaredFields();
/* 681 */         for (int i = 0; i < fields.length; i++)
/*     */         {
/* 683 */           Field field = fields[i];
/* 684 */           String fieldName = field.getName();
/* 685 */           if (!fieldName.endsWith("HTTP"))
/*     */             continue;
/* 687 */           proxyType = field.get(proxyTypeClass);
/* 688 */           break;
/*     */         }
/*     */ 
/* 691 */         Constructor proxyConstructor = proxyClass.getConstructor(new Class[] { proxyTypeClass, SocketAddress.class });
/* 692 */         Object proxy = proxyConstructor.newInstance(new Object[] { proxyType, proxyAddress });
/* 693 */         Method openConnection = externalURL.getClass().getMethod("openConnection", new Class[] { proxyClass });
/* 694 */         httpURLConn = (HttpURLConnection)openConnection.invoke(externalURL, new Object[] { proxy });
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 698 */         log.error("Can not set proxy for http invocation (proxy host: " + proxyHost + ", proxy port: " + proxyPort + ") " + "as this configuration requires JDK 1.5 or later.  If running JDK 1.4, can use proxy by setting system properties.");
/*     */ 
/* 700 */         log.debug(e);
/*     */       }
/*     */ 
/* 704 */       String proxyAuth = getProxyAuth(metadata);
/* 705 */       if (proxyAuth != null)
/*     */       {
/* 707 */         httpURLConn.setRequestProperty("Proxy-Authorization", proxyAuth);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 712 */       externalURL = new URL(url);
/* 713 */       httpURLConn = (HttpURLConnection)externalURL.openConnection();
/*     */     }
/*     */ 
/* 716 */     return httpURLConn;
/*     */   }
/*     */ 
/*     */   private String getProxyAuth(Map metadata)
/*     */   {
/* 721 */     String authString = null;
/* 722 */     String username = null;
/* 723 */     String password = null;
/*     */ 
/* 725 */     if (metadata != null)
/*     */     {
/* 727 */       username = (String)metadata.get("http.proxy.username");
/*     */     }
/* 729 */     if ((username == null) || (username.length() == 0))
/*     */     {
/* 731 */       username = System.getProperty("http.proxy.username");
/*     */     }
/* 733 */     if (metadata != null)
/*     */     {
/* 735 */       password = (String)metadata.get("http.proxy.password");
/*     */     }
/* 737 */     if (password == null)
/*     */     {
/* 739 */       password = System.getProperty("http.proxy.password");
/*     */     }
/*     */ 
/* 742 */     if ((username != null) && (password != null))
/*     */     {
/* 744 */       StringBuffer buffer = new StringBuffer();
/* 745 */       buffer.append(username);
/* 746 */       buffer.append(":");
/* 747 */       buffer.append(password);
/*     */ 
/* 749 */       String encoded = Base64.encodeBytes(buffer.toString().getBytes());
/*     */ 
/* 751 */       authString = "Basic " + encoded;
/*     */     }
/*     */ 
/* 755 */     return authString;
/*     */   }
/*     */ 
/*     */   private String getBasicAuth(Map metadata)
/*     */   {
/* 760 */     String authString = null;
/* 761 */     String username = null;
/* 762 */     String password = null;
/*     */ 
/* 764 */     if (metadata != null)
/*     */     {
/* 766 */       username = (String)metadata.get("http.basic.username");
/*     */     }
/* 768 */     if ((username == null) || (username.length() == 0))
/*     */     {
/* 770 */       username = System.getProperty("http.basic.username");
/*     */     }
/* 772 */     if (metadata != null)
/*     */     {
/* 774 */       password = (String)metadata.get("http.basic.password");
/*     */     }
/* 776 */     if (password == null)
/*     */     {
/* 778 */       password = System.getProperty("http.basic.password");
/*     */     }
/*     */ 
/* 781 */     if ((username != null) && (password != null))
/*     */     {
/* 783 */       StringBuffer buffer = new StringBuffer();
/* 784 */       buffer.append(username);
/* 785 */       buffer.append(":");
/* 786 */       buffer.append(password);
/*     */ 
/* 788 */       String encoded = Base64.encodeBytes(buffer.toString().getBytes(), 8);
/*     */ 
/* 790 */       authString = "Basic " + encoded;
/*     */     }
/*     */ 
/* 794 */     return authString;
/*     */   }
/*     */ 
/*     */   protected void handleConnect()
/*     */     throws ConnectionFailedException
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void handleDisconnect()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected String getDefaultDataType()
/*     */   {
/* 832 */     return "http";
/*     */   }
/*     */ 
/*     */   public void setTimeoutThreadPool(ThreadPool pool)
/*     */   {
/* 841 */     this.timeoutThreadPool = pool;
/*     */   }
/*     */ 
/*     */   public ThreadPool getTimeoutThreadPool()
/*     */   {
/* 851 */     synchronized (this.timeoutThreadPoolLock)
/*     */     {
/* 853 */       if (this.timeoutThreadPool == null)
/*     */       {
/* 855 */         int maxNumberThreads = 10;
/* 856 */         int maxTimeoutQueueSize = -1;
/*     */ 
/* 858 */         BasicThreadPool pool = new BasicThreadPool("HTTP timeout");
/* 859 */         log.debug("created new thread pool: " + pool);
/* 860 */         Object param = this.configuration.get("maxNumTimeoutThreads");
/* 861 */         if ((param instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 865 */             maxNumberThreads = Integer.parseInt((String)param);
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 869 */             log.error("maxNumberThreads parameter has invalid format: " + param);
/*     */           }
/*     */         }
/* 872 */         else if (param != null)
/*     */         {
/* 874 */           log.error("maxNumberThreads parameter must be a string in integer format: " + param);
/*     */         }
/*     */ 
/* 877 */         param = this.configuration.get("maxTimeoutQueueSize");
/*     */ 
/* 879 */         if ((param instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 883 */             maxTimeoutQueueSize = Integer.parseInt((String)param);
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 887 */             log.error("maxTimeoutQueueSize parameter has invalid format: " + param);
/*     */           }
/*     */         }
/* 890 */         else if (param != null)
/*     */         {
/* 892 */           log.error("maxTimeoutQueueSize parameter must be a string in integer format: " + param);
/*     */         }
/*     */ 
/* 895 */         pool.setMaximumPoolSize(maxNumberThreads);
/*     */ 
/* 897 */         if (maxTimeoutQueueSize > 0)
/*     */         {
/* 899 */           pool.setMaximumQueueSize(maxTimeoutQueueSize);
/*     */         }
/* 901 */         pool.setBlockingMode(BlockingMode.RUN);
/* 902 */         this.timeoutThreadPool = pool;
/*     */       }
/*     */     }
/* 905 */     return this.timeoutThreadPool;
/*     */   }
/*     */ 
/*     */   static class WaitingTaskWrapper extends RunnableTaskWrapper
/*     */   {
/*     */     long completeTimeout;
/*     */ 
/*     */     public WaitingTaskWrapper(Runnable runnable, long completeTimeout)
/*     */     {
/* 919 */       super(0L, completeTimeout);
/* 920 */       this.completeTimeout = completeTimeout;
/*     */     }
/*     */ 
/*     */     public int getTaskWaitType() {
/* 924 */       return 2;
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 928 */       return "WaitingTaskWrapper[" + this.completeTimeout + "]";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.http.HTTPClientInvoker
 * JD-Core Version:    0.6.0
 */