/*     */ package org.jboss.remoting.transport.coyote.ssl;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerInvocationHandler;
/*     */ import javax.management.ObjectName;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.security.ServerSocketFactoryMBean;
/*     */ import org.jboss.remoting.security.ServerSocketFactoryWrapper;
/*     */ 
/*     */ public class RemotingServerSocketFactory extends org.apache.tomcat.util.net.ServerSocketFactory
/*     */ {
/*  46 */   private Map mbeanServerMap = null;
/*  47 */   private javax.net.ServerSocketFactory serverSocketFactory = null;
/*     */ 
/*  49 */   private static Map serverSocketFactories = new HashMap();
/*     */ 
/*  51 */   protected final Logger log = Logger.getLogger(getClass());
/*     */ 
/*  53 */   private boolean performHandshake = false;
/*     */ 
/*     */   public RemotingServerSocketFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public RemotingServerSocketFactory(Map mbeanServerMap)
/*     */   {
/*  67 */     this.mbeanServerMap = mbeanServerMap;
/*     */   }
/*     */ 
/*     */   private void init()
/*     */     throws InstantiationException
/*     */   {
/*  73 */     String locator = (String)this.attributes.get("locator");
/*     */ 
/*  76 */     this.serverSocketFactory = ((javax.net.ServerSocketFactory)serverSocketFactories.get(locator));
/*  77 */     if (this.serverSocketFactory == null)
/*     */     {
/*  81 */       MBeanServer mbeanserver = (MBeanServer)this.mbeanServerMap.get(locator);
/*  82 */       String serverSocketObjName = (String)this.attributes.get("serverSocketFactory");
/*     */ 
/*  84 */       if ((locator == null) || (mbeanserver == null) || (serverSocketObjName == null))
/*     */       {
/*  86 */         throw new InstantiationException("Can not create ServerSocketFactory with SSL support due to one of the following being null.\nlocator = " + locator + "\nmbeanserver = " + mbeanserver + "\nserverSocketObjName = " + serverSocketObjName);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/*  94 */         ServerSocketFactoryMBean serverSocketFactoryMBean = (ServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(mbeanserver, new ObjectName(serverSocketObjName), ServerSocketFactoryMBean.class, false);
/*     */ 
/*  99 */         this.serverSocketFactory = new ServerSocketFactoryWrapper(serverSocketFactoryMBean);
/* 100 */         this.performHandshake = true;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 104 */         InstantiationException iex = new InstantiationException("Error creating ServerSocketFactory proxy via MBeanServer");
/* 105 */         iex.setStackTrace(e.getStackTrace());
/* 106 */         throw iex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public ServerSocket createSocket(int port)
/*     */     throws IOException, InstantiationException
/*     */   {
/* 125 */     if (this.serverSocketFactory == null)
/*     */     {
/* 127 */       init();
/*     */     }
/* 129 */     return this.serverSocketFactory.createServerSocket(port);
/*     */   }
/*     */ 
/*     */   public ServerSocket createSocket(int port, int backlog)
/*     */     throws IOException, InstantiationException
/*     */   {
/* 146 */     if (this.serverSocketFactory == null)
/*     */     {
/* 148 */       init();
/*     */     }
/* 150 */     return this.serverSocketFactory.createServerSocket(port, backlog);
/*     */   }
/*     */ 
/*     */   public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress)
/*     */     throws IOException, InstantiationException
/*     */   {
/* 168 */     if (this.serverSocketFactory == null)
/*     */     {
/* 170 */       init();
/*     */     }
/*     */ 
/* 173 */     ServerSocket svrSocket = this.serverSocketFactory.createServerSocket(port, backlog, ifAddress);
/* 174 */     return svrSocket;
/*     */   }
/*     */ 
/*     */   public Socket acceptSocket(ServerSocket socket)
/*     */     throws IOException
/*     */   {
/* 185 */     return socket.accept();
/*     */   }
/*     */ 
/*     */   public void handshake(Socket sock)
/*     */     throws IOException
/*     */   {
/* 196 */     if (this.performHandshake)
/*     */     {
/* 198 */       ((SSLSocket)sock).startHandshake();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void setServerSocketFactory(String locatorURI, javax.net.ServerSocketFactory svrSocketFactory)
/*     */   {
/* 204 */     serverSocketFactories.put(locatorURI, svrSocketFactory);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.coyote.ssl.RemotingServerSocketFactory
 * JD-Core Version:    0.6.0
 */