/*     */ package org.jboss.remoting.transport.coyote;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.apache.coyote.Request;
/*     */ import org.apache.tomcat.util.buf.B2CConverter;
/*     */ import org.apache.tomcat.util.buf.MessageBytes;
/*     */ 
/*     */ public class RequestMap
/*     */   implements Map
/*     */ {
/*  34 */   Map internalMap = new HashMap();
/*     */ 
/*  39 */   protected InputBuffer inputBuffer = new InputBuffer();
/*     */ 
/*  44 */   protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
/*     */   protected Request coyoteRequest;
/*  82 */   protected B2CConverter URIConverter = null;
/*     */ 
/*     */   public void setCoyoteRequest(Request coyoteRequest)
/*     */   {
/*  59 */     this.coyoteRequest = coyoteRequest;
/*  60 */     this.inputBuffer.setRequest(coyoteRequest);
/*     */   }
/*     */ 
/*     */   public Request getCoyoteRequest()
/*     */   {
/*  68 */     return this.coyoteRequest;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */   {
/*  76 */     return this.inputStream;
/*     */   }
/*     */ 
/*     */   protected B2CConverter getURIConverter()
/*     */   {
/*  89 */     return this.URIConverter;
/*     */   }
/*     */ 
/*     */   protected void setURIConverter(B2CConverter URIConverter)
/*     */   {
/*  99 */     this.URIConverter = URIConverter;
/*     */   }
/*     */ 
/*     */   public void recycle()
/*     */   {
/* 104 */     this.inputBuffer.recycle();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 110 */     return this.internalMap.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 115 */     return this.internalMap.isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 120 */     return this.internalMap.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value)
/*     */   {
/* 125 */     return this.internalMap.containsValue(value);
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 130 */     if ("MethodType".equals(key))
/*     */     {
/* 132 */       return this.coyoteRequest.method().toString();
/*     */     }
/* 134 */     if ("Path".equals(key))
/*     */     {
/* 136 */       return this.coyoteRequest.decodedURI().toString();
/*     */     }
/* 138 */     if ("HttpVersion".equals(key))
/*     */     {
/* 140 */       return this.coyoteRequest.protocol().toString();
/*     */     }
/*     */ 
/* 144 */     Object value = this.internalMap.get(key);
/* 145 */     if (value != null)
/*     */     {
/* 147 */       return value;
/*     */     }
/*     */ 
/* 151 */     return this.coyoteRequest.getHeader(String.valueOf(key));
/*     */   }
/*     */ 
/*     */   public Object put(Object arg0, Object arg1)
/*     */   {
/* 158 */     return this.internalMap.put(arg0, arg1);
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 163 */     return this.internalMap.remove(key);
/*     */   }
/*     */ 
/*     */   public void putAll(Map arg0)
/*     */   {
/* 168 */     this.internalMap.putAll(arg0);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 173 */     this.internalMap.clear();
/*     */   }
/*     */ 
/*     */   public Set keySet()
/*     */   {
/* 178 */     return this.internalMap.keySet();
/*     */   }
/*     */ 
/*     */   public Collection values()
/*     */   {
/* 183 */     return this.internalMap.values();
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 188 */     return this.internalMap.entrySet();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.coyote.RequestMap
 * JD-Core Version:    0.6.0
 */