/*     */ package org.jboss.remoting.transport.coyote;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Reader;
/*     */ import java.util.HashMap;
/*     */ import org.apache.coyote.Request;
/*     */ import org.apache.tomcat.util.buf.B2CConverter;
/*     */ import org.apache.tomcat.util.buf.ByteChunk;
/*     */ import org.apache.tomcat.util.buf.ByteChunk.ByteInputChannel;
/*     */ import org.apache.tomcat.util.buf.CharChunk;
/*     */ import org.apache.tomcat.util.buf.CharChunk.CharInputChannel;
/*     */ import org.apache.tomcat.util.buf.CharChunk.CharOutputChannel;
/*     */ 
/*     */ public class InputBuffer extends Reader
/*     */   implements ByteChunk.ByteInputChannel, CharChunk.CharInputChannel, CharChunk.CharOutputChannel
/*     */ {
/*     */   public static final String DEFAULT_ENCODING = "ISO-8859-1";
/*     */   public static final int DEFAULT_BUFFER_SIZE = 8192;
/*  51 */   public final int INITIAL_STATE = 0;
/*  52 */   public final int CHAR_STATE = 1;
/*  53 */   public final int BYTE_STATE = 2;
/*     */   private ByteChunk bb;
/*     */   private CharChunk cb;
/*  73 */   private int state = 0;
/*     */ 
/*  79 */   private int bytesRead = 0;
/*     */ 
/*  85 */   private int charsRead = 0;
/*     */ 
/*  91 */   private boolean closed = false;
/*     */ 
/*  97 */   private ByteChunk inputChunk = new ByteChunk();
/*     */   private String enc;
/* 109 */   private boolean gotEnc = false;
/*     */ 
/* 115 */   protected HashMap encoders = new HashMap();
/*     */   protected B2CConverter conv;
/*     */   private Request coyoteRequest;
/* 133 */   private int markPos = -1;
/*     */ 
/* 139 */   private int size = -1;
/*     */ 
/*     */   public InputBuffer()
/*     */   {
/* 150 */     this(8192);
/*     */   }
/*     */ 
/*     */   public InputBuffer(int size)
/*     */   {
/* 163 */     this.size = size;
/* 164 */     this.bb = new ByteChunk(size);
/* 165 */     this.bb.setLimit(size);
/* 166 */     this.bb.setByteInputChannel(this);
/* 167 */     this.cb = new CharChunk(size);
/* 168 */     this.cb.setLimit(size);
/* 169 */     this.cb.setOptimizedWrite(false);
/* 170 */     this.cb.setCharInputChannel(this);
/* 171 */     this.cb.setCharOutputChannel(this);
/*     */   }
/*     */ 
/*     */   public void setRequest(Request coyoteRequest)
/*     */   {
/* 185 */     this.coyoteRequest = coyoteRequest;
/*     */   }
/*     */ 
/*     */   public Request getRequest()
/*     */   {
/* 196 */     return this.coyoteRequest;
/*     */   }
/*     */ 
/*     */   public void recycle()
/*     */   {
/* 208 */     this.state = 0;
/* 209 */     this.bytesRead = 0;
/* 210 */     this.charsRead = 0;
/*     */ 
/* 213 */     if (this.cb.getChars().length > this.size)
/*     */     {
/* 215 */       this.cb = new CharChunk(this.size);
/* 216 */       this.cb.setLimit(this.size);
/* 217 */       this.cb.setCharInputChannel(this);
/* 218 */       this.cb.setCharOutputChannel(this);
/*     */     }
/*     */     else
/*     */     {
/* 222 */       this.cb.recycle();
/*     */     }
/* 224 */     this.markPos = -1;
/* 225 */     this.bb.recycle();
/* 226 */     this.closed = false;
/*     */ 
/* 228 */     if (this.conv != null)
/*     */     {
/* 230 */       this.conv.recycle();
/*     */     }
/*     */ 
/* 233 */     this.gotEnc = false;
/* 234 */     this.enc = null;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 247 */     this.closed = true;
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 254 */     if (this.state == 2)
/*     */     {
/* 256 */       return this.bb.getLength();
/*     */     }
/* 258 */     if (this.state == 1)
/*     */     {
/* 260 */       return this.cb.getLength();
/*     */     }
/*     */ 
/* 264 */     return 0;
/*     */   }
/*     */ 
/*     */   public int realReadBytes(byte[] cbuf, int off, int len)
/*     */     throws IOException
/*     */   {
/* 283 */     if (this.closed)
/*     */     {
/* 285 */       return -1;
/*     */     }
/* 287 */     if (this.coyoteRequest == null)
/*     */     {
/* 289 */       return -1;
/*     */     }
/*     */ 
/* 292 */     this.state = 2;
/*     */ 
/* 294 */     int result = this.coyoteRequest.doRead(this.bb);
/*     */ 
/* 296 */     return result;
/*     */   }
/*     */ 
/*     */   public int readByte()
/*     */     throws IOException
/*     */   {
/* 304 */     return this.bb.substract();
/*     */   }
/*     */ 
/*     */   public int read(byte[] b, int off, int len)
/*     */     throws IOException
/*     */   {
/* 311 */     return this.bb.substract(b, off, len);
/*     */   }
/*     */ 
/*     */   public void realWriteChars(char[] c, int off, int len)
/*     */     throws IOException
/*     */   {
/* 326 */     this.markPos = -1;
/*     */   }
/*     */ 
/*     */   public void setEncoding(String s)
/*     */   {
/* 332 */     this.enc = s;
/*     */   }
/*     */ 
/*     */   public int realReadChars(char[] cbuf, int off, int len)
/*     */     throws IOException
/*     */   {
/* 340 */     if (!this.gotEnc)
/*     */     {
/* 342 */       setConverter();
/*     */     }
/*     */ 
/* 345 */     if (this.bb.getLength() <= 0)
/*     */     {
/* 347 */       int nRead = realReadBytes(this.bb.getBytes(), 0, this.bb.getBytes().length);
/* 348 */       if (nRead < 0)
/*     */       {
/* 350 */         return -1;
/*     */       }
/*     */     }
/*     */ 
/* 354 */     if (this.markPos == -1)
/*     */     {
/* 356 */       this.cb.setOffset(0);
/* 357 */       this.cb.setEnd(0);
/*     */     }
/*     */ 
/* 360 */     this.conv.convert(this.bb, this.cb);
/* 361 */     this.bb.setOffset(this.bb.getEnd());
/* 362 */     this.state = 1;
/*     */ 
/* 364 */     return this.cb.getLength();
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException
/*     */   {
/* 372 */     return this.cb.substract();
/*     */   }
/*     */ 
/*     */   public int read(char[] cbuf)
/*     */     throws IOException
/*     */   {
/* 379 */     return read(cbuf, 0, cbuf.length);
/*     */   }
/*     */ 
/*     */   public int read(char[] cbuf, int off, int len)
/*     */     throws IOException
/*     */   {
/* 386 */     return this.cb.substract(cbuf, off, len);
/*     */   }
/*     */ 
/*     */   public long skip(long n)
/*     */     throws IOException
/*     */   {
/* 394 */     if (n < 0L)
/*     */     {
/* 396 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/* 399 */     long nRead = 0L;
/* 400 */     while (nRead < n)
/*     */     {
/* 402 */       if (this.cb.getLength() >= n)
/*     */       {
/* 404 */         this.cb.setOffset(this.cb.getStart() + (int)n);
/* 405 */         nRead = n; continue;
/*     */       }
/*     */ 
/* 409 */       nRead += this.cb.getLength();
/* 410 */       this.cb.setOffset(this.cb.getEnd());
/* 411 */       int toRead = 0;
/* 412 */       if (this.cb.getChars().length < n - nRead)
/*     */       {
/* 414 */         toRead = this.cb.getChars().length;
/*     */       }
/*     */       else
/*     */       {
/* 418 */         toRead = (int)(n - nRead);
/*     */       }
/* 420 */       int nb = realReadChars(this.cb.getChars(), 0, toRead);
/* 421 */       if (nb < 0)
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 428 */     return nRead;
/*     */   }
/*     */ 
/*     */   public boolean ready()
/*     */     throws IOException
/*     */   {
/* 436 */     return this.cb.getLength() > 0;
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 442 */     return true;
/*     */   }
/*     */ 
/*     */   public void mark(int readAheadLimit)
/*     */     throws IOException
/*     */   {
/* 449 */     if (this.cb.getLength() <= 0)
/*     */     {
/* 451 */       this.cb.setOffset(0);
/* 452 */       this.cb.setEnd(0);
/*     */     }
/* 456 */     else if ((this.cb.getBuffer().length > 2 * this.size) && (this.cb.getLength() < this.cb.getStart()))
/*     */     {
/* 459 */       System.arraycopy(this.cb.getBuffer(), this.cb.getStart(), this.cb.getBuffer(), 0, this.cb.getLength());
/*     */ 
/* 461 */       this.cb.setEnd(this.cb.getLength());
/* 462 */       this.cb.setOffset(0);
/*     */     }
/*     */ 
/* 465 */     int offset = readAheadLimit;
/* 466 */     if (offset < this.size)
/*     */     {
/* 468 */       offset = this.size;
/*     */     }
/* 470 */     this.cb.setLimit(this.cb.getStart() + offset);
/* 471 */     this.markPos = this.cb.getStart();
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws IOException
/*     */   {
/* 478 */     if (this.state == 1)
/*     */     {
/* 480 */       if (this.markPos < 0)
/*     */       {
/* 482 */         this.cb.recycle();
/* 483 */         this.markPos = -1;
/* 484 */         throw new IOException();
/*     */       }
/*     */ 
/* 488 */       this.cb.setOffset(this.markPos);
/*     */     }
/*     */     else
/*     */     {
/* 493 */       this.bb.recycle();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void checkConverter()
/*     */     throws IOException
/*     */   {
/* 502 */     if (!this.gotEnc)
/*     */     {
/* 504 */       setConverter();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setConverter()
/*     */     throws IOException
/*     */   {
/* 514 */     if (this.coyoteRequest != null)
/*     */     {
/* 516 */       this.enc = this.coyoteRequest.getCharacterEncoding();
/*     */     }
/*     */ 
/* 519 */     this.gotEnc = true;
/* 520 */     if (this.enc == null)
/*     */     {
/* 522 */       this.enc = "ISO-8859-1";
/*     */     }
/* 524 */     this.conv = ((B2CConverter)this.encoders.get(this.enc));
/* 525 */     if (this.conv == null)
/*     */     {
/* 527 */       this.conv = new B2CConverter(this.enc);
/* 528 */       this.encoders.put(this.enc, this.conv);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.coyote.InputBuffer
 * JD-Core Version:    0.6.0
 */