/*     */ package org.jboss.remoting.socketfactory;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketAddress;
/*     */ import java.net.SocketException;
/*     */ import java.nio.channels.ServerSocketChannel;
/*     */ 
/*     */ public class CreationListenerServerSocket extends ServerSocket
/*     */ {
/*     */   private ServerSocket serverSocket;
/*     */   private SocketCreationListener listener;
/*     */ 
/*     */   public CreationListenerServerSocket(ServerSocket serverSocket, SocketCreationListener listener)
/*     */     throws IOException
/*     */   {
/*  52 */     this.serverSocket = serverSocket;
/*  53 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public SocketCreationListener getListener()
/*     */   {
/*  59 */     return this.listener;
/*     */   }
/*     */ 
/*     */   public ServerSocket getServerSocket()
/*     */   {
/*  65 */     return this.serverSocket;
/*     */   }
/*     */ 
/*     */   public void setListener(SocketCreationListener listener)
/*     */   {
/*  71 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public void setServerSocket(ServerSocket serverSocket)
/*     */   {
/*  77 */     this.serverSocket = serverSocket;
/*     */   }
/*     */ 
/*     */   public void bind(SocketAddress endpoint)
/*     */     throws IOException
/*     */   {
/*  83 */     this.serverSocket.bind(endpoint);
/*     */   }
/*     */ 
/*     */   public void bind(SocketAddress endpoint, int backlog)
/*     */     throws IOException
/*     */   {
/*  89 */     this.serverSocket.bind(endpoint, backlog);
/*     */   }
/*     */ 
/*     */   public Socket accept()
/*     */     throws IOException
/*     */   {
/*  95 */     Socket socket = this.serverSocket.accept();
/*  96 */     this.listener.socketCreated(socket, this.serverSocket);
/*  97 */     return socket;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 103 */     this.serverSocket.close();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 109 */     return this.serverSocket.equals(obj);
/*     */   }
/*     */ 
/*     */   public ServerSocketChannel getChannel()
/*     */   {
/* 115 */     return this.serverSocket.getChannel();
/*     */   }
/*     */ 
/*     */   public InetAddress getInetAddress()
/*     */   {
/* 121 */     return this.serverSocket.getInetAddress();
/*     */   }
/*     */ 
/*     */   public int getLocalPort()
/*     */   {
/* 127 */     return this.serverSocket.getLocalPort();
/*     */   }
/*     */ 
/*     */   public SocketAddress getLocalSocketAddress()
/*     */   {
/* 133 */     return this.serverSocket.getLocalSocketAddress();
/*     */   }
/*     */ 
/*     */   public int getReceiveBufferSize()
/*     */     throws SocketException
/*     */   {
/* 139 */     return this.serverSocket.getReceiveBufferSize();
/*     */   }
/*     */ 
/*     */   public boolean getReuseAddress()
/*     */     throws SocketException
/*     */   {
/* 145 */     return this.serverSocket.getReuseAddress();
/*     */   }
/*     */ 
/*     */   public int getSoTimeout()
/*     */     throws IOException
/*     */   {
/* 151 */     return this.serverSocket.getSoTimeout();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 157 */     return this.serverSocket.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean isBound()
/*     */   {
/* 163 */     return this.serverSocket.isBound();
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 169 */     return this.serverSocket.isClosed();
/*     */   }
/*     */ 
/*     */   public void setReceiveBufferSize(int size)
/*     */     throws SocketException
/*     */   {
/* 175 */     this.serverSocket.setReceiveBufferSize(size);
/*     */   }
/*     */ 
/*     */   public void setReuseAddress(boolean on)
/*     */     throws SocketException
/*     */   {
/* 181 */     this.serverSocket.setReuseAddress(on);
/*     */   }
/*     */ 
/*     */   public void setSoTimeout(int timeout)
/*     */     throws SocketException
/*     */   {
/* 187 */     this.serverSocket.setSoTimeout(timeout);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 193 */     return this.serverSocket.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.socketfactory.CreationListenerServerSocket
 * JD-Core Version:    0.6.0
 */