/*    */ package org.jboss.remoting.samples.transporter.proxy;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import java.util.Random;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ import org.jboss.remoting.transporter.TransporterServer;
/*    */ 
/*    */ public class CustomerProcessorImpl
/*    */   implements CustomerProcessor
/*    */ {
/* 35 */   private String locatorURI = "socket://localhost:5401";
/*    */ 
/*    */   public ICustomer processCustomer(Customer customer)
/*    */   {
/* 48 */     if ((customer != null) && (customer.getCustomerId() < 0))
/*    */     {
/* 50 */       customer.setCustomerId(new Random().nextInt(1000));
/*    */     }
/*    */ 
/* 53 */     ICustomer customerProxy = null;
/*    */     try
/*    */     {
/* 56 */       TransporterServer server = TransporterServer.createTransporterServer(this.locatorURI, customer, ICustomer.class.getName());
/* 57 */       customerProxy = (ICustomer)TransporterClient.createTransporterClient(this.locatorURI, ICustomer.class);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 61 */       e.printStackTrace();
/*    */     }
/*    */ 
/* 64 */     System.out.println("processed customer with new id of " + customerProxy.getCustomerId());
/* 65 */     return customerProxy;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.proxy.CustomerProcessorImpl
 * JD-Core Version:    0.6.0
 */