/*    */ package org.jboss.remoting.samples.transporter.complex.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.samples.transporter.complex.Doctor;
/*    */ import org.jboss.remoting.samples.transporter.complex.NoDoctorAvailableException;
/*    */ import org.jboss.remoting.samples.transporter.complex.Patient;
/*    */ import org.jboss.remoting.samples.transporter.complex.ProviderInterface;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 35 */   private String locatorURI = "socket://localhost:5401/?serializationtype=jboss";
/*    */ 
/*    */   public void makeClientCall()
/*    */     throws Exception
/*    */   {
/* 40 */     Patient patient = new Patient("Bill", "Gates");
/* 41 */     patient.setAilmentType("financial");
/* 42 */     patient.setAilmentDescription("Money coming out the wazoo.");
/*    */ 
/* 44 */     System.out.println("*** Have a new patient that needs a doctor.  The patient is:\n" + patient);
/*    */ 
/* 47 */     ProviderInterface providerProcessor = (ProviderInterface)TransporterClient.createTransporterClient(this.locatorURI, ProviderInterface.class);
/*    */     try
/*    */     {
/* 53 */       System.out.println("*** Looking for doctor that can help our patient...\n");
/* 54 */       Doctor doctor = providerProcessor.findDoctor(patient);
/*    */ 
/* 57 */       System.out.println("*** Found doctor for our patient.  Doctor found is:\n" + doctor);
/*    */ 
/* 60 */       patient.setDoctor(doctor);
/* 61 */       System.out.println("*** Set doctor as patient's doctor.  Patient info is now:\n" + patient);
/*    */ 
/* 64 */       providerProcessor.retireDoctor(doctor);
/*    */ 
/* 67 */       Patient patient2 = new Patient("Larry", "Page");
/* 68 */       patient2.setAilmentType("financial");
/* 69 */       patient2.setAilmentDescription("Money coming out the wazoo.");
/*    */ 
/* 71 */       System.out.println("*** Have a new patient that we need to find a doctor for (remember, the previous one retired and there are no others)");
/* 72 */       providerProcessor.findDoctor(patient2);
/*    */     }
/*    */     catch (NoDoctorAvailableException e)
/*    */     {
/* 76 */       System.out.println("*** Could not find doctor for patient.  This is an expected exception when there are not doctors available.");
/* 77 */       e.printStackTrace();
/*    */     }
/*    */ 
/* 80 */     TransporterClient.destroyTransporterClient(providerProcessor);
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 87 */     Client client = new Client();
/*    */     try
/*    */     {
/* 90 */       client.makeClientCall();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 94 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.complex.client.Client
 * JD-Core Version:    0.6.0
 */